/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.MySQLCommandFactory;
import com.inet.dbupdater.databases.modelpatch.IModelPatcher;
import com.inet.dbupdater.databases.modelpatch.MySQLModelPatcher;
import com.inet.dbupdater.dbconnection.DBConnection;
import com.inet.dbupdater.model.IModelComparator;
import com.inet.dbupdater.model.MySQLPatcher;
import com.inet.dbupdater.model.NodeFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.SuppressFBWarnings;

public class DatabaseInfosMySQL
extends DatabaseInfos {
    public DatabaseInfosMySQL(DBConnection dbcon) {
        super(dbcon);
    }

    @Override
    protected ICommandFactory createCommandFactory() {
        return new MySQLCommandFactory(this);
    }

    @Override
    protected IModelPatcher createModelPatcher() {
        return new MySQLModelPatcher();
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="access only possible with server credentials")
    public void activateDatabase(DBConnection wrappedConnection, Connection connection, String databaseName) throws SQLException {
        String statement = "USE " + this.getQuoteIdentiferIfNeeded(databaseName);
        if (wrappedConnection != null) {
            wrappedConnection.execute(statement);
        } else {
            try (Statement stm = connection.createStatement();){
                stm.execute(statement);
            }
        }
        try {
            if (!databaseName.equals(connection.getSchema())) {
                connection.setSchema(databaseName);
            }
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    @Override
    public String getDestDataType(int datatype, int size, int scale, String originalName, boolean identity) throws SQLException {
        switch (datatype) {
            case -1: {
                if (size == 65535) {
                    return "text";
                }
                return "longtext";
            }
            case 2005: {
                return "longtext";
            }
            case -4: 
            case 2004: {
                return "longblob";
            }
            case 93: {
                if (originalName != null) {
                    return originalName.toLowerCase();
                }
                return super.getDestDataType(datatype, size, scale, originalName, false) + (identity ? " AUTO_INCREMENT" : "");
            }
            case -8: {
                return "varchar(" + size + ")";
            }
            case -9: {
                return "varchar(" + size + ")";
            }
            case -10: {
                return "text";
            }
            case -16: {
                return "text";
            }
        }
        return super.getDestDataType(datatype, size, scale, originalName, false) + (identity ? " AUTO_INCREMENT" : "");
    }

    @Override
    public IModelComparator getModelPatchComparator() {
        return new MySQLPatcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readView(String cat, String schema, String name) throws SQLException {
        PreparedStatement pr = null;
        if (cat == null) {
            pr = this.getDBConnection().prepareStatement("SELECT * FROM INFORMATION_SCHEMA.VIEWS Where TABLE_NAME = ?");
            pr.setString(1, name);
        } else {
            pr = this.getDBConnection().prepareStatement("SELECT * FROM INFORMATION_SCHEMA.VIEWS Where TABLE_SCHEMA = ? and TABLE_NAME = ?");
            pr.setString(1, cat);
            pr.setString(2, name);
        }
        try {
            ResultSet rs = pr.executeQuery();
            if (rs.next()) {
                String viewdev = rs.getString("VIEW_DEFINITION");
                if (viewdev == null || viewdev.length() == 0) {
                    throw new SQLException("View Definition not readable: " + name);
                }
                String quote = this.getDBConnection().getConnection().getMetaData().getIdentifierQuoteString();
                String catalog = cat;
                if (catalog == null) {
                    catalog = this.getDBConnection().getConnection().getCatalog();
                }
                if ((catalog == null || catalog.length() == 0) && this.getDBConnection().getDatabaseName() != null) {
                    catalog = this.getDBConnection().getDatabaseName();
                }
                viewdev = viewdev.replaceAll("[" + quote + "]?(" + catalog + "|" + catalog.toLowerCase() + ")[" + quote + "]?\\.", "");
                viewdev = viewdev.replace("/* ALGORITHM=UNDEFINED */", "");
                String string = viewdev = viewdev.replace("_latin1", "");
                return string;
            }
        }
        finally {
            this.getDBConnection().close(pr);
        }
        throw new SQLException("View Definition not found for " + name);
    }

    @Override
    public Set<String> getInnoDBTables() {
        try {
            String sql = "SELECT table_name FROM INFORMATION_SCHEMA.TABLES WHERE engine = 'innodb' AND table_schema = " + this.getQuotedValue(this.getDBConnection().getDatabaseName(), 12);
            HashSet<String> tables = new HashSet<String>();
            try (ResultSet rs = this.getDBConnection().executeQuery(sql);){
                while (rs.next()) {
                    tables.add(rs.getString(1));
                }
            }
            return tables;
        }
        catch (Exception e) {
            return new HashSet<String>();
        }
    }

    @Override
    public void dropTable(String tableName) throws SQLException {
        this.getDBConnection().execute("SET FOREIGN_KEY_CHECKS=0");
        super.dropTable(tableName);
        this.getDBConnection().execute("SET FOREIGN_KEY_CHECKS=1");
    }

    @Override
    protected String dropForeignKeySql(String tableName, String constraintName) throws SQLException {
        return "ALTER TABLE " + this.getQuoteIdentiferIfNeeded(tableName) + " DROP FOREIGN KEY " + this.getQuoteIdentiferIfNeeded(constraintName);
    }

    @Override
    public ResultSet getTriggers() throws SQLException {
        return this.getDBConnection().executeQuery("SHOW TRIGGERS");
    }

    @Override
    public ResultSet getSequences() throws SQLException {
        return null;
    }

    @Override
    public void prepareInsertInto(String tableName, ResultSetMetaData rs) throws SQLException {
        Statement st = this.getDBConnection().getConnection().createStatement();
        st.execute("set session sql_mode = NO_AUTO_VALUE_ON_ZERO");
        this.getDBConnection().close(st);
    }

    @Override
    public void prepareAlter() throws SQLException {
        Statement st = this.getDBConnection().getConnection().createStatement();
        st.execute("set session sql_mode = NO_AUTO_VALUE_ON_ZERO");
        this.getDBConnection().close(st);
    }

    @Override
    public void finishInsertInto(String tableName, ResultSetMetaData rs) throws SQLException {
        Statement st = this.getDBConnection().getConnection().createStatement();
        st.execute("set session sql_mode = ''");
        this.getDBConnection().close(st);
    }

    @Override
    public String translateDefault(String def, int datatype) {
        if (def == null) {
            return null;
        }
        if (datatype == -7 && def.length() == 1) {
            return Integer.toString(def.charAt(0));
        }
        return def.trim();
    }

    @Override
    public boolean isQuoteableDataType(int type) {
        switch (type) {
            case 92: {
                return true;
            }
            case 93: {
                return true;
            }
        }
        return super.isQuoteableDataType(type);
    }

    @Override
    public String getQuotedValue(String value, int dataType) {
        switch (dataType) {
            case 92: 
            case 93: {
                if (value == null || !"CURRENT_TIMESTAMP".equals(value = value.toUpperCase()) && !"NULL".equals(value)) break;
                return value;
            }
        }
        return super.getQuotedValue(value, dataType);
    }

    @Override
    public String modifyContent(NodeFactory.TAG tag, String content) {
        if (tag == NodeFactory.TAG.view && content != null) {
            int fromPos = content.toLowerCase().indexOf(" from ");
            int wherePos = content.toLowerCase().indexOf(" where ");
            if (wherePos == -1) {
                wherePos = content.length() - 1;
            }
            if (fromPos >= 0 && wherePos >= 0) {
                String fromClause = content.substring(fromPos, wherePos);
                String fromReplaced = fromClause.replaceAll("[\\(\\)]", "");
                return content.substring(0, fromPos) + fromReplaced + content.substring(wherePos);
            }
        }
        return super.modifyContent(tag, content);
    }

    @Override
    public String getDBMSTypeName() {
        return "MySQL";
    }

    @Override
    public String getDefaultStringByType(int type) {
        switch (type) {
            case 16: {
                return "0";
            }
        }
        return super.getDefaultStringByType(type);
    }

    @Override
    public int getTypeID() {
        return 4;
    }

    @Override
    boolean isIdentiferQuoteRequired(String name) throws SQLException {
        return super.isIdentiferQuoteRequired(name);
    }

    public String getDatabaseCreateCollation() {
        return "utf8mb4_unicode_ci";
    }
}

