/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jj.srv;

import java.util.ArrayList;

public class ThreadPool {
    private String name;
    private int maxThreadCount;
    private int currentThreadCount;
    private int threadID;
    private int idleWorkerThreadCount = 0;
    private ArrayList runnables = new ArrayList();

    public ThreadPool(String string, int n) {
        this.maxThreadCount = n;
        this.name = string;
    }

    public void clear() {
        this.runnables.clear();
    }

    synchronized Runnable getNextThread() {
        Runnable runnable;
        block7: {
            runnable = null;
            ++this.idleWorkerThreadCount;
            try {
                int n = 0;
                while (this.runnables.size() == 0 && n < 100) {
                    WorkerThread workerThread = (WorkerThread)Thread.currentThread();
                    try {
                        if (workerThread.hasBeenShutdown()) {
                            throw new InterruptedException();
                        }
                        this.wait(1000L);
                        ++n;
                    }
                    catch (InterruptedException interruptedException) {
                        workerThread.shutdown();
                        Runnable runnable2 = null;
                        Object var4_5 = null;
                        --this.idleWorkerThreadCount;
                        return runnable2;
                    }
                    catch (Throwable throwable) {}
                }
                if (this.runnables.size() <= 0) break block7;
                runnable = (Runnable)this.runnables.remove(0);
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                --this.idleWorkerThreadCount;
                throw throwable;
            }
        }
        Object var4_6 = null;
        --this.idleWorkerThreadCount;
        return runnable;
    }

    public synchronized void start(Runnable runnable) {
        this.runnables.add(runnable);
        if (this.idleWorkerThreadCount < this.runnables.size() && (this.currentThreadCount < this.maxThreadCount || this.maxThreadCount == 0)) {
            WorkerThread workerThread = new WorkerThread(this.name, this.threadID++);
            workerThread.start();
            ++this.currentThreadCount;
        }
        this.notify();
    }

    public class WorkerThread
    extends Thread {
        public Runnable currentRunnable;
        private boolean shutdown = false;

        public WorkerThread(String string, int n) {
            super(String.valueOf(string) + "-" + n);
            try {
                this.setDaemon(true);
                this.setPriority(5);
            }
            catch (Exception exception) {}
        }

        public boolean hasBeenShutdown() {
            return this.shutdown;
        }

        public void interrupt() {
            this.shutdown();
            super.interrupt();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            ThreadPool threadPool;
            try {
                try {
                    while (true) {
                        this.currentRunnable = ThreadPool.this.getNextThread();
                        if (this.currentRunnable == null) break;
                        this.currentRunnable.run();
                        this.currentRunnable = null;
                    }
                    Object var2_1 = null;
                    threadPool = ThreadPool.this;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    Object var2_2 = null;
                    ThreadPool threadPool2 = ThreadPool.this;
                    threadPool2.currentThreadCount = threadPool2.currentThreadCount - 1;
                    this.currentRunnable = null;
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                ThreadPool threadPool3 = ThreadPool.this;
                threadPool3.currentThreadCount = threadPool3.currentThreadCount - 1;
                this.currentRunnable = null;
                throw throwable;
            }
            threadPool.currentThreadCount = threadPool.currentThreadCount - 1;
            this.currentRunnable = null;
        }

        public void shutdown() {
            this.shutdown = true;
        }
    }
}

