/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jj.srv;

import com.inet.jj.srv.JJHashtable;
import com.inet.jj.srv.JJServer;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;

class Session {
    final JJHashtable jj_table = new JJHashtable();
    private JJServer srv;
    Connection con;
    int codierung;
    boolean isProxyConnection;
    String current_cmd;
    private String clientHostName;
    private boolean isClientHostRequester = true;
    String clientUrl;
    int stCount;
    int rsCount;
    int cstCount;
    int pstCount;
    int jcCount;
    long iniTime;
    Hashtable openedCommands;
    long lastRequestTime;
    private boolean isClosed;
    int hashValue;

    Session(JJServer jJServer) throws IOException {
        this.srv = jJServer;
        this.lastRequestTime = this.iniTime = System.currentTimeMillis();
    }

    void close(String string) {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        JJServer.session_table.remove(this.hashValue);
        if (this.srv.isDebug()) {
            this.srv.debug("Connection to " + this.getClientHostNameDebug() + " closed. Session ID " + this.hashValue);
        }
        try {
            Enumeration enumeration = this.jj_table.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof Statement) {
                    try {
                        ((Statement)e).close();
                    }
                    catch (Exception exception) {}
                }
                if (!(e instanceof ResultSet)) continue;
                try {
                    ((ResultSet)e).close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
        try {
            this.con.close();
        }
        catch (Exception exception) {}
        this.jj_table.clear();
        JJServer.conCount(false);
        if (this.srv.isWarning()) {
            this.srv.warning("Session " + this.hashValue + " to " + this.getClientHostNameDebug() + " closed. Last use: " + new Timestamp(this.lastRequestTime) + " cause: " + string);
        }
    }

    String getClientHostName() {
        if (this.isClientHostRequester) {
            Session session = this;
            synchronized (session) {
                if (this.isClientHostRequester) {
                    try {
                        this.wait(20000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.isClientHostRequester) {
                    String string = "Unknown Client";
                    Object var3_3 = null;
                    return string;
                }
            }
        }
        return this.clientHostName;
    }

    String getClientHostNameDebug() {
        return this.clientHostName;
    }

    void setClientHostName(String string) {
        this.clientHostName = string;
        this.isClientHostRequester = false;
        Session session = this;
        synchronized (session) {
            this.notifyAll();
        }
        if (this.srv.isWarning()) {
            this.srv.warning("Session " + this.hashValue + " client is: " + string);
        }
    }
}

