/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jj.srv;

import com.inet.jj.srv.PoolConnection;
import com.inet.jj.srv.PoolManager;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;

class PoolEntry {
    Connection c;
    boolean isUsing = true;
    long lastUse = System.currentTimeMillis();
    PoolManager pm;

    PoolEntry(PoolManager poolManager) {
        this.pm = poolManager;
    }

    void close() {
        try {
            this.c.close();
        }
        catch (Throwable throwable) {}
        this.c = null;
        this.isUsing = false;
        Object object = this.pm.waitForFreeCon;
        synchronized (object) {
            this.pm.waitForFreeCon.notify();
        }
        --this.pm.conCount;
    }

    public void connectionClosed() {
        this.isUsing = false;
        this.lastUse = System.currentTimeMillis();
        Object object = this.pm.waitForFreeCon;
        synchronized (object) {
            this.pm.waitForFreeCon.notify();
        }
    }

    PoolConnection init(Driver driver, String string, Properties properties) throws SQLException {
        this.c = driver.connect(string, (Properties)((Hashtable)properties).clone());
        if (this.c == null) {
            throw new SQLException("[JJServer] Invalid Driver Url: " + string);
        }
        String string2 = properties.getProperty("initSQL");
        if (string2 != null && string2.length() > 0) {
            Statement statement = this.c.createStatement();
            statement.executeQuery(string2);
            statement.close();
        }
        ++this.pm.conCount;
        return new PoolConnection(this.c, this);
    }
}

