/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jj.srv;

import com.inet.jj.srv.HashtableEntry;
import com.inet.jj.srv.HashtableEnumerator;
import java.util.Enumeration;

class JJHashtable {
    private transient HashtableEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    JJHashtable() {
        this(101, 0.75f);
    }

    JJHashtable(int n) {
        this(n, 0.75f);
    }

    JJHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new HashtableEntry[n];
        this.threshold = (int)((float)n * f);
    }

    synchronized void clear() {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = hashtableEntryArray.length;
        while (--n >= 0) {
            hashtableEntryArray[n] = null;
        }
        this.count = 0;
    }

    synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = hashtableEntryArray.length;
        while (n-- > 0) {
            HashtableEntry hashtableEntry = hashtableEntryArray[n];
            while (hashtableEntry != null) {
                if (hashtableEntry.value.equals(object)) {
                    return true;
                }
                hashtableEntry = hashtableEntry.next;
            }
        }
        return false;
    }

    synchronized boolean containsKey(int n) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n) {
                return true;
            }
            hashtableEntry = hashtableEntry.next;
        }
        return false;
    }

    synchronized Enumeration elements() {
        return new HashtableEnumerator(this.table, false);
    }

    synchronized Object get(int n) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n) {
                return hashtableEntry.value;
            }
            hashtableEntry = hashtableEntry.next;
        }
        return null;
    }

    boolean isEmpty() {
        return this.count == 0;
    }

    synchronized Enumeration keys() {
        return new HashtableEnumerator(this.table, true);
    }

    synchronized Object put(int n, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        HashtableEntry[] hashtableEntryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n) {
                Object object2 = hashtableEntry.value;
                hashtableEntry.value = object;
                return object2;
            }
            hashtableEntry = hashtableEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(n, object);
        }
        HashtableEntry hashtableEntry2 = new HashtableEntry();
        hashtableEntry2.hash = n;
        hashtableEntry2.value = object;
        hashtableEntry2.next = hashtableEntryArray[n2];
        hashtableEntryArray[n2] = hashtableEntry2;
        ++this.count;
        return null;
    }

    synchronized int put(Object object) {
        if (this.count >= this.threshold) {
            this.rehash();
        }
        int n = object.hashCode();
        HashtableEntry[] hashtableEntryArray = this.table;
        if (n == 0) {
            n = hashtableEntryArray.length;
        }
        HashtableEntry hashtableEntry = new HashtableEntry();
        hashtableEntry.value = object;
        ++this.count;
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry2 = hashtableEntryArray[n2];
        if (hashtableEntry2 == null) {
            hashtableEntryArray[n2] = hashtableEntry;
            hashtableEntry.hash = n;
            return hashtableEntry.hash;
        }
        while (hashtableEntry2.hash != n) {
            if (hashtableEntry2.next == null) {
                hashtableEntry2.next = hashtableEntry;
                hashtableEntry.hash = n;
                return hashtableEntry.hash;
            }
            hashtableEntry2 = hashtableEntry2.next;
        }
        int n3 = hashtableEntryArray.length;
        while (--n3 >= 0) {
            if (hashtableEntryArray[n3] != null) continue;
            hashtableEntryArray[n3] = hashtableEntry;
            hashtableEntry.hash = n3;
            return hashtableEntry.hash;
        }
        throw new RuntimeException("Hashtable - Internal Error on put:" + n + " " + object);
    }

    private void rehash() {
        int n = this.table.length;
        HashtableEntry[] hashtableEntryArray = this.table;
        int n2 = n * 2 + 1;
        HashtableEntry[] hashtableEntryArray2 = new HashtableEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = hashtableEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            HashtableEntry hashtableEntry = hashtableEntryArray[n3];
            while (hashtableEntry != null) {
                HashtableEntry hashtableEntry2 = hashtableEntry;
                hashtableEntry = hashtableEntry.next;
                int n4 = (hashtableEntry2.hash & Integer.MAX_VALUE) % n2;
                hashtableEntry2.next = hashtableEntryArray2[n4];
                hashtableEntryArray2[n4] = hashtableEntry2;
            }
        }
    }

    synchronized Object remove(int n) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        HashtableEntry hashtableEntry2 = null;
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n) {
                if (hashtableEntry2 != null) {
                    hashtableEntry2.next = hashtableEntry.next;
                } else {
                    hashtableEntryArray[n2] = hashtableEntry.next;
                }
                --this.count;
                return hashtableEntry.value;
            }
            hashtableEntry2 = hashtableEntry;
            hashtableEntry = hashtableEntry.next;
        }
        return null;
    }

    int size() {
        return this.count;
    }
}

