/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jj.srv;

import com.inet.jj.srv.JJServer;
import com.inet.jj.srv.Session;
import java.util.Enumeration;

class ClientObserver
implements Runnable {
    private static final int DELAY = 60000;
    private JJServer srv;
    private boolean stopped;
    private Thread thread;

    ClientObserver(JJServer jJServer) {
        this.srv = jJServer;
        this.thread = new Thread((Runnable)this, "Konnekter client observer");
        this.thread.setPriority(1);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void run() {
        while (!this.stopped) {
            try {
                long l = System.currentTimeMillis();
                int n = this.srv.getInactiveTimeout() * 1000;
                if (n != 0) {
                    Enumeration enumeration = JJServer.session_table.elements();
                    while (enumeration.hasMoreElements()) {
                        Session session = (Session)enumeration.nextElement();
                        if (l - session.lastRequestTime > (long)n) {
                            if (this.srv.isDebug()) {
                                this.srv.debug("Closing connection to '" + session.getClientHostNameDebug() + "' after timeout expired. Current inactive timeout " + n / 1000 + " sec.");
                            }
                            session.close("Timeout");
                        }
                        Thread.sleep(10L);
                    }
                }
                Thread.sleep(60000L);
            }
            catch (Exception exception) {
                this.srv.warning(exception);
            }
        }
    }

    void stop() {
        this.stopped = true;
        this.thread.interrupt();
    }
}

