/*
 * Decompiled with CFR 0.152.
 */
package srv.orderlistcache;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.shared.rpc.QueryParameter;
import com.inet.jj.srv.JavaCommand;
import com.inet.lib.json.Json;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import srv.UserNameMappingResultSet;
import srv.orderlistcache.CachedResultSet;
import srv.orderlistcache.cache.QueryCache;
import srv.orderlistcache.cache.QueryCacheKey;

public class OrderListCommand
extends JavaCommand {
    private String command;
    private List<QueryCacheKey.Parameter> parameters = new ArrayList<QueryCacheKey.Parameter>();
    private final QueryCache cache;

    public OrderListCommand(QueryCache cache, String commandName) {
        this.cache = cache;
        this.command = commandName;
    }

    public void setObject(String paramName, Object value) throws SQLException {
        if (value == null) {
            return;
        }
        QueryParameter[] jsonParameters = (QueryParameter[])new Json().fromJson(value.toString(), QueryParameter[].class);
        if (jsonParameters != null) {
            for (QueryParameter param : jsonParameters) {
                this.parameters.add(new QueryCacheKey.Parameter(param));
            }
        }
    }

    public ResultSet executeQuery() throws SQLException {
        QueryCacheKey key = this.parameters.size() > 0 ? new QueryCacheKey(this.command, this.parameters.toArray(new QueryCacheKey.Parameter[this.parameters.size()])) : new QueryCacheKey(this.command, new QueryCacheKey.Parameter[0]);
        CachedResultSet cachedResultSet = this.cache.get(key);
        if (HDLogger.isDebug()) {
            HDLogger.error("REQUEST: " + key + " ==>" + (cachedResultSet != null ? Integer.toString(cachedResultSet.getRowCount()) : "ERROR"));
        }
        if (cachedResultSet != null) {
            CachedResultSet copy = cachedResultSet.createCopy();
            if (this.getMaxRows() > 0) {
                copy.setMaxRows(this.getMaxRows());
            }
            return new UserNameMappingResultSet(copy, "UserID");
        }
        this.cache.invalidate(key);
        return null;
    }

    public int executeUpdate() throws SQLException {
        throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + " cannot perform executeUpdate() calls");
    }

    public boolean execute() throws SQLException {
        throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + " cannot perform execute() calls");
    }
}

