/*
 * Decompiled with CFR 0.152.
 */
package srv.mail;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.TempDirectory;
import com.inet.helpdesk.core.utils.AttachedFile;
import com.inet.helpdesk.core.utils.MailAttachmentUtilities;
import com.inet.helpdesk.core.utils.MailEncodingUtilities;
import com.inet.helpdesk.core.utils.SecurityUtils;
import com.inet.persistence.PersistenceEntry;
import com.inet.persistence.file.FilePersistenceFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;

public class MailFileMethods {
    private static final String LEER_STRING = "";
    private OutputStream os;

    public boolean isOutputStreamUsed() {
        return this.os != null;
    }

    public void closeOutputStream() throws IOException {
        if (this.isOutputStreamUsed()) {
            this.os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WritePartToFileResult writePartToFile(File file, Part p, boolean checkForID, String possibleId, String firstId) throws MessagingException {
        boolean erfolg = true;
        InputStream is = null;
        int anzahlZeichen = 4096;
        try {
            byte[] in_outtext = new byte[anzahlZeichen];
            this.os = new FileOutputStream(file);
            is = p.getInputStream();
            while (anzahlZeichen > 0) {
                anzahlZeichen = is.read(in_outtext, 0, 4096);
                if (checkForID && (possibleId = this.searchForID(firstId, anzahlZeichen, in_outtext, possibleId)) != null) {
                    checkForID = false;
                }
                if (anzahlZeichen <= -1) continue;
                this.os.write(in_outtext, 0, anzahlZeichen);
            }
        }
        catch (Throwable e) {
            erfolg = false;
            try {
                file.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            HDLogger.debug("Fehler bei " + file.getName() + " " + anzahlZeichen);
            HDLogger.error(e);
        }
        finally {
            try {
                this.os.close();
            }
            catch (Throwable in_outtext) {}
            this.os = null;
            try {
                is.close();
            }
            catch (Throwable in_outtext) {}
        }
        return new WritePartToFileResult(possibleId, erfolg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WritePartToFileResult writePartToFile(PersistenceEntry file, Part p, boolean checkForID, String possibleId, String firstId) throws MessagingException {
        boolean erfolg = true;
        InputStream is = null;
        int anzahlZeichen = 4096;
        try {
            byte[] in_outtext = new byte[anzahlZeichen];
            this.os = file.getOutputStream();
            is = p.getInputStream();
            while (anzahlZeichen > 0) {
                anzahlZeichen = is.read(in_outtext, 0, 4096);
                if (checkForID && (possibleId = this.searchForID(firstId, anzahlZeichen, in_outtext, possibleId)) != null) {
                    checkForID = false;
                }
                if (anzahlZeichen <= -1) continue;
                this.os.write(in_outtext, 0, anzahlZeichen);
            }
        }
        catch (Throwable e) {
            erfolg = false;
            try {
                file.deleteValue();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            HDLogger.debug("Fehler bei " + file.getName() + " " + anzahlZeichen);
            HDLogger.error(e);
        }
        finally {
            try {
                this.os.close();
            }
            catch (Throwable in_outtext) {}
            this.os = null;
            try {
                is.close();
            }
            catch (Throwable in_outtext) {}
        }
        return new WritePartToFileResult(possibleId, erfolg);
    }

    private String searchForID(String firstId, int signs, byte[] dataBytes, String posibleIdString) {
        char startChar = firstId.charAt(0);
        for (int i = 0; i < signs - (firstId.length() + 15); ++i) {
            int n;
            if (dataBytes[i] != startChar) continue;
            for (n = 1; n < firstId.length() && dataBytes[i + n] == firstId.charAt(n); ++n) {
            }
            if (n != firstId.length()) continue;
            int len = signs - (i + 10);
            if (len > 30) {
                len = 30;
            }
            if (len > 0) {
                return new String(dataBytes, i, len);
            }
            return posibleIdString;
        }
        return posibleIdString;
    }

    public File getFile(String name) {
        Path verzPath = TempDirectory.ATTACHMENTS_PUFFER;
        File file = verzPath.toFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        if (name.indexOf(92) > 0) {
            name = name.substring(name.lastIndexOf(92) + 1);
        }
        if ((name = FilePersistenceFactory.normalizeName((String)name, (boolean)false)).length() > 100) {
            name = name.substring(name.length() - 100);
        }
        File result = verzPath.resolve(name).toFile();
        return result;
    }

    void writeToFile(File file, String content, String encoding) {
        if ("base64".equals(encoding)) {
            StringBuilder build = new StringBuilder();
            for (int i = 0; i < content.length(); ++i) {
                if (content.charAt(i) <= ' ') continue;
                build.append(content.charAt(i));
            }
            String str = build.toString();
            this.writeToFile(file, SecurityUtils.decodeBase64(str.getBytes()));
        } else {
            this.writeToFile(file, content.getBytes());
        }
    }

    String writeToFile(String fileName, String fileExtention, String content, List<AttachedFile> allFiles, boolean setBufferedContent) {
        AttachedFile anlage = new AttachedFile(MailAttachmentUtilities.getFileName(fileName, fileExtention, allFiles));
        anlage.setFile(this.getFile(anlage.getFileName()));
        this.writeToFile(anlage.getFile(), content.getBytes());
        if (setBufferedContent) {
            anlage.setBufferedContent(content);
        }
        allFiles.add(anlage);
        return anlage.getFileName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeToFile(File file, byte[] content) {
        try {
            this.os = new FileOutputStream(file);
            this.os.write(content);
        }
        catch (Throwable e) {
            HDLogger.debug("Fehler bei byte " + file.getName());
            HDLogger.error(e);
        }
        finally {
            try {
                this.os.close();
            }
            catch (Throwable throwable) {}
            this.os = null;
        }
        content = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeToFile(File file, Message m, boolean fetchContent) {
        String contentStr = LEER_STRING;
        try {
            this.os = new FileOutputStream(file);
            m.writeTo(this.os);
            try {
                this.os.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (fetchContent) {
                contentStr = this.fetchMessage(file);
            }
        }
        catch (Throwable e) {
            HDLogger.error(e);
            try {
                this.os.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            this.os = null;
        }
        return contentStr;
    }

    private String fetchMessage(File targ) {
        String[] metaDaten = new String[3];
        String string = LEER_STRING;
        StringBuffer contentBuf = new StringBuffer();
        try {
            FileInputStream is = new FileInputStream(targ);
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)is, "8859_1"));
            this.moveDownTheHeader(in, metaDaten);
            if (metaDaten[0].length() == 0 && metaDaten[1].length() == 0 || metaDaten[0].equals("text/plain;")) {
                this.fetchPartContent(in, contentBuf, metaDaten[1]);
                string = metaDaten[2].equals("quoted-printable") ? MailFileMethods.decodePrintable(contentBuf.toString()) : (metaDaten[2].equals("utf-7") ? MailEncodingUtilities.replaceUTF7codes(contentBuf.toString(), false) : contentBuf.toString());
            } else if (metaDaten[0].startsWith("multipart/alternative;")) {
                String headerInfo = this.fetchPartHeader(in);
                this.fetchPartContent(in, contentBuf, metaDaten[1]);
                string = headerInfo.indexOf("Content-Transfer-Encoding: quoted-printable") > -1 ? MailFileMethods.decodePrintable(contentBuf.toString()) : (headerInfo.indexOf("charset=\"utf-7\"") > -1 ? MailEncodingUtilities.replaceUTF7codes(contentBuf.toString(), false) : contentBuf.toString());
            } else if (metaDaten[0].indexOf("multipart/") > -1) {
                String headerInfo = this.fetchPartHeader(in);
                this.fetchPartContent(in, contentBuf, metaDaten[1]);
                string = headerInfo.indexOf("Content-Transfer-Encoding: quoted-printable") > -1 ? MailFileMethods.decodePrintable(contentBuf.toString()) : (headerInfo.indexOf("charset=\"utf-7\"") > -1 ? MailEncodingUtilities.replaceUTF7codes(contentBuf.toString(), false) : contentBuf.toString());
            } else {
                HDLogger.debug("Can not handle Part structure from file!");
                HDLogger.warn("EmailReader: Can not handle Part structure from file!");
            }
            in.close();
            is.close();
        }
        catch (Throwable e) {
            HDLogger.error(e);
        }
        return string;
    }

    private static String decodePrintable(String inString) {
        if (inString.indexOf(61) != -1) {
            char[] chars = new char[inString.length()];
            int writePos = 0;
            for (int i = 0; i < inString.length(); ++i) {
                char ch = inString.charAt(i);
                if (ch == '=' && i < inString.length() - 2) {
                    int result = MailFileMethods.parseInt(inString.charAt(i + 1), inString.charAt(i + 2));
                    if (result == -1) {
                        ++i;
                        continue;
                    }
                    if (result != 0) {
                        chars[writePos++] = (char)result;
                        i += 2;
                        continue;
                    }
                    chars[writePos++] = ch;
                    continue;
                }
                chars[writePos++] = ch;
            }
            return new String(chars, 0, writePos);
        }
        return inString;
    }

    private static int parseInt(char charEins, char charZwei) {
        int result = 0;
        if (charEins == '-') {
            return 0;
        }
        if (charEins == '\n') {
            return -1;
        }
        int digit = Character.digit(charEins, 16);
        if (digit < 0) {
            return 0;
        }
        result = -digit;
        int multmin = -134217727;
        digit = Character.digit(charZwei, 16);
        if (digit < 0) {
            return 0;
        }
        if (result < multmin) {
            return 0;
        }
        if ((result *= 16) < -2147483647 + digit) {
            return 0;
        }
        return -(result -= digit);
    }

    private void moveDownTheHeader(BufferedReader reader, String[] metaDaten) throws IOException {
        String line;
        metaDaten[0] = LEER_STRING;
        metaDaten[1] = LEER_STRING;
        metaDaten[2] = LEER_STRING;
        while ((line = reader.readLine()) != null) {
            if (line.length() == 0 && metaDaten[1].length() == 0) {
                return;
            }
            if (line.length() > 0 && metaDaten[1].equals(line)) {
                return;
            }
            if (line.startsWith("Content-Type: ")) {
                int pos2;
                metaDaten[0] = line.substring(14);
                if (metaDaten[0].indexOf("boundary=\"") > 0) {
                    metaDaten[1] = "--" + metaDaten[0].substring(metaDaten[0].indexOf("boundary=\"") + 10, metaDaten[0].length() - 1);
                    continue;
                }
                line = reader.readLine();
                if (line.indexOf("boundary=\"") == 1) {
                    metaDaten[1] = "--" + line.substring(11, line.length() - 1);
                    continue;
                }
                int pos = line.indexOf("charset=\"");
                if (pos <= -1 || (pos2 = line.indexOf(34, pos + 10)) <= -1) continue;
                metaDaten[2] = line.substring(pos + 9, pos2);
                continue;
            }
            if (!line.startsWith("Content-Transfer-Encoding: ")) continue;
            metaDaten[2] = line.substring(27);
        }
    }

    private String fetchPartHeader(BufferedReader reader) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = reader.readLine()) != null && line.length() != 0) {
            buf.append(line).append('\n');
        }
        return buf.toString();
    }

    private boolean fetchPartContent(BufferedReader reader, StringBuffer buf, String boundary) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if (boundary.length() > 0 && line.startsWith(boundary) && line.length() < boundary.length() + 3) {
                return line.length() != boundary.length();
            }
            buf.append(line).append('\n');
        }
        return true;
    }

    class WritePartToFileResult {
        private final String possibleId;
        private final boolean success;

        WritePartToFileResult(String possibleId, boolean success) {
            this.possibleId = possibleId;
            this.success = success;
        }

        String getPossibleId() {
            return this.possibleId;
        }

        boolean isSuccess() {
            return this.success;
        }
    }
}

