/*
 * Decompiled with CFR 0.152.
 */
package srv.mail;

import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.i18n.LocalizationImpl;
import com.inet.id.GUID;
import com.inet.notification.Notification;
import com.inet.notification.NotificationManager;
import com.inet.notification.PermissionNotificationGenerator;
import com.inet.permissions.Permission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class MailConnectionErrorNotification
extends PermissionNotificationGenerator {
    private static Set<GUID> PREVIOUS_ERROR_IDS = new HashSet<GUID>();
    private static Set<GUID> USED_ERROR_IDS = new HashSet<GUID>();
    private GUID id;
    private String emailHost;
    private String errorMessage;

    public MailConnectionErrorNotification(EmailAccount postfach, String errorMessage) {
        super(new Permission[]{Permission.CONFIGURATION, HdPermissions.TICKET_RESOURCES_READ_WRITE});
        this.errorMessage = errorMessage;
        this.id = MailConnectionErrorNotification.getNotificationIdFor(postfach);
        this.emailHost = postfach.getHost();
        USED_ERROR_IDS.add(this.id);
    }

    public String getPeriodKey() {
        return this.errorMessage;
    }

    public GUID getId() {
        return this.id;
    }

    public Notification createNotification() {
        String title = LocalizationImpl.getStaticInstance().getTranslation("MAIL_CONNECT_FAIL", new Object[]{this.emailHost});
        Notification notification = new Notification(title, this.errorMessage);
        notification.setCritical(true);
        return notification;
    }

    public static GUID getNotificationIdFor(EmailAccount postfach) {
        int hashCode = postfach.getAccount() == null ? 23684 : postfach.getAccount().hashCode();
        int hashCode2 = postfach.getHost() == null ? 3564567 : postfach.getHost().hashCode();
        return GUID.generateFor((int)(723 + 31 * hashCode + 11 * postfach.getPort() + 13 * hashCode2));
    }

    public static void clearUnusedErrors() {
        ArrayList<GUID> toRemove = new ArrayList<GUID>(PREVIOUS_ERROR_IDS);
        toRemove.removeAll(USED_ERROR_IDS);
        for (GUID guid : toRemove) {
            NotificationManager.getInstance().unregisterGenerator(guid);
        }
        PREVIOUS_ERROR_IDS = USED_ERROR_IDS;
        USED_ERROR_IDS = new HashSet<GUID>();
    }

    static Set<GUID> getPrevious_ERROR_IDS() {
        return PREVIOUS_ERROR_IDS;
    }
}

