/*
 * Decompiled with CFR 0.152.
 */
package srv.mail;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.mail.OutMailProcessor;
import com.inet.mail.api.BaseEmail;
import com.inet.mail.api.MailAuthenticationMethod;
import com.inet.mail.api.MailEncryption;
import com.inet.plugin.ServerPluginManager;
import java.util.Collection;
import java.util.List;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import srv.mail.Mail;

public abstract class HelpDeskBaseEmail
extends BaseEmail {
    public static MailSender senderObj;

    protected Collection<MimeMessage> willSend(MimeMessage m, Session session) throws MessagingException {
        List processors = ServerPluginManager.getInstance().get(OutMailProcessor.class);
        if (!processors.isEmpty()) {
            if (processors.size() != 1) {
                throw new IllegalStateException("Only one mail processor plug-in allowed");
            }
            OutMailProcessor processor = (OutMailProcessor)processors.get(0);
            Collection<MimeMessage> procMsgList = processor.process(m, session);
            if (procMsgList != null) {
                procMsgList.forEach(msg -> {
                    try {
                        msg.setFlags(new Flags("autoresponse"), true);
                    }
                    catch (MessagingException e) {
                        HDLogger.error((Object)e);
                    }
                });
                return procMsgList;
            }
        }
        return super.willSend(m, session);
    }

    protected Object send(String host, String port, String pop3Host, String pop3Port, MailAuthenticationMethod authMode, MailEncryption encryption, String user, String password, InternetAddress sender) throws MessagingException {
        senderObj.baseEmail(this);
        return senderObj.send(() -> super.send(host, port, pop3Host, pop3Port, authMode, encryption, user, password, sender));
    }

    public static void setSenderObj(MailSender senderObj) {
        if (senderObj == null) {
            senderObj = method -> method.sendMail();
        }
        Mail.senderObj = senderObj;
    }

    static {
        HelpDeskBaseEmail.setSenderObj(null);
    }

    public static interface SendMethod {
        public Object sendMail() throws MessagingException;
    }

    public static interface MailSender {
        public Object send(SendMethod var1) throws MessagingException;

        default public void baseEmail(HelpDeskBaseEmail helpDeskBaseEmail) {
        }
    }
}

