/*
 * Decompiled with CFR 0.152.
 */
package srv.mail;

import com.inet.helpdesk.core.HDLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class DeliveryStatusInformation {
    private static final String RFC822 = "rfc822;";
    private static int PERSISTENT_TRANSIENT_FFAILURE = 4;
    public static int PERMANENT_FFAILURE = 5;
    public static int ADDRESSING_STATUS = 1;
    private static int MAILBOX_STATUS = 2;
    private static int SYSTEM_STATUS = 3;
    private int status_code_class = 0;
    private int status_code_subject = 0;
    private int status_code_detail = 0;
    private String recipient = "";
    private String action = "";
    private String diagnostic = "unknown";

    private DeliveryStatusInformation() {
    }

    public DeliveryStatusInformation(int status_code_class, int status_code_subject, int status_code_detail) {
        this.status_code_class = status_code_class;
        this.status_code_subject = status_code_subject;
        this.status_code_detail = status_code_detail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeliveryStatusInformation(File file) {
        StringBuffer strBuf = new StringBuffer();
        FileInputStream is = null;
        InputStreamReader isr = null;
        try {
            int ch;
            is = new FileInputStream(file);
            isr = new InputStreamReader(is);
            while ((ch = isr.read()) != -1) {
                strBuf.append((char)ch);
            }
            String content = strBuf.toString();
            StringTokenizer tokens = new StringTokenizer(content, "\r\n");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                int splitPos = token.indexOf(58);
                if (splitPos <= -1) continue;
                String key = token.substring(0, splitPos);
                String value = token.substring(splitPos + 1).trim().toLowerCase();
                if ("Status".equalsIgnoreCase(key)) {
                    int blankPos = value.indexOf(32);
                    if (blankPos > -1) {
                        value = value.substring(0, blankPos);
                    }
                    int firstDot = value.indexOf(46);
                    int secondDot = value.lastIndexOf(46);
                    this.status_code_class = Integer.parseInt(value.substring(0, firstDot));
                    this.status_code_subject = Integer.parseInt(value.substring(firstDot + 1, secondDot));
                    this.status_code_detail = Integer.parseInt(value.substring(secondDot + 1));
                    continue;
                }
                if ("Final-Recipient".equalsIgnoreCase(key)) {
                    if (value.startsWith(RFC822)) {
                        value = value.substring(RFC822.length()).trim();
                    }
                    this.recipient = value;
                    continue;
                }
                if ("Action".equalsIgnoreCase(key)) {
                    this.action = value;
                    continue;
                }
                if (!"Diagnostic-Code".equalsIgnoreCase(key) && (!this.diagnostic.equals("unknown") || !"X-Supplementary-Info".equalsIgnoreCase(key))) continue;
                this.diagnostic = value;
            }
        }
        catch (Throwable ex) {
            HDLogger.error(ex);
        }
        finally {
            try {
                isr.close();
            }
            catch (Throwable ch) {}
            try {
                is.close();
            }
            catch (Throwable ch) {}
        }
    }

    public boolean isPermanentFailure() {
        return this.status_code_class == PERMANENT_FFAILURE;
    }

    public boolean isTemporaryFailure() {
        return this.status_code_class == PERSISTENT_TRANSIENT_FFAILURE;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public String getAction() {
        return this.action;
    }

    public String getDiagnosticCode() {
        if ("unknown".endsWith(this.diagnostic)) {
            return this.status_code_class + "." + this.status_code_subject + "." + this.status_code_detail + " " + this.action;
        }
        return this.diagnostic;
    }

    public boolean isServerStorageProblem() {
        return this.status_code_subject == MAILBOX_STATUS && (this.status_code_detail == 1 || this.status_code_detail == 2) || this.status_code_subject == SYSTEM_STATUS && this.status_code_detail == 1;
    }

    public boolean isSizeProblem() {
        return this.status_code_subject == MAILBOX_STATUS && this.status_code_detail == 3 || this.status_code_subject == MAILBOX_STATUS && this.status_code_detail == 11 || this.status_code_subject == MAILBOX_STATUS && this.status_code_detail == 12 || this.status_code_subject == SYSTEM_STATUS && this.status_code_detail == 4;
    }

    public boolean isAddressProblem() {
        if (this.status_code_subject == ADDRESSING_STATUS) {
            if (this.status_code_detail != 5) {
                return true;
            }
        } else {
            if (this.isPermanentFailure() && (this.status_code_subject == 0 || this.status_code_subject == 3 || this.status_code_subject == 5) && this.status_code_detail == 0) {
                return true;
            }
            if (this.isPermanentFailure() && this.status_code_subject == 4 && this.status_code_detail == 4) {
                return true;
            }
            if (this.isPermanentFailure() && this.status_code_subject == 7 && this.status_code_detail == 1 && this.diagnostic.contains("relay")) {
                return true;
            }
        }
        return false;
    }

    public boolean isContentProblem() {
        return this.isPermanentFailure() && this.status_code_subject == 7 && (this.status_code_detail == 1 || this.status_code_detail == 0) && !this.diagnostic.contains("relay");
    }

    public static DeliveryStatusInformation getInvalidAddressInfo(String address) {
        DeliveryStatusInformation dsi = new DeliveryStatusInformation();
        dsi.status_code_class = PERMANENT_FFAILURE;
        dsi.status_code_subject = ADDRESSING_STATUS;
        dsi.status_code_detail = 1;
        dsi.recipient = address.toLowerCase();
        dsi.action = "suppress";
        dsi.diagnostic = "Suppressed account!";
        return dsi;
    }

    protected static DeliveryStatusInformation getAutoMailCountBlocker() {
        DeliveryStatusInformation dsi = new DeliveryStatusInformation();
        dsi.status_code_class = PERSISTENT_TRANSIENT_FFAILURE;
        dsi.status_code_subject = 0;
        dsi.status_code_detail = 0;
        dsi.recipient = "";
        dsi.action = "block";
        dsi.diagnostic = "To many mails for this ticket!";
        return dsi;
    }
}

