/*
 * Decompiled with CFR 0.152.
 */
package srv.mail;

import com.inet.helpdesk.config.EmailAccount;
import java.util.Hashtable;

public class CombinationCheck {
    private Hashtable<String, Integer> emailsLastLoop = new Hashtable();
    private Hashtable<String, Integer> emailsCurrentLoop = new Hashtable();
    private static final String[] PREFIXES_TO_NEGLECT = new String[]{"aw: ", "re: ", "fw: ", "wg: ", "fwd: "};

    public Integer gotTheSameBefore(String subject, EmailAccount account, String senderAddress) {
        Integer result = null;
        if (this.bundleAllowedTest(account, senderAddress.toLowerCase())) {
            String key = this.getKey(senderAddress, account, subject);
            result = this.emailsLastLoop.get(key);
            if (result == null) {
                result = this.emailsCurrentLoop.get(key);
            } else {
                this.emailsCurrentLoop.put(key, result);
            }
        }
        return result;
    }

    protected boolean bundleAllowedTest(EmailAccount account, String senderAddress) {
        String test = account.getNoBundles();
        if (test != null) {
            if ((test = test.toLowerCase()).equalsIgnoreCase("*")) {
                return false;
            }
            if (test.equals(senderAddress) || test.startsWith(senderAddress + ";") || test.endsWith(";" + senderAddress) || test.indexOf(";" + senderAddress + ";") > -1) {
                return false;
            }
        }
        return true;
    }

    private String getKey(String senderAddress, EmailAccount account, String subject) {
        if (subject == null) {
            subject = "";
        } else {
            subject = subject.toLowerCase();
            for (String element : PREFIXES_TO_NEGLECT) {
                if (!subject.startsWith(element)) continue;
                subject = subject.substring(element.length());
                break;
            }
        }
        return senderAddress + " " + account.getAccount() + " " + subject;
    }

    public void noticeNewTicket(String subject, EmailAccount account, String senderAddress, Integer ticketId) {
        this.emailsCurrentLoop.put(this.getKey(senderAddress, account, subject), ticketId);
    }

    public void cycleFinished() {
        this.emailsLastLoop = this.emailsCurrentLoop;
        this.emailsCurrentLoop = new Hashtable();
    }
}

