/*
 * Decompiled with CFR 0.152.
 */
package srv.mail;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.components.MinutenFeld;
import com.inet.helpdesk.config.AliasMapper;
import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.config.EmailAccountList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.MailResourceToAbsenderAndAliasMap;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.HelpDeskServerException;
import com.inet.helpdesk.core.mail.MailAttachment;
import com.inet.helpdesk.core.mail.MailMetaData;
import com.inet.helpdesk.core.mail.MailUtilities;
import com.inet.helpdesk.core.mail.SendAutoMailExtension;
import com.inet.helpdesk.core.model.ticket.TableColumnDatabaseFieldModificationProvider;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.mail.reader.EmailReader_Main;
import com.inet.helpdesk.search.user.tokenmatchers.SupporterUserConditionTokenMatcher;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.logging.Logger;
import com.inet.mail.api.MailDataSource;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.EmailAddressHelper;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import srv.ServerUtilities;
import srv.automatic.trigger.Trigger;
import srv.automatic.trigger.TriggerHandler;
import srv.controller.ticket.timeline.ResourceTimelineManager;
import srv.mail.BlackListHandler;
import srv.mail.HelpDeskBaseEmail;
import srv.mail.Mail;
import srv.mail.TemplatePlaceholderReplacementFinder;

public class AutoMail
implements Runnable {
    public static final ConfigValue<String> MAIL_FROM = new ConfigValue(ConfigKey.MAIL_SENDER);
    static final ConfigValue<String> MAIL_USERS_DEF_ABSENDER = new ConfigValue(HDConfigKeys.MAIL_USERS_DEF_ABSENDER);
    static final ConfigValue<String> MAIL_USERS_DEF_ABSENDER_NAME = new ConfigValue(HDConfigKeys.MAIL_USERS_DEF_ABSENDER_NAME);
    static final ConfigValue<String> MAIL_RESOURCES_DEF_ABSENDER = new ConfigValue(HDConfigKeys.MAIL_RESOURCES_DEF_ABSENDER);
    static final ConfigValue<String> MAIL_RESOURCES_DEF_ABSENDER_NAME = new ConfigValue(HDConfigKeys.MAIL_RESOURCES_DEF_ABSENDER_NAME);
    static final ConfigValue<MailResourceToAbsenderAndAliasMap> MAIL_RESOURCE_TO_ABSENDER_AND_ALIAS_MAP = new ConfigValue(HDConfigKeys.MAIL_RESOURCE_TO_ABSENDER_AND_ALIAS_MAP);
    private static final ConfigValue<String> MAILTO_DISPATCHER = new ConfigValue(HDConfigKeys.MAILTO_DISPATCHER);
    private static final ConfigValue<String> MAIL_FORMAT = new ConfigValue(HDConfigKeys.MAIL_FORMAT);
    private static final ConfigValue<String> MAIL_LOGO_FILE = new ConfigValue(ConfigKey.IMPRINT_LOGO_URL);
    private static final ConfigValue<String> SUBTEMPLATE_ORDER = new ConfigValue(HDConfigKeys.SUBTEMPLATE_ORDER);
    private static final ConfigValue<String> FOREIGN_KEY_COLUMN = new ConfigValue(HDConfigKeys.FOREIGN_KEY_COLUMN);
    private static final ConfigValue<String> COMPANY_ADDRESS = new ConfigValue(HDConfigKeys.DEFAULT_COMPANY_ADDRESS);
    private static final String DATA_QUERY = "SELECT tblAuf.EmailEingang, tblAuf.BetID, tblAuf.Auftrag, tblAuf.ishtml, tblAuf.DerBetreff, tblAuf.DeadlineZeit, tblAuf.PriID, tblAuf.AutorisierenReaID, tblAuf.spezFeld, tblAuf.WFID, tblAuf.AnfReaID, tblRealisierung.UserID as DisID, tblPrioritaeten.PriBezeichnung, tblRessourcen.ResID, tblRessourcen.ResBezeichnung, tblRessourcen.Email, tblRessourcen.MsgText, tblRessourcen.MsgVon, tblRessourcen.MsgBis, tblRessourcen.Rechte, tblRessourcen.Stundensatz, tblBenutzerGruppe.GroupName, tblKlasse.KlassenName, tblKlasse.KlasseInfo, tblUser.UsrID, tblUser.Nachname, tblUser.Vorname, tblUser.Telefon, tblUser.Email AS UserEmail, tblUser.Zimmer, tblUser.Computername, tblUser.Abteilung, tblUser.Kostenstelle, tblUser.SprID, tblUser.Frei1, tblUser.Frei2, tblUser.Frei3, tblUser.Frei4, tblUser.Frei5, tblGebaeude.GebBezeichnung, tblGebaeude.Adresse, tblBuendel.*, tblStatus.StatusBezeichnung, tblItil.ItilBezeichnung, tblItil.MsgTyp, tblItil.MsgEmail FROM tblBuendel INNER JOIN tblAuftraege tblAuf ON tblBuendel.BunID = tblAuf.BunID INNER JOIN tblAuftraege tblAuf_master ON tblAuf.BunID = tblAuf_master.AufID INNER JOIN tblItil ON tblAuf.ItiID = tblItil.ItiID INNER JOIN tblKlasse ON tblAuf.KlaID = tblKlasse.KlaID INNER JOIN tblPrioritaeten ON tblAuf.PriID = tblPrioritaeten.PriID INNER JOIN tblStatus ON tblBuendel.Status = tblStatus.Status INNER JOIN tblRessourcen ON tblAuf_master.ResID = tblRessourcen.ResID LEFT OUTER JOIN tblRealisierung ON tblAuf.AutorisierenReaID = tblRealisierung.ReaID LEFT OUTER JOIN tblUser INNER JOIN tblBenutzerGruppe ON tblUser.BgrID = tblBenutzerGruppe.BgrID INNER JOIN tblGebaeude ON tblUser.GebID = tblGebaeude.GebID ON tblAuf.UsrID = tblUser.UsrID WHERE tblAuf.AufID = ?";
    public static final int ANFRAGE_USER = 1;
    public static final int ANFRAGE_DISP = 2;
    public static final int AUTORISIEREN_USER = 3;
    public static final int AUTORISIEREN_RES = 4;
    public static final int MAILEINGANG_RES = 5;
    public static final int WIEDERVORLAGE = 6;
    public static final int MANU_ESCALATION_DISP = 7;
    public static final int MANU_ESCALATION_RES = 8;
    public static final int AUTO_ESCALATION_DISP = 9;
    public static final int AUTO_ESCALATION_RES = 10;
    public static final int AUTO_MAHNUNG_DISP = 11;
    public static final int AUTO_MAHNUNG_RES = 12;
    public static final int BEENDEN = 13;
    public static final int ERROR = 14;
    public static final int NEW_INCIDENT = 15;
    public static final int LOOP_ERROR = 16;
    public static final int ESCA_WARN_YELLOW = 17;
    public static final int ESCA_WARN_RED = 18;
    public static final int DEAD_WARN_YELLOW = 19;
    public static final int DEAD_WARN_RED = 20;
    public static final int MAILEINGANG_DISP = 21;
    public static final int NO_NEW_TICKETS = 22;
    public static final int TRIGGER_MAIL = 666;
    public static final String KEY_ABTEILUNG = "abteilung";
    public static final String KEY_ADRESSE = "adresse";
    public static final String KEY_ANFRAGEDATUM = "anfragedatum";
    public static final String KEY_ANFRAGEDATUMGMT = "anfragedatumgmt";
    public static final String KEY_AUFID = "aufid";
    public static final String KEY_AUFIDXXX = "aufidxxx";
    public static final String KEY_AUFTRAG = "auftrag";
    public static final String KEY_AUFTRAGFREI1 = "auftragfrei1";
    public static final String KEY_AUFTRAGFREI2 = "auftragfrei2";
    public static final String KEY_AUFTRAGFREI3 = "auftragfrei3";
    public static final String KEY_AUFTRAGFREI4 = "auftragfrei4";
    public static final String KEY_AUFTRAGFREI5 = "auftragfrei5";
    public static final String KEY_AUFTRAGFREI6 = "auftragfrei6";
    public static final String KEY_AUFTRAGFREI7 = "auftragfrei7";
    public static final String KEY_BEARBEITUNGSDATUM = "bearbeitungsdatum";
    public static final String KEY_BENUTZERFREI5 = "benutzerfrei5";
    public static final String KEY_BENUTZERFREI4 = "benutzerfrei4";
    public static final String KEY_BENUTZERFREI3 = "benutzerfrei3";
    public static final String KEY_BENUTZERFREI2 = "benutzerfrei2";
    public static final String KEY_BENUTZERFREI1 = "benutzerfrei1";
    public static final String KEY_BENUTZERGRUPPE = "benutzergruppe";
    public static final String KEY_BETREFF = "derbetreff";
    public static final String KEY_BETREFF_MANUAL = "derbetreff_manual";
    public static final String KEY_COMPUTERNAME = "computername";
    public static final String KEY_DATE = "date";
    public static final String KEY_DEADLINEZEIT = "deadlinezeit";
    public static final String KEY_DISPATCHER = "dispatcher";
    public static final String KEY_DISPATCHERUSR = "dispatcherusr";
    public static final String KEY_DISID = "disid";
    public static final String KEY_EMAIL = "email";
    public static final String KEY_EMAILEINGANG = "emaileingang";
    public static final String KEY_EMAIL_DISP = "e-mail disp";
    public static final String KEY_EMAIL_EMPF = "e-mail empfaenger";
    public static final String KEY_EMAIL_EMPF_CC = "e-mail cc";
    public static final String KEY_EMAIL_EMPF_BCC = "e-mail bcc";
    public static final String KEY_EMAIL_SEND = "e-mail absender";
    public static final String KEY_EMAIL_SEND_DISP_NAME = "name absender";
    public static final String KEY_FIRMA = "firma";
    public static final String KEY_LOCATIONBEZEICHNUNG = "gebbezeichnung";
    public static final String KEY_INFO = "info";
    public static final String KEY_ISHTML = "ishtml";
    public static final String KEY_ITILBEZEICHNUNG = "itilbezeichnung";
    public static final String KEY_ITIL_MESSAGE_TYPE = "MsgTyp";
    public static final String KEY_ITIL_MESSAGE_ADDRESS = "MsgEmail";
    public static final String KEY_KATEGORIE = "betreff";
    public static final String KEY_KENNUNG = "kennung";
    public static final String KEY_KLASSIFIZIERUNG = "klassifizierung";
    public static final String KEY_KLASSIFIZIERUNGINFO = "klassifizierunginfo";
    public static final String KEY_KOSTENSTELLE = "kostenstelle";
    public static final String KEY_LETZTERBEARBEITER = "letzterbearbeiter";
    public static final String KEY_LETZTERBEARBEITERGUID = "LetzterBearbeiterGUID";
    public static final String KEY_LOCALE = "locale";
    public static final String KEY_LOGO_FILE_KEY = "logo";
    public static final String KEY_MAILTODISPATCHER = "mailtodispatcher";
    public static final String KEY_NACHNAME = "nachname";
    public static final String KEY_PRIBEZEICHNUNG = "pribezeichnung";
    public static final String KEY_PRIID = "priid";
    public static final String KEY_PRODUCER = "producer";
    public static final String KEY_RESANWESEND = "resanwesend";
    public static final String KEY_RESBEZEICHNUNG = "resbezeichnung";
    public static final String KEY_RESMSGTEXT = "resmsgtext";
    public static final String KEY_RESSOURCESTUNDENSATZ = "ressourcestundensatz";
    public static final String KEY_SENDATTACHMENTS = "sendattachments";
    public static final String KEY_SERVERURL = "serverurl";
    public static final String KEY_SOLLZEITVALUE = "sollzeitvalue";
    public static final String KEY_SOLLZEIT = "sollzeit";
    public static final String KEY_STATUS = "status";
    public static final String KEY_STATUSBEZEICHNUNG = "statusbezeichnung";
    public static final String KEY_STEPPRODUCER = "stepproducer";
    public static final String KEY_SUBTEMPLATE = "subtemplate";
    public static final String KEY_SUBTEMPLATEFILE = "subtemplatefile";
    public static final String KEY_SUBTEMPLATELASTSTEP = "subtemplatelaststep";
    public static final String KEY_SUBTEMPLATESORTORDER = "subtemplatesortorder";
    public static final String KEY_SUMMEZEITVALUE = "summezeitvalue";
    public static final String KEY_SUMMEZEIT = "summezeit";
    public static final String KEY_TELEFON = "telefon";
    public static final String KEY_TEMPLATE_NAME = "templatename";
    public static final String KEY_THE_MESSAGE = "the message";
    public static final String KEY_TIME = "time";
    public static final String KEY_TO_TYP = "totyp";
    public static final String KEY_TYP_DESCRIPTION = "typdescription";
    public static final String KEY_USEREMAIL = "useremail";
    public static final String KEY_USERNAME = "username";
    public static final String KEY_VORNAME = "vorname";
    public static final String KEY_WARNING_MSG_KEY = "msgkey";
    public static final String KEY_WORKFLOW = "workflow";
    public static final String KEY_WVZEIT = "wvzeit";
    public static final String KEY_ZEIT_MAL_RESSOURCESTUNDENSATZ = "zeit_mal_ressourcestundensatz";
    public static final String KEY_ZIMMER = "zimmer";
    public static final String KEY_ISDISPATCHED = "isdispatched";
    private static final String TO_TYP_UNKNOWN = "others";
    private static final String TO_TYP_ALL_DISP = "alldispatchers";
    private static final String TO_TYP_DISP = "dispatcher";
    private static final String TO_TYP_RES = "resource";
    private static final String TO_TYP_USER = "user";
    private static final int ITIL_INCIDENT_NO_MAIL = 0;
    private static final int ITIL_INCIDENT_OWNER_MAIL = 1;
    private static final int ITIL_INCIDENT_RESOURCE_MAIL = 2;
    private static final int ITIL_INCIDENT_ADDRESS_MAIL = 3;
    private static final String DATE_TIME_DEUTSCH = "EE, d. MMMM yyyy H:mm";
    private static final String DATE_TIME_ENGLISH = "EEE, MMMM d. yyyy H:mm";
    private static final String DATE_DEUTSCH = "EE, d. MMMM yyyy";
    private static final String DATE_ENGLISH = "EEE, MMMM d. yyyy";
    private static final String TYP_DESCRIPTION_LOOP = "Loop Error Message";
    private static final ArrayList<String> SIMPLE_TEXT_FIELDS = new ArrayList<String>(){
        {
            this.add(AutoMail.KEY_ABTEILUNG);
            this.add(AutoMail.KEY_BETREFF);
            this.add(AutoMail.KEY_AUFTRAGFREI1);
            this.add(AutoMail.KEY_AUFTRAGFREI2);
            this.add(AutoMail.KEY_AUFTRAGFREI3);
            this.add(AutoMail.KEY_AUFTRAGFREI4);
            this.add(AutoMail.KEY_STATUSBEZEICHNUNG);
            this.add(AutoMail.KEY_STEPPRODUCER);
            this.add(AutoMail.KEY_TELEFON);
            this.add(AutoMail.KEY_THE_MESSAGE);
            this.add(AutoMail.KEY_USERNAME);
            this.add(AutoMail.KEY_VORNAME);
            this.add(AutoMail.KEY_KOSTENSTELLE);
            this.add(AutoMail.KEY_LETZTERBEARBEITER);
            this.add(AutoMail.KEY_LETZTERBEARBEITERGUID);
            this.add(AutoMail.KEY_NACHNAME);
            this.add(AutoMail.KEY_PRIBEZEICHNUNG);
            this.add(AutoMail.KEY_PRODUCER);
            this.add(AutoMail.KEY_RESBEZEICHNUNG);
            this.add(AutoMail.KEY_BENUTZERFREI2);
            this.add(AutoMail.KEY_BENUTZERFREI1);
            this.add(AutoMail.KEY_BENUTZERGRUPPE);
            this.add(AutoMail.KEY_COMPUTERNAME);
            this.add("dispatcher");
            this.add(AutoMail.KEY_ZIMMER);
            this.add(AutoMail.KEY_EMAIL_SEND_DISP_NAME);
            this.add(AutoMail.KEY_LOCATIONBEZEICHNUNG);
            this.add(AutoMail.KEY_ITILBEZEICHNUNG);
            this.add(AutoMail.KEY_KATEGORIE);
            this.add(AutoMail.KEY_KENNUNG);
            this.add(AutoMail.KEY_KLASSIFIZIERUNG);
            this.add(AutoMail.KEY_AUFTRAGFREI5);
            this.add(AutoMail.KEY_AUFTRAGFREI6);
            this.add(AutoMail.KEY_AUFTRAGFREI7);
            this.add(AutoMail.KEY_BENUTZERFREI5);
            this.add(AutoMail.KEY_BENUTZERFREI4);
            this.add(AutoMail.KEY_BENUTZERFREI3);
        }
    };
    private static ListResourceBundle emailsLangRess;
    private Map<String, String> data;
    private int myTyp;
    private String aufID;
    private String bunID;
    private int anfReaId = -1;
    private String datepattern = "EE, d. MMMM yyyy";
    private SimpleDateFormat dateFormatter;
    private MailMetaData mailMetaData = new MailMetaData();
    private TemplatePlaceholderReplacementFinder replacementFinder = new TemplatePlaceholderReplacementFinder();
    private List<TableColumnDatabaseFieldModificationProvider> extensions;

    public AutoMail(Map<String, String> table, int typ, String producer) {
        emailsLangRess = (ListResourceBundle)ListResourceBundle.getBundle("lang.EMailMsg", ServerUtilities.serverLocale);
        this.data = table;
        this.myTyp = typ;
        this.putValues(this.data, typ, producer);
        this.putServerURLValue(this.data);
    }

    private void putServerURLValue(Map<String, String> table) {
        Object replacement = this.replacementFinder.getReplacementForPlaceholderServerURL();
        if (!((String)replacement).endsWith("/")) {
            replacement = (String)replacement + "/";
        }
        table.put(KEY_SERVERURL, (String)replacement);
    }

    private void putValues(Map<String, String> table, int typ, String producer) {
        boolean htmlMail = "html".equals(MAIL_FORMAT.get());
        switch (typ) {
            case 1: {
                table.put(KEY_TO_TYP, TO_TYP_USER);
                table.put(KEY_TYP_DESCRIPTION, "IMAP new Order");
                break;
            }
            case 2: {
                table.put(KEY_TO_TYP, TO_TYP_ALL_DISP);
                table.put(KEY_TEMPLATE_NAME, htmlMail ? "anfrage.html" : "anfrage.txt");
                table.put(KEY_TYP_DESCRIPTION, "New Request Dispatcher");
                if (producer == null || producer.length() <= 6) break;
                table.put(KEY_PRODUCER, producer);
                break;
            }
            case 3: {
                table.put(KEY_TO_TYP, TO_TYP_USER);
                table.put(KEY_TEMPLATE_NAME, htmlMail ? "autorisierenuser.html" : "autorisierenuser.txt");
                table.put(KEY_TYP_DESCRIPTION, "New Order User");
                if (producer == null || producer.length() <= 6) break;
                table.put(KEY_PRODUCER, producer);
                break;
            }
            case 4: {
                table.put(KEY_TO_TYP, TO_TYP_RES);
                table.put(KEY_TEMPLATE_NAME, htmlMail ? "autorisierenres.html" : "autorisierenres.txt");
                table.put(KEY_TYP_DESCRIPTION, "New Order Resource");
                if (producer == null || producer.length() <= 6) break;
                table.put(KEY_PRODUCER, producer);
                break;
            }
            case 5: {
                table.put(KEY_TO_TYP, TO_TYP_RES);
                table.put(KEY_TEMPLATE_NAME, htmlMail ? "maileingangres.html" : "maileingangres.txt");
                table.put(KEY_TYP_DESCRIPTION, "New Mail");
                if (producer == null || producer.length() <= 6) break;
                table.put(KEY_PRODUCER, producer);
                break;
            }
            case 21: {
                table.put(KEY_TO_TYP, "dispatcher");
                table.put(KEY_TEMPLATE_NAME, htmlMail ? "maileingangdisp.html" : "maileingangdisp.txt");
                table.put(KEY_TYP_DESCRIPTION, "New Mail");
                if (producer == null || producer.length() <= 6) break;
                table.put(KEY_PRODUCER, producer);
                break;
            }
            case 6: {
                table.put(KEY_TO_TYP, TO_TYP_RES);
                table.put(KEY_TEMPLATE_NAME, htmlMail ? "vorlage.html" : "vorlage.txt");
                table.put(KEY_TYP_DESCRIPTION, "Reminder");
                break;
            }
            case 7: {
                table.put(KEY_TO_TYP, "dispatcher");
                table.put(KEY_TEMPLATE_NAME, htmlMail ? "manueskadisp.html" : "manueskadisp.txt");
                table.put(KEY_TYP_DESCRIPTION, "Manual Escalation");
                if (producer == null || producer.length() <= 6) break;
                table.put(KEY_PRODUCER, producer);
                break;
            }
            case 8: {
                table.put(KEY_TO_TYP, TO_TYP_RES);
                table.put(KEY_TEMPLATE_NAME, htmlMail ? "manueskares.html" : "manueskares.txt");
                table.put(KEY_TYP_DESCRIPTION, "Manual Escalation");
                if (producer == null || producer.length() <= 6) break;
                table.put(KEY_PRODUCER, producer);
                break;
            }
            case 9: {
                table.put(KEY_TO_TYP, "dispatcher");
                table.put(KEY_TEMPLATE_NAME, htmlMail ? "autoeskadisp.html" : "autoeskadisp.txt");
                table.put(KEY_TYP_DESCRIPTION, "Automatic Escalation");
                break;
            }
            case 10: {
                table.put(KEY_TO_TYP, TO_TYP_RES);
                table.put(KEY_TEMPLATE_NAME, htmlMail ? "autoeskares.html" : "autoeskares.txt");
                table.put(KEY_TYP_DESCRIPTION, "Automatic Escalation");
                break;
            }
            case 11: {
                table.put(KEY_TO_TYP, "dispatcher");
                table.put(KEY_TEMPLATE_NAME, htmlMail ? "automahn.html" : "automahn.txt");
                table.put(KEY_TYP_DESCRIPTION, "Deadline expired");
                break;
            }
            case 12: {
                table.put(KEY_TO_TYP, TO_TYP_RES);
                table.put(KEY_TEMPLATE_NAME, htmlMail ? "automahn.html" : "automahn.txt");
                table.put(KEY_TYP_DESCRIPTION, "Deadline expired");
                break;
            }
            case 13: {
                table.put(KEY_TO_TYP, TO_TYP_USER);
                table.put(KEY_TEMPLATE_NAME, htmlMail ? "beenden.html" : "beenden.txt");
                table.put(KEY_TYP_DESCRIPTION, "Order finished");
                if (producer == null || producer.length() <= 6) break;
                table.put(KEY_PRODUCER, producer);
                break;
            }
            case 14: {
                table.put(KEY_TO_TYP, TO_TYP_USER);
                table.put(KEY_TEMPLATE_NAME, htmlMail ? "error.html" : "error.txt");
                table.put(KEY_TYP_DESCRIPTION, "Error Message");
                break;
            }
            case 16: {
                table.put(KEY_TO_TYP, TO_TYP_ALL_DISP);
                table.put(KEY_TEMPLATE_NAME, htmlMail ? "loop-error.html" : "loop-error.txt");
                table.put(KEY_TYP_DESCRIPTION, TYP_DESCRIPTION_LOOP);
                break;
            }
            case 666: {
                if (table.get(KEY_TO_TYP) == null) {
                    table.put(KEY_TO_TYP, TO_TYP_USER);
                }
                table.put(KEY_TYP_DESCRIPTION, "Triggered Mail");
                break;
            }
            case 15: {
                table.put(KEY_TO_TYP, TO_TYP_UNKNOWN);
                table.put(KEY_TEMPLATE_NAME, htmlMail ? "newincident.html" : "newincident.txt");
                table.put(KEY_TYP_DESCRIPTION, "New Problem Link");
                break;
            }
            case 22: {
                table.put(KEY_TO_TYP, TO_TYP_USER);
                table.put(KEY_TEMPLATE_NAME, htmlMail ? "nonewticket.html" : "nonewticket.txt");
                table.put(KEY_TYP_DESCRIPTION, "Only Existing Tickets Allowed");
                break;
            }
            case 17: {
                table.put(KEY_TO_TYP, TO_TYP_RES);
                table.put(KEY_TEMPLATE_NAME, htmlMail ? "warning.html" : "warning.txt");
                table.put(KEY_TYP_DESCRIPTION, "Escalation threshold yellow");
                table.put(KEY_WARNING_MSG_KEY, emailsLangRess.getString("Esca_Gelb"));
                break;
            }
            case 18: {
                table.put(KEY_TO_TYP, TO_TYP_RES);
                table.put(KEY_TEMPLATE_NAME, htmlMail ? "warning.html" : "warning.txt");
                table.put(KEY_TYP_DESCRIPTION, "Escalation threshold red");
                table.put(KEY_WARNING_MSG_KEY, emailsLangRess.getString("Esca_Rot"));
                break;
            }
            case 19: {
                table.put(KEY_TO_TYP, TO_TYP_RES);
                table.put(KEY_TEMPLATE_NAME, htmlMail ? "warning.html" : "warning.txt");
                table.put(KEY_TYP_DESCRIPTION, "Deadline threshold yellow");
                table.put(KEY_WARNING_MSG_KEY, emailsLangRess.getString("Dead_Gelb"));
                break;
            }
            case 20: {
                table.put(KEY_TO_TYP, TO_TYP_RES);
                table.put(KEY_TEMPLATE_NAME, htmlMail ? "warning.html" : "warning.txt");
                table.put(KEY_TYP_DESCRIPTION, "Deadline threshold red");
                table.put(KEY_WARNING_MSG_KEY, emailsLangRess.getString("Dead_Rot"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadData() throws Exception {
        Exception er = null;
        Connection con = null;
        PreparedStatement pr = null;
        ResultSet rs = null;
        String account = null;
        boolean dropTheMail = false;
        this.data.put(KEY_SUBTEMPLATESORTORDER, (String)SUBTEMPLATE_ORDER.get());
        String dummy = (String)MAIL_LOGO_FILE.get();
        if (dummy != null && dummy.length() > 0) {
            this.data.put(KEY_LOGO_FILE_KEY, dummy);
        }
        try {
            con = ServerUtilities.getJJServer().getConnection("HDS");
            pr = con.prepareStatement(DATA_QUERY);
            pr.setInt(1, Integer.parseInt(this.aufID));
            rs = pr.executeQuery();
            if (rs.next()) {
                this.bunID = rs.getString("BunID");
                if (this.myTyp == 15) {
                    int itilWer = rs.getInt(KEY_ITIL_MESSAGE_TYPE);
                    if (itilWer == 0) {
                        dropTheMail = true;
                    } else if (itilWer == 1) {
                        this.data.put(KEY_TO_TYP, TO_TYP_USER);
                    } else if (itilWer == 2) {
                        this.data.put(KEY_TO_TYP, TO_TYP_RES);
                    } else if (itilWer == 3) {
                        String str = rs.getString(KEY_ITIL_MESSAGE_ADDRESS);
                        if (str == null || str.length() < 8) {
                            dropTheMail = true;
                        } else {
                            this.data.put(KEY_EMAIL_EMPF, str);
                        }
                    }
                }
                if (!dropTheMail) {
                    String dateTimePattern;
                    UserAccount userAccount;
                    boolean sendAttachments;
                    boolean resAvailable = false;
                    try {
                        int resId = rs.getInt("ResID");
                        if (resId > 0) {
                            resAvailable = ResourceTimelineManager.getInstance().isResourceAccessibleNow(resId);
                        }
                    }
                    catch (Exception ex) {
                        HDLogger.error(ex);
                    }
                    this.data.put(KEY_RESANWESEND, String.valueOf(resAvailable));
                    boolean bl = sendAttachments = (rs.getInt("Rechte") & 4) != 0;
                    if (sendAttachments && TO_TYP_RES.equals(this.data.get(KEY_TO_TYP))) {
                        this.data.put(KEY_SENDATTACHMENTS, "true");
                    } else {
                        this.data.put(KEY_SENDATTACHMENTS, "false");
                    }
                    this.extensions = ServerPluginManager.getInstance().get(TableColumnDatabaseFieldModificationProvider.class);
                    this.data.put(KEY_FIRMA, (String)COMPANY_ADDRESS.get());
                    int kategoryID = rs.getInt("BetID");
                    if (kategoryID > 0) {
                        try {
                            String categoryPathOrThrow = CategoryManager.getInstance().findCategoryPathOrThrow(kategoryID);
                            this.data.put(KEY_KATEGORIE, categoryPathOrThrow);
                        }
                        catch (Exception e) {
                            HDLogger.error(e);
                        }
                    } else {
                        this.data.put(KEY_KATEGORIE, "");
                    }
                    this.setParam(rs, "Auftrag", KEY_AUFTRAG);
                    this.data.put(KEY_ISHTML, String.valueOf(rs.getInt(KEY_ISHTML) != 0));
                    this.setParam(rs, "DerBetreff", KEY_BETREFF);
                    this.setParam(rs, "spezFeld", KEY_KENNUNG);
                    this.setParam(rs, "PriID", KEY_PRIID);
                    this.setParam(rs, "WFID", KEY_WORKFLOW);
                    this.setParam(rs, "PriBezeichnung", KEY_PRIBEZEICHNUNG);
                    this.setParam(rs, "ResBezeichnung", KEY_RESBEZEICHNUNG);
                    this.data.put(KEY_INFO, "");
                    this.setParam(rs, "Email", KEY_EMAIL);
                    Timestamp tstart = rs.getTimestamp("MsgVon");
                    Timestamp tend = rs.getTimestamp("MsgBis");
                    if (!(tstart != null && tstart.getTime() >= System.currentTimeMillis() || tend != null && tend.getTime() <= System.currentTimeMillis())) {
                        this.setParam(rs, "MsgText", KEY_RESMSGTEXT);
                    } else {
                        this.data.put(KEY_RESMSGTEXT, "");
                    }
                    this.setParam(rs, "GebBezeichnung", KEY_LOCATIONBEZEICHNUNG);
                    this.setParam(rs, "Adresse", KEY_ADRESSE);
                    this.setParam(rs, "GroupName", KEY_BENUTZERGRUPPE);
                    this.data.put(KEY_USERNAME, "");
                    int userId = rs.getInt("UsrID");
                    if (!rs.wasNull()) {
                        UserAccount ua = HDUsersAndGroups.getUserAccount(userId);
                        this.data.put(KEY_USERNAME, ua.getDisplayName());
                        List logins = ua.getLoginSettings();
                        for (LoginSettings login : logins) {
                            if (!"system".equals(login.getLoginSource())) continue;
                            this.data.put(KEY_USERNAME, login.getLoginID());
                            break;
                        }
                        this.setParam(rs, "Nachname", KEY_NACHNAME);
                        this.setParam(rs, "Vorname", KEY_VORNAME);
                        this.setParam(rs, "Telefon", KEY_TELEFON);
                        this.setParam(rs, "UserEmail", KEY_USEREMAIL);
                        this.setParam(rs, "Zimmer", KEY_ZIMMER);
                        this.setParam(rs, "Computername", KEY_COMPUTERNAME);
                        this.setParam(rs, "Abteilung", KEY_ABTEILUNG);
                        this.setParam(rs, "Kostenstelle", KEY_KOSTENSTELLE);
                        this.setParam(rs, "Frei1", KEY_BENUTZERFREI1);
                        this.setParam(rs, "Frei2", KEY_BENUTZERFREI2);
                        this.setParam(rs, "Frei3", KEY_BENUTZERFREI3);
                        this.setParam(rs, "Frei4", KEY_BENUTZERFREI4);
                        this.setParam(rs, "Frei5", KEY_BENUTZERFREI5);
                    }
                    this.setParam(rs, "KlassenName", KEY_KLASSIFIZIERUNG);
                    this.setParam(rs, "KlasseInfo", KEY_KLASSIFIZIERUNGINFO);
                    this.setParam(rs, "Status", KEY_STATUS);
                    this.setParam(rs, "StatusBezeichnung", KEY_STATUSBEZEICHNUNG);
                    this.setParam(rs, "Bearbeiter", KEY_LETZTERBEARBEITER);
                    int lastEditorIntID = rs.getInt("LastEditorID");
                    if (!rs.wasNull() && (userAccount = HDUsersAndGroups.getUserAccount(lastEditorIntID)) != null) {
                        this.data.put(KEY_LETZTERBEARBEITERGUID, userAccount.getID().toString());
                        this.data.put(KEY_LETZTERBEARBEITER, userAccount.getDisplayName());
                    }
                    this.setParam(rs, "BunFeld1", KEY_AUFTRAGFREI1);
                    this.setParam(rs, "BunFeld2", KEY_AUFTRAGFREI2);
                    this.setParam(rs, "BunFeld3", KEY_AUFTRAGFREI3);
                    this.setParam(rs, "BunFeld4", KEY_AUFTRAGFREI4);
                    this.setParam(rs, "BunFeld5", KEY_AUFTRAGFREI5);
                    this.setParam(rs, "BunFeld6", KEY_AUFTRAGFREI6);
                    this.setParam(rs, "BunFeld7", KEY_AUFTRAGFREI7);
                    this.setParam(rs, "ItilBezeichnung", KEY_ITILBEZEICHNUNG);
                    String lokaleWert = rs.getString("SprID");
                    if (lokaleWert == null || "xx".equals(lokaleWert)) {
                        lokaleWert = emailsLangRess.getString("LOKALE");
                    }
                    if ("en".equals(lokaleWert)) {
                        dateTimePattern = DATE_TIME_ENGLISH;
                        this.datepattern = DATE_ENGLISH;
                    } else {
                        dateTimePattern = DATE_TIME_DEUTSCH;
                        this.datepattern = DATE_DEUTSCH;
                    }
                    this.data.put(KEY_LOCALE, lokaleWert);
                    this.dateFormatter = new SimpleDateFormat(dateTimePattern);
                    this.setParam(rs, "DeadlineZeit", KEY_DEADLINEZEIT, this.dateFormatter);
                    this.setParam(rs, "AnfrageDatum", KEY_ANFRAGEDATUM, this.dateFormatter);
                    MinutenFeld minutenUmrechnung = new MinutenFeld();
                    this.setParam(rs, "SummeZeit", KEY_SUMMEZEIT, minutenUmrechnung);
                    this.setParam(rs, "SummeZeit", KEY_SUMMEZEITVALUE, "0");
                    this.setParam(rs, "SollZeit", KEY_SOLLZEIT, minutenUmrechnung);
                    this.setParam(rs, "SollZeit", KEY_SOLLZEITVALUE, "0");
                    try {
                        Timestamp date = rs.getTimestamp("AnfrageDatum");
                        this.data.put(KEY_ANFRAGEDATUMGMT, date.toGMTString());
                    }
                    catch (Throwable date) {
                        // empty catch block
                    }
                    this.setParam(rs, "BearbeitungsDatum", KEY_BEARBEITUNGSDATUM, this.dateFormatter);
                    this.setParam(rs, "WiedervorlageDatum", KEY_WVZEIT, this.dateFormatter);
                    Locale loc = this.getFormatingLocale(lokaleWert);
                    DateFormat dF = DateFormat.getDateTimeInstance(1, 3, loc);
                    NumberFormat numFormatter = NumberFormat.getCurrencyInstance(loc);
                    double std = rs.getDouble("Stundensatz");
                    int minuten = rs.getInt("SummeZeit");
                    if (std > 0.0 && minuten > 0) {
                        this.data.put(KEY_RESSOURCESTUNDENSATZ, numFormatter.format(std));
                        this.data.put(KEY_ZEIT_MAL_RESSOURCESTUNDENSATZ, numFormatter.format(std * (double)minuten / 60.0));
                    } else {
                        this.data.put(KEY_RESSOURCESTUNDENSATZ, "");
                        this.data.put(KEY_ZEIT_MAL_RESSOURCESTUNDENSATZ, "");
                    }
                    String zeit = dF.format(new Timestamp(System.currentTimeMillis()));
                    int posTrennen = zeit.indexOf(58) - 5;
                    posTrennen = zeit.indexOf(32, posTrennen) + 1;
                    this.data.put(KEY_DATE, zeit.substring(0, posTrennen));
                    this.data.put(KEY_TIME, zeit.substring(posTrennen));
                    int disID = rs.getInt("DisID");
                    if (rs.wasNull()) {
                        disID = -1;
                    }
                    this.readDispatcherData(con, disID);
                    account = rs.getString("EmailEingang");
                    boolean dispatched = rs.getInt("AutorisierenReaID") != 0;
                    this.data.put(KEY_ISDISPATCHED, Boolean.toString(dispatched));
                    this.anfReaId = rs.getInt("AnfReaID");
                }
            } else {
                throw new Exception("Keine Daten " + this.data.get(KEY_TYP_DESCRIPTION) + " " + this.aufID);
            }
            if (!dropTheMail) {
                EmailAccount emailAccount;
                boolean foundEmf;
                this.data.put(KEY_MAILTODISPATCHER, this.getDispatcherEmails());
                account = account != null && account.startsWith("er_") ? account.substring(3) : "";
                this.data.put(KEY_EMAILEINGANG, account);
                dummy = this.data.get(KEY_EMAIL_SEND);
                boolean foundSender = dummy != null && dummy.length() > 0;
                dummy = this.data.get(KEY_EMAIL_EMPF);
                boolean bl = foundEmf = dummy != null && dummy.length() > 0;
                if (!foundSender && account.length() > 0 && (emailAccount = ((EmailAccountList)EmailReader_Main.MAIL_ACCOUNTS.get()).get(account)) != null) {
                    foundSender = AutoMail.putAbsenderFrom(this.data, emailAccount.getFrom(), emailAccount.getFromName());
                }
                if (TO_TYP_USER.equals(this.data.get(KEY_TO_TYP))) {
                    if (!foundEmf && this.data.get(KEY_USEREMAIL) != null) {
                        this.data.put(KEY_EMAIL_EMPF, this.data.get(KEY_USEREMAIL));
                    }
                    if (!foundSender) {
                        foundSender = AutoMail.putAbsenderFrom(this.data, (String)MAIL_USERS_DEF_ABSENDER.get(), (String)MAIL_USERS_DEF_ABSENDER_NAME.get());
                    }
                } else if (TO_TYP_RES.equals(this.data.get(KEY_TO_TYP))) {
                    if (!foundEmf) {
                        this.data.put(KEY_EMAIL_EMPF, this.data.get(KEY_EMAIL));
                    }
                    MailResourceToAbsenderAndAliasMap mailAbsenderResourceMap = (MailResourceToAbsenderAndAliasMap)MAIL_RESOURCE_TO_ABSENDER_AND_ALIAS_MAP.get();
                    String resourceBezeichnung = this.data.get(KEY_RESBEZEICHNUNG);
                    String alias = mailAbsenderResourceMap.getAlias(resourceBezeichnung);
                    String absender = mailAbsenderResourceMap.getAbsender(resourceBezeichnung);
                    if (AutoMail.putAbsenderFrom(this.data, absender, alias)) {
                        foundSender = true;
                    }
                    if (!foundSender) {
                        foundSender = AutoMail.putAbsenderFrom(this.data, (String)MAIL_RESOURCES_DEF_ABSENDER.get(), (String)MAIL_RESOURCES_DEF_ABSENDER_NAME.get());
                    }
                } else if (TO_TYP_ALL_DISP.equals(this.data.get(KEY_TO_TYP)) || "dispatcher".equals(this.data.get(KEY_TO_TYP))) {
                    String resourceAddress;
                    if (!foundEmf && TO_TYP_ALL_DISP.equals(this.data.get(KEY_TO_TYP))) {
                        this.data.put(KEY_EMAIL_EMPF, this.data.get(KEY_MAILTODISPATCHER));
                    } else if (!foundEmf && "dispatcher".equals(this.data.get(KEY_TO_TYP))) {
                        String addr = this.data.get(KEY_EMAIL_DISP);
                        if (Mail.getEmailAddress(addr) == null) {
                            this.data.put(KEY_EMAIL_EMPF, this.data.get(KEY_MAILTODISPATCHER));
                        } else {
                            this.data.put(KEY_EMAIL_EMPF, addr);
                        }
                    }
                    if (TYP_DESCRIPTION_LOOP.equals(this.data.get(KEY_TYP_DESCRIPTION)) && (resourceAddress = this.data.get(KEY_EMAIL)) != null && resourceAddress.length() > 0) {
                        String dispatcherAdresses = this.data.get(KEY_EMAIL_EMPF);
                        if (dispatcherAdresses != null && dispatcherAdresses.length() > 0) {
                            this.data.put(KEY_EMAIL_EMPF, dispatcherAdresses + ";" + resourceAddress);
                        } else {
                            this.data.put(KEY_EMAIL_EMPF, resourceAddress);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            HDLogger.debug("Fehler in NewMail.loadData");
            er = e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable throwable) {}
            try {
                pr.close();
            }
            catch (Throwable throwable) {}
            try {
                con.close();
            }
            catch (Throwable throwable) {}
        }
        if (er != null) {
            throw er;
        }
        return !dropTheMail;
    }

    private void setSender() {
        String sender = this.data.get(KEY_EMAIL_SEND);
        if (sender != null && sender.length() > 0) {
            return;
        }
        EmailAccountList accounts = (EmailAccountList)EmailReader_Main.MAIL_ACCOUNTS.get();
        String kategorie = this.data.get(KEY_KATEGORIE);
        kategorie = kategorie != null ? kategorie : "";
        EmailAccount defaultAccount = null;
        for (EmailAccount emailAccount : accounts) {
            String accEm;
            String accKat = "";
            try {
                Integer categoryId = emailAccount.getCategoryId();
                accKat = CategoryManager.getInstance().findCategoryPathOrThrow(categoryId);
            }
            catch (ServerDataException e) {
                HDLogger.error(e);
            }
            if ((accEm = emailAccount.getFrom()) == null || accEm.length() <= 0) continue;
            if (kategorie.length() > 0 && kategorie.equals(accKat)) {
                if (!AutoMail.putAbsenderFrom(this.data, accEm, emailAccount.getFromName())) continue;
                return;
            }
            if (!accEm.equalsIgnoreCase((String)MAIL_FROM.get()) && (kategorie.length() <= 0 || !kategorie.startsWith(accKat + "\\"))) continue;
            defaultAccount = emailAccount;
        }
        if (defaultAccount != null && AutoMail.putAbsenderFrom(this.data, defaultAccount.getFrom(), defaultAccount.getFromName())) {
            return;
        }
        for (EmailAccount emailAccount : accounts) {
            if (!AutoMail.putAbsenderFrom(this.data, emailAccount.getFrom(), emailAccount.getFromName())) continue;
            return;
        }
        String email = (String)MAIL_FROM.get();
        if (email.length() > 0) {
            AutoMail.putAbsenderFrom(this.data, email, "HelpDesk");
        }
    }

    public static boolean putAbsenderFrom(Map<String, String> dat, String email, String displayName) {
        if (email != null && email.length() > 0) {
            dat.put(KEY_EMAIL_SEND, email);
            if (displayName == null || displayName.length() == 0) {
                dat.put(KEY_EMAIL_SEND_DISP_NAME, email);
            } else {
                dat.put(KEY_EMAIL_SEND_DISP_NAME, displayName);
            }
            return true;
        }
        return false;
    }

    private void setParam(ResultSet rs, String colName, String paramName, Format formatter) throws SQLException {
        Object value = rs.getObject(colName);
        if (value instanceof LocalDateTime) {
            value = rs.getTimestamp(colName);
        }
        if (value == null) {
            this.data.put(paramName, "");
        } else {
            this.data.put(paramName, formatter.format(value));
        }
    }

    private void setParam(ResultSet rs, String colName, String paramName, String defaultValue) throws SQLException {
        String val = rs.getString(colName);
        if (val == null) {
            this.data.put(paramName, defaultValue);
        } else {
            this.data.put(paramName, val.toString());
        }
    }

    private void setParam(ResultSet rs, String colName, String paramName) throws SQLException {
        String val = this.prepareValue(rs, colName);
        this.data.put(paramName, val);
    }

    private String prepareValue(ResultSet rs, String colName) throws SQLException {
        String val = rs.getString(colName);
        if (val == null) {
            return "";
        }
        for (TableColumnDatabaseFieldModificationProvider extension : this.extensions) {
            if (!extension.providesFor(null, colName)) continue;
            val = extension.getDisplayStringFor(val, "addresses");
            break;
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="No user value is used for the internal statement")
    private void readDispatcherData(Connection con, int disID) {
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.createStatement();
            rs = st.executeQuery("Select Email From tblUser Where geloescht = 0 AND UsrID = " + disID);
            if (rs.next()) {
                String em;
                this.data.put(KEY_DISID, Integer.toString(disID));
                UserAccount ua = HDUsersAndGroups.getUserAccount(disID);
                if (ua != null) {
                    this.data.put("dispatcher", ua.getDisplayName());
                    List logins = ua.getLoginSettings();
                    for (LoginSettings login : logins) {
                        if (!"system".equals(login.getLoginSource())) continue;
                        this.data.put(KEY_DISPATCHERUSR, login.getLoginID());
                        break;
                    }
                }
                if ((em = rs.getString("Email")) == null) {
                    this.data.put(KEY_EMAIL_DISP, "");
                } else {
                    this.data.put(KEY_EMAIL_DISP, em);
                }
            }
        }
        catch (Exception e) {
            HDLogger.error(e);
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable throwable) {}
            try {
                st.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private String getDispatcherEmails() {
        String dummy = (String)MAILTO_DISPATCHER.get();
        if (dummy != null && dummy.length() > 0) {
            return dummy;
        }
        Set<GUID> dispatcherIDs = SupporterUserConditionTokenMatcher.getDispatcherIDs();
        if (dispatcherIDs == null) {
            return "";
        }
        UserManager manager = UserManager.getInstance();
        HashSet<String> addresses = new HashSet<String>();
        StringBuilder buf = null;
        for (GUID guid : dispatcherIDs) {
            String firstEmailAddress;
            UserAccount account = manager.getUserAccount(guid);
            if (account == null || !account.isActive() || (firstEmailAddress = EmailAddressHelper.get().getFirstEmailAddress((String)account.getValue((UserField)UsersAndGroups.FIELD_EMAIL))) == null) continue;
            firstEmailAddress = firstEmailAddress.trim().toLowerCase();
            buf = this.addAddress(firstEmailAddress, buf, addresses);
        }
        return buf == null ? "" : buf.toString();
    }

    private StringBuilder addAddress(String address, StringBuilder buf, HashSet<String> addresses) {
        if (!addresses.contains(address)) {
            addresses.add(address);
            if (buf == null) {
                buf = new StringBuilder(address);
            } else {
                buf.append(';').append(address);
            }
        }
        return buf;
    }

    private Locale getFormatingLocale(String lang) {
        Configuration configuration = ConfigurationManager.getInstance().getCurrent();
        String country = configuration.get("vm.user.country");
        if (country == null || country.length() != 2) {
            country = Locale.getDefault().getCountry();
        }
        if ("de".equals(this.data.get(KEY_LOCALE))) {
            return new Locale("de", country);
        }
        return new Locale("en", country);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="this is definitely safe because we're only optionally adding DESC to the end")
    private String loadSubtemplateData(boolean html, Template subTemplate, Set<Integer> listOfReasWhoseTextIsUsedInMail) {
        if (subTemplate == null) {
            return "";
        }
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        String order = "";
        boolean lastOnly = "LastOnly".equals(this.data.get(KEY_SUBTEMPLATESORTORDER));
        if ("LastTop".equals(this.data.get(KEY_SUBTEMPLATESORTORDER)) || lastOnly) {
            order = " DESC";
        }
        Vector<String[]> templData = new Vector<String[]>();
        try {
            con = ServerUtilities.getJJServer().getConnection("HDS");
            st = con.createStatement();
            rs = TO_TYP_USER.equals(this.data.get(KEY_TO_TYP)) ? st.executeQuery("SELECT tblRealisierung.ReaID, tblRealisierung.StartZeit, tblRealisierung.EndZeit, tblRealisierung.was, tblRealisierung.ishtml, tblRealisierung.UserID, tblRealisierung.DisplayName, tblRealisierung.Stundensatz, tblRealisierung.EmailIn, tblRealisierung.EmailAn, tblRealisierung.EmailCC, tblAktionen.AktID, tblAktionen.AktBezeichnung as Aktion FROM tblRealisierung, tblAktionen WHERE tblRealisierung.AktID = tblAktionen.AktID AND tblAktionen.UserInVis = 0 AND ( (tblRealisierung.BunID = " + this.aufID + " AND tblAktionen.Status > 100) OR (tblRealisierung.OrgBunID = " + this.aufID + ") OR (tblRealisierung.BunID = " + this.bunID + " AND tblAktionen.Status >= 300 AND tblAktionen.Status < 400)) ORDER BY tblRealisierung.ReaID" + order) : st.executeQuery("SELECT tblRealisierung.ReaID, tblRealisierung.StartZeit, tblRealisierung.EndZeit, tblRealisierung.was, tblRealisierung.ishtml, tblRealisierung.UserID, tblRealisierung.DisplayName, tblRealisierung.Stundensatz, tblRealisierung.EmailIn, tblRealisierung.EmailAn, tblRealisierung.EmailCC, tblAktionen.AktID, tblAktionen.AktBezeichnung as Aktion FROM tblRealisierung, tblAktionen WHERE tblRealisierung.AktID = tblAktionen.AktID AND ((tblRealisierung.BunID = " + this.aufID + " AND tblAktionen.Status >= 100) OR tblRealisierung.OrgBunID = " + this.aufID + ") ORDER BY tblRealisierung.ReaID" + order);
            Locale loc = this.getFormatingLocale(this.data.get(KEY_LOCALE));
            SimpleDateFormat dateFormatter = new SimpleDateFormat(this.datepattern);
            DateFormat timeFormatter = DateFormat.getTimeInstance(3, loc);
            NumberFormat numFormatter = NumberFormat.getCurrencyInstance(loc);
            while (rs.next()) {
                boolean stepTextIsHtml = rs.getInt(KEY_ISHTML) != 0;
                boolean foundText = false;
                String[] singleData = new String[11];
                singleData[0] = dateFormatter.format(rs.getDate("StartZeit"));
                singleData[1] = timeFormatter.format(rs.getTime("StartZeit"));
                singleData[2] = timeFormatter.format(rs.getTime("EndZeit"));
                int aktID = rs.getInt("AktID");
                singleData[3] = rs.getString("was");
                if (singleData[3] == null) {
                    singleData[3] = "";
                } else if (stepTextIsHtml && html) {
                    singleData[3] = this.removeHtmlTags(singleData[3]);
                }
                if (stepTextIsHtml) {
                    foundText = HtmlConverter.html2text((String)singleData[3]).trim().length() > 0 || singleData[3].contains("src=\"Attachments/ticket/");
                } else {
                    boolean bl = foundText = singleData[3].trim().length() > 0;
                }
                if (html != stepTextIsHtml && singleData[3].length() > 5) {
                    singleData[3] = html ? HtmlConverter.text2html((String)singleData[3], null) : HtmlConverter.html2text((String)singleData[3]);
                }
                singleData[4] = numFormatter.format(rs.getDouble("Stundensatz"));
                singleData[5] = rs.getString("DisplayName");
                singleData[6] = rs.getString("Aktion");
                int userId = rs.getInt("UserID");
                UserAccount ua = HDUsersAndGroups.getUserAccount(userId);
                if (ua != null) {
                    List logins = ua.getLoginSettings();
                    for (LoginSettings login : logins) {
                        if (!"system".equals(login.getLoginSource())) continue;
                        singleData[7] = login.getLoginID();
                        break;
                    }
                }
                if (singleData[7] == null) {
                    singleData[7] = singleData[5];
                }
                singleData[8] = rs.getString("EmailIn");
                singleData[9] = rs.getString("EmailAn");
                singleData[10] = rs.getString("EmailCC");
                if (subTemplate.containsReaStepTextPlaceholder()) {
                    listOfReasWhoseTextIsUsedInMail.add(rs.getInt("ReaID"));
                }
                templData.addElement(singleData);
                if (!lastOnly) continue;
                if (foundText) break;
                if (aktID == -2) {
                    break;
                }
                templData.clear();
            }
        }
        catch (Throwable er) {
            HDLogger.error(er);
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable loc) {}
            try {
                st.close();
            }
            catch (Throwable loc) {}
            try {
                con.close();
            }
            catch (Throwable loc) {}
        }
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < templData.size(); ++n) {
            String[] singleData = (String[])templData.elementAt(n);
            buf.append(subTemplate.texte[0]);
            for (int m = 0; m < subTemplate.texte.length - 1; ++m) {
                buf.append(this.getString(singleData, subTemplate.vars[m], html));
                buf.append(subTemplate.texte[m + 1]);
            }
        }
        return buf.toString();
    }

    private String getString(String[] data, String name, boolean asHtml) {
        String str;
        boolean addressParam = false;
        if (name.startsWith("mailto:")) {
            name = name.substring(7);
            addressParam = true;
        }
        if ((str = name.equals("aktion") ? data[6] : (name.equals("wann") ? data[0] : (name.equals("von") ? data[1] : (name.equals("bis") ? data[2] : (name.equals("was") ? data[3] : (name.equals("wer") ? data[5] : (name.equals("stundensatz") ? data[4] : (name.equals(KEY_USERNAME) ? data[7] : (name.equals("absender") ? data[8] : (name.equals("empfaenger") ? data[9] : (name.equals("cc") ? data[10] : "fehlerhafter Platzhalter!!!"))))))))))) == null) {
            return " ";
        }
        if (addressParam && str.length() > 9) {
            if (asHtml) {
                return "<a href=\"mailto:" + str + "\">" + str + "</a>";
            }
            return "[mailto:" + str + "]";
        }
        return str;
    }

    private String[] zusammensetzen(Template template) {
        int i;
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < template.texte.length - 1; ++i2) {
            buf.append(template.texte[i2]).append(this.getPlatzhalter(template.vars[i2], template.isHtml));
        }
        buf.append(template.texte[template.texte.length - 1]);
        String[] result = new String[2];
        if (template.isHtml) {
            block1: for (i = 0; i < buf.length(); ++i) {
                if (buf.charAt(i) != '<' || (buf.charAt(i + 1) | 0x20) != 116 || (buf.charAt(i + 2) | 0x20) != 105 || (buf.charAt(i + 3) | 0x20) != 116 || (buf.charAt(i + 4) | 0x20) != 108 || (buf.charAt(i + 5) | 0x20) != 101 || buf.charAt(i + 6) != '>') continue;
                for (int n = i; n < buf.length(); ++n) {
                    if (buf.charAt(n) != '<' || buf.charAt(n + 1) != '/' || (buf.charAt(n + 2) | 0x20) != 116 || (buf.charAt(n + 3) | 0x20) != 105 || (buf.charAt(n + 4) | 0x20) != 116 || (buf.charAt(n + 5) | 0x20) != 108 || (buf.charAt(n + 6) | 0x20) != 101 || buf.charAt(n + 7) != '>') continue;
                    char[] emailBetreff = new char[n - i - 7];
                    buf.getChars(i + 7, n, emailBetreff, 0);
                    result[0] = new String(emailBetreff);
                    break block1;
                }
                break;
            }
            result[1] = buf.toString();
        } else {
            for (i = 0; i < buf.length(); ++i) {
                if (buf.charAt(i) != '\n') continue;
                char[] emalibetreff = new char[i];
                buf.getChars(0, i, emalibetreff, 0);
                result[0] = new String(emalibetreff);
                if (result[0].indexOf(13) > -1) {
                    result[0] = result[0].replace('\r', ' ').trim();
                }
                char[] content = new char[buf.length() - (i + 1)];
                buf.getChars(i + 1, buf.length(), content, 0);
                result[1] = new String(content);
                break;
            }
        }
        String betreff = this.data.get(KEY_BETREFF_MANUAL);
        if (betreff != null) {
            result[0] = betreff;
        }
        return result;
    }

    private boolean compareChars(boolean caseInSensitiv, char tag, char start, char end) {
        if (tag == start && tag == end) {
            return true;
        }
        if (caseInSensitiv) {
            if (start < '[') {
                start = (char)(start + 32);
            }
            if (end < '[') {
                end = (char)(end + 32);
            }
            if (tag == start && tag == end) {
                return true;
            }
        }
        return false;
    }

    private String removeTag(String in, String tag) {
        int startOffset;
        int endOffset = 0;
        int length = in.length();
        int tagLen = tag.length();
        for (startOffset = 0; startOffset < length && in.charAt(startOffset) < '!'; ++startOffset) {
        }
        while (endOffset < length && in.charAt(length - 1 - endOffset) < '!') {
            ++endOffset;
        }
        if (length - startOffset - startOffset > tagLen * 2 + 5 && this.compareChars(false, '<', in.charAt(0 + startOffset), in.charAt(length - endOffset - tagLen - 3)) && this.compareChars(false, '>', in.charAt(tagLen + startOffset + 1), in.charAt(length - endOffset - 1))) {
            for (int i = 0; i < tag.length(); ++i) {
                if (this.compareChars(true, tag.charAt(i), in.charAt(i + startOffset + 1), in.charAt(length - endOffset - tagLen - 1 + i))) continue;
                return in;
            }
            int cutStart = tagLen + startOffset + 2;
            int cutEnd = length - tagLen - endOffset - 3;
            return in.substring(cutStart, cutEnd);
        }
        return in;
    }

    private String removeStartPart(String in, String startTag, String partEndTag) {
        int index;
        if (in.startsWith(startTag) && (index = in.indexOf(partEndTag)) > -1) {
            return in.substring(index + partEndTag.length());
        }
        startTag = startTag.toUpperCase();
        partEndTag = partEndTag.toUpperCase();
        if (in.startsWith(startTag) && (index = in.indexOf(partEndTag)) > -1) {
            int cut;
            for (cut = index + partEndTag.length(); cut < in.length() && in.charAt(cut) < '!'; ++cut) {
            }
            return in.substring(cut);
        }
        return in;
    }

    private String removeHtmlTags(String in) {
        in = HtmlConverter.html2inlinedHtml((String)in, (boolean)false, (boolean)true, null);
        in = this.removeTag(in, "html");
        in = this.removeStartPart(in, "<head>", "</head>");
        in = this.removeTag(in, "body");
        return in;
    }

    private String getPlatzhalter(String name, boolean html) {
        String str = this.data.get(name);
        if (str == null) {
            if (name.startsWith("mailto:")) {
                str = this.data.get(name = name.substring(7));
                if (str == null || str.length() < 9) {
                    return "";
                }
                if (html) {
                    return "<a href=\"mailto:" + str + "\">" + str + "</a>";
                }
                return "[mailto:" + str + "]";
            }
            Configuration configuration = ConfigurationManager.getInstance().getCurrent();
            String value = configuration.get(name);
            return value != null ? value : "";
        }
        if (name.equals(KEY_AUFTRAG)) {
            boolean htmlAuftrag = "true".equals(this.data.get(KEY_ISHTML));
            if (htmlAuftrag != html) {
                str = html ? HtmlConverter.text2html((String)str, null) : HtmlConverter.html2text((String)str);
            } else if (html) {
                str = HtmlConverter.html2inlinedHtml((String)str, (boolean)false, (boolean)true, null);
            }
        } else if (html && !name.startsWith(KEY_SUBTEMPLATE)) {
            if (SIMPLE_TEXT_FIELDS.contains(name)) {
                str = HtmlConverter.text2html((String)str, null);
            } else {
                int index = str.indexOf(10);
                if (index > -1) {
                    str = str.replace("\n", "<BR>");
                }
            }
        }
        return str;
    }

    @Override
    public void run() {
        InternetAddress[] to = null;
        InternetAddress[] cc = null;
        InternetAddress[] bcc = null;
        InternetAddress from = null;
        try {
            this.aufID = this.data.get(KEY_AUFID);
            if (this.aufID == null) {
                this.aufID = "";
            }
            int idInt = -1;
            int bunIdInt = -1;
            if (this.aufID.length() > 0) {
                this.data.put(KEY_AUFIDXXX, Tickets.getTicketIDForEmailSubject(Integer.parseInt(this.aufID)));
                if (this.data.get("ready") == null && !this.loadData()) {
                    return;
                }
                idInt = Integer.parseInt(this.aufID);
                bunIdInt = this.bunID != null && this.bunID.length() > 0 ? Integer.parseInt(this.bunID) : idInt;
                String dispatched = this.data.get(KEY_ISDISPATCHED);
                if (dispatched != null) {
                    boolean sendToDispatcher = 21 == this.myTyp;
                    boolean sendToResource = 5 == this.myTyp;
                    boolean isDispatched = Boolean.valueOf(dispatched);
                    if (sendToDispatcher && isDispatched) {
                        return;
                    }
                    if (sendToResource && !isDispatched) {
                        return;
                    }
                }
            }
            this.setSender();
            Trigger tr = TriggerHandler.getTrigger(2);
            if (tr != null) {
                tr.checkData(this.data, false);
            }
            String templateName = this.data.get(KEY_TEMPLATE_NAME);
            String empf = this.data.get(KEY_EMAIL_EMPF);
            String abs = this.data.get(KEY_EMAIL_SEND);
            if (templateName != null && templateName.length() > 0 && empf != null && empf.length() > 0 && abs != null && abs.length() > 0) {
                Template thisTemplate = this.getTemplate(templateName);
                if (thisTemplate == null) {
                    return;
                }
                from = this.getfrom(abs, this.data.get(KEY_EMAIL_SEND_DISP_NAME));
                if (from == null) {
                    return;
                }
                to = this.getrecipients(empf, this.data.get(KEY_PRODUCER), bunIdInt, this.data.get(KEY_TYP_DESCRIPTION));
                if (to == null) {
                    return;
                }
                cc = this.getrecipients(this.data.get(KEY_EMAIL_EMPF_CC), this.data.get(KEY_PRODUCER), bunIdInt, this.data.get(KEY_TYP_DESCRIPTION));
                bcc = this.getrecipients(this.data.get(KEY_EMAIL_EMPF_BCC), this.data.get(KEY_PRODUCER), bunIdInt, this.data.get(KEY_TYP_DESCRIPTION));
                ArrayList<MailAttachment> toAttach = new ArrayList<MailAttachment>();
                if (thisTemplate.isHtml && thisTemplate.logo && this.data.get(KEY_LOGO_FILE_KEY) != null) {
                    this.addLogoFile(this.data, toAttach);
                }
                HashSet<Integer> listOfReasWhoseTextIsUsedInMail = new HashSet<Integer>();
                if (thisTemplate.containsAnfrageTextPlaceholder()) {
                    listOfReasWhoseTextIsUsedInMail.add(this.anfReaId);
                    listOfReasWhoseTextIsUsedInMail.add(-1);
                }
                if (thisTemplate.containsSubtemplates()) {
                    String subTempName;
                    Object paramName = KEY_SUBTEMPLATE;
                    if (this.data.get(KEY_SUBTEMPLATEFILE) != null) {
                        subTempName = this.data.get(KEY_SUBTEMPLATEFILE).toString();
                    } else if (thisTemplate.subtemplateLast) {
                        subTempName = thisTemplate.isHtml ? "subtemplatelaststep_html.txt" : "subtemplatelaststep_text.txt";
                        paramName = KEY_SUBTEMPLATELASTSTEP;
                        this.data.put(KEY_SUBTEMPLATESORTORDER, "LastOnly");
                    } else {
                        subTempName = thisTemplate.isHtml ? "subtemplate_html.txt" : "subtemplate_text.txt";
                    }
                    this.data.put((String)paramName, this.loadSubtemplateData(thisTemplate.isHtml, this.getTemplate(subTempName), listOfReasWhoseTextIsUsedInMail));
                }
                final String[] result = this.zusammensetzen(thisTemplate);
                this.mailMetaData.setTicketId(idInt);
                this.mailMetaData.setSendAttachments("true".equals(this.data.get(KEY_SENDATTACHMENTS)));
                this.mailMetaData.setSendMailAsHtml("html".equals(MAIL_FORMAT.get()));
                this.mailMetaData.setListOfReaIDsWhoseTextIsUsedInMail(listOfReasWhoseTextIsUsedInMail);
                for (SendAutoMailExtension extension : ServerPluginManager.getInstance().get(SendAutoMailExtension.class)) {
                    result[1] = extension.extendEmail(result[1], toAttach, this.mailMetaData);
                }
                final boolean html = thisTemplate.isHtml;
                final MailDataSource[] allAttachments = toAttach.toArray(new MailDataSource[0]);
                final InternetAddress[] toAddresses = to;
                final InternetAddress[] ccAddresses = cc;
                final InternetAddress[] bccAddresses = bcc;
                final InternetAddress fromAddress = from;
                HelpDeskBaseEmail email = new HelpDeskBaseEmail(){

                    protected String getSubject() throws MessagingException {
                        if (html) {
                            return HtmlConverter.html2text((String)result[0]);
                        }
                        return result[0];
                    }

                    protected InternetAddress[] getTo() throws MessagingException {
                        return toAddresses;
                    }

                    @Nullable
                    protected InternetAddress[] getCc() throws MessagingException {
                        return ccAddresses;
                    }

                    @Nullable
                    protected InternetAddress[] getBcc() throws MessagingException {
                        return bccAddresses;
                    }

                    protected String getMessage() throws MessagingException {
                        return result[1];
                    }

                    @Nonnull
                    protected Logger getLogger() {
                        return HDLogger.LOG;
                    }

                    protected String getMessageMime() throws MessagingException {
                        return html ? "HTML" : "plain";
                    }

                    @Nullable
                    protected MailDataSource[] getFiles() throws MessagingException {
                        return allAttachments;
                    }

                    public void send() throws MessagingException {
                        super.send(fromAddress);
                    }

                    protected Properties getHeaders() {
                        String foreignKeyColumn = (String)FOREIGN_KEY_COLUMN.get();
                        String forkKey = foreignKeyColumn != null && foreignKeyColumn.length() > 0 ? AutoMail.this.data.get(AliasMapper.getReverseMappingForCustomFields(foreignKeyColumn)) : AutoMail.this.data.get("foreignkey");
                        String ticketIDForEmailSubject = AutoMail.this.aufID != null && AutoMail.this.aufID.length() > 0 ? Tickets.getTicketIDForEmailSubject(Integer.parseInt(AutoMail.this.aufID)) : "";
                        return Mail.getHeaders(ticketIDForEmailSubject, forkKey, AutoMail.this.data.get("Message-ID"));
                    }
                };
                email.send();
                if (this.aufID != null && this.aufID.length() > 0) {
                    Mail.addRealisierung(Integer.parseInt(this.aufID), null, -14, from.getAddress(), Mail.getAddressString((Address[])to), Mail.getAddressString((Address[])cc), Mail.getAddressString((Address[])bcc), "Template: " + templateName);
                }
            }
        }
        catch (Exception trErr) {
            HDLogger.error(new HelpDeskServerException("Automail failed!", (Throwable)trErr, HelpDeskErrorCodes.MAIL_CREATION_ERROR));
            try {
                if (this.aufID != null && this.aufID.length() > 0 && from != null) {
                    String errorMsg = "Error: " + trErr.getMessage();
                    if (errorMsg.length() > 255) {
                        HDLogger.error("shortening email description from -> " + errorMsg);
                        errorMsg = errorMsg.substring(0, 252) + "...";
                    }
                    Mail.addRealisierung(Integer.parseInt(this.aufID), null, -14, from.getAddress(), Mail.getAddressString(to), Mail.getAddressString(cc), Mail.getAddressString(bcc), errorMsg);
                }
            }
            catch (Exception other) {
                HDLogger.error(new HelpDeskServerException("Could not write mail failure to database!", (Throwable)other, HelpDeskErrorCodes.SQL_EXECUTION_ERROR));
            }
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="This add the logo to the internal data")
    private void addLogoFile(Map<String, String> data, ArrayList<MailAttachment> toAttach) {
        Path filePath;
        String logoPath = data.get(KEY_LOGO_FILE_KEY);
        if (logoPath == null || logoPath.trim().isEmpty()) {
            return;
        }
        if (logoPath.trim().startsWith("http:") || logoPath.trim().startsWith("https:")) {
            try {
                URL url = new URL(logoPath);
                data.put(KEY_LOGO_FILE_KEY, "<img src=\"" + url.toExternalForm() + "\">");
                return;
            }
            catch (MalformedURLException e) {
                return;
            }
        }
        try {
            filePath = Paths.get(logoPath, new String[0]);
        }
        catch (InvalidPathException ex) {
            return;
        }
        if (filePath.isAbsolute()) {
            File file = filePath.toFile();
            if (file.exists() && !file.isDirectory()) {
                String result = MailUtilities.addToList(file.getAbsolutePath(), file.getName(), true, toAttach);
                data.put(KEY_LOGO_FILE_KEY, "<img src=\"cid:" + result + "\">");
            }
        } else {
            PersistenceEntry file = this.getLogoFileFromPersistence(logoPath);
            if (file != null) {
                String result = MailUtilities.addToList(file, file.getName(), true, toAttach);
                data.put(KEY_LOGO_FILE_KEY, "<img src=\"cid:" + result + "\">");
            }
        }
    }

    private PersistenceEntry getLogoFileFromPersistence(@Nonnull String filePath) {
        PersistenceEntry file = AppDataLocation.getClientImageDirectory().resolve(filePath);
        if (file.exists()) {
            return file;
        }
        file = Persistence.getInstance().resolve(filePath);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private InternetAddress isAddressValid(String addr, String producer, HashSet<String> filter, int ticketId, String mailType) {
        InternetAddress address = Mail.getEmailAddress(addr);
        if (address != null) {
            BlackListHandler.BlackListEntry entry = BlackListHandler.checkForBlackListEntry(addr, ticketId);
            if (entry != null) {
                if (entry.isSizeProblem()) {
                    this.mailMetaData.setBlackListedBecauseofSize(true);
                } else {
                    if (entry.isSuppressAutomailing()) {
                        HDLogger.info("Black list: #" + ticketId + " " + entry.getBlackListInformation() + " " + mailType);
                        return null;
                    }
                    HDLogger.info("Black list: " + addr + " " + entry.getBlackListInformation() + " " + mailType);
                    return null;
                }
            }
            int addpos = addr.indexOf(64);
            String vorn = addr.substring(0, addpos).toLowerCase();
            String hinten = addr.substring(addpos + 1).toLowerCase();
            if (filter.contains(vorn) && filter.contains(hinten)) {
                HDLogger.info("No automail to internal account: " + addr);
                return null;
            }
            if (producer != null && producer.equalsIgnoreCase(addr)) {
                HDLogger.info("No Auto-Mail (" + mailType + ") to originator: " + producer);
                return null;
            }
        }
        return address;
    }

    private InternetAddress[] getrecipients(String addresses, String producer, int ticketId, String mailType) {
        if (addresses == null || addresses.length() < 7) {
            return null;
        }
        HashSet<String> hm = Mail.generateMailFilter();
        InternetAddress[] allMails = null;
        if (addresses.indexOf(44) > -1) {
            addresses = addresses.replace(',', ';');
        }
        if (addresses.indexOf(59) > -1) {
            Vector<InternetAddress> vec = null;
            StringTokenizer eimailTokens = new StringTokenizer(addresses, ";");
            while (eimailTokens.hasMoreTokens()) {
                String test = eimailTokens.nextToken().trim();
                InternetAddress address = this.isAddressValid(test, producer, hm, ticketId, mailType);
                if (address == null) continue;
                if (vec == null) {
                    vec = new Vector<InternetAddress>();
                }
                vec.addElement(address);
            }
            if (vec != null) {
                allMails = new InternetAddress[vec.size()];
                for (int i = 0; i < vec.size(); ++i) {
                    allMails[i] = (InternetAddress)vec.elementAt(i);
                }
            }
        } else {
            InternetAddress address = this.isAddressValid(addresses, producer, hm, ticketId, mailType);
            if (address != null) {
                allMails = new InternetAddress[]{address};
            } else {
                return null;
            }
        }
        return allMails;
    }

    private InternetAddress getfrom(String em, String dispName) {
        InternetAddress address = Mail.getEmailAddress(em);
        if (address != null && dispName != null && dispName.trim().length() > 0) {
            try {
                address.setPersonal(dispName, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                HDLogger.error(ex);
            }
        }
        return address;
    }

    public static String[] availableTemplateNames() {
        return AppDataLocation.getAutoMailTemplateDirectory().getChildren().stream().map(f -> {
            int lastIndex = f.getName().lastIndexOf(46);
            if (lastIndex == -1) {
                lastIndex = f.getName().length();
            }
            return f.getName().substring(0, lastIndex);
        }).distinct().collect(Collectors.toList()).toArray(new String[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Template getTemplate(String templateName) {
        byte[] inputtext = new byte[1];
        int length = 0;
        int anfang = 0;
        Vector<byte[]> emailText = new Vector<byte[]>();
        Vector<String> platzhalter = new Vector<String>();
        HDLogger.debug("Lade Templates//" + templateName);
        try (InputStream fs = this.getTemplateInputStream(templateName);){
            if (fs == null) {
                PersistenceEntry template2 = AppDataLocation.getAutoMailTemplate(templateName);
                HDLogger.error(new FileNotFoundException(template2.getPath()));
                Template template = null;
                return template;
            }
            inputtext = new byte[fs.available()];
            length = fs.read(inputtext);
        }
        catch (IOException e) {
            HDLogger.error(e);
            return null;
        }
        Template theTemplate = new Template();
        theTemplate.isHtml = !templateName.toLowerCase().endsWith(".txt");
        int start = 0;
        if (length > 3 && inputtext[0] == -17 && inputtext[1] == -69 && inputtext[2] == -65) {
            start = 3;
            anfang = 3;
        }
        int i = start;
        while (true) {
            block21: {
                block22: {
                    byte[] stueck;
                    block20: {
                        if (i >= length) break block20;
                        if (inputtext[i] != 60 || i + 1 >= length || inputtext[i + 1] != 37) break block21;
                        stueck = new byte[i - anfang];
                        System.arraycopy(inputtext, anfang, stueck, 0, i - anfang);
                        emailText.addElement(stueck);
                        anfang = i + 2;
                        break block22;
                    }
                    stueck = new byte[length - anfang];
                    System.arraycopy(inputtext, anfang, stueck, 0, length - anfang);
                    emailText.addElement(stueck);
                    theTemplate.subtemplate = platzhalter.indexOf(KEY_SUBTEMPLATE) > -1;
                    theTemplate.subtemplateLast = platzhalter.indexOf(KEY_SUBTEMPLATELASTSTEP) > -1;
                    theTemplate.logo = platzhalter.indexOf(KEY_LOGO_FILE_KEY) > -1;
                    theTemplate.texte = new String[emailText.size()];
                    try {
                        for (i = 0; i < emailText.size(); ++i) {
                            theTemplate.texte[i] = new String((byte[])emailText.elementAt(i), "UTF-8");
                        }
                    }
                    catch (Throwable er) {
                        HDLogger.error(er);
                    }
                    theTemplate.vars = new String[platzhalter.size()];
                    int i2 = 0;
                    while (i2 < platzhalter.size()) {
                        theTemplate.vars[i2] = ((String)platzhalter.elementAt(i2)).toString();
                        ++i2;
                    }
                    return theTemplate;
                }
                for (int n = i + 1; n < length; ++n) {
                    String pStueck;
                    if (inputtext[n] != 37 || inputtext[n + 1] != 62) continue;
                    try {
                        pStueck = new String(inputtext, anfang, n - anfang, "UTF-8").toLowerCase();
                    }
                    catch (Exception ex) {
                        HDLogger.error(ex);
                        pStueck = "Encoding Exception";
                    }
                    anfang = n + 2;
                    platzhalter.addElement(pStueck);
                    i = n + 2;
                    break;
                }
            }
            ++i;
        }
    }

    protected InputStream getTemplateInputStream(String templateName) {
        PersistenceEntry template = AppDataLocation.getAutoMailTemplate(templateName);
        HDLogger.debug("File: " + template);
        return template.getInputStream();
    }

    private class Template {
        private boolean isHtml;
        private boolean logo;
        private boolean subtemplate;
        private boolean subtemplateLast;
        private String[] texte;
        private String[] vars;

        private Template() {
        }

        private boolean containsSubtemplates() {
            return this.subtemplate || this.subtemplateLast;
        }

        private boolean containsAnfrageTextPlaceholder() {
            for (String v : this.vars) {
                if (!v.equals(AutoMail.KEY_AUFTRAG)) continue;
                return true;
            }
            return false;
        }

        private boolean containsReaStepTextPlaceholder() {
            for (String v : this.vars) {
                if (!v.equals("was")) continue;
                return true;
            }
            return false;
        }
    }
}

