/*
 * Decompiled with CFR 0.152.
 */
package srv.controller.ticket;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.GenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationManager;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationVO;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;
import com.inet.helpdesk.core.ticketmanager.fields.resource.ResourceManager;
import com.inet.helpdesk.core.ticketmanager.fields.resource.ResourceVO;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserGroupVOManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import srv.ServerUtilities;
import srv.controller.OpenOrderController;
import srv.controller.ticket.attributes.LastEditorVO;
import srv.controller.ticket.attributes.ResourceAdditionalData;
import srv.controller.ticket.attributes.UserDefinedVO;

public class Auftrag {
    public static final int SUBAUFTRAG_REFERENZ = 1;
    public static final int WORKFLOW_REFERENZ = 2;
    public static final int NO_FLAG = 0;
    public static final int BEEP_FLAG = 1;
    public static final int SYSTRAY_FLAG = 2;
    public static final int BOTH_FLAG = 3;
    public static final int MAX_SUBJECT_LENGTH = 30;
    private OpenOrderController theChief;
    private int aufNr;

    public Auftrag(OpenOrderController controlleti, int id) {
        this.theChief = controlleti;
        this.aufNr = id;
    }

    public void check(int stat, int resID, boolean countUp) {
        boolean valueChanged;
        int resourceID = HDUsersAndGroups.getResourceId(this.ticket().getResourceID());
        boolean resourceChange = resourceID != resID;
        boolean bl = valueChanged = resourceChange || this.ticket().getStatusID() != stat;
        if (valueChanged) {
            this.updateVersionToLastChanged(resourceChange);
            if (resourceChange) {
                this.theChief.getResource(resID).setBufferVersion(this.getVersion());
                this.theChief.getResource(resID).realizeChanges(this.theChief);
                this.onCheck();
            }
            this.theChief.wipeCacheFor(this);
        }
        this.setStatus(stat, countUp, this.ticket().getStatusID());
        this.getResourceAdditionals().setBufferVersion(this.getVersion());
    }

    protected void onCheck() {
    }

    public void setStatus(int stat, boolean countup, int previousStatus) {
        if (stat != previousStatus && !this.theChief.isNewState(stat)) {
            this.theChief.setMsgFlag(this.aufNr, 0);
        }
        this.updateVersionToLastChanged(true);
        if (stat != previousStatus) {
            this.onSetStatus();
        }
    }

    protected void onSetStatus() {
    }

    public void updateVersionToLastChanged(boolean triggerResourceVersion) {
        this.theChief.wipeCacheFor(this);
        ResourceAdditionalData resourceAdditionals = this.getResourceAdditionals();
        if (triggerResourceVersion && resourceAdditionals != null) {
            resourceAdditionals.setBufferVersion(this.getVersion());
        }
    }

    public FieldVO getAttribut(Field typ) {
        TicketVO ticket = TicketManager.getReaderForSystem().getTicket(this.aufNr);
        Integer key = null;
        GenericFieldsManager mgr = null;
        UserAccount userAccount = ticket.getOwnerID() != null ? UserManager.getInstance().getUserAccount(ticket.getOwnerID()) : null;
        switch (typ) {
            case PRIORITAET: {
                mgr = PriorityManager.getInstance();
                key = ticket.getPriorityID();
                break;
            }
            case KLASSIFIZIERUNG: {
                mgr = ClassificationManager.getInstance();
                key = ticket.getClassificationID();
                break;
            }
            case KATEGORIE: {
                mgr = CategoryManager.getInstance();
                key = ticket.getCategoryID();
                break;
            }
            case ITIL: {
                mgr = ItilManager.getInstance();
                key = ticket.getItilID();
                break;
            }
            case RESOURCE: {
                ResourceVO ress = this.getResource();
                if (ress != null) {
                    return ress;
                }
                return new FieldVO(0){

                    @Override
                    public String getDisplayValue() {
                        return "";
                    }
                };
            }
            case ORT: {
                if (userAccount == null) break;
                key = (Integer)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
                mgr = LocationManager.getInstance();
                break;
            }
            case BENUTZERGRUPPE: {
                if (userAccount == null) break;
                key = (Integer)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_GROUP_ID);
                mgr = UserGroupVOManager.getInstance();
                break;
            }
            case STATUS: {
                return StatusManager.getInstance().get(ticket.getStatusID());
            }
            case FREI: {
                if (this.theChief != null && this.theChief.isUserViewField()) {
                    return userAccount == null ? new UserDefinedVO(-1, "") : this.theChief.getFreiauswahl(userAccount);
                }
                return this.getUserDefinedField();
            }
            case LASTEDITOR: {
                UserAccount lastEditorAccount;
                GUID lastEditorID = ticket.getLastEditorID();
                if (lastEditorID != null && (lastEditorAccount = UserManager.getInstance().getUserAccount(lastEditorID)) != null) {
                    return new LastEditorVO(lastEditorAccount.hashCode(), lastEditorAccount.getDisplayName());
                }
                return new LastEditorVO(-1, "");
            }
            default: {
                return null;
            }
        }
        if (key != null) {
            return mgr.get(key);
        }
        return new FieldVO(-1){

            @Override
            public String getDisplayValue() {
                return "";
            }
        };
    }

    public int getBunID() {
        return this.ticket().getBundleID();
    }

    public String getSubject() {
        return TicketManager.getReaderForSystem().getTicket(this.aufNr).getSubject();
    }

    public String getCuttedSubject() {
        String subject = this.getSubject();
        return ServerUtilities.getCutedString(subject, 30);
    }

    public Timestamp getLastChanged() {
        return new Timestamp(this.ticket().getLastChanged());
    }

    public int getOrderID() {
        return this.aufNr;
    }

    @Nullable
    public UserAccount getUser() {
        GUID ownerID = this.ticket().getOwnerID();
        return ownerID == null ? null : UserManager.getInstance().getUserAccount(ownerID);
    }

    public int getStatus() {
        return this.ticket().getStatusID();
    }

    public ResourceVO getResource() {
        ResourceAdditionalData resourceAdditionals = this.getResourceAdditionals();
        return resourceAdditionals == null ? null : resourceAdditionals.getResource();
    }

    public ResourceAdditionalData getResourceAdditionals() {
        TicketVO ticket = this.ticket();
        if (ticket == null) {
            return null;
        }
        GUID groupId = ticket.getResourceID();
        if (groupId == null) {
            return null;
        }
        int resourceID = HDUsersAndGroups.getResourceId(groupId);
        return this.theChief.getResource(resourceID);
    }

    public String getInAccount() {
        return this.ticket().getEmailEingang();
    }

    public void updateVersion() {
        int newVersion = (int)(System.currentTimeMillis() / 1000L);
        int lastChangedVersion = this.theChief.getAuftragLastVersion(this.aufNr);
        this.theChief.setAuftragLastVersion(this.aufNr, Math.max(lastChangedVersion + 1, newVersion));
    }

    public int getVersion() {
        if (this.theChief == null) {
            return 1;
        }
        return this.theChief.getAuftragLastVersion(this.aufNr);
    }

    private TicketVO ticket() {
        return TicketManager.getReaderForSystem().getTicket(this.aufNr);
    }

    public PriorityVO getPriority() {
        TicketVO vo = this.ticket();
        return (PriorityVO)PriorityManager.getInstance().get(vo.getPriorityID());
    }

    public CategoryVO getCategory() {
        Integer categoryID = this.ticket().getCategoryID();
        if (categoryID == null) {
            return new CategoryVO(0, "", 0, 0, false, false, null);
        }
        return (CategoryVO)CategoryManager.getInstance().get(categoryID);
    }

    public ClassificationVO getClassification() {
        return (ClassificationVO)ClassificationManager.getInstance().get(this.ticket().getClassificationID());
    }

    public ItilVO getItil() {
        return (ItilVO)ItilManager.getInstance().get(this.ticket().getItilID());
    }

    public UserDefinedVO getUserDefinedField() {
        String name;
        String dbFeldKurz;
        switch (dbFeldKurz = this.theChief.getDbFeldKurz()) {
            case "BunFeld1": {
                name = this.ticket().getCustom1();
                break;
            }
            case "BunFeld2": {
                name = this.ticket().getCustom2();
                break;
            }
            case "BunFeld3": {
                name = this.ticket().getCustom3();
                break;
            }
            case "BunFeld4": {
                name = this.ticket().getCustom4();
                break;
            }
            case "BunFeld5": {
                name = this.ticket().getCustom5();
                break;
            }
            case "BunFeld6": {
                name = this.ticket().getCustom6();
                break;
            }
            case "BunFeld7": {
                name = this.ticket().getCustom7();
                break;
            }
            case "spezFeld": {
                name = this.ticket().getIdentifier();
                break;
            }
            default: {
                return null;
            }
        }
        return new UserDefinedVO(name.hashCode(), name);
    }

    public void setMsgFlag(int msgFlag) {
        this.theChief.setMsgFlag(this.aufNr, msgFlag);
    }

    public int getMsgFlag() {
        return this.theChief.getMsgFlag(this.aufNr);
    }

    public Integer getAutorisierenReaID() {
        return this.ticket().getDispatchingReaStepID();
    }

    public int getResourceID() {
        return HDUsersAndGroups.getResourceId(this.ticket().getResourceID());
    }

    public static enum Field {
        STATUS("Status", "StatusBezeichnung", true, StatusManager::getInstance),
        RESOURCE("ResID", "ResBezeichnung", true, ResourceManager::getInstance),
        PRIORITAET("PriID", "PriBezeichnung", true, PriorityManager::getInstance),
        KLASSIFIZIERUNG("KlaID", "KlassenName", true, ClassificationManager::getInstance),
        KATEGORIE("BetID", "Betreff", true, CategoryManager::getInstance),
        ORT("GebID", "GebBezeichnung", true, LocationManager::getInstance),
        BENUTZERGRUPPE("BgrID", "GroupName", true, UserGroupVOManager::getInstance),
        ITIL("ItiID", "ItilBezeichnung", true, ItilManager::getInstance),
        FREI(null, null, false, null),
        USER("UsrID", "Username", true, null),
        LASTEDITOR("Bearbeiter", "Men7", false, null),
        PREDEFINED_TICKETFIELD1("BunFeld1", null, false, null),
        PREDEFINED_TICKETFIELD2("BunFeld2", null, false, null),
        PREDEFINED_TICKETFIELD3("BunFeld3", null, false, null),
        PREDEFINED_TICKETFIELD4("BunFeld4", null, false, null);

        private static final Map<String, Field> FIELDS_MAP;
        private final String keyColumn;
        private final String nameColumn;
        private final boolean numeric;
        private Supplier<GenericFieldsManager<? extends FieldVO>> managerProvider;

        private Field(String keyColumn, String nameColumn, boolean numeric, Supplier<GenericFieldsManager<? extends FieldVO>> managerProvider) {
            this.keyColumn = keyColumn;
            this.nameColumn = nameColumn;
            this.numeric = numeric;
            this.managerProvider = managerProvider;
        }

        public GenericFieldsManager<? extends FieldVO> getManager() {
            return this.managerProvider.get();
        }

        public String getKeyColumn() {
            return this.keyColumn;
        }

        public String getNameColumn() {
            return this.nameColumn;
        }

        public boolean isNumeric() {
            return this.numeric;
        }

        public static Field findField(String keyName) {
            Field field;
            if (keyName == null) {
                return FREI;
            }
            int index = keyName.lastIndexOf(46);
            if (index > 0) {
                keyName = keyName.substring(index + 1);
            }
            return (field = FIELDS_MAP.get(keyName.toUpperCase())) != null ? field : FREI;
        }

        static {
            FIELDS_MAP = new HashMap<String, Field>();
            for (Field field : Field.values()) {
                String key = field.getKeyColumn() != null ? field.getKeyColumn().toUpperCase(Locale.GERMANY) : null;
                FIELDS_MAP.put(key, field);
            }
            FIELDS_MAP.put("Betreff".toUpperCase(Locale.GERMANY), KATEGORIE);
        }
    }
}

