/*
 * Decompiled with CFR 0.152.
 */
package srv.controller;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.TicketAccessInfo;
import com.inet.helpdesk.core.data.TicketAccessInformations;
import com.inet.helpdesk.core.data.TicketAccessInformationsProvider;
import com.inet.helpdesk.core.swing.ListResultSet;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.server.tickets.SetTicketReadAfterAccess;
import com.inet.helpdesk.shared.util.TypespecificIntMap;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.thread.EventDispatcher;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import srv.ServerUtilities;
import srv.controller.ClientSession;
import srv.controller.UserSession;

public class TicketAccessController
implements TicketAccessInformationsProvider {
    private static final int REQUEST_READ = 1;
    private static final int REQUEST_WRITE = 2;
    private static final int REQUEST_WRITE_OR_READ = 3;
    private TypespecificIntMap<OpenedBuendel> theOpenedTickets;
    private final EventDispatcher<TicketAccessInformationsProvider.TicketAccessChangedListener> eventDispatcher = new EventDispatcher();
    private final Map<String, ClientSession> pureClientSessions = Collections.synchronizedMap(new HashMap());

    public TicketAccessController() {
        this.theOpenedTickets = new TypespecificIntMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleOpenedOrders(UserSession theSession, int[] openedOrders, Properties daten) {
        if (theSession.getCountOfOpenOrders() > 0 || openedOrders != null) {
            TicketAccessController ticketAccessController = this;
            synchronized (ticketAccessController) {
                this.buendelRemoves(theSession, openedOrders);
                if (openedOrders != null) {
                    for (int id : openedOrders) {
                        this.buendelAccess(theSession, id, 3);
                    }
                    if (daten != null) {
                        for (int openedOrder : openedOrders) {
                            daten.setProperty(String.valueOf(openedOrder), this.getMessageInformation(theSession, openedOrder));
                        }
                    }
                }
                theSession.setCountOfOpenOrders(openedOrders != null ? openedOrders.length : 0);
            }
        }
    }

    private String getMessageInformation(ClientSession userSession, int orderID) {
        boolean writeAccess = false;
        int aufVersion = -1;
        StringBuffer buf = new StringBuffer();
        OpenedBuendel ob = this.theOpenedTickets.get(this.aufIdToBunId(orderID));
        if (ob != null) {
            boolean firstInTheRow = userSession != null && (userSession.equals(ob.ownerSession) || ob.ownerSession == null && ob.existsInBundle(userSession) == 1);
            writeAccess = firstInTheRow && ob.referenz != null;
            for (int i = 0; i < ob.occupantsCount(); ++i) {
                ClientSession someSession;
                if (i > 0) {
                    buf.append('\n');
                }
                if ((someSession = ob.getSession(i)) == null) continue;
                if (userSession != null && userSession.equals(someSession)) {
                    aufVersion = ob.referenz != null ? (int)(ob.referenz.getLastChanged() / 1000L) : 0;
                    buf.append("<b>").append(someSession.getOwner().getDisplayName()).append("</b>");
                    continue;
                }
                buf.append(someSession.getOwner().getDisplayName());
            }
        }
        long latestChange = ob.referenz.getLastChanged();
        TicketVO ticketWithLatestChange = ob.referenz;
        List<TicketVOSingle> slaves = TicketManager.getReaderForSystem().getTicketsInBundle(orderID, false);
        for (TicketVOSingle slave : slaves) {
            if (slave.getLastChanged() <= latestChange) continue;
            latestChange = slave.getLastChanged();
            ticketWithLatestChange = slave;
        }
        GUID lastChangedByID = ticketWithLatestChange.getLastChangedByID();
        int userID = lastChangedByID == null ? 0 : HDUsersAndGroups.getUserID(lastChangedByID);
        buf.insert(0, String.valueOf(userID) + ";");
        buf.insert(0, String.valueOf(ob != null ? ob.occupantsCount() : 0) + ";");
        buf.insert(0, String.valueOf(writeAccess) + ";");
        buf.insert(0, String.valueOf(aufVersion) + ";");
        return buf.toString();
    }

    public ArrayList<UserAccount> getUsersInTicket(int orderID) {
        ArrayList<UserAccount> result = new ArrayList<UserAccount>();
        OpenedBuendel ob = this.theOpenedTickets.get(this.aufIdToBunId(orderID));
        if (ob != null) {
            for (int i = 0; i < ob.occupantsCount(); ++i) {
                ClientSession someSession = ob.getSession(i);
                if (someSession == null) continue;
                result.add(someSession.getOwner());
            }
        }
        return result;
    }

    private void buendelRemoves(ClientSession session, int[] aufnrs) {
        int[] allTickets;
        for (int ticketBunId : allTickets = this.theOpenedTickets.getAllKeys()) {
            OpenedBuendel ob = this.theOpenedTickets.get(ticketBunId);
            if (ob == null) continue;
            ob.checkSessions();
            boolean found = false;
            if (aufnrs != null) {
                for (int aufnr : aufnrs) {
                    if (ob.bunId != this.aufIdToBunId(aufnr)) continue;
                    found = true;
                    break;
                }
            }
            boolean removed = false;
            if (!found) {
                removed = ob.removeSession(session);
            }
            if (ob.occupantsCount() == 0) {
                this.theOpenedTickets.remove(ticketBunId);
            }
            if (!removed) continue;
            this.sendTicketAccessChangedEvent(ticketBunId);
        }
    }

    public int[] getOpenedTicketsOfSession(UserSession session) {
        int[] allTickets;
        ArrayList<OpenedBuendel> tickets = new ArrayList<OpenedBuendel>();
        for (int allTicket : allTickets = this.theOpenedTickets.getAllKeys()) {
            OpenedBuendel ob = this.theOpenedTickets.get(allTicket);
            if (ob.existsInBundle(session) <= -1) continue;
            tickets.add(ob);
        }
        int[] ids = new int[tickets.size()];
        for (int i = 0; i < tickets.size(); ++i) {
            ids[i] = ((OpenedBuendel)tickets.get((int)i)).bunId;
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean buendelAccess(ClientSession session, int orderID, int request) {
        TicketVO t = TicketManager.getReaderForSystem().getTicket(orderID);
        if (t == null) {
            HDLogger.error("Ticket not found: " + orderID);
            return false;
        }
        int bunId = t.getBundleID();
        OpenedBuendel ob = this.theOpenedTickets.get(bunId);
        if (ob == null) {
            ob = new OpenedBuendel(bunId);
            this.theOpenedTickets.put(bunId, ob);
        }
        ob.referenz = t;
        try {
            boolean bl = ob.addSession(session, request);
            return bl;
        }
        finally {
            if (ob.occupantsCount() == 0) {
                this.theOpenedTickets.remove(bunId);
            }
        }
    }

    public ResultSet getBuendelOccupant(int aufnr) {
        ListResultSet theRS = ServerUtilities.getSingleStringResultSet();
        OpenedBuendel ob = this.theOpenedTickets.get(this.aufIdToBunId(aufnr));
        if (ob != null && ob.ownerSession != null && !ob.ownerSession.isClosed()) {
            return theRS.setSingleValue(this.getMessageInformation(null, aufnr), true);
        }
        return theRS.setSingleValue(null, false);
    }

    private int aufIdToBunId(int aufId) {
        TicketVO ticket = TicketManager.getReaderForSystem().getTicket(aufId);
        if (ticket == null) {
            return aufId;
        }
        return ticket.getBundleID();
    }

    public int isOrderOpened(int aufNr) {
        OpenedBuendel ob = this.theOpenedTickets.get(this.aufIdToBunId(aufNr));
        if (ob != null) {
            if (ob.ownerSession != null) {
                return ob.ownerSession.getSessionID();
            }
            if (ob.otherSessions != null && ob.otherSessions.size() > 0) {
                return ob.otherSessions.get(0).getSessionID();
            }
        }
        return -1;
    }

    private boolean checkWriteAccess(UserAccount user, TicketVO ticket) {
        if (ticket != null) {
            try (UserAccountScope scope = UserAccountScope.create((GUID)user.getID());){
                boolean bl = TicketManager.getTicketPermissionChecker().checkCurrentUserCanWriteTicket(ticket.getID());
                return bl;
            }
        }
        return false;
    }

    @Override
    public TicketAccessInformations getTicketAccessInformations(int ticketId) {
        return this.theOpenedTickets.get(this.aufIdToBunId(ticketId));
    }

    @Override
    public void accessTicketRead(String clientID, int ticket) {
        ClientSession session = this.findOrCreateClientSessionForCurrentUser(clientID);
        this.buendelAccess(session, ticket, 1);
        this.updateSessionOpenedTicketsCountAndDropIfZero(clientID, session);
    }

    @Override
    public boolean accessTicketWrite(String clientID, int ticket) {
        ClientSession session = this.findOrCreateClientSessionForCurrentUser(clientID);
        boolean writeAccess = this.buendelAccess(session, ticket, 2);
        this.updateSessionOpenedTicketsCountAndDropIfZero(clientID, session);
        return writeAccess;
    }

    @Override
    public void leaveTickets(String clientID, int ... tickets) {
        ClientSession session = this.pureClientSessions.get(clientID);
        if (session == null) {
            return;
        }
        for (int ticket : tickets) {
            int bunId = this.aufIdToBunId(ticket);
            OpenedBuendel ob = this.theOpenedTickets.get(bunId);
            if (ob == null) continue;
            ob.checkSessions();
            boolean changed = ob.removeSession(session);
            if (ob.occupantsCount() == 0) {
                this.theOpenedTickets.remove(bunId);
            }
            if (!changed) continue;
            this.sendTicketAccessChangedEvent(bunId);
        }
        this.updateSessionOpenedTicketsCountAndDropIfZero(clientID, session);
    }

    private void updateSessionOpenedTicketsCountAndDropIfZero(String clientID, ClientSession session) {
        session.setCountOfOpenOrders((int)this.theOpenedTickets.getValueList().stream().filter(ob -> ob.existsInBundle(session) != -1).count());
        if (session.getCountOfOpenOrders() == 0) {
            this.pureClientSessions.remove(clientID);
        }
    }

    @Override
    public void leaveAllTickets(String clientID) {
        this.leaveTickets(clientID, this.theOpenedTickets.getAllKeys());
    }

    @Override
    public TicketAccessInfo getTicketAccessInfo(int ticketID) {
        return this.getTicketAccessInfo_BunID(this.aufIdToBunId(ticketID));
    }

    private TicketAccessInfo getTicketAccessInfo_BunID(int bunId) {
        OpenedBuendel cache = this.theOpenedTickets.get(bunId);
        if (cache == null) {
            return null;
        }
        TicketAccessInfo.TicketAccessor writeSession = cache.ownerSession == null ? null : this.createTicketAccessor(cache.ownerSession);
        ArrayList<ClientSession> otherSessions = new ArrayList<ClientSession>(cache.otherSessions);
        List<TicketAccessInfo.TicketAccessor> readSessions = otherSessions.stream().map(b -> this.createTicketAccessor((ClientSession)b)).collect(Collectors.toList());
        return new TicketAccessInfo(writeSession, readSessions);
    }

    @Override
    public void addTicketAccessChangedListener(TicketAccessInformationsProvider.TicketAccessChangedListener listener) {
        this.eventDispatcher.registerListener((Object)listener);
    }

    @Override
    public void removeTicketAccessChangedListener(TicketAccessInformationsProvider.TicketAccessChangedListener listener) {
        this.eventDispatcher.unregisterListener((Object)listener);
    }

    @Nonnull
    private ClientSession findOrCreateClientSessionForCurrentUser(@Nonnull String clientID) {
        ClientSession session = this.pureClientSessions.get(clientID);
        if (session == null) {
            session = ClientSession.create(UserManager.getInstance().getCurrentUserAccount(), clientID);
            this.pureClientSessions.put(clientID, session);
        }
        return session;
    }

    private TicketAccessInfo.TicketAccessor createTicketAccessor(ClientSession session) {
        return new TicketAccessInfo.TicketAccessor(session.getOwner().getID(), session.getSessionID(), session.getOwner().getDisplayName(), session.getClientID());
    }

    private void sendTicketAccessChangedEvent(int bunId) {
        TicketAccessInformationsProvider.TicketAccessChangedEvent event = new TicketAccessInformationsProvider.TicketAccessChangedEvent(bunId, this.getTicketAccessInfo_BunID(bunId));
        this.eventDispatcher.dispatchEvent(listener -> {
            try {
                listener.ticketAccessChanged(event);
            }
            catch (Exception ex) {
                HDLogger.error(ex);
            }
        });
    }

    private class OpenedBuendel
    implements TicketAccessInformations {
        private final int bunId;
        private ClientSession ownerSession;
        private ArrayList<ClientSession> otherSessions = new ArrayList();
        private TicketVO referenz;

        private OpenedBuendel(int bunId) {
            this.bunId = bunId;
        }

        private void setOwnerSession(ClientSession userSession) {
            if (userSession != null) {
                boolean exists;
                boolean bl = exists = this.existsInBundle(userSession) > 0;
                if (exists) {
                    this.otherSessions.remove(userSession);
                }
            }
            this.ownerSession = userSession;
        }

        private boolean addSession(ClientSession userSession, int request) {
            boolean isOwner = this.ownerSession == userSession;
            boolean changed = false;
            if ((request & 2) > 0 && this.ownerSession == null && TicketAccessController.this.checkWriteAccess(userSession.getOwner(), this.referenz)) {
                isOwner = true;
                changed = true;
                this.setOwnerSession(userSession);
            } else if (request == 1 && this.existsInBundle(userSession) < 1) {
                this.otherSessions.add(userSession);
                if (isOwner) {
                    this.setOwnerSession(null);
                }
                changed = true;
            } else if (request == 3 && this.existsInBundle(userSession) == -1) {
                this.otherSessions.add(userSession);
                changed = true;
            }
            if (request == 3 && this.ownerSession == null && this.otherSessions != null) {
                for (int i = this.otherSessions.size() - 1; i >= 0; --i) {
                    ClientSession session = this.otherSessions.get(i);
                    if (!TicketAccessController.this.checkWriteAccess(session.getOwner(), this.referenz)) continue;
                    changed = true;
                    this.setOwnerSession(session);
                }
            }
            if (changed) {
                if (!isOwner) {
                    SetTicketReadAfterAccess.setTicketReadIfReadAccessedBySupporter(this.bunId, this.otherSessions.stream().map(cs -> cs.getOwner().getID()).collect(Collectors.toList()));
                }
                TicketAccessController.this.sendTicketAccessChangedEvent(this.bunId);
            }
            return isOwner;
        }

        private int existsInBundle(ClientSession userSession) {
            if (userSession.equals(this.ownerSession)) {
                return 0;
            }
            if (this.otherSessions != null) {
                int index = this.otherSessions.indexOf(userSession);
                if (index > -1) {
                    ++index;
                }
                return index;
            }
            return -1;
        }

        private boolean removeSession(ClientSession sessionToRemove) {
            boolean changed = false;
            if (sessionToRemove.equals(this.ownerSession)) {
                this.setOwnerSession(null);
                changed = true;
            }
            if (this.otherSessions != null && this.otherSessions.remove(sessionToRemove)) {
                changed = true;
            }
            return changed;
        }

        private void checkSessions() {
            boolean changed = false;
            if (this.ownerSession != null && this.ownerSession.isClosed()) {
                this.setOwnerSession(null);
                changed = true;
            }
            if (this.otherSessions != null) {
                for (int i = this.otherSessions.size() - 1; i >= 0; --i) {
                    if (!this.otherSessions.get(i).isClosed()) continue;
                    this.otherSessions.remove(i);
                    changed = true;
                }
            }
            if (changed) {
                TicketAccessController.this.sendTicketAccessChangedEvent(this.bunId);
            }
        }

        private ClientSession getSession(int index) {
            if (index == 0) {
                if (this.ownerSession != null) {
                    return this.ownerSession;
                }
                index = 1;
            }
            if (this.otherSessions != null && this.otherSessions.size() > --index) {
                return this.otherSessions.get(index);
            }
            return null;
        }

        private int occupantsCount() {
            int count;
            int n = count = this.ownerSession != null ? 1 : 0;
            if (this.otherSessions != null) {
                count += this.otherSessions.size();
            }
            return count;
        }

        @Override
        public boolean isInTicket(int sessionId) {
            if (this.ownerSession != null && this.ownerSession.getSessionID() == sessionId) {
                return true;
            }
            if (this.otherSessions != null) {
                for (int i = 0; i < this.otherSessions.size(); ++i) {
                    if (this.otherSessions.get(i).getSessionID() != sessionId) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getTicketOwnerName() {
            if (this.ownerSession != null) {
                return this.ownerSession.getOwner().getDisplayName();
            }
            return "";
        }

        @Override
        public int getTicketOwnerSessionId() {
            if (this.ownerSession != null && !this.ownerSession.isClosed()) {
                return this.ownerSession.getSessionID();
            }
            return 0;
        }
    }
}

