/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic.deviceimport;

import com.inet.classloader.I18nMessages;
import com.inet.helpdesk.config.DeviceImportConfigInfo;
import com.inet.helpdesk.core.data.DataImportJob;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.SuppressFBWarnings;
import srv.automatic.deviceimport.DeviceImportingException;
import srv.automatic.deviceimport.MappingHandler;

public abstract class AbstractDeviceImporter {
    protected static final int DEVICENAME_INDEX = 0;
    protected PreparedStatement pstSelect;
    protected PreparedStatement pstVerschieben;
    protected PreparedStatement pstSimpleUpdate;
    protected PreparedStatement pstInsert;
    private PreparedStatement pstVersionUpdate;
    protected String updateString;
    protected String baseSelectString;
    protected String theInsertStatement;
    protected int newImports;
    protected int updates;
    protected int available;
    private int importColumnCount;
    protected final Logger logger = LogManager.getLogger((String)"Data Import");
    private static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.data.i18n.LanguageResources", AbstractDeviceImporter.class);

    public abstract HashMap<String, Integer> replaceOwnKey(HashMap<String, Integer> var1, String var2, String var3, String var4, String var5) throws DeviceImportingException;

    public abstract List<Map<String, String>> doImport(DataImportJob var1, Map<Integer, Integer> var2, HashMap<String, Integer> var3, Connection var4, DeviceImportConfigInfo var5, String var6, String var7, int var8, int var9, MappingHandler var10, String var11, boolean var12, RowAddedListener var13) throws Exception;

    protected void putKontrolle(HashMap<String, Integer> aHm, String fremdKey, Integer userid) throws IllegalStateException {
        Integer test = aHm.get(fremdKey);
        if (test != null && !test.equals(userid)) {
            throw new IllegalStateException(MSG.getMsg("dataImport.userImport.userMappingNotUnique", new Object[0]));
        }
        aHm.put(fremdKey, userid);
    }

    protected static String removeBlanks(String instr) {
        if (instr.indexOf(32) > -1) {
            StringBuffer strbuf = new StringBuffer();
            for (int i = 0; i < instr.length(); ++i) {
                char c = instr.charAt(i);
                if (c == ' ') continue;
                strbuf.append(c);
            }
            instr = strbuf.toString();
        }
        return instr;
    }

    public abstract void cleanup();

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internally created statement")
    protected void prepareAllStatements(Connection conHD, String impName, int versID, int typID, MappingHandler mappingHandler) throws SQLException {
        this.pstVerschieben = conHD.prepareStatement("UPDATE tblGeraeteBestand Set ParentID = 0, UserID = ? Where GerID = ?");
        this.baseSelectString = "Select RefID, UserID";
        Object insertStart = "INSERT INTO tblGeraeteBestand(ParentID, SlaID, VerkID, LizID, GTyID, ImpFlag, ImpName, RefID, UserID, GebID";
        String insertEnd = ") VALUES (0, 0, 0, 0, " + typID + ", " + versID + ", '" + impName + "', ?, ?, ?";
        this.updateString = "UPDATE tblGeraeteBestand SET ImpFlag = " + versID + ", GTyID = " + typID;
        this.importColumnCount = 2;
        List<MappingHandler.MappedColumn> mappedCols = mappingHandler.getMappedColumns();
        for (int i = 0; i < mappedCols.size(); ++i) {
            ++this.importColumnCount;
            String name = mappedCols.get(i).getInternalColumnName();
            this.baseSelectString = this.baseSelectString + ", " + name;
            this.updateString = this.updateString + ", " + name + " = ?";
            insertStart = (String)insertStart + ", " + name;
            insertEnd = insertEnd + ", ?";
        }
        this.updateString = this.updateString + " Where GerID ";
        this.baseSelectString = this.baseSelectString + ", GerID, GTyID From tblGeraeteBestand Where ImpName = ? AND RefId ";
        this.theInsertStatement = (String)insertStart + insertEnd + ")";
        this.logger.debug((Object)(this.updateString + "= ?"));
        this.logger.debug((Object)this.theInsertStatement);
        this.pstSelect = conHD.prepareStatement(this.baseSelectString + " = ?");
        this.pstSelect.setString(1, impName);
        this.pstSimpleUpdate = conHD.prepareStatement(this.updateString + "= ?");
        this.pstVersionUpdate = conHD.prepareStatement("UPDATE tblGeraeteBestand SET ImpFlag = " + versID + " WHERE GerID = ?");
        this.pstInsert = conHD.prepareStatement(this.theInsertStatement);
    }

    public String getResultStatisticMessage(DataImportJob dataImportJob) {
        dataImportJob.setEntriesAdded(this.newImports);
        dataImportJob.setEntriesUpdated(this.updates);
        return "Imports: " + this.newImports + "  Updates: " + this.updates + "  Anzahl-Datens\u00e4tze: " + this.available;
    }

    protected void updateVersion(int gerID) throws SQLException {
        this.pstVersionUpdate.setInt(1, gerID);
        this.pstVersionUpdate.execute();
    }

    protected List<Map<String, String>> createEntrys(List<String[]> exampleBuffer, ArrayList<MappingHandler.MappedColumn> requiredDataColumns) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (int i = 0; i < exampleBuffer.size(); ++i) {
            String[] data = exampleBuffer.get(i);
            HashMap<String, String> entry = new HashMap<String, String>();
            for (int n = 0; n < requiredDataColumns.size(); ++n) {
                if (data[n] == null || data[n].length() <= 0) continue;
                entry.put(requiredDataColumns.get(n).getInternalColumnName(), data[n]);
            }
            result.add(entry);
        }
        return result;
    }

    protected DeviceData getDataFromResultSet(ResultSet rs) throws SQLException {
        int devType;
        DeviceData data = new DeviceData();
        data.gerTyp = devType = rs.getInt("GTyID");
        data.gerid = rs.getInt("GerID");
        data.rowData = new String[this.importColumnCount];
        for (int i = 0; i < this.importColumnCount; ++i) {
            data.rowData[i] = rs.getString(i + 1);
        }
        return data;
    }

    protected boolean compareData(String[] hdValues, String[] importData) {
        for (int i = 0; i < importData.length; ++i) {
            if (this.equal(hdValues[i + 2], importData[i])) continue;
            return false;
        }
        return true;
    }

    private boolean equal(String a, String b) {
        if (a == null || a.length() == 0) {
            return b == null || b.length() == 0;
        }
        if (b == null || b.length() == 0) {
            return false;
        }
        return a.equals(b);
    }

    protected void closeAllStatements() {
        if (this.pstSelect != null) {
            try {
                this.pstSelect.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.pstVerschieben.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.pstInsert.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.pstSimpleUpdate.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.pstVersionUpdate.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.pstSelect = null;
        }
    }

    protected void setUpdateData(PreparedStatement pst, List<MappingHandler.MappedColumn> colInfos, String[] data, int writepos) throws SQLException {
        for (int i = 0; i < data.length; ++i) {
            if (colInfos != null) {
                this.logger.debug((Object)(i + ". " + colInfos.get(i).getSourceColumnName() + " '" + data[i] + "' Zeichenanzahl " + (data[i] != null ? data[i].length() : 0)));
            }
            pst.setString(writepos++, data[i]);
        }
    }

    protected class DeviceData {
        int gerTyp;
        private int gerid;
        private String[] rowData;

        protected DeviceData() {
        }

        protected int getId() {
            return this.gerid;
        }

        protected String[] getData() {
            return this.rowData;
        }

        protected Integer getUserId() {
            return Integer.valueOf(this.rowData[1]);
        }

        protected String getForeignKey() {
            return this.rowData[0];
        }
    }

    public static interface RowAddedListener {
        public boolean finishedWithRowCount(int var1);
    }
}

