/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic;

import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.config.LdapConnectionInfo;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.shared.utils.TrustAllSSLSocketFactory;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.InitialLdapContext;

public class LdapUtilities {
    private static final Logger logger = LogManager.getLogger((String)"Data Import");

    public static SearchControls getSearchControls(String[] attrs) {
        SearchControls sc = new SearchControls();
        sc.setSearchScope(2);
        if (attrs != null) {
            sc.setReturningAttributes(attrs);
        }
        return sc;
    }

    public static InitialLdapContext getDirContext(LdapConnectionInfo ldapConn) throws NamingException {
        String host = ldapConn.getHost();
        Object user = ldapConn.getUser();
        int port = ldapConn.getPort();
        String pwd = ldapConn.getDecodedPassword();
        String domaene = ldapConn.getDomaene();
        boolean useSsl = ldapConn.isSsl();
        InitialLdapContext ctx = null;
        Properties envLdap = ConfigurationManager.getInstance().getCurrent().getProperties();
        envLdap.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        envLdap.put("java.naming.provider.url", "ldap://" + host + ":" + port);
        envLdap.put("java.naming.security.authentication", "simple");
        if (domaene.length() != 0) {
            if (((String)user).startsWith("cn=")) {
                user = ((String)user).substring(3);
                user = domaene + "\\" + (String)user;
                user = LdapUtilities.convertToLdapName("cn", (String)user);
            } else {
                user = domaene + "\\" + (String)user;
            }
        }
        envLdap.put("java.naming.security.principal", user);
        envLdap.put("java.naming.security.credentials", pwd);
        envLdap.put("com.sun.jndi.ldap.read.timeout", "5000");
        if (useSsl) {
            envLdap.put("java.naming.security.protocol", "ssl");
            envLdap.put("java.naming.ldap.factory.socket", TrustAllSSLSocketFactory.class.getName());
        }
        try {
            ctx = new InitialLdapContext(envLdap, null);
        }
        catch (Throwable e) {
            envLdap.put("java.naming.security.principal", LdapUtilities.convertToLdapName("cn", (String)user));
            ctx = new InitialLdapContext(envLdap, null);
        }
        return ctx;
    }

    public static String[] getSearchContext(DirContext ctx, String filter) throws NamingException {
        String[] result = new String[]{""};
        if (filter != null && filter.length() > 0) {
            result = filter.split(";");
        } else {
            logger.debug((Object)"Generelle Attribute:");
            Attributes gAttrs = ctx.getAttributes("");
            NamingEnumeration<String> gEnum = gAttrs.getIDs();
            while (LdapUtilities.enumerationHasMore(gEnum)) {
                String str = gEnum.next();
                logger.debug((Object)str);
                if (!str.equalsIgnoreCase("defaultNamingContext") && !str.equalsIgnoreCase("dn") && !str.equalsIgnoreCase("distinguishedName")) continue;
                String attrValue = ctx.getAttributes("").get(str).get().toString();
                if (attrValue.indexOf(59) > -1) {
                    result = attrValue.split(";");
                    continue;
                }
                result[0] = attrValue;
            }
            gEnum.close();
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
            logger.debug((Object)(i + 1 + ". SearchContext: " + result[i]));
        }
        return result;
    }

    public static boolean enumerationHasMore(NamingEnumeration enumeration) {
        try {
            return enumeration.hasMore();
        }
        catch (NamingException ex) {
            return false;
        }
    }

    private static String convertToLdapName(String attribut, String name) {
        int idx1;
        int idx2;
        if (name == null) {
            name = "";
        }
        if ((idx2 = name.indexOf(46, idx1 = 0)) >= 0) {
            StringBuffer sb = new StringBuffer();
            do {
                sb.append(attribut).append('=').append(name.substring(idx1 + 1, idx2)).append(',');
            } while ((idx2 = name.indexOf(46, idx1 = idx2 + 1)) >= 0);
            sb.append(attribut).append('=').append(name.substring(idx1));
            return sb.toString();
        }
        idx1 = name.length();
        idx2 = name.lastIndexOf(92, idx1 - 1);
        if (idx2 >= 0) {
            StringBuffer sb = new StringBuffer();
            do {
                sb.append(attribut).append('=').append(name.substring(idx2 + 1, idx1)).append(',');
            } while ((idx2 = name.lastIndexOf(92, (idx1 = idx2) - 1)) >= 0);
            sb.append(attribut).append('=').append(name.substring(0, idx1));
            return sb.toString();
        }
        return attribut + "=" + name;
    }
}

