/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic;

import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.DeviceImportConfigInfo;
import com.inet.helpdesk.config.DeviceImportConfigInfoMap;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.LdapConnectionInfo;
import com.inet.helpdesk.config.LdapConnectionInfoMap;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.data.DataImportJob;
import com.inet.helpdesk.core.data.ImportedDeviceDeletionListener;
import com.inet.helpdesk.core.utils.SubListTaskExecutor;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.SuppressFBWarnings;
import srv.ServerUtilities;
import srv.automatic.deviceimport.AbstractDeviceImporter;
import srv.automatic.deviceimport.DbDeviceImporter;
import srv.automatic.deviceimport.LdapDeviceImporter;
import srv.automatic.deviceimport.MappingHandler;

public class GeraeteImporter {
    private static final ConfigValue<DeviceImportConfigInfoMap> DEVICE_IMPORT_CONFIGS = new ConfigValue(HDConfigKeys.DEVICE_IMPORT_CONFIGS);
    private static final ConfigValue<LdapConnectionInfoMap> LDAP_CONNECTION_INFOS = new ConfigValue(HDConfigKeys.LDAP_CONNECTION_INFOS);
    private static final ConfigValue<DatabaseConfigInfoList> DB_INFOS = new ConfigValue(HDConfigKeys.DB_CONFIGS);
    private static boolean killed = false;
    private final Logger logger;
    protected Map<Integer, Integer> userGebs = null;
    private static final Object MONITOR_OBJECT = new Object();
    private static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.data.i18n.LanguageResources", GeraeteImporter.class);

    public GeraeteImporter(Connection conHD, DeviceImportConfigInfo importConfig, String name, Invoker invoker, DataImportJob dataImportJob) {
        this();
        this.runImport(conHD, importConfig, name, invoker, dataImportJob);
    }

    public GeraeteImporter(Connection conHD, DeviceImportConfigInfo importConfig, String name, DataImportJob dataImportJob) {
        this.logger = LogManager.getLogger((String)"Data Import");
        this.runImport(conHD, importConfig, name, new ImportInvoker(), dataImportJob);
    }

    public GeraeteImporter() {
        killed = false;
        this.logger = LogManager.getLogger((String)"Data Import");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runImport(Connection conHD, DeviceImportConfigInfo importConfig, String name, Invoker invoker, DataImportJob dataImportJob) {
        String connectionName = importConfig.getConnectionName();
        boolean isLdap = importConfig.isLdap();
        AbstractDeviceImporter importer = null;
        try {
            long startZeit = System.currentTimeMillis();
            dataImportJob.setStartTime(startZeit);
            String filter = "";
            if (isLdap) {
                LdapConnectionInfoMap ldapConns = (LdapConnectionInfoMap)LDAP_CONNECTION_INFOS.get();
                LdapConnectionInfo ldapConn = ldapConns.get(connectionName);
                if (ldapConn == null) {
                    throw new IllegalArgumentException(MSG.getMsg("dataImport.deviceImport.noSuchConnection", new Object[]{connectionName}));
                }
                filter = ldapConn.getSearchContext();
                importer = new LdapDeviceImporter(ldapConn);
            } else {
                DatabaseConfigInfoList list = (DatabaseConfigInfoList)DB_INFOS.get();
                DatabaseConfigInfo dbConn = list.get(connectionName);
                if (dbConn == null) {
                    throw new IllegalArgumentException(MSG.getMsg("dataImport.deviceImport.noSuchConnection", new Object[]{connectionName}));
                }
                importer = new DbDeviceImporter(dbConn);
            }
            filter = filter.trim();
            boolean indirekt = importConfig.isIndirekt();
            int gerTyp = importConfig.getGerTyp();
            HashMap<String, Integer> userHm = this.getAllValidUsersAndInitUserGebs();
            if (indirekt) {
                userHm = importer.replaceOwnKey(userHm, importConfig.getIndirectUserReferenceObject(), importConfig.getIndirectUserKeyReference(), importConfig.getIndirectUsernameReference(), filter);
            }
            if (userHm.size() > 0) {
                this.logger.debug((Object)"Users found!");
                PreparedStatement st = conHD.prepareStatement("Select max(ImpFlag) From tblGeraeteBestand Where ImpName = ?");
                st.setString(1, name);
                ResultSet rs = st.executeQuery();
                rs.next();
                int newVersID = rs.getInt(1) + 1;
                try {
                    rs.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                MappingHandler mph = new MappingHandler(importConfig.getSelektionList());
                invoker.run(importer, dataImportJob, this.userGebs, userHm, conHD, importConfig, name, filter, newVersID, gerTyp, mph, importConfig.getSelektionUserMain(), indirekt);
                if (invoker.isSample()) {
                    return;
                }
                if (importConfig.isDelete()) {
                    this.logger.debug((Object)"Delete Statement");
                    List<Integer> deviceIds = this.readIdsOfDevicesFromImportBeforeVersion(name, newVersID, conHD);
                    this.deleteDevices(deviceIds, conHD);
                    for (ImportedDeviceDeletionListener listener : ServerPluginManager.getInstance().get(ImportedDeviceDeletionListener.class)) {
                        listener.devicesDeleted(deviceIds);
                    }
                    dataImportJob.setEntriesDeleted(deviceIds.size());
                }
                try {
                    st.close();
                }
                catch (Throwable deviceIds) {
                    // empty catch block
                }
            }
            long endZeit = System.currentTimeMillis();
            long dauer = endZeit - startZeit;
            Object msg = importer.getResultStatisticMessage(dataImportJob);
            msg = (String)msg + "  Dauer: " + dauer + "ms";
            this.logger.info(msg);
        }
        catch (Exception error) {
            this.logger.error((Object)error);
            String message = error.getMessage();
            if (message == null) {
                message = MSG.getMsg("dataImport.serverError", new Object[0]);
            }
            dataImportJob.setError(message);
        }
        finally {
            dataImportJob.setEndTime(System.currentTimeMillis());
            if (importer != null) {
                importer.cleanup();
            }
        }
    }

    private List<Integer> readIdsOfDevicesFromImportBeforeVersion(String importName, int versionID, Connection con) throws SQLException {
        ArrayList<Integer> deviceIds = new ArrayList<Integer>();
        String sql = "SELECT GerID from tblGeraeteBestand WHERE ImpFlag < ? AND ImpName=?";
        try (PreparedStatement pstm = con.prepareStatement(sql);){
            pstm.setInt(1, versionID);
            pstm.setString(2, importName);
            try (ResultSet rs = pstm.executeQuery();){
                while (rs.next()) {
                    deviceIds.add(rs.getInt(1));
                }
            }
        }
        return deviceIds;
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL parameter is integer")
    private void deleteDevices(List<Integer> deviceIds, Connection con) throws SQLException {
        try {
            new SubListTaskExecutor().executeForEachSubList(deviceIds, 900, subList -> {
                Object ids = subList.toString();
                ids = "(" + ((String)ids).substring(1, ((String)ids).length() - 1) + ")";
                try (PreparedStatement pstm = con.prepareStatement("DELETE from tblGeraeteBestand WHERE GerID IN " + (String)ids);){
                    pstm.execute();
                }
            });
        }
        catch (Exception ex) {
            throw (SQLException)ex;
        }
    }

    public void work() {
        DeviceImportConfigInfoMap map = (DeviceImportConfigInfoMap)DEVICE_IMPORT_CONFIGS.get();
        DataImportConnector dataImportConnector = (DataImportConnector)ServerPluginManager.getInstance().getSingleInstance(DataImportConnector.class);
        HashMap<String, DataImportJob> jobs = new HashMap<String, DataImportJob>();
        for (Map.Entry entry : map.entrySet()) {
            String name = (String)entry.getKey();
            DeviceImportConfigInfo importConfig = (DeviceImportConfigInfo)entry.getValue();
            if (dataImportConnector.getJobs(importConfig.getUid()).stream().filter(DataImportJob::isRunning).count() > 0L || !dataImportConnector.isTimeForJob(importConfig.getUid(), importConfig.getSchedule(), ServerUtilities.getCalendar())) continue;
            jobs.put(name, dataImportConnector.createJob(importConfig.getUid()));
        }
        new Thread(() -> {
            Object object = MONITOR_OBJECT;
            synchronized (object) {
                ConnectionFactory factory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
                try (Connection hdConn = factory.getConnection();){
                    for (Map.Entry entry : map.entrySet()) {
                        String name = (String)entry.getKey();
                        DeviceImportConfigInfo importConfig = (DeviceImportConfigInfo)entry.getValue();
                        if (!dataImportConnector.isTimeForJob(importConfig.getUid(), importConfig.getSchedule(), ServerUtilities.getCalendar())) continue;
                        try {
                            if (killed) {
                                break;
                            }
                            new GeraeteImporter(hdConn, importConfig, name, (DataImportJob)jobs.get(name));
                        }
                        catch (Exception e) {
                            LogManager.getLogger((String)"Data Import").error((Object)e);
                        }
                    }
                }
                catch (SQLException e) {
                    this.logger.error((Object)e);
                }
            }
        }, "DeviceImport - Scheduled").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runNow(Connection connection, DeviceImportConfigInfo importConfig, String name, DataImportJob dataImportJob) {
        Object object = MONITOR_OBJECT;
        synchronized (object) {
            this.logger.info((Object)"Start manual Device Import");
            new GeraeteImporter(connection, importConfig, name, dataImportJob);
        }
    }

    public void kill() {
        try {
            killed = true;
        }
        catch (Throwable e) {
            this.logger.error((Object)e);
        }
    }

    private HashMap<String, Integer> getAllValidUsersAndInitUserGebs() throws SQLException {
        boolean gebData;
        boolean bl = gebData = this.userGebs == null;
        if (gebData) {
            this.userGebs = new HashMap<Integer, Integer>();
        }
        HashMap<String, Integer> userHm = new HashMap<String, Integer>();
        UserManager users = UserManager.getInstance();
        Iterator it = users.getIteratorOverUserAccountIDs();
        while (it.hasNext()) {
            UserAccount userAccount = users.getUserAccount((GUID)it.next());
            if (!userAccount.isActive()) continue;
            for (LoginSettings l : userAccount.getLoginSettings()) {
                UserAccount usr;
                int index;
                String name = l.getLoginID();
                if (name == null || name.length() <= 0) continue;
                String simpleName = GeraeteImporter.normalizeName(name);
                userHm.put(simpleName, HDUsersAndGroups.getUserID(userAccount));
                if (this.logger.isDebug()) {
                    this.logger.debug((Object)("Add possible user for devices '" + simpleName + "' - '" + name + "'"));
                }
                if (!((index = simpleName.lastIndexOf(47)) <= -1 || (usr = users.findActiveUserAccount("system", simpleName = simpleName.substring(index + 1))) != null && usr.isActive())) {
                    if (this.logger.isDebug()) {
                        this.logger.debug((Object)("Add possible user for devices '" + simpleName + "' - '" + name + "'"));
                    }
                    userHm.put(simpleName, HDUsersAndGroups.getUserID(userAccount));
                }
                if (!gebData) continue;
                this.userGebs.put(HDUsersAndGroups.getUserID(userAccount), (Integer)userAccount.getValue(users.getField("location")));
            }
        }
        return userHm;
    }

    public static String normalizeName(String name) {
        if (name != null) {
            if (name.length() == 0) {
                return null;
            }
            name = name.replaceAll("\\\\", "/").toUpperCase();
        }
        return name;
    }

    public static class SampleInvoker
    implements Invoker {
        private List<Map<String, String>> result;

        @Override
        public void run(AbstractDeviceImporter importer, DataImportJob dataImportJob, Map<Integer, Integer> userGebs, HashMap<String, Integer> userHm, Connection conHD, DeviceImportConfigInfo importConfig, String name, String filter, int newVersID, int gerTyp, MappingHandler columnMapping, String selektionUserMain, boolean indirekt) throws Exception {
            this.result = importer.doImport(dataImportJob, userGebs, userHm, conHD, importConfig, name, filter, newVersID, gerTyp, columnMapping, importConfig.getSelektionUserMain() == null ? "" : importConfig.getSelektionUserMain(), indirekt, currentRow -> currentRow >= 20);
        }

        @Override
        public boolean isSample() {
            return true;
        }

        public List<Map<String, String>> getResult() {
            return this.result;
        }
    }

    private static class ImportInvoker
    implements Invoker {
        private ImportInvoker() {
        }

        @Override
        public void run(AbstractDeviceImporter importer, DataImportJob dataImportJob, Map<Integer, Integer> userGebs, HashMap<String, Integer> userHm, Connection conHD, DeviceImportConfigInfo importConfig, String name, String filter, int newVersID, int gerTyp, MappingHandler columnMapping, String selektionUserMain, boolean indirekt) throws Exception {
            importer.doImport(dataImportJob, userGebs, userHm, conHD, importConfig, name, filter, newVersID, gerTyp, columnMapping, importConfig.getSelektionUserMain(), indirekt, null);
        }

        @Override
        public boolean isSample() {
            return false;
        }
    }

    private static interface Invoker {
        public void run(AbstractDeviceImporter var1, DataImportJob var2, Map<Integer, Integer> var3, HashMap<String, Integer> var4, Connection var5, DeviceImportConfigInfo var6, String var7, String var8, int var9, int var10, MappingHandler var11, String var12, boolean var13) throws Exception;

        public boolean isSample();
    }
}

