/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic;

import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.shared.util.TypespecificIntMap;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.ArrayList;
import srv.ServerUtilities;
import srv.WriteThreadDump;
import srv.controller.UserSession;

public class AutoProcessErrorHandler {
    private ArrayList<UserAccount> errorMessageTargets;

    protected AutoProcessErrorHandler() {
        ServerUtilities.systemOut("TimerExecutionError", null, "Couldn't finish last timer loop!!");
        new WriteThreadDump();
    }

    protected void checkConnectedUsers(TypespecificIntMap<UserSession> connectedUsers) {
        int i;
        ArrayList<UserAccount> errorMessageTargetsTemp;
        int[] allSessionKeys = connectedUsers.getAllKeys();
        ArrayList<UserAccount> listDispatcher = new ArrayList<UserAccount>();
        ArrayList<UserAccount> listResourceMembers = new ArrayList<UserAccount>();
        for (int allSessionKey : allSessionKeys) {
            UserSession session = connectedUsers.get(allSessionKey);
            if (session == null || session.isClosed()) continue;
            if (SystemPermissionChecker.hasAnyPermission((UserAccount)session.getOwner(), (Permission[])new Permission[]{HdPermissions.DISPATCHER})) {
                if (listDispatcher.contains(session.getOwner())) continue;
                listDispatcher.add(session.getOwner());
                continue;
            }
            int[] resIds = ServerUtilities.getOpenOrderController().getResources(HDUsersAndGroups.getUserID(session.getOwner()), false);
            if (resIds == null || resIds.length <= 0 || listResourceMembers.contains(session.getOwner())) continue;
            listResourceMembers.add(session.getOwner());
        }
        ArrayList<UserAccount> arrayList = errorMessageTargetsTemp = listDispatcher.size() > 0 ? listDispatcher : listResourceMembers;
        if (this.errorMessageTargets != null) {
            for (i = 0; i < this.errorMessageTargets.size(); ++i) {
                UserAccount user = this.errorMessageTargets.get(i);
                if (errorMessageTargetsTemp.contains(user)) continue;
                this.setServerErrorFlag(HDUsersAndGroups.getUserID(user), false);
            }
        }
        this.errorMessageTargets = errorMessageTargetsTemp;
        for (i = 0; i < this.errorMessageTargets.size(); ++i) {
            UserAccount user = this.errorMessageTargets.get(i);
            this.setServerErrorFlag(HDUsersAndGroups.getUserID(user), true);
        }
    }

    protected void blockadeReversed() {
        for (int i = 0; i < this.errorMessageTargets.size(); ++i) {
            this.setServerErrorFlag(HDUsersAndGroups.getUserID(this.errorMessageTargets.get(i)), false);
        }
    }

    private void setServerErrorFlag(int userID, boolean value) {
        ArrayList<UserSession> theSessions = ServerUtilities.conti.getSessionsForUser(userID);
        if (theSessions != null) {
            for (int i = 0; i < theSessions.size(); ++i) {
                theSessions.get(i).setDeliverAutoProcessError(value);
            }
        }
    }
}

