/*
 * Decompiled with CFR 0.152.
 */
package srv;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.utils.DatabaseTransactionUtils;
import com.inet.helpdesk.search.SearcherImpl;
import com.inet.jj.srv.JavaCommand;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.SuppressFBWarnings;
import srv.UserNameMappingResultSet;

public class UserSearchCommand
extends JavaCommand {
    private Statement st = null;
    private Connection con;
    private int rsTyp;
    private int rsConc;
    private int maxRows = 0;
    private String[] values;
    private int searchID;
    private boolean pseudoUsername;

    public UserSearchCommand(Connection con, int rsType, int rsConcur, boolean pseudoUsername) {
        this.con = con;
        this.rsTyp = rsType;
        this.rsConc = rsConcur;
        this.pseudoUsername = pseudoUsername;
        this.values = new String[5];
    }

    public UserSearchCommand(Connection con, boolean pseudoUsername) {
        this(con, -1, 0, pseudoUsername);
    }

    public void setString(int objectIndex, String value) throws SQLException {
        this.values[objectIndex - 1] = value;
    }

    public void setObject(String paramName, Object value) throws SQLException {
    }

    public void setMaxRows(int maxRs) {
        this.maxRows = maxRs;
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internal api")
    public ResultSet executeQuery() throws SQLException {
        int searchID = Integer.parseInt(this.values[0]);
        String searchText = this.values[1];
        String whereString = this.values[2];
        String baseKeyString = this.values[3];
        int searchWhereBits = Integer.parseInt(this.values[4]);
        searchID = new SearcherImpl().prepareSearch(this.con, searchID, searchWhereBits, searchText, whereString);
        this.st = this.rsTyp != -1 ? this.con.createStatement(this.rsTyp, this.rsConc) : this.con.createStatement();
        if (this.maxRows > 0) {
            this.st.setMaxRows(this.maxRows);
        }
        String query = "SELECT tblAuftraege.AufID, tblAuftraege.AnfReaID, tblAuftraege.ResID, tblAuftraege.Master, tblAuftraege.DerBetreff, tblAuftraege.BetID, tblAuftraege.PriID, tblAuftraege.KlaID, tblAuftraege.ItiID, tblAuftraege.DeadlineZeit, tblAuftraege.spezFeld, tblBuendel.*, tblUser.UsrID as UserID, tblUser.UsrID as UsrID, tblUser.Nachname FROM tblAuftraege, tblBuendel, tblUser, tblSearchresult WHERE tblSearchresult.SearchID = " + searchID + " AND (tblAuftraege.WFID IS NULL OR tblAuftraege.WFID = tblAuftraege.AufID) AND tblSearchresult.BunID = tblBuendel.BunID AND tblBuendel.BunID = tblAuftraege.BunID " + baseKeyString + " AND tblAuftraege.UsrID = tblUser.UsrID ORDER BY tblAuftraege.AufID DESC";
        ResultSet rs = DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> this.st.executeQuery(query));
        if (this.pseudoUsername) {
            return new UserNameMappingResultSet(rs, "UserID");
        }
        return rs;
    }

    public boolean execute() throws SQLException {
        throw new SQLException("not supported");
    }

    public int executeUpdate() throws SQLException {
        throw new SQLException("not supported");
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="number so no injection possible")
    public void close() throws SQLException {
        if (this.st != null) {
            try {
                this.st.execute("DELETE FROM tblSearchresult WHERE SearchID = " + this.searchID);
            }
            catch (Throwable e) {
                HDLogger.error(e);
            }
            try {
                this.st.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

