/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.ticket.step;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.webapi.data.step.TicketStepEntryResponseData;
import com.inet.helpdesk.webapi.ticket.step.HelpDeskTicketStepIdHandler;
import com.inet.helpdesk.webapi.util.HelpDeskWebAPIHelper;
import com.inet.logging.LogManager;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandlerGenericBase;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@InternalApi
public class HelpDeskTicketStepsHandler
extends RequestHandlerGenericBase<Integer, List<ReaStepVO>, Integer> {
    public static final String STEPS_REQUEST_HANDLER_NAME = "steps";

    public HelpDeskTicketStepsHandler() {
        super(new String[]{STEPS_REQUEST_HANDLER_NAME});
        this.setGenericRequestHandler(new HelpDeskTicketStepIdHandler());
    }

    public String getHelpPageKey() {
        return "webapi.ticket.id.steps";
    }

    public List<ReaStepVO> handle(HttpServletRequest request, HttpServletResponse response, Integer ticketId, List<String> pathTokens, boolean previewModeEnabled) throws IOException {
        HelpDeskWebAPIHelper.checkTicketReadAccessOrThrow(ticketId, response);
        List<ReaStepVO> reaStepsForTicket = TicketManager.getReader().getReaStepsForTicket(ticketId, null);
        String sinceParameter = request.getParameter("since");
        if (sinceParameter != null) {
            try {
                long since = Long.parseLong(sinceParameter);
                reaStepsForTicket.removeIf(r -> r.getEndDate() < since);
            }
            catch (NumberFormatException e) {
                LogManager.getApplicationLogger().error((Object)("The given 'since' parameter can not be parsed: " + sinceParameter));
            }
        }
        ResponseWriter.json((HttpServletResponse)response, TicketStepEntryResponseData.from(reaStepsForTicket));
        return reaStepsForTicket;
    }
}

