/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.data;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.webapi.util.HelpDeskWebAPIHelper;
import com.inet.search.SuggestedValue;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@JsonData
public class HelpDeskTicketSearchResponseData {
    private Set<?> ticketList;
    private boolean hasMore;
    private List<String> suggestedValues;
    private List<String> suggestedFields;

    private HelpDeskTicketSearchResponseData() {
    }

    public static HelpDeskTicketSearchResponseData from(Set<Integer> responseList, List<SuggestedValue> suggestedValues, boolean hasMore) {
        HelpDeskTicketSearchResponseData response = new HelpDeskTicketSearchResponseData();
        response.ticketList = !HelpDeskWebAPIHelper.requestRequiresEncodedTicketId() ? responseList : responseList.stream().map(id -> Tickets.encodeTicketId(id)).collect(Collectors.toSet());
        response.hasMore = hasMore;
        response.suggestedFields = suggestedValues.stream().filter(e -> e.getKey().startsWith("field:")).map(e -> e.getKey().substring(6)).collect(Collectors.toList());
        response.suggestedValues = suggestedValues.stream().filter(e -> e.getKey().startsWith("value:")).map(e -> e.getDisplayName()).collect(Collectors.toList());
        return response;
    }
}

