/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.user;

import com.inet.authentication.LoginListener;
import com.inet.authentication.LoginProcessor;
import com.inet.classloader.I18nMessages;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionCreationListener;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.data.UserDataConnectorImpl;
import com.inet.helpdesk.login.FirstUserPermissionsHandler;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.user.HelpDeskUserSearchDataCache;
import com.inet.helpdesk.usersandgroups.user.persistence.HelpDeskUserPersistence;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.notification.NotificationSettings;
import com.inet.permissions.Permission;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchResult;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SearchID;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.BaseUserManager;
import com.inet.usersandgroups.api.user.BinaryDataKey;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserEventListener;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.api.user.persistence.UserPersistence;
import com.inet.usersandgroups.api.user.search.UserSearchDataCache;
import com.inet.usersandgroups.api.user.search.UserSearchEngine;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import srv.HdLicenseObserver;
import srv.ServerUtilities;
import srv.controller.OpenOrderController;
import srv.controller.UserVersionManager;

public class HelpDeskUserManager
extends UserManager
implements ConnectionCreationListener,
LoginListener {
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.data.i18n.LanguageResources", UserDataConnectorImpl.class);
    public static final GUID ADMIN_ACCOUNT_ID = new GUID("sys02qmoxwlwprnnovhrxtx7n");
    private final UserSearchEngine searchEngine;
    private final FirstUserPermissionsHandler firstUserPermissionsHandler;
    private BaseUserManager manager;
    private HelpDeskUserPersistence userPersistence;
    private boolean connectionEstablished = false;
    private ConnectionFactory connectionFactory;
    private final MutableUserData customDataOfTempMasterUser = new MutableUserData();

    public HelpDeskUserManager(UserSearchEngine searchEngine, FirstUserPermissionsHandler firstUserPermissionsHandler) {
        if (searchEngine == null) {
            throw new IllegalArgumentException("search engine must not be null");
        }
        if (firstUserPermissionsHandler == null) {
            throw new IllegalArgumentException("firstUserPermissionsHandler must not be null");
        }
        this.searchEngine = searchEngine;
        this.firstUserPermissionsHandler = firstUserPermissionsHandler;
    }

    private boolean hasConnection() {
        return this.connectionEstablished && this.getConnectionFactory().isHelpDeskDatabaseConnectionValid();
    }

    private ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        }
        return this.connectionFactory;
    }

    public void init(List<UserField<Object>> userFields) throws IOException {
        if (this.manager != null) {
            throw new IllegalStateException("manager is already initialized");
        }
        if (userFields == null) {
            throw new IllegalArgumentException("list of fields must not be null");
        }
        this.userPersistence = new HelpDeskUserPersistence();
        if (this.connectionEstablished) {
            this.userPersistence.connectionCreated(this.getConnectionFactory());
        }
        this.manager = new BaseUserManager(this.userPersistence, this.searchEngine){

            protected UserSearchDataCache createSearchDataCache(UserPersistence persistence, List<UserField<Object>> userFields) {
                return new HelpDeskUserSearchDataCache(persistence, userFields);
            }
        };
        this.manager.init(userFields);
    }

    public UserAccount createUserAccount(UserAccountType type, MutableUserData userData) {
        if (type != UserAccountType.Administrator) {
            this.throwIfNoMoreUsersAllowed(false);
        }
        if (userData != null && userData.containsField((UserField)HDUsersAndGroups.FIELD_USER_ID)) {
            String msg = String.format("User account could not be created because field \"%s\" is already defined", HDUsersAndGroups.FIELD_USER_ID.getKey());
            throw new IllegalArgumentException(msg);
        }
        UserAccount account = this.manager.createUserAccount(type, userData);
        UserVersionManager.getInstance().incUserVersion(account.getID());
        if (this.isFirstStandardLogin(type)) {
            this.firstUserPermissionsHandler.giveFirstUserAllPermissions(account.getID(), this, UserGroupManager.getInstance());
        }
        HdLicenseObserver.resetLicenseCount();
        this.activateSystemNotificationForEmail(account);
        return account;
    }

    private void activateSystemNotificationForEmail(UserAccount account) {
        HashMap activeStatesMap = new HashMap();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("notificationdispatcher.email", Boolean.TRUE);
        activeStatesMap.put("system", map);
        NotificationSettings settings = new NotificationSettings(activeStatesMap, true);
        this.updateUserData(account.getID(), UsersAndGroups.FIELD_NOTIFICATIONSETTINGS, old -> new Json().toJson((Object)settings));
    }

    private void throwIfNoMoreUsersAllowed(boolean reactivating) throws IllegalStateException {
        int userCount = HdLicenseObserver.getCountOfNamedUsers();
        if (HdLicenseObserver.getMaxUsers() > -1 && userCount >= HdLicenseObserver.getMaxUsers()) {
            throw new IllegalStateException(reactivating ? MSG.getMsg("error.maxusers.exceeded.reactivate", new Object[0]) : MSG.getMsg("error.maxusers.exceeded.newuser", new Object[0]));
        }
    }

    private boolean isFirstStandardLogin(UserAccountType accounttype) {
        if (accounttype != UserAccountType.Standard) {
            return false;
        }
        UserAccount masterAccount = this.getUserAccount(MASTER_ACCOUNT_ID);
        if (masterAccount != null && masterAccount.getLastAccess() != 0L) {
            return false;
        }
        UserAccount adminAccount = this.getUserAccount(ADMIN_ACCOUNT_ID);
        if (adminAccount != null && adminAccount.getLastAccess() != 0L) {
            return false;
        }
        SearchCommand command = new SearchCommand("useraccounttype", SearchCondition.SearchTermOperator.Equals, (Object)UserAccountType.Standard.name());
        command.setResultLimit(3);
        SearchResult result = this.getSearchEngine().search(command);
        int count = result.getEntries().size();
        return count <= 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserData(GUID accountID, MutableUserData userData) {
        boolean changeOfSelectedFreiauswahlField;
        if (!this.hasConnection() && MASTER_ACCOUNT_ID.equals((Object)accountID)) {
            MutableUserData mutableUserData = this.customDataOfTempMasterUser;
            synchronized (mutableUserData) {
                userData.getIncludedFields().forEach(field -> this.customDataOfTempMasterUser.put(field, userData.get(field)));
            }
            return;
        }
        if (userData != null && userData.containsField((UserField)HDUsersAndGroups.FIELD_USER_ID)) {
            String msg = String.format("Data of user account with ID \"%s\" could not be updated because field \"%s\" may not be redefined", accountID, HDUsersAndGroups.FIELD_USER_ID.getKey());
            throw new IllegalArgumentException(msg);
        }
        this.manager.updateUserData(accountID, userData);
        UserVersionManager.getInstance().incUserVersion(accountID);
        OpenOrderController ooc = ServerUtilities.getOpenOrderController();
        UserField<?> freiauswahlUserField = ooc.getFreiauswahlUserField();
        boolean bl = changeOfSelectedFreiauswahlField = freiauswahlUserField != null && userData.containsField(freiauswahlUserField);
        if (changeOfSelectedFreiauswahlField || userData.containsField((UserField)HDUsersAndGroups.FIELD_LOCATION_ID) || userData.containsField((UserField)HDUsersAndGroups.FIELD_GROUP_ID)) {
            ooc.notifyUserChangeToOrders(accountID);
        }
    }

    public <VALUE> void updateUserData(GUID accountID, UserField<VALUE> field, Function<VALUE, VALUE> func) {
        this.manager.updateUserData(accountID, field, func);
    }

    public void updateLoginSettings(GUID accountID, List<LoginSettings> settingsToAdd, List<LoginSettings> settingsToRemove) {
        this.manager.updateLoginSettings(accountID, settingsToAdd, settingsToRemove);
        UserVersionManager.getInstance().incUserVersion(accountID);
    }

    public void updateUserPermissions(GUID accountID, Set<Permission> permissionsToAdd, Set<Permission> permissionsToRemove) {
        this.manager.updateUserPermissions(accountID, permissionsToAdd, permissionsToRemove);
        UserVersionManager.getInstance().incUserVersion(accountID);
        HdLicenseObserver.resetLicenseCount();
    }

    public void deleteUserAccount(GUID accountID) {
        if (ADMIN_ACCOUNT_ID.equals((Object)accountID)) {
            throw new IllegalArgumentException(HDFieldDisplayNameProvider.MSG.getMsg(ClientLocale.getThreadLocale(), "forbiddenaccountdeletion.administrator", new Object[0]));
        }
        UserAccount account = this.manager.getUserAccount(accountID);
        if (account == null) {
            return;
        }
        String sperrvermerk = (String)account.getValue((UserField)UsersAndGroups.FIELD_USER_LOCKED);
        if (sperrvermerk != null) {
            throw new IllegalArgumentException("Cannot delete because user is LOCKED: " + StringFunctions.encodeHTML((String)sperrvermerk));
        }
        this.manager.deleteUserAccount(accountID);
        UserVersionManager.getInstance().removeVersions(accountID);
        HdLicenseObserver.resetLicenseCount();
        ServerUtilities.getOpenOrderController().notifyUserChangeToOrders(accountID);
    }

    public void setUserAccountActive(GUID accountID) {
        this.throwIfNoMoreUsersAllowed(true);
        this.manager.setUserAccountActive(accountID);
        UserVersionManager.getInstance().incUserVersion(accountID);
        HdLicenseObserver.resetLicenseCount();
    }

    public void setUserAccountInactive(GUID accountID) {
        this.manager.setUserAccountInactive(accountID);
        UserVersionManager.getInstance().incUserVersion(accountID);
        HdLicenseObserver.resetLicenseCount();
    }

    public InputStream getBinaryData(GUID accountID, BinaryDataKey key) {
        if (!this.hasConnection() && MASTER_ACCOUNT_ID.equals((Object)accountID)) {
            return null;
        }
        return this.manager.getBinaryData(accountID, key);
    }

    public void storeBinaryData(GUID accountID, BinaryDataKey key, InputStream in, int length) {
        this.manager.storeBinaryData(accountID, key, in, length);
    }

    public void deleteBinaryData(GUID accountID, BinaryDataKey key) {
        this.manager.deleteBinaryData(accountID, key);
    }

    public UserAccount getUserAccount(GUID accountID) {
        if (PRIVILEGED_ACCOUNT_ID != accountID && !this.hasConnection() && MASTER_ACCOUNT_ID.equals((Object)accountID)) {
            return this.createTempMasterAccount();
        }
        return this.manager.getUserAccount(accountID);
    }

    public List<UserAccount> getUserAccounts(List<GUID> accountIDs) {
        return this.manager.getUserAccounts(accountIDs);
    }

    public Iterator<GUID> getIteratorOverUserAccountIDs(BinaryDataKey key) {
        return this.manager.getIteratorOverUserAccountIDs(key);
    }

    public void registerListener(UserEventListener listener) {
        this.manager.registerListener(listener);
    }

    public void unregisterListener(UserEventListener listener) {
        this.manager.unregisterListener(listener);
    }

    public List<UserField<?>> getAllFields() {
        return this.manager.getAllFields();
    }

    public UserField<Object> getField(String fieldKey) {
        return this.manager.getField(fieldKey);
    }

    public SearchResult<GUID> search(String phrase, List<SearchExpression> additionalExpressions, List<SearchExpression> boostingExpressions, int maxResults, SearchID searchID) {
        return this.manager.search(phrase, additionalExpressions, boostingExpressions, maxResults, searchID);
    }

    public IndexSearchEngine<GUID> getSearchEngine() {
        return this.manager.getSearchEngine();
    }

    public UserAccount findActiveUserAccount(String loginSource, String loginID) {
        if ("master".equals(loginSource) && "Master".equals(loginID) && !this.hasConnection()) {
            return this.createTempMasterAccount();
        }
        return this.manager.findActiveUserAccount(loginSource, loginID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserAccount createTempMasterAccount() {
        MutableUserData userData;
        long currentTimeMillis = System.currentTimeMillis();
        ArrayList<LoginSettings> loginSettings = new ArrayList<LoginSettings>();
        loginSettings.add(new LoginSettings("master", "Master", ""));
        List userFields = ServerPluginManager.getInstance().get(UserField.class);
        userFields.remove((Object)HDUsersAndGroups.FIELD_USER_ID);
        MutableUserData mutableUserData = this.customDataOfTempMasterUser;
        synchronized (mutableUserData) {
            userData = this.customDataOfTempMasterUser.copyWithSpecifiedFieldsOnly((Collection)userFields, true);
        }
        return UserAccount.createForActiveUser((GUID)MASTER_ACCOUNT_ID, (UserAccountType)UserAccountType.Administrator, (long)currentTimeMillis, (long)currentTimeMillis, (MutableUserData)userData, loginSettings, Collections.emptySet());
    }

    public void userLoggedIn(UserAccount userAccount, LoginProcessor loginProcessor) {
        if (!this.hasConnection()) {
            HDLogger.warn("Cannot update current User's authentication groups because connection to the database is not established.");
            return;
        }
        this.manager.userLoggedIn(userAccount, loginProcessor);
        HdLicenseObserver.resetLicenseCount();
    }

    public LoginProcessor getNonSessionLoginProcessor(GUID accountID) {
        return this.manager.getNonSessionLoginProcessor(accountID);
    }

    @Override
    public void connectionCreated() {
        this.connectionEstablished = true;
        if (this.userPersistence != null) {
            this.userPersistence.connectionCreated(this.getConnectionFactory());
        }
        HdLicenseObserver.resetLicenseCount();
    }

    public Set<GUID> getAuthGroupMemberIDs(String authGroupName) {
        return this.manager.getAuthGroupMemberIDs(authGroupName);
    }

    public Set<String> getAuthGroupsForUser(GUID accountID) {
        return this.manager.getAuthGroupsForUser(accountID);
    }

    public List<LoginSettings> findConflictingLoginSettings(GUID accountID) {
        return this.manager.findConflictingLoginSettings(accountID);
    }

    public long getAccountFileSize(GUID accountId) {
        return this.manager.getAccountFileSize(accountId);
    }
}

