/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.ui.fieldgroups;

import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.ui.fields.SelectOption;
import com.inet.usersandgroups.api.ui.fields.SelectOptionResult;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class SelectFieldDefinitionUtils {
    public static SelectOptionResult getOptions(String searchTerm, int currentSize, int chunkSize, Map<? extends Object, String> valuesToDisplayNames) {
        return SelectFieldDefinitionUtils.getOptions(searchTerm, currentSize, chunkSize, valuesToDisplayNames, (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getLabel(), o2.getLabel()));
    }

    public static SelectOptionResult getOptions(String searchTerm, int currentSize, int chunkSize, Map<? extends Object, String> valuesToDisplayNames, Comparator<SelectOption> comparator) {
        List<Object> options = new ArrayList<SelectOption>();
        if (!StringFunctions.isEmpty((String)searchTerm)) {
            searchTerm = searchTerm.toLowerCase();
        }
        for (Map.Entry<? extends Object, String> entry : valuesToDisplayNames.entrySet()) {
            String displayName;
            if (!StringFunctions.isEmpty((String)searchTerm) && (entry.getValue() == null || !(displayName = entry.getValue().toLowerCase()).contains(searchTerm))) continue;
            options.add(new SelectOption(entry.getKey().toString(), entry.getValue()));
        }
        options.sort(comparator);
        int totalCount = options.size();
        if (currentSize >= totalCount) {
            options.clear();
        } else {
            options = options.subList(currentSize, Math.min(options.size(), currentSize + chunkSize));
        }
        return new SelectOptionResult(totalCount, options);
    }
}

