/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.ui;

import com.inet.helpdesk.core.data.ServerDataConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.ui.UserFieldsWithClientSettingManager;
import com.inet.helpdesk.usersandgroups.ui.UserFieldsWithClientSettings;
import com.inet.http.ClientMessageException;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.CustomUserAction;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.ArrayList;
import java.util.List;

public class SetAsDefaultGUIPreferencesCustomUserAction
implements CustomUserAction {
    public String getActionKey() {
        return "setasdefaultguipreferences";
    }

    public boolean isAvailable(UserAccount userAccount) {
        if (userAccount == null) {
            return false;
        }
        return userAccount.isActive();
    }

    public String getActionLabel() {
        return HDFieldDisplayNameProvider.MSG.getMsg("usersandgroupsmanager.customuseraction.setAsDefaultGUIPreferences", new Object[0]);
    }

    public void performUserAction(UserAccount userAccount) throws ClientMessageException {
        try {
            ServerDataConnector sdc = (ServerDataConnector)ServerPluginManager.getInstance().getSingleInstance(ServerDataConnector.class);
            sdc.saveUserPropertiesAsDefault(HDUsersAndGroups.getUserID(userAccount));
            ArrayList<UserField<String>> userProperties = new ArrayList<UserField<String>>();
            List udp = ServerPluginManager.getInstance().get(UserFieldsWithClientSettings.class);
            for (UserFieldsWithClientSettings provider : udp) {
                userProperties.addAll(provider.getUserFieldsWithClientSettings());
            }
            UserFieldsWithClientSettingManager.getInstance().saveUserFieldValues(userProperties, userAccount);
        }
        catch (ServerDataException e) {
            UsersAndGroups.LOGGER.error((Object)e);
            throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)e));
        }
    }
}

