/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups;

import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.Field;
import com.inet.usersandgroups.api.UserField;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class HDFieldLocator {
    private static final String TRANSLATION_PREFIX_OTHER = "_";
    private static final String TRANSLATION_PREFIX_USERFIELD = "UF_";
    private static final String TRANSLATION_PREFIX_DEVICEFIELD = "DF_";
    private static final String TRANSLATION_PREFIX_TICKETFIELD = "TF_";
    private static Map<com.inet.helpdesk.shared.model.Field, Field> dbKeyToFieldKey = new HashMap<com.inet.helpdesk.shared.model.Field, Field>(){
        {
            this.put(com.inet.helpdesk.shared.model.Field.USERDATA_EMAIL, UsersAndGroups.FIELD_EMAIL);
            this.put(com.inet.helpdesk.shared.model.Field.USERDATA_FIRSTNAME, UsersAndGroups.FIELD_FIRSTNAME);
            this.put(com.inet.helpdesk.shared.model.Field.USERDATA_LASTNAME, UsersAndGroups.FIELD_LASTNAME);
            this.put(com.inet.helpdesk.shared.model.Field.USERDATA_COMPUTERNAME, HDUsersAndGroups.FIELD_COMPUTER_NAME);
            this.put(com.inet.helpdesk.shared.model.Field.USERDATA_COSTCENTRE, HDUsersAndGroups.FIELD_COST_CENTRE);
            this.put(com.inet.helpdesk.shared.model.Field.USERDATA_DEPARTMENT, HDUsersAndGroups.FIELD_DEPARTMENT);
            this.put(com.inet.helpdesk.shared.model.Field.USERDATA_GROUP, HDUsersAndGroups.FIELD_GROUP_ID);
            this.put(com.inet.helpdesk.shared.model.Field.USERDATA_IMPORT_NAME, HDUsersAndGroups.FIELD_IMPORT_NAME);
            this.put(com.inet.helpdesk.shared.model.Field.USERDATA_LANGUAGE, HDUsersAndGroups.FIELD_LANGUAGE);
            this.put(com.inet.helpdesk.shared.model.Field.USERDATA_LOCATION, HDUsersAndGroups.FIELD_LOCATION_ID);
            this.put(com.inet.helpdesk.shared.model.Field.USERDATA_ROOM, HDUsersAndGroups.FIELD_ROOM);
            this.put(com.inet.helpdesk.shared.model.Field.USERDATA_TELEPHONE, HDUsersAndGroups.FIELD_TELEPHONE);
            this.put(com.inet.helpdesk.shared.model.Field.USERDATA_LUMPSUM1, HDUsersAndGroups.FIELD_LUMP_SUM_1);
            this.put(com.inet.helpdesk.shared.model.Field.USERDATA_LUMPSUM2, HDUsersAndGroups.FIELD_LUMP_SUM_2);
            this.put(com.inet.helpdesk.shared.model.Field.USERDATA_LUMPSUM3, HDUsersAndGroups.FIELD_LUMP_SUM_3);
            this.put(com.inet.helpdesk.shared.model.Field.USERDATA_USERFIELD1, HDUsersAndGroups.FIELD_CUSTOM_1);
            this.put(com.inet.helpdesk.shared.model.Field.USERDATA_USERFIELD2, HDUsersAndGroups.FIELD_CUSTOM_2);
            this.put(com.inet.helpdesk.shared.model.Field.USERDATA_USERFIELD3, HDUsersAndGroups.FIELD_CUSTOM_3);
            this.put(com.inet.helpdesk.shared.model.Field.USERDATA_USERFIELD4, HDUsersAndGroups.FIELD_CUSTOM_4);
            this.put(com.inet.helpdesk.shared.model.Field.USERDATA_USERFIELD5, HDUsersAndGroups.FIELD_CUSTOM_5);
            this.put(com.inet.helpdesk.shared.model.Field.USERDATA_USERFIELD6, HDUsersAndGroups.FIELD_CUSTOM_6);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_CATEGORY, Tickets.FIELD_CATEGORY_ID);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_CATEGORYID, Tickets.FIELD_CATEGORY_ID);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_CLASSIFICATIONID, Tickets.FIELD_CLASSIFICATION_ID);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_DEADLINE, Tickets.FIELD_DEADLINE);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_DUETIME, Tickets.FIELD_TARGET_TIME);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_HASATTACHMENTS, Tickets.ATTRIBUTE_ATTACHMENTS);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_INQUIRYDATE, Tickets.ATTRIBUTE_INQUIRY_DATE);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_ITILID, Tickets.FIELD_ITIL_ID);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_LASTMODIFIED, Tickets.ATTRIBUTE_LAST_CHANGED);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_LASTTEXTEDITOR, Tickets.ATTRIBUTE_LAST_EDITOR_GUID);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_ORDERID, Tickets.ATTRIBUTE_BUNDLE_ID);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_PRIORITYID, Tickets.FIELD_PRIORITY_ID);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_REQUESTMAILACCOUNT, Tickets.ATTRIBUTE_EMAIL_EINGANG);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_RESOURCEID_DISPLAYNAME, Tickets.FIELD_RESOURCE_GUID);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_RESOURCEID, Tickets.FIELD_RESOURCE_GUID);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_SPECIALFIELD, Tickets.FIELD_IDENTIFIER);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_STATUSID, Tickets.ATTRIBUTE_STATUS_ID);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_SUBJECT, Tickets.FIELD_SUBJECT);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_SUMTIMES, Tickets.ATTRIBUTE_SUM_TIME);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_TERMINVEREINBARUNG, Tickets.FIELD_TERMINVEREINBARUNG);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_TICKETFIELD1, Tickets.FIELD_CUSTOM_1);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_TICKETFIELD2, Tickets.FIELD_CUSTOM_2);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_TICKETFIELD3, Tickets.FIELD_CUSTOM_3);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_TICKETFIELD4, Tickets.FIELD_CUSTOM_4);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_TICKETFIELD5, Tickets.FIELD_CUSTOM_5);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_TICKETFIELD6, Tickets.FIELD_CUSTOM_6);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_TICKETFIELD7, Tickets.FIELD_CUSTOM_7);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_TICKETID, Tickets.ATTRIBUTE_TICKET_ID);
            this.put(com.inet.helpdesk.shared.model.Field.TICKETDATA_WORKFLOWTICKETID, Tickets.ATTRIBUTE_WORKFLOW_ID);
        }
    };
    private static Map<Field, com.inet.helpdesk.shared.model.Field> fieldKeyToDbKey = dbKeyToFieldKey.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (first, second) -> first));
    private static final Map<Integer, com.inet.helpdesk.shared.model.Field> OLD_TRANSLATION_ID_TO_MAIN_DB_KEY = new HashMap<Integer, com.inet.helpdesk.shared.model.Field>(){
        {
            this.put(1, com.inet.helpdesk.shared.model.Field.USERDATA_LOCATION);
            this.put(2, com.inet.helpdesk.shared.model.Field.USERDATA_USERFIELD1);
            this.put(3, com.inet.helpdesk.shared.model.Field.USERDATA_USERFIELD2);
            this.put(4, com.inet.helpdesk.shared.model.Field.USERDATA_USERFIELD3);
            this.put(5, com.inet.helpdesk.shared.model.Field.USERDATA_USERFIELD4);
            this.put(6, com.inet.helpdesk.shared.model.Field.USERDATA_USERFIELD5);
            this.put(7, com.inet.helpdesk.shared.model.Field.USERDATA_USERFIELD6);
            this.put(8, com.inet.helpdesk.shared.model.Field.DEVICEDATA_DEVICEFIELD1);
            this.put(9, com.inet.helpdesk.shared.model.Field.DEVICEDATA_DEVICEFIELD2);
            this.put(10, com.inet.helpdesk.shared.model.Field.DEVICEDATA_DEVICEFIELD3);
            this.put(11, com.inet.helpdesk.shared.model.Field.DEVICEDATA_DEVICEFIELD4);
            this.put(12, com.inet.helpdesk.shared.model.Field.DEVICEDATA_DEVICEFIELD5);
            this.put(13, com.inet.helpdesk.shared.model.Field.TICKETDATA_SPECIALFIELD);
            this.put(14, com.inet.helpdesk.shared.model.Field.TICKETDATA_PRIORITYID);
            this.put(15, com.inet.helpdesk.shared.model.Field.TICKETDATA_CATEGORY);
            this.put(16, com.inet.helpdesk.shared.model.Field.USERDATA_GROUP);
            this.put(17, com.inet.helpdesk.shared.model.Field.TICKETDATA_TICKETFIELD1);
            this.put(18, com.inet.helpdesk.shared.model.Field.TICKETDATA_TICKETFIELD2);
            this.put(19, com.inet.helpdesk.shared.model.Field.TICKETDATA_TICKETFIELD3);
            this.put(20, com.inet.helpdesk.shared.model.Field.TICKETDATA_TICKETFIELD4);
            this.put(21, com.inet.helpdesk.shared.model.Field.TICKETDATA_TICKETFIELD5);
            this.put(22, com.inet.helpdesk.shared.model.Field.USERDATA_LUMPSUM1);
            this.put(23, com.inet.helpdesk.shared.model.Field.USERDATA_LUMPSUM2);
            this.put(24, com.inet.helpdesk.shared.model.Field.USERDATA_LUMPSUM3);
            this.put(25, com.inet.helpdesk.shared.model.Field.TICKETDATA_CLASSIFICATIONID);
            this.put(26, com.inet.helpdesk.shared.model.Field.TICKETDATA_TICKETFIELD6);
            this.put(27, com.inet.helpdesk.shared.model.Field.TICKETDATA_TICKETFIELD7);
            this.put(29, com.inet.helpdesk.shared.model.Field.TICKETDATA_ITILID);
            this.put(32, com.inet.helpdesk.shared.model.Field.DEVICEDATA_DISPLAYNAME);
            this.put(33, com.inet.helpdesk.shared.model.Field.DEVICEDATA_TYPE);
            this.put(34, com.inet.helpdesk.shared.model.Field.DEVICEDATA_PLANTNUMBER);
            this.put(35, com.inet.helpdesk.shared.model.Field.DEVICEDATA_LICENSEID);
            this.put(36, com.inet.helpdesk.shared.model.Field.DEVICEDATA_COSTCENTRE);
            this.put(37, com.inet.helpdesk.shared.model.Field.DEVICEDATA_ROOM);
            this.put(38, com.inet.helpdesk.shared.model.Field.DEVICEDATA_COMPUTERNAME);
            this.put(39, com.inet.helpdesk.shared.model.Field.DEVICEDATA_SERIALNUMBER);
            this.put(40, com.inet.helpdesk.shared.model.Field.DEVICEDATA_INVOICENUMBER);
            this.put(41, com.inet.helpdesk.shared.model.Field.DEVICEDATA_PURCHASEDATE);
            this.put(42, com.inet.helpdesk.shared.model.Field.DEVICEDATA_WARRANTY);
            this.put(43, com.inet.helpdesk.shared.model.Field.USERDATA_ROOM);
            this.put(44, com.inet.helpdesk.shared.model.Field.USERDATA_COMPUTERNAME);
            this.put(45, com.inet.helpdesk.shared.model.Field.USERDATA_DEPARTMENT);
            this.put(46, com.inet.helpdesk.shared.model.Field.USERDATA_COSTCENTRE);
            this.put(47, com.inet.helpdesk.shared.model.Field.DEVICEDATA_DEVICEFIELD6);
            this.put(48, com.inet.helpdesk.shared.model.Field.DEVICEDATA_DEVICEFIELD7);
            this.put(49, com.inet.helpdesk.shared.model.Field.DEVICEDATA_DEVICEFIELD8);
            this.put(50, com.inet.helpdesk.shared.model.Field.DEVICEDATA_DEVICEFIELD9);
            this.put(51, com.inet.helpdesk.shared.model.Field.TICKETDATA_DUETIME);
            this.put(52, com.inet.helpdesk.shared.model.Field.DEVICEDATA_PRICE);
        }
    };

    public static <T extends Field> T getUserFieldForDBKey(String dbKey) {
        Optional<com.inet.helpdesk.shared.model.Field> field = Arrays.stream(com.inet.helpdesk.shared.model.Field.values()).filter(f -> f.name().startsWith("USERDATA")).filter(f -> f.getKey() != null && f.getKey().equals(dbKey)).findFirst();
        if (field.isPresent()) {
            return HDFieldLocator.getFieldForOldDbField(field.get());
        }
        throw new IllegalArgumentException("No such field: " + dbKey);
    }

    public static <T extends Field> T getFieldForOldDbField(com.inet.helpdesk.shared.model.Field dbKey) {
        return (T)dbKeyToFieldKey.get((Object)dbKey);
    }

    public static com.inet.helpdesk.shared.model.Field getOldDbFieldForNewField(Field<?> fieldKey) {
        return fieldKeyToDbKey.get(fieldKey);
    }

    public static String getTranslationKeyForSetID(int setID) {
        com.inet.helpdesk.shared.model.Field dbKey = OLD_TRANSLATION_ID_TO_MAIN_DB_KEY.get(setID);
        if (dbKey != null) {
            return HDFieldLocator.getTranslationKeyForOldField(dbKey);
        }
        throw new IllegalArgumentException("Not existing setID: " + setID);
    }

    public static String getTranslationKeyForOldField(com.inet.helpdesk.shared.model.Field field) {
        String key;
        if (field.getLanguageSetID() == -1) {
            return null;
        }
        Field newKey = dbKeyToFieldKey.get((Object)field);
        if (newKey != null) {
            return HDFieldLocator.getTranslationKeyForNewField(newKey);
        }
        com.inet.helpdesk.shared.model.Field otherField = OLD_TRANSLATION_ID_TO_MAIN_DB_KEY.get(field.getLanguageSetID());
        if (otherField != field) {
            return HDFieldLocator.getTranslationKeyForOldField(otherField);
        }
        switch (field) {
            case DEVICEDATA_COMPUTERNAME: {
                key = "computername";
                break;
            }
            case DEVICEDATA_COSTCENTRE: {
                key = "costcenter";
                break;
            }
            case DEVICEDATA_DEVICEFIELD1: {
                key = "custom1";
                break;
            }
            case DEVICEDATA_DEVICEFIELD2: {
                key = "custom2";
                break;
            }
            case DEVICEDATA_DEVICEFIELD3: {
                key = "custom3";
                break;
            }
            case DEVICEDATA_DEVICEFIELD4: {
                key = "custom4";
                break;
            }
            case DEVICEDATA_DEVICEFIELD5: {
                key = "custom5";
                break;
            }
            case DEVICEDATA_DEVICEFIELD6: {
                key = "custom6";
                break;
            }
            case DEVICEDATA_DEVICEFIELD7: {
                key = "custom7";
                break;
            }
            case DEVICEDATA_DEVICEFIELD8: {
                key = "custom8";
                break;
            }
            case DEVICEDATA_DEVICEFIELD9: {
                key = "custom9";
                break;
            }
            case DEVICEDATA_DISPLAYNAME: {
                key = "displayname";
                break;
            }
            case DEVICEDATA_INVOICENUMBER: {
                key = "invoicenumber";
                break;
            }
            case DEVICEDATA_LICENSEID: {
                key = "licenseid";
                break;
            }
            case DEVICEDATA_PLANTNUMBER: {
                key = "plantnumber";
                break;
            }
            case DEVICEDATA_PRICE: {
                key = "price";
                break;
            }
            case DEVICEDATA_PURCHASEDATE: {
                key = "purchasedate";
                break;
            }
            case DEVICEDATA_ROOM: {
                key = "room";
                break;
            }
            case DEVICEDATA_SERIALNUMBER: {
                key = "serialnumber";
                break;
            }
            case DEVICEDATA_TYPE: {
                key = "devicetype";
                break;
            }
            case DEVICEDATA_WARRANTY: {
                key = "warranty";
                break;
            }
            default: {
                throw new IllegalArgumentException(field.name());
            }
        }
        String prefix = field.name().startsWith("TICKETDATA") ? TRANSLATION_PREFIX_TICKETFIELD : (field.name().startsWith("DEVICEDATA") ? TRANSLATION_PREFIX_DEVICEFIELD : TRANSLATION_PREFIX_OTHER);
        return prefix + key;
    }

    public static String getTranslationKeyForNewField(Field<?> field) {
        if (field instanceof UserField) {
            return TRANSLATION_PREFIX_USERFIELD + field.getKey();
        }
        if (field instanceof TicketField || field instanceof TicketAttribute) {
            return HDFieldLocator.getTicketTranslationKey(field);
        }
        if (field == Tickets.ATTRIBUTE_TICKET_ID) {
            return null;
        }
        throw new UnsupportedOperationException(field.toString());
    }

    private static String getTicketTranslationKey(Field<?> field) {
        String prefix = TRANSLATION_PREFIX_TICKETFIELD;
        if (field == Tickets.FIELD_PRIORITY_ID) {
            return prefix + "priority";
        }
        if (field == Tickets.FIELD_CATEGORY_ID) {
            return prefix + "category";
        }
        if (field == Tickets.FIELD_CUSTOM_1) {
            return prefix + "custom1";
        }
        if (field == Tickets.FIELD_CUSTOM_2) {
            return prefix + "custom2";
        }
        if (field == Tickets.FIELD_CUSTOM_3) {
            return prefix + "custom3";
        }
        if (field == Tickets.FIELD_CUSTOM_4) {
            return prefix + "custom4";
        }
        if (field == Tickets.FIELD_CUSTOM_5) {
            return prefix + "custom5";
        }
        if (field == Tickets.FIELD_CUSTOM_6) {
            return prefix + "custom6";
        }
        if (field == Tickets.FIELD_CUSTOM_7) {
            return prefix + "custom7";
        }
        if (field == Tickets.FIELD_ITIL_ID) {
            return prefix + "itil";
        }
        if (field == Tickets.FIELD_CLASSIFICATION_ID) {
            return prefix + "classification";
        }
        if (field == Tickets.FIELD_TARGET_TIME) {
            return prefix + "duetime";
        }
        if (field == Tickets.FIELD_IDENTIFIER) {
            return prefix + "specialfield";
        }
        return null;
    }
}

