/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups;

import com.inet.helpdesk.core.data.ServerOptions;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.usersandgroups.api.FieldValueModifier;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Map;

public class DisableMyUserFieldsModifier
implements FieldValueModifier {
    public void modifyUserFieldValues(UserAccount userAccount, Map<String, FieldValue> fieldValues) {
        UserAccount currentUserAccount = UserManager.getRecoveryEnabledInstance().getCurrentUserAccount();
        if (currentUserAccount == null || userAccount == null) {
            return;
        }
        ServerOptions serverOptions = new ServerOptions();
        if (!HDUsersAndGroups.isUserManager(currentUserAccount) && !currentUserAccount.getID().equals((Object)userAccount.getID())) {
            if (ServerOptions.isOptionSet(32768)) {
                for (Map.Entry<String, FieldValue> entry : fieldValues.entrySet()) {
                    entry.getValue().setEnabled(false);
                }
                return;
            }
        }
        if (HDUsersAndGroups.isDispatcher(currentUserAccount) || HDUsersAndGroups.isResourceMember(currentUserAccount)) {
            return;
        }
        if (ServerOptions.isOptionSet(64)) {
            for (Map.Entry<String, FieldValue> entry : fieldValues.entrySet()) {
                entry.getValue().setEnabled(false);
            }
        }
    }

    public void modifyGroupFieldValues(UserGroupInfo group, Map<String, FieldValue> fieldValues) {
    }
}

