/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups;

import com.inet.error.ServiceUnavailableException;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.thread.ThreadUtils;

public class ConnectionFactoryHolder {
    private final Object syncObject = new Object();
    private ConnectionFactory factory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionFactory(ConnectionFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("connection factory must not be null");
        }
        this.factory = factory;
        Object object = this.syncObject;
        synchronized (object) {
            this.syncObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOnConnectionEstablished() {
        Object object = this.syncObject;
        synchronized (object) {
            if (!this.isConnectionEstablished()) {
                try {
                    if (ThreadUtils.isGuiThread()) {
                        throw new ServiceUnavailableException();
                    }
                    this.syncObject.wait();
                }
                catch (InterruptedException ex) {
                    HDLogger.debug(ex);
                }
            }
        }
    }

    public ConnectionFactory getFactory() {
        return this.factory;
    }

    public void throwIfNoConnection() {
        if (!this.isConnectionEstablished()) {
            if (ThreadUtils.isGuiThread()) {
                throw new ServiceUnavailableException();
            }
            throw new IllegalStateException("Connection to the database has not been established yet.");
        }
        if (this.isConnectionEstablished() && !this.factory.isHelpDeskDatabaseConnectionValid()) {
            if (ThreadUtils.isGuiThread()) {
                throw new ServiceUnavailableException("Connection to the database temporarily unavailable.");
            }
            throw new IllegalStateException("Connection to the database temporarily unavailable.");
        }
    }

    public boolean isConnectionEstablished() {
        return this.factory != null;
    }
}

