/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserGroupVOManager;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketview.CustomTicketViewDefinition;
import com.inet.helpdesk.core.ticketview.GlobalSearchViewDefinition;
import com.inet.helpdesk.core.ticketview.SubViewGroupingDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.core.ticketview.TicketViewSearchCommandFactory;
import com.inet.helpdesk.ticketview.TicketViewTree;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.SearchCommand;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nonnull;

class CustomTicketViewFactory
implements TicketViewFactory {
    private final CustomTicketViewDefinition viewDef;
    private final TicketViewTree tree;
    private SubViewGroupingDefinition subViewGrouping;

    CustomTicketViewFactory(@Nonnull CustomTicketViewDefinition viewDef, @Nonnull TicketViewTree tree) {
        this.viewDef = viewDef;
        this.tree = tree;
        String subViewGroupingKey = viewDef.getSubViewGroupingKey();
        if (subViewGroupingKey != null && (HDUsersAndGroups.isSupporter(UserManager.getInstance().getCurrentUserAccount()) || Tickets.getFieldIdsVisibleForEnduser().contains(subViewGroupingKey) || "supervisor".equals(subViewGroupingKey) && !UserGroupVOManager.getInstance().getGroupsWhereUserIsSupervisor(UserManager.getInstance().getCurrentUserAccountID()).isEmpty())) {
            try {
                this.subViewGrouping = (SubViewGroupingDefinition)ServerPluginManager.getInstance().getSingleInstanceByName(SubViewGroupingDefinition.class, subViewGroupingKey, false);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getID() {
        return this.viewDef.getID();
    }

    @Override
    public String getDisplayName() {
        return this.viewDef.getDisplayName();
    }

    @Override
    public String getDescription() {
        return this.viewDef.getDescription();
    }

    @Override
    public String getCategoryKey() {
        if (this.subViewGrouping != null || this.viewDef.getSubViewGroupingKey() != null) {
            return this.viewDef.getDisplayName();
        }
        return this.viewDef.getCategoryKey();
    }

    @Override
    public SearchCommand createSearchCommand(GUID accountID, Locale locale, IndexSearchEngine<Integer> engine) {
        SearchCommand parentCommand;
        Locale oldLocale = ClientLocale.getThreadLocale();
        ClientLocale.setThreadLocale((Locale)locale);
        SearchCommand command = this.viewDef.createSearchCommand();
        ClientLocale.setThreadLocale((Locale)oldLocale);
        String parentId = this.viewDef.getParentID();
        TicketViewSearchCommandFactory parentFactory = parentId != null ? this.tree.getTicketViewSearchFactory(parentId) : GlobalSearchViewDefinition.INSTANCE;
        if (parentFactory == null) {
            return null;
        }
        try {
            parentCommand = parentFactory.createSearchCommand(accountID, locale, engine);
            if (parentCommand == null) {
                return null;
            }
        }
        catch (Throwable th) {
            HDLogger.error(th);
            parentCommand = GlobalSearchViewDefinition.INSTANCE.createSearchCommand(accountID, locale, engine);
        }
        command.getSearchExpression().addAll(0, (Collection)parentCommand.getSearchExpression());
        if (this.subViewGrouping != null) {
            this.subViewGrouping.appendMarker(command);
        }
        return command;
    }

    @Override
    public SubViewGroupingDefinition getSubViewGrouping() {
        return this.subViewGrouping;
    }

    @Nonnull
    public CustomTicketViewDefinition getCustomView() {
        return this.viewDef;
    }
}

