/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.internal.generated;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.ChangedTicketVO;
import com.inet.helpdesk.core.ticketmanager.model.tickets.GeneratedTicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.generated.GeneratedAttributeChangeEventSender;
import com.inet.helpdesk.ticketmanager.TicketReaderImpl;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAOCacheCleaner;
import com.inet.helpdesk.ticketmanager.internal.IndexUpdateAndEvents;
import com.inet.usersandgroups.api.Field;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class GeneratedAttributeChangeEventSenderImpl
implements GeneratedAttributeChangeEventSender {
    private IndexUpdateAndEvents eventSender;
    private TicketReadDAOCacheCleaner cacheCleaner;
    private TicketReaderImpl reader;

    public GeneratedAttributeChangeEventSenderImpl(IndexUpdateAndEvents eventSender, TicketReadDAOCacheCleaner cacheCleaner, TicketReaderImpl reader) {
        this.eventSender = eventSender;
        this.cacheCleaner = cacheCleaner;
        this.reader = reader;
    }

    @Override
    public void sendEventForGeneratedAttributeChanged(int ticketId, Map<GeneratedTicketAttribute, Object> oldValues) {
        this.sendEventForGeneratedAttributeChanged(Collections.singletonMap(ticketId, oldValues));
    }

    @Override
    public void sendEventForGeneratedAttributeChanged(Map<Integer, Map<GeneratedTicketAttribute, Object>> oldValueMap) {
        ArrayList<ChangedTicketVO> changedTickets = new ArrayList<ChangedTicketVO>();
        for (Map.Entry<Integer, Map<GeneratedTicketAttribute, Object>> entry : oldValueMap.entrySet()) {
            int ticketId = entry.getKey();
            Map<GeneratedTicketAttribute, Object> oldValues = entry.getValue();
            TicketVO ticket = this.reader.getTicket(ticketId, TicketPermissionContext.artificialSupporterForDispatchedTicket());
            TicketVOChangedAttributes old = new TicketVOChangedAttributes(ticket, oldValues);
            this.cacheCleaner.clearTicket(ticketId);
            TicketVO neww = this.reader.getTicket(ticketId, TicketPermissionContext.artificialSupporterForDispatchedTicket());
            if (this.nothingChanged(neww, oldValues)) {
                HDLogger.debug("[SendEventForGeneratedAttribute] no change in values for ticket " + ticketId);
                continue;
            }
            changedTickets.add(new ChangedTicketVO(old, neww, Collections.emptySet()));
        }
        if (!changedTickets.isEmpty()) {
            if (UserManager.getInstance().getCurrentUserAccountID() == null) {
                try (UserAccountScope sc = UserAccountScope.createPrivileged();){
                    this.eventSender.dispatchEvent(changedTickets);
                }
            } else {
                this.eventSender.dispatchEvent(changedTickets);
            }
        }
    }

    private boolean nothingChanged(TicketVO neww, Map<GeneratedTicketAttribute, Object> oldValues) {
        for (Map.Entry<GeneratedTicketAttribute, Object> attr : oldValues.entrySet()) {
            if (Objects.equals(neww.getAttribute(attr.getKey()), attr.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clearTicketFromCache(int ticketId) {
        this.cacheCleaner.clearTicket(ticketId);
    }

    private class TicketVOChangedAttributes
    extends TicketVO {
        private TicketVO ticket;
        Map<GeneratedTicketAttribute, Object> oldValues;

        public TicketVOChangedAttributes(TicketVO ticket, Map<GeneratedTicketAttribute, Object> oldValues) {
            this.ticket = ticket;
            this.oldValues = new HashMap<GeneratedTicketAttribute, Object>(oldValues);
        }

        @Override
        public <VALUE> VALUE getAttribute(TicketAttribute<VALUE> attribute) {
            if (this.oldValues.containsKey(attribute)) {
                return (VALUE)this.oldValues.get(attribute);
            }
            return this.ticket.getAttribute(attribute);
        }

        @Override
        public Object getForKey(String key) throws IllegalArgumentException {
            return this.ticket.getForKey(key);
        }

        @Override
        public <VALUE> boolean hasAttributeKey(TicketAttribute<VALUE> attribute) {
            if (this.oldValues.containsKey(attribute)) {
                return true;
            }
            return this.ticket.hasAttributeKey(attribute);
        }

        @Override
        public Set<TicketAttribute<Object>> getIncludedAttributes() {
            HashSet<TicketAttribute<Object>> set = new HashSet<TicketAttribute<Object>>(this.ticket.getIncludedAttributes());
            for (GeneratedTicketAttribute attr : this.oldValues.keySet()) {
                set.add(attr);
            }
            return set;
        }

        @Override
        public <VALUE> VALUE getValue(TicketField<VALUE> field) {
            return this.ticket.getValue(field);
        }

        @Override
        public <VALUE> boolean hasFieldKey(TicketField<VALUE> field) {
            return this.ticket.hasFieldKey(field);
        }

        @Override
        public Set<TicketField<Object>> getIncludedFields() {
            return this.ticket.getIncludedFields();
        }

        @Override
        public int getID() {
            return this.ticket.getID();
        }

        @Override
        public <T> T getFieldOrAttributeValue(Field<T> fieldOrAttribute) {
            if (this.oldValues.containsKey(fieldOrAttribute)) {
                return (T)this.oldValues.get(fieldOrAttribute);
            }
            return this.ticket.getFieldOrAttributeValue(fieldOrAttribute);
        }

        public String toString() {
            return this.ticket.toString();
        }
    }
}

