/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.internal;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.data.ServerOptions;
import com.inet.helpdesk.core.ticketmanager.TicketEmailSenderInformation;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.mail.reader.EmailReader_Main;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.model.user.User;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.UserModelConverter;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import srv.mail.Mail;

public class TicketEmailSenderInformationCreator {
    private static final ConfigValue<String> SENDER_ORDER = new ConfigValue(HDConfigKeys.MAIL_SENDER_ORDER);
    private static final ConfigValue<String> MAIL_SENDER = new ConfigValue(ConfigKey.MAIL_SENDER);

    /*
     * Enabled aggressive block sorting
     */
    public static List<TicketEmailSenderInformation> getSenderInformation(@Nonnull UserAccount currentUserAccount, @Nullable GUID resourceID, @Nullable Integer categoryID, @Nullable String requestMailAccount) {
        String[] mails;
        String email;
        UserGroupInfo res;
        ArrayList<TicketEmailSenderInformation> senders = new ArrayList<TicketEmailSenderInformation>();
        ArrayList<TicketEmailSenderInformation> sendersSupporter = new ArrayList<TicketEmailSenderInformation>();
        User currentUser = UserModelConverter.convertUserAccount(currentUserAccount);
        String[] userEmails = currentUser.getValue(Field.USERDATA_EMAIL, String[].class);
        if (userEmails != null && userEmails.length > 0 && userEmails[0].length() > 0) {
            for (String userEmail : userEmails) {
                if (userEmail == null || userEmail.trim().length() <= 0) continue;
                sendersSupporter.add(new TicketEmailSenderInformation(currentUserAccount.getID().toString(), currentUser.getUserName(), currentUserAccount.getDisplayName(), TicketEmailSenderInformation.SenderType.owner, userEmail));
            }
        }
        if (ServerOptions.isOptionSet(0x10000000)) {
            return sendersSupporter;
        }
        ArrayList<TicketEmailSenderInformation> sendersResource = new ArrayList<TicketEmailSenderInformation>();
        if (resourceID != null && (res = UserGroupManager.getRecoveryEnabledInstance().getGroup(resourceID)) != null && (email = (String)res.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_EMAIL)) != null && email.length() > 0 && (mails = TicketEmailSenderInformationCreator.convertMailsToAddressArray(email)).length > 0 && mails[0] != null && mails[0].length() > 0) {
            for (String mail : mails) {
                sendersResource.add(new TicketEmailSenderInformation("" + HDUsersAndGroups.getResourceId(res.getID()), res.getDisplayName(), res.getDisplayName(), TicketEmailSenderInformation.SenderType.resource, mail));
            }
        }
        ArrayList<TicketEmailSenderInformation> sendersMail = new ArrayList<TicketEmailSenderInformation>();
        ArrayList mailAccounts = (ArrayList)EmailReader_Main.MAIL_ACCOUNTS.get();
        CategoryVO categoryVO = categoryID == null ? null : (CategoryVO)CategoryManager.getInstance().get(categoryID);
        ArrayList<TicketEmailSenderInformation> senderCategory = new ArrayList<TicketEmailSenderInformation>();
        while (categoryVO != null) {
            String absender = categoryVO.getAbsender();
            if (absender != null && !absender.trim().isEmpty()) {
                senderCategory.add(new TicketEmailSenderInformation("" + categoryID, absender, absender, TicketEmailSenderInformation.SenderType.category, absender));
                break;
            }
            Integer parentCategoryID = categoryVO.getParentCategoryID();
            if (parentCategoryID == null || parentCategoryID.intValue() == categoryVO.getId()) break;
            categoryVO = (CategoryVO)CategoryManager.getInstance().get(parentCategoryID);
        }
        TicketEmailSenderInformation fallBackSender = null;
        String fallbackFallbackSender = (String)MAIL_SENDER.get();
        if (fallbackFallbackSender != null && fallbackFallbackSender.length() > 0) {
            fallBackSender = new TicketEmailSenderInformation(fallbackFallbackSender, fallbackFallbackSender, fallbackFallbackSender, TicketEmailSenderInformation.SenderType.fallback, fallbackFallbackSender);
        }
        TicketEmailSenderInformation preferredSender = null;
        TicketEmailSenderInformation mailboxSender = null;
        for (EmailAccount account : mailAccounts) {
            String userName = account.getAccount();
            String alias = account.getFromName();
            if (alias == null || alias.isEmpty()) {
                alias = account.getAccount();
            }
            String displayName = alias;
            String[] mails2 = Mail.convertToAddressArray(account.getFrom());
            if (mails2.length <= 0 || mails2[0] == null || mails2[0].length() <= 0) continue;
            for (String mail : mails2) {
                TicketEmailSenderInformation senderInfo = new TicketEmailSenderInformation(account.getAccount(), userName, displayName, TicketEmailSenderInformation.SenderType.mailbox, mail);
                sendersMail.add(senderInfo);
                if (requestMailAccount == null || !requestMailAccount.equalsIgnoreCase("er_" + account.getAccount())) continue;
                mailboxSender = senderInfo;
            }
        }
        String order = (String)SENDER_ORDER.get() + "4444";
        block19: for (int i = 0; i < order.length(); ++i) {
            String senderType;
            switch (senderType = order.substring(i, i + 1)) {
                case "0": {
                    if (sendersSupporter.size() <= 0) break;
                    preferredSender = sendersSupporter.get(0);
                    break block19;
                }
                case "1": {
                    if (mailboxSender == null) break;
                    preferredSender = mailboxSender;
                    break block19;
                }
                case "2": {
                    if (senderCategory.size() <= 0) break;
                    preferredSender = (TicketEmailSenderInformation)senderCategory.get(0);
                    break block19;
                }
                case "3": {
                    if (sendersResource.size() <= 0) break;
                    preferredSender = (TicketEmailSenderInformation)sendersResource.get(0);
                    break block19;
                }
                case "4": {
                    preferredSender = fallBackSender;
                    break block19;
                }
            }
        }
        Comparator userComparator = (o1, o2) -> o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
        Collections.sort(sendersMail, userComparator);
        Collections.sort(sendersResource, userComparator);
        Collections.sort(sendersSupporter, userComparator);
        senders.addAll(sendersMail);
        senders.addAll(senderCategory);
        senders.addAll(sendersResource);
        senders.addAll(sendersSupporter);
        if (preferredSender != null && senders.size() > 0) {
            senders.remove(preferredSender);
            senders.add(0, preferredSender);
        }
        if (senders.size() == 0 && fallBackSender != null) {
            senders.add(fallBackSender);
        }
        return senders;
    }

    @Nonnull
    private static String[] convertMailsToAddressArray(String mailString) {
        if (mailString != null && mailString.length() > 0) {
            if (mailString.indexOf(59) > -1) {
                StringTokenizer emailTokens = new StringTokenizer(mailString, ";");
                Vector<String> allAdresses = new Vector<String>();
                while (emailTokens.hasMoreTokens()) {
                    allAdresses.addElement(emailTokens.nextToken().trim());
                }
                if (allAdresses.size() > 0) {
                    return allAdresses.toArray(new String[allAdresses.size()]);
                }
            } else {
                mailString = mailString.trim();
                return new String[]{mailString};
            }
        }
        return new String[0];
    }
}

