/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.internal;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.ticketmanager.access.TicketActionValidator;
import com.inet.helpdesk.ticketmanager.internal.DefaultValueManagerImpl;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class MandatoryFieldsManagerImpl
implements MandatoryFieldsManager {
    public static final int IDENTIFIER_KEY = 13;
    public static final int PRIORITY_KEY = 14;
    public static final int CATEGORY_KEY = 15;
    public static final int CLASSIFICATION_KEY = 25;
    public static final int ITIL_KEY = 29;
    public static final int TARGET_TIME_KEY = 51;
    public static final int CUSTOM_1_KEY = 17;
    public static final int CUSTOM_2_KEY = 18;
    public static final int CUSTOM_3_KEY = 19;
    public static final int CUSTOM_4_KEY = 20;
    public static final int NONE_BIT = 0;
    public static final int DISPATCHER_BIT = 1;
    public static final int SUPPORTER_BIT = 2;
    public static final int SETTING_BENUTZER_PFLICHTFELD = 2;
    public static final int SETTING_BENUTZER_ANZEIGEN = 1;
    public static final int SETTING_BENUTZER_NICHT_ANZEIGEN = 0;
    private List<MandatoryFieldVO> mandatoryFields = new ArrayList<MandatoryFieldVO>();
    private static boolean initialized = false;

    public static MandatoryFieldsManagerImpl getInstance() {
        return (MandatoryFieldsManagerImpl)ServerPluginManager.getInstance().getSingleInstance(MandatoryFieldsManager.class);
    }

    public static void settingsCouldHaveChanged() {
        initialized = false;
    }

    private void init() {
        if (initialized) {
            return;
        }
        ArrayList<MandatoryFieldVO> newFields = new ArrayList<MandatoryFieldVO>();
        ConnectionFactory confac = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        try (Connection con = confac.getConnection();
             Statement stm = con.createStatement();
             ResultSet rs = stm.executeQuery("SELECT * FROM tblSettings");){
            while (rs.next()) {
                this.initMandatoryField(rs.getInt("SetID"), rs.getInt("Pflichtfeld"), rs.getInt("Selektion"), newFields);
            }
            this.mandatoryFields = Collections.unmodifiableList(newFields);
            initialized = true;
        }
        catch (SQLException sqle) {
            HDLogger.error(sqle);
        }
    }

    private void initMandatoryField(int setIDInDb, int mandatoryFlag, int selection, List<MandatoryFieldVO> mandatoryFields) {
        MandatoryFieldVO.MandatoryType enduser;
        TicketField field;
        boolean disp = (mandatoryFlag & 1) > 0;
        boolean supporter = (mandatoryFlag & 2) > 0;
        Object defaultValue = null;
        switch (setIDInDb) {
            case 17: {
                field = Tickets.FIELD_CUSTOM_1;
                defaultValue = "";
                enduser = MandatoryFieldsManagerImpl.ofNormalIndex(selection);
                break;
            }
            case 18: {
                field = Tickets.FIELD_CUSTOM_2;
                defaultValue = "";
                enduser = MandatoryFieldsManagerImpl.ofNormalIndex(selection);
                break;
            }
            case 19: {
                field = Tickets.FIELD_CUSTOM_3;
                defaultValue = "";
                enduser = MandatoryFieldsManagerImpl.ofNormalIndex(selection);
                break;
            }
            case 20: {
                field = Tickets.FIELD_CUSTOM_4;
                defaultValue = "";
                enduser = MandatoryFieldsManagerImpl.ofNormalIndex(selection);
                break;
            }
            case 25: {
                field = Tickets.FIELD_CLASSIFICATION_ID;
                defaultValue = 0;
                enduser = MandatoryFieldsManagerImpl.ofNormalIndex(selection);
                break;
            }
            case 13: {
                field = Tickets.FIELD_IDENTIFIER;
                defaultValue = "";
                enduser = MandatoryFieldVO.MandatoryType.HIDDEN;
                break;
            }
            case 14: {
                field = Tickets.FIELD_PRIORITY_ID;
                defaultValue = DefaultValueManagerImpl.getInstance().getPriorityDefault();
                enduser = MandatoryFieldsManagerImpl.ofPriority(selection);
                break;
            }
            case 15: {
                field = Tickets.FIELD_CATEGORY_ID;
                defaultValue = null;
                enduser = MandatoryFieldsManagerImpl.ofCategory(selection);
                break;
            }
            case 29: {
                field = Tickets.FIELD_ITIL_ID;
                defaultValue = Tickets.FIELD_ITIL_ID.getDefaultValue();
                enduser = MandatoryFieldVO.MandatoryType.HIDDEN;
                break;
            }
            case 51: {
                field = Tickets.FIELD_TARGET_TIME;
                defaultValue = 0;
                enduser = MandatoryFieldVO.MandatoryType.HIDDEN;
                break;
            }
            default: {
                return;
            }
        }
        mandatoryFields.add(this.createFieldVO(field, disp, supporter, enduser, defaultValue));
    }

    private static MandatoryFieldVO.MandatoryType ofNormalIndex(int selection) {
        switch (selection) {
            case 0: {
                return MandatoryFieldVO.MandatoryType.HIDDEN;
            }
            case 1: {
                return MandatoryFieldVO.MandatoryType.VISIBLE;
            }
            case 2: {
                return MandatoryFieldVO.MandatoryType.REQUIRED;
            }
        }
        throw new IllegalArgumentException("Bad value: " + selection);
    }

    private static MandatoryFieldVO.MandatoryType ofPriority(int selection) {
        switch (selection) {
            case 0: {
                return MandatoryFieldVO.MandatoryType.VISIBLE;
            }
            case 1: {
                return MandatoryFieldVO.MandatoryType.HIDDEN;
            }
            case 2: {
                return MandatoryFieldVO.MandatoryType.REQUIRED;
            }
        }
        throw new IllegalArgumentException("Bad value: " + selection);
    }

    private static MandatoryFieldVO.MandatoryType ofCategory(int selection) {
        switch (selection) {
            case 0: {
                return MandatoryFieldVO.MandatoryType.VISIBLE;
            }
            case 1: {
                return MandatoryFieldVO.MandatoryType.REQUIRED;
            }
            case 2: {
                return MandatoryFieldVO.MandatoryType.HIDDEN;
            }
        }
        throw new IllegalArgumentException("Bad value: " + selection);
    }

    private <T> MandatoryFieldVO<T> createFieldVO(TicketField<T> field, boolean disp, boolean supporter, MandatoryFieldVO.MandatoryType enduser, T defaultValue) {
        return new MandatoryFieldVO<T>(field, disp, supporter, enduser, defaultValue);
    }

    public void checkMandatoryUserValues(MutableTicketData ticketData) {
        this.init();
        this.mandatoryFields.stream().filter(f -> f.getUserMandatorySetting() == MandatoryFieldVO.MandatoryType.REQUIRED).forEach(mandatField -> this.checkValueInternalThrow(mandatField.getTicketField(), ticketData.get(mandatField.getTicketField()), mandatField.getDefaultValueToBeChanged()));
    }

    public void checkMandatorySupporterValues(MutableTicketData ticketData) {
        this.init();
        this.mandatoryFields.stream().filter(MandatoryFieldVO::isRequiredForSupporter).forEach(mandatField -> this.checkValueInternalThrow(mandatField.getTicketField(), ticketData.get(mandatField.getTicketField()), mandatField.getDefaultValueToBeChanged()));
    }

    public void checkMandatoryDispatcherValues(MutableTicketData ticketData) {
        this.init();
        this.mandatoryFields.stream().filter(MandatoryFieldVO::isRequiredForDispatcher).forEach(mandatField -> this.checkValueInternalThrow(mandatField.getTicketField(), ticketData.get(mandatField.getTicketField()), mandatField.getDefaultValueToBeChanged()));
    }

    public void checkMandatoryDispatcherValues(TicketVOSingle ticketData) {
        this.init();
        this.mandatoryFields.stream().filter(MandatoryFieldVO::isRequiredForDispatcher).forEach(mandatField -> this.checkValueInternalThrow(mandatField.getTicketField(), ticketData.getValue(mandatField.getTicketField()), mandatField.getDefaultValueToBeChanged()));
    }

    @Override
    public Map<TicketField, String> getInfoAboutFieldsToChangeBeforeAction(TicketVO ticket, ActionVO actionToApply) {
        Predicate<MandatoryFieldVO> filter;
        this.init();
        HashMap<TicketField, String> requiredFields = new HashMap<TicketField, String>();
        TicketPermissionContext context = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket.getID());
        if (TicketActionValidator.mustCheckMandatorySupporterFields(ticket, context, actionToApply)) {
            filter = MandatoryFieldVO::isRequiredForSupporter;
        } else if (context.hasDispatcherAccessToTicket() && actionToApply.getId() == 5) {
            filter = MandatoryFieldVO::isRequiredForDispatcher;
        } else {
            if (!context.hasAnyAccessToTicket()) {
                throw new AccessDeniedException();
            }
            return requiredFields;
        }
        this.mandatoryFields.stream().filter(filter).forEach(mandatField -> {
            String message = this.checkValueInternal(mandatField.getTicketField(), ticket.getValue(mandatField.getTicketField()), mandatField.getDefaultValueToBeChanged());
            if (message != null) {
                requiredFields.put(mandatField.getTicketField(), message);
            }
        });
        return requiredFields;
    }

    private void checkValueInternalThrow(TicketField field, Object value, Object noValue) {
        String error = this.checkValueInternal(field, value, noValue);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
    }

    private String checkValueInternal(TicketField field, Object value, Object noValue) {
        if (value == null || noValue != null && noValue.equals(value)) {
            if (value != null && field == Tickets.FIELD_PRIORITY_ID) {
                return Tickets.MSG.getMsg("error.prioMustBeChanged", new Object[0]);
            }
            if (value != null && field == Tickets.FIELD_ITIL_ID) {
                return Tickets.MSG.getMsg("error.itilMustBeChanged", new Object[0]);
            }
            List fieldDefinitions = ServerPluginManager.getInstance().get(TicketFieldDefinition.class);
            TicketFieldDefinition ticketFieldDefinition = fieldDefinitions.stream().filter(def -> def.getKey().equals(field.getKey())).findAny().orElse(null);
            return Tickets.MSG.getMsg("error.missingFieldValue", new Object[]{ticketFieldDefinition.getDisplayName()});
        }
        return null;
    }

    @Override
    public List<MandatoryFieldVO> getMandatoryFieldSettings() {
        this.init();
        return this.mandatoryFields;
    }
}

