/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.internal;

import com.inet.config.ConfigValue;
import com.inet.error.PersistenceException;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.TicketManipulatorBackdoor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;

public class IDGenerator
implements TicketManipulatorBackdoor.IDGeneratorBackdoor {
    private AtomicInteger ticketIDGen;
    private AtomicInteger reaIDGen;

    public IDGenerator(ConnectionFactory factory) {
        try (Connection con = factory.getConnection();
             Statement maxTicket = con.createStatement();
             ResultSet rs = maxTicket.executeQuery("SELECT max(BunID) from tblBuendel");){
            this.ticketIDGen = rs.next() ? new AtomicInteger(rs.getInt(1)) : new AtomicInteger(0);
            try (Statement maxReaStep = con.createStatement();
                 ResultSet rs2 = maxReaStep.executeQuery("SELECT max(ReaID) from tblRealisierung");){
                this.reaIDGen = rs2.next() ? new AtomicInteger(rs2.getInt(1)) : new AtomicInteger(0);
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        new ConfigValue<Integer>(HDConfigKeys.TICKET_START_TICKET_ID){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void setValue(String strValue) throws IllegalArgumentException {
                super.setValue(strValue);
                Integer minTicketId = (Integer)this.get();
                if (minTicketId != null) {
                    IDGenerator iDGenerator = IDGenerator.this;
                    synchronized (iDGenerator) {
                        IDGenerator.this.ticketIDGen.set(Math.max(IDGenerator.this.ticketIDGen.get(), minTicketId - 1));
                    }
                }
            }
        };
    }

    @Override
    public synchronized int generateNewTicketID() {
        return this.ticketIDGen.incrementAndGet();
    }

    @Override
    public int generateNewReaStepID() {
        return this.reaIDGen.incrementAndGet();
    }

    public synchronized void transactionFailed(int ticketID) {
        if (this.ticketIDGen.get() == ticketID) {
            this.ticketIDGen.decrementAndGet();
        }
    }
}

