/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.config.EmailAccountList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ServerDataConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.ServerOptions;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.data.TicketAccessInformations;
import com.inet.helpdesk.core.data.TicketDataConnector;
import com.inet.helpdesk.core.data.UserDataConnector;
import com.inet.helpdesk.core.model.general.ActionType;
import com.inet.helpdesk.core.model.general.Entry;
import com.inet.helpdesk.core.model.general.FieldSetting;
import com.inet.helpdesk.core.model.general.Sorting;
import com.inet.helpdesk.core.model.ticket.Action;
import com.inet.helpdesk.core.model.ticket.EmailReceiverAdder;
import com.inet.helpdesk.core.model.ticket.ReaStep;
import com.inet.helpdesk.core.model.ticket.SenderInformation;
import com.inet.helpdesk.core.model.ticket.Ticket;
import com.inet.helpdesk.core.model.ticket.TicketPermissionFilter;
import com.inet.helpdesk.core.model.ticket.TicketPermissionsInfo;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.ReaStepEmailAddresses;
import com.inet.helpdesk.core.ticketmanager.TicketEmailSenderInformation;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketManipulator;
import com.inet.helpdesk.core.ticketmanager.TicketReaderForSystem;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.fields.resource.ResourceManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserGroupVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserGroupVOManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextVO;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.TextSearchParameters;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.TicketSearchFilterOptions;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.ChangedTicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldCustomField;
import com.inet.helpdesk.data.UserDataConnectorImpl;
import com.inet.helpdesk.i18n.LocalizationImpl;
import com.inet.helpdesk.mail.reader.EmailReader_Main;
import com.inet.helpdesk.shared.model.DataField;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.model.general.ContextType;
import com.inet.helpdesk.shared.model.user.User;
import com.inet.helpdesk.ticketmanager.TicketManipulatorInternal;
import com.inet.helpdesk.ticketmanager.TicketReaderImpl;
import com.inet.helpdesk.ticketmanager.adapt.OldApiAdapter;
import com.inet.helpdesk.ticketmanager.internal.CachedTicketSorter;
import com.inet.helpdesk.ticketmanager.search.GroupingParameterToSearchCondition;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.UserModelConverter;
import com.inet.helpdesk.usersandgroups.user.HelpDeskUserManager;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.fields.EmailAddressHelper;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.user.search.SearchTagActive;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.internet.AddressException;
import srv.ServerUtilities;
import srv.controller.IntObjectHashMap;
import srv.controller.OpenOrderController;
import srv.controller.TicketAccessController;
import srv.controller.UserSession;
import srv.controller.ticket.timeline.ResourceTimelineManager;

public class NewTicketDataConnectorImpl
implements TicketDataConnector {
    private static final ConfigValue<String> MAIL_HOST = new ConfigValue(HDConfigKeys.MAIL_HOST);
    private static final ConfigValue<String> SPERRLIST = new ConfigValue(HDConfigKeys.SPERRLIST);
    private static final ConfigValue<String> MAIL_SENDER = new ConfigValue(ConfigKey.MAIL_SENDER);
    private static TicketReaderImpl ticketReader;
    private TicketAccessController ticketAccessCtrl;
    private ServerDataConnector serverDataConnector;
    private ServerValuesConnector serverValuesConnector;
    private ServerPluginManager spm;
    private UserManager userManager;
    private ConnectionFactory connectionFactory;
    protected VersionHandler versionHandler;

    public static void setReaderImpl(TicketReaderImpl reader) {
        ticketReader = reader;
    }

    public void setupOnRegister(ServerDataConnector serverDataConnector, ServerValuesConnector serverValuesConnector, UserDataConnector userDataConnector, ConnectionFactory connectionFactory) {
        this.serverDataConnector = serverDataConnector;
        this.serverValuesConnector = serverValuesConnector;
        this.connectionFactory = connectionFactory;
    }

    public void init(UserManager userManager, TicketAccessController accessCtrl, ServerPluginManager spm) {
        this.userManager = userManager;
        this.ticketAccessCtrl = accessCtrl;
        this.spm = spm;
    }

    @Override
    public Ticket getTicket(ContextType context, int ticketId, TicketDataConnector.TicketText ticketText) throws ServerDataException {
        TicketVO cachedTicket = this.getReaderForSystem().getTicket(ticketId);
        if (cachedTicket == null) {
            return null;
        }
        Ticket ticket = this.cachedTicketToTicket(cachedTicket, ticketText == TicketDataConnector.TicketText.INQUIRY);
        if (ticketText == TicketDataConnector.TicketText.LASTSTEP) {
            this.setNewestReastepContentForPreview(context, ticket);
        }
        return ticket;
    }

    private TicketReaderForSystem getReaderForSystem() {
        return TicketManager.getReaderForSystem();
    }

    private Ticket cachedTicketToTicket(TicketVO cachedTicket, boolean includeAuftragsText) {
        Long termin;
        Long timestamp;
        int sumTimes;
        UserAccount editorAccount;
        UserAccount userAccount;
        int ticketId = cachedTicket.getID();
        String subject = cachedTicket.getSubject();
        ReaStepTextVO auftragsText = ticketReader.getReaStepText(cachedTicket.getInitialReaStepID());
        boolean htmlContent = auftragsText.hasHtmlContent();
        String aufText = "";
        if (includeAuftragsText) {
            aufText = auftragsText.getText();
            aufText = aufText != null && aufText.length() > 0 ? (htmlContent ? HtmlConverter.getCompactHtmlText((String)aufText, null) : aufText.trim()) : "";
        }
        if ((subject == null || subject.trim().length() == 0) && aufText.length() > 0) {
            if (htmlContent) {
                subject = HtmlConverter.html2text((String)aufText);
                subject = subject.substring(0, Math.min(50, subject.length()));
            } else {
                subject = aufText.substring(0, Math.min(50, aufText.length()));
            }
        }
        if (subject == null) {
            subject = "";
        } else {
            subject = subject.replace("\r", "").replace("\n", " ").replace("\t", " ").replaceAll("\\s+", " ");
            subject = subject.trim();
        }
        int ticketVersion = this.getVersionHandler().getTicketVersion(ticketId);
        Long lastModifiedDate = cachedTicket.getLastChanged();
        if (ticketVersion < 0) {
            ticketVersion = (int)(lastModifiedDate / 1000L);
        }
        int resID = 0;
        UserGroupInfo resource = null;
        GUID resUUID = cachedTicket.getResourceID();
        if (resUUID != null && (resource = UserGroupManager.getInstance().getGroup(resUUID)) != null) {
            resID = (Integer)resource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID);
        }
        int prioId = cachedTicket.getPriorityID();
        Ticket ticket = new Ticket(ticketVersion, ticketId, resID, subject, new Date(lastModifiedDate), cachedTicket.getStatusID(), prioId);
        Integer category = cachedTicket.getCategoryID();
        if (category == null) {
            ticket.addData(Field.TICKETDATA_CATEGORYID, 0);
        } else {
            ticket.addData(Field.TICKETDATA_CATEGORYID, category);
        }
        ticket.addData(Field.TICKETDATA_INQUIRYDATE, cachedTicket.getInquiryDate());
        ticket.setHtmlContent(htmlContent);
        ticket.addData(Field.TICKETDATA_PREVIEW, aufText);
        User ticketOwner = null;
        GUID userID = cachedTicket.getOwnerID();
        if (userID == null) {
            userID = HelpDeskUserManager.ADMIN_ACCOUNT_ID;
        }
        if ((userAccount = UserManager.getInstance().getUserAccount(userID)) == null) {
            ticketOwner = new User();
            ticketOwner.addData(new DataField(Field.USERDATA_USERID, (Object)-1));
            ticketOwner.addData(new DataField(Field.USERDATA_USERNAME, (Object)"Admin"));
            ticketOwner.addData(new DataField(Field.USERDATA_DISPLAYNAME, (Object)"Admin"));
        } else {
            ticketOwner = UserModelConverter.convertUserAccount(userAccount);
        }
        ticket.addData(Field.TICKETDATA_OWNER, ticketOwner);
        GUID editor = cachedTicket.getLastEditorID();
        String lastEditor = null;
        if (editor != null && (editorAccount = this.userManager.getUserAccount(editor)) != null) {
            lastEditor = editorAccount.getDisplayName();
        }
        if (lastEditor == null && ticketOwner != null) {
            lastEditor = ticketOwner.getDisplayName();
        }
        ticket.addData(Field.TICKETDATA_LASTTEXTEDITOR, lastEditor);
        ticket.addData(Field.TICKETDATA_REQUESTMAILACCOUNT, cachedTicket.getEmailEingang());
        Integer workFlowID = cachedTicket.getWorkflowID();
        if (workFlowID != null && workFlowID > 0) {
            ticket.addData(Field.TICKETDATA_WORKFLOWTICKETID, (int)workFlowID);
        }
        if ((sumTimes = cachedTicket.getSumTime()) > 0) {
            ticket.addData(Field.TICKETDATA_SUMTIMES, sumTimes);
        }
        ticket.addData(Field.TICKETDATA_TICKETFIELD1, cachedTicket.getCustom1());
        ticket.addData(Field.TICKETDATA_TICKETFIELD2, cachedTicket.getCustom2());
        ticket.addData(Field.TICKETDATA_TICKETFIELD3, cachedTicket.getCustom3());
        ticket.addData(Field.TICKETDATA_TICKETFIELD4, cachedTicket.getCustom4());
        ticket.addData(Field.TICKETDATA_TICKETFIELD5, cachedTicket.getCustom5());
        ticket.addData(Field.TICKETDATA_TICKETFIELD6, cachedTicket.getCustom6());
        ticket.addData(Field.TICKETDATA_TICKETFIELD7, cachedTicket.getCustom7());
        ticket.addData(Field.TICKETDATA_SPECIALFIELD, cachedTicket.getIdentifier());
        ticket.addData(Field.TICKETDATA_CLASSIFICATIONID, cachedTicket.getClassificationID());
        ticket.addData(Field.TICKETDATA_ITILID, cachedTicket.getItilID());
        if (resource != null) {
            ticket.addData(Field.TICKETDATA_RESOURCEID_DISPLAYNAME, resource.getDisplayName());
        } else {
            ticket.addData(Field.TICKETDATA_RESOURCEID_DISPLAYNAME, "");
        }
        Integer dueTime = cachedTicket.getTargetTime();
        if (dueTime != null) {
            ticket.addData(Field.TICKETDATA_DUETIME, dueTime);
        }
        if ((timestamp = cachedTicket.getDeadline()) != null) {
            ticket.addData(Field.TICKETDATA_DEADLINE, new Date(timestamp));
        }
        if ((termin = cachedTicket.getValue(Tickets.FIELD_TERMINVEREINBARUNG)) != null) {
            ticket.addData(Field.TICKETDATA_TERMINVEREINBARUNG, new Date(termin));
        }
        ticket.addData(Field.TICKETDATA_HASATTACHMENTS, cachedTicket.hasAttachments());
        ticket.addData(Field.TICKETDATA_MASTERTICKET, cachedTicket.isMasterInBundle() || cachedTicket.isUnbundled());
        ticket.addData(Field.TICKETDATA_HASSUBTICKETS, cachedTicket.isMasterInBundle() && !cachedTicket.isUnbundled());
        return ticket;
    }

    private void setNewestReastepContentForPreview(ContextType context, List<Ticket> tickets) throws ServerDataException {
        for (Ticket ticket : tickets) {
            this.setNewestReastepContentForPreview(context, ticket);
        }
    }

    private void setNewestReastepContentForPreview(ContextType context, Ticket ticket) throws ServerDataException {
        ReaStepTextVO auftragsText;
        String subject;
        int ticketID = ticket.getId();
        Function<ReaStepVO, Boolean> statusFilter = reaStep -> {
            int actionID = reaStep.getActionID();
            try {
                Action action = this.serverDataConnector.getAction(actionID);
                return action.getStateId() == 0 || action.getStateId() >= 100;
            }
            catch (ServerDataException e) {
                throw new IllegalStateException(e);
            }
        };
        List<ReaStepVO> steps = this.findReaSteps(ticketID, statusFilter, context);
        Collections.sort(steps, (o1, o2) -> o2.getID() - o1.getID());
        TicketVO cachedTicket = this.getReaderForSystem().getTicket(ticket.getId());
        int anfReaId = cachedTicket.getInitialReaStepID();
        boolean hasPreviewText = false;
        Object reaStepContent = null;
        for (ReaStepVO cachedReaStep : steps) {
            ReaStepTextVO reaStepText = ticketReader.getReaStepText(cachedReaStep.getID());
            reaStepContent = reaStepText.getText();
            boolean isHtml = reaStepText.hasHtmlContent();
            if (reaStepText.isEmpty() && cachedReaStep.getID() != anfReaId) continue;
            if (cachedReaStep.getID() == anfReaId) {
                ReaStepTextVO auftragsText2 = ticketReader.getReaStepText(cachedTicket.getInitialReaStepID());
                reaStepContent = auftragsText2.getText();
                isHtml = auftragsText2.hasHtmlContent();
            }
            ticket.setHtmlContent(isHtml);
            if (reaStepContent == null) {
                reaStepContent = "";
            }
            if (isHtml && ((String)reaStepContent).length() < 10000) {
                reaStepContent = HtmlConverter.getCompactHtmlText((String)reaStepContent, null);
            }
            if (isHtml) {
                int styleTagStart = ((String)reaStepContent).indexOf("<style>");
                int styleTagEnd = ((String)reaStepContent).indexOf("</style>", styleTagStart);
                if (styleTagStart >= 0 && styleTagEnd >= 0) {
                    String prefix = ((String)reaStepContent).substring(0, styleTagStart);
                    String styleTag = ((String)reaStepContent).substring(styleTagStart, styleTagEnd);
                    String suffix = ((String)reaStepContent).substring(styleTagEnd);
                    styleTag = styleTag.replaceAll("\t", " ");
                    styleTag = styleTag.replaceAll("\n", " ");
                    styleTag = styleTag.replaceAll("\r", " ");
                    reaStepContent = prefix + styleTag + suffix;
                }
            }
            ticket.setData(Field.TICKETDATA_PREVIEW, reaStepContent);
            hasPreviewText = true;
            GUID userID = cachedReaStep.getUserID();
            if (userID != null) {
                UserAccount account = UserManager.getInstance().getUserAccount(userID);
                if (account == null) break;
                ticket.setData(Field.TICKETDATA_LASTTEXTEDITOR, account.getDisplayName());
                break;
            }
            if (!StringFunctions.isEmpty((String)cachedReaStep.getDisplayName())) {
                ticket.setData(Field.TICKETDATA_LASTTEXTEDITOR, cachedReaStep.getDisplayName());
                break;
            }
            ticket.setData(Field.TICKETDATA_LASTTEXTEDITOR, Tickets.MSG.getMsg("lasteditor.automated", new Object[0]));
            break;
        }
        if (!hasPreviewText) {
            ReaStepTextVO auftragsText3 = ticketReader.getReaStepText(cachedTicket.getInitialReaStepID());
            reaStepContent = auftragsText3.getText();
            boolean htmlContent = auftragsText3.hasHtmlContent();
            ticket.setHtmlContent(htmlContent);
            if (reaStepContent == null) {
                reaStepContent = "";
            }
            if (htmlContent && ((String)reaStepContent).length() < 10000) {
                reaStepContent = HtmlConverter.getCompactHtmlText((String)reaStepContent, null);
            }
            reaStepContent = ((String)reaStepContent).replaceAll("\t", " ");
            reaStepContent = ((String)reaStepContent).replaceAll("\n", " ");
            reaStepContent = ((String)reaStepContent).replaceAll("\r", " ");
            ticket.setData(Field.TICKETDATA_PREVIEW, reaStepContent);
            GUID textEditor = cachedTicket.getLastEditorID();
            if (textEditor != null) {
                UserAccount userAccount = this.userManager.getUserAccount(textEditor);
                ticket.setData(Field.TICKETDATA_LASTTEXTEDITOR, userAccount.getDisplayName());
            }
        }
        if (((subject = ticket.getValue(Field.TICKETDATA_SUBJECT, String.class)) == null || subject.trim().length() == 0) && reaStepContent != null && ((String)reaStepContent).length() > 0 && (auftragsText = ticketReader.getReaStepText(cachedTicket.getInitialReaStepID())) != null) {
            subject = this.generateSubjectFromAuftragsText(auftragsText.getText(), auftragsText.hasHtmlContent());
            ticket.setData(Field.TICKETDATA_SUBJECT, subject);
        }
    }

    private String generateSubjectFromAuftragsText(String text, boolean isHtml) {
        String subject;
        if (isHtml) {
            subject = HtmlConverter.html2text((String)text);
            subject = subject.substring(0, Math.min(50, subject.length()));
        } else {
            subject = text.substring(0, Math.min(50, text.length()));
        }
        subject = subject.replace("\r", "").replace("\n", " ").replace("\t", " ").replaceAll("\\s+", " ");
        subject = subject.trim();
        return subject;
    }

    private List<ReaStepVO> findReaSteps(int ticketId, Function<ReaStepVO, Boolean> filter, ContextType context) throws ServerDataException {
        if (!TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticketId).hasAnyAccessToTicket()) {
            return Collections.emptyList();
        }
        boolean includeSystemSteps = context == ContextType.supporter;
        try {
            List<ReaStepVO> steps = TicketManager.getReader().getReaStepsForTicket(ticketId, BundleStepsFilter.WITH_BUNDLE_STEPS);
            steps.removeIf(stepVo -> (Boolean)filter.apply((ReaStepVO)stepVo) == false);
            if (!includeSystemSteps) {
                steps.removeIf(s -> ((ActionVO)ActionManager.getInstance().get(s.getActionID())).isHidden());
            }
            return steps;
        }
        catch (AccessDeniedException | IllegalArgumentException ex) {
            throw new ServerDataException((Exception)ex);
        }
    }

    @Override
    public String getReaStepContent(int reaStepId) throws ServerDataException {
        ReaStepTextVO stepContent = ticketReader.getReaStepText(reaStepId);
        return stepContent == null ? null : stepContent.getText();
    }

    private void sortCachedTickets(List<TicketVO> tickets, Sorting sorting) {
        CachedTicketSorter sorter = new CachedTicketSorter(sorting);
        Collections.sort(tickets, sorter.getComparator());
    }

    private List<Ticket> generateTicketsFillOnlyNewOrChangedOnes(List<TicketVO> tickets, int numberOfTickets, Map<Integer, Integer> knownTickets, ContextType context) throws ServerDataException {
        ArrayList<Ticket> result = new ArrayList<Ticket>();
        ArrayList<Ticket> filledTickets = new ArrayList<Ticket>();
        for (int i = 0; i < tickets.size(); ++i) {
            TicketVO cached = tickets.get(i);
            int ticketID = cached.getID();
            Integer clientVersion = knownTickets.get(ticketID);
            Ticket ticket = null;
            int currentTicketVersion = this.getVersionHandler().getTicketVersion(ticketID);
            if (i < numberOfTickets && (clientVersion == null || clientVersion != currentTicketVersion)) {
                ticket = this.cachedTicketToTicket(cached, false);
                filledTickets.add(ticket);
            } else {
                ticket = new Ticket(currentTicketVersion, ticketID, -1, null, null, -1, -1);
            }
            result.add(ticket);
        }
        if (!filledTickets.isEmpty()) {
            this.setNewestReastepContentForPreview(context, filledTickets);
        }
        return result;
    }

    @Override
    public ArrayList<Ticket> getDispatcherTicketsSync(ContextType context, TicketDataConnector.GroupingParameter grouping, Sorting sorting, int numberOfTickets, Map<Integer, Integer> knownTickets, int sessionId) throws ServerDataException {
        TicketSearchFilterOptions options = TicketSearchFilterOptions.of(TicketSearchFilterOptions.ONLY_OPEN_INQUIRIES);
        options.withNumOfTickets(Math.max(1000, numberOfTickets * 10));
        if (grouping.getFirstGroupType() != -1) {
            options.addFieldCondition(new GroupingParameterToSearchCondition(5, grouping.getFirstGroupValue()));
        }
        List<TicketVO> tickets = ticketReader.findAllTicketsVisibleForUser(options, sorting, context);
        this.dropAllAnfragenBlockedByOtherUser(tickets, sessionId);
        List<Ticket> result = this.generateTicketsFillOnlyNewOrChangedOnes(tickets, numberOfTickets, knownTickets, context);
        return new ArrayList<Ticket>(result);
    }

    private void dropAllAnfragenBlockedByOtherUser(List<TicketVO> tickets, int sessionId) {
        tickets.removeIf(ticket -> {
            if (!ticket.isInquiry()) {
                return false;
            }
            TicketAccessInformations accessInformations = this.ticketAccessCtrl.getTicketAccessInformations(ticket.getID());
            return accessInformations != null && accessInformations.getTicketOwnerSessionId() > 0 && accessInformations.getTicketOwnerSessionId() != sessionId;
        });
    }

    @Override
    public ArrayList<Ticket> getTicketsSync(ContextType context, TicketDataConnector.GroupingParameter grouping, Sorting sorting, int numberOfTickets, Map<Integer, Integer> knownTickets, boolean onlyOwnResources) throws ServerDataException {
        TicketSearchFilterOptions options = TicketSearchFilterOptions.of(TicketSearchFilterOptions.ONLY_OPEN_TICKETS).withNumOfTickets(Math.max(1000, numberOfTickets * 10)).withOnlyOwnResources(onlyOwnResources).withTicketsBundled(true);
        if (grouping != null) {
            if (grouping.getFirstGroupType() != -1) {
                options.addFieldCondition(new GroupingParameterToSearchCondition(grouping.getFirstGroupType(), grouping.getFirstGroupValue()));
            }
            if (grouping.getSecondGroupType() != -1) {
                options.addFieldCondition(new GroupingParameterToSearchCondition(grouping.getSecondGroupType(), grouping.getSecondGroupValue()));
            }
        }
        List<TicketVO> tickets = ticketReader.findAllTicketsVisibleForUser(options, sorting, context);
        List<Ticket> result = this.generateTicketsFillOnlyNewOrChangedOnes(tickets, numberOfTickets, knownTickets, context);
        return new ArrayList<Ticket>(result);
    }

    @Override
    public List<ReaStep> getReaSteps(ContextType contextType, int ticketID) throws ServerDataException {
        List<ReaStepVO> reas = ticketReader.getReaStepsForTicket(ticketID, new TicketPermissionContext(contextType == ContextType.enduser, contextType == ContextType.supporter ? TicketPermissionContext.SupporterPermission.READ : TicketPermissionContext.SupporterPermission.NONE), BundleStepsFilter.WITH_BUNDLE_STEPS);
        ArrayList<ReaStep> result = new ArrayList<ReaStep>();
        for (ReaStepVO reaStepVO : reas) {
            UserAccount userAccount;
            int orgBunId = reaStepVO.getOrgBunID();
            int reaStepId = reaStepVO.getID();
            Date endDate = new Date(reaStepVO.getEndDate());
            User sender = null;
            String senderName = "";
            GUID userID = reaStepVO.getUserID();
            if (userID != null && (userAccount = UserManager.getInstance().getUserAccount(userID)) != null) {
                if (userAccount.isActive()) {
                    sender = UserModelConverter.convertUserAccount(userAccount);
                } else {
                    senderName = userAccount.getDisplayName();
                }
            }
            if (sender == null) {
                sender = new User();
                senderName = reaStepVO.getDisplayName();
                if (senderName == null) {
                    senderName = Tickets.MSG.getMsg("lasteditor.automated", new Object[0]);
                }
                sender.addData(Field.USERDATA_USERID, -1);
                sender.addData(Field.USERDATA_USERNAME, senderName);
                sender.addData(Field.USERDATA_DISPLAYNAME, senderName);
            }
            Action action = this.serverDataConnector.getAction(reaStepVO.getActionID());
            String stepDescription = reaStepVO.getDescription();
            ReaStepTextVO reaStepText = ticketReader.getReaStepText(reaStepVO.getID());
            String content = reaStepText.getText();
            boolean htmlContent = reaStepText.hasHtmlContent();
            ReaStep reaStep = new ReaStep(reaStepId, action, endDate, sender, stepDescription, content, htmlContent, orgBunId != ticketID);
            result.add(reaStep);
        }
        if (contextType == ContextType.supporter) {
            Collections.sort(result, new Comparator<ReaStep>(){

                @Override
                public int compare(ReaStep o1, ReaStep o2) {
                    if (o1 == null) {
                        return o2 == null ? 0 : -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    if (o1.getStateId() == 0 && !o1.isForeignTicket()) {
                        return -1;
                    }
                    if (o2.getStateId() == 0 && !o2.isForeignTicket()) {
                        return 1;
                    }
                    return o1.getReaStepId() - o2.getReaStepId();
                }
            });
        }
        if (contextType == ContextType.enduser) {
            Collections.sort(result, new Comparator<ReaStep>(){

                @Override
                public int compare(ReaStep o1, ReaStep o2) {
                    if (o1 == null) {
                        return o2 == null ? 0 : -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    long diff = o1.getEndDate().getTime() - o2.getEndDate().getTime();
                    if (diff == 0L) {
                        return o1.getReaStepId() - o2.getReaStepId();
                    }
                    return diff < 0L ? 1 : -1;
                }
            });
            Date inquiryDate = null;
            for (ReaStep reaStep : result) {
                if (reaStep.getStateId() != 0 || reaStep.isForeignTicket()) continue;
                inquiryDate = reaStep.getEndDate();
                break;
            }
            if (inquiryDate != null) {
                Iterator<ReaStep> iterator = result.iterator();
                while (iterator.hasNext()) {
                    ReaStep reaStep = iterator.next();
                    if (!reaStep.getEndDate().before(inquiryDate)) continue;
                    iterator.remove();
                }
            }
        }
        return result;
    }

    @Override
    public TicketPermissionsInfo getTicketPermissionsInfo(Ticket ticket, int sessionId, ContextType contextType) throws ServerDataException {
        UserAccount currentUser = this.getCurrentUserAccountOrThrow();
        if (ticket == null) {
            throw new ServerDataException(new IllegalArgumentException("No ticket is provided."));
        }
        boolean editable = false;
        boolean readable = false;
        boolean finishable = false;
        boolean answerable = false;
        boolean escalatable = false;
        boolean deletable = false;
        boolean commentable = false;
        boolean bundable = false;
        int status = ticket.getValue(Field.TICKETDATA_STATUSID, Integer.class);
        ArrayList<Action> allActions = this.getTicketActions(ticket, true);
        Set<Integer> allowedActions = TicketManager.getTicketActionChecker().getEffectiveAllowedActionsForCurrentUser();
        if (contextType == ContextType.enduser) {
            int daysToReactivate;
            User ticketOwner = ticket.getValue(Field.TICKETDATA_OWNER, User.class);
            int userID = HDUsersAndGroups.getUserID(currentUser);
            boolean bl = readable = ticketOwner != null && ticketOwner.getUserID() == userID;
            if (!readable) {
                Integer group;
                List<UserGroupVO> supervisorGroups = UserGroupVOManager.getInstance().getGroupsWhereUserIsSupervisor(userID);
                Integer n = group = ticketOwner != null ? ticketOwner.getValue(Field.USERDATA_GROUP, Integer.class) : null;
                if (group != null && supervisorGroups.stream().anyMatch(userGroup -> userGroup.getId() == group.intValue())) {
                    readable = true;
                }
            }
            boolean isMaster = ticket.getValue(Field.TICKETDATA_MASTERTICKET, Boolean.class);
            boolean hasSubTickets = ticket.getValue(Field.TICKETDATA_HASSUBTICKETS, Boolean.class);
            deletable = isMaster && !hasSubTickets;
            deletable &= allowedActions.contains(7);
            if (allowedActions.contains(2) && status >= 100 && status < 300) {
                for (Action action : allActions) {
                    if (action.getId() != 2) continue;
                    finishable = true;
                }
            }
            if (allowedActions.contains(-12) && status >= 100 && status < 300) {
                for (Action action : allActions) {
                    if (action.getId() != -12) continue;
                    commentable = true;
                }
            }
            if (allowedActions.contains(-12) && !commentable && status == 300 && (daysToReactivate = this.serverValuesConnector.getDefaultReactivationTimeInDays()) > 0) {
                Date lastModified = ticket.getValue(Field.TICKETDATA_LASTMODIFIED, Date.class);
                long reactivatableUntil = lastModified.getTime() + 86400000L * (long)daysToReactivate;
                if (System.currentTimeMillis() < reactivatableUntil) {
                    commentable = true;
                }
            }
            if (status >= 300) {
                deletable = false;
            }
        } else {
            int resourceId;
            Integer resourceIDValue = ticket.getValue(Field.TICKETDATA_RESOURCEID, Integer.class);
            int n = resourceId = resourceIDValue == null ? 0 : resourceIDValue;
            if (status == 0) {
                boolean isDispatcher;
                editable = isDispatcher = HDUsersAndGroups.isDispatcher(currentUser);
                readable = isDispatcher;
            } else {
                int openerTicketId;
                if (SystemPermissionChecker.hasAnyPermission((UserAccount)currentUser, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ, HdPermissions.TICKET_RESOURCES_READ_WRITE})) {
                    readable = true;
                } else if (!HDUsersAndGroups.isResourceMember(currentUser)) {
                    readable = false;
                } else {
                    int[] visibleResources = ResourceManager.getInstance().getResources(currentUser, false);
                    if (visibleResources != null) {
                        for (int resID : visibleResources) {
                            if (resID != resourceId) continue;
                            readable = true;
                            break;
                        }
                    }
                }
                editable = this.serverValuesConnector.isResourceWritable(resourceId, HDUsersAndGroups.getUserID(currentUser), 0);
                if (status >= 300 || status == 251) {
                    editable = false;
                }
                if ((openerTicketId = this.ticketAccessCtrl.isOrderOpened(ticket.getId())) != sessionId && openerTicketId != -1) {
                    editable = false;
                }
                if (allActions != null) {
                    Object hasSubTickets = allActions.iterator();
                    while (hasSubTickets.hasNext()) {
                        Action action = (Action)hasSubTickets.next();
                        if (allowedActions.contains(2) && action.getId() == 2 && !action.isIntern() && !action.isDeleted()) {
                            finishable = editable;
                            continue;
                        }
                        if (allowedActions.contains(8) && action.getId() == 8 && !action.isDeleted()) {
                            escalatable = editable && status >= 100 && status < 300;
                            continue;
                        }
                        if (!allowedActions.contains(-7) || action.getId() != -7 || action.isDeleted()) continue;
                        answerable = true;
                    }
                }
                answerable = answerable && editable && MAIL_HOST.get() != null && ((String)MAIL_HOST.get()).length() > 0;
                bundable = allowedActions.contains(-1) && status >= 100;
            }
        }
        TicketPermissionsInfo permInfo = new TicketPermissionsInfo(editable, finishable, answerable, escalatable, readable);
        if (deletable) {
            permInfo.addPermission(TicketPermissionsInfo.TicketPermission.DELETABLE);
        }
        if (commentable) {
            permInfo.addPermission(TicketPermissionsInfo.TicketPermission.COMMENTABLE);
        }
        if (bundable) {
            // empty if block
        }
        List permissionFilters = this.spm.get(TicketPermissionFilter.class);
        for (TicketPermissionFilter filter : permissionFilters) {
            try {
                filter.filterPermissions(ticket, permInfo);
            }
            catch (IOException e) {
                HDLogger.error(e);
            }
        }
        return permInfo;
    }

    private UserAccount getCurrentUserAccountOrThrow() throws ServerDataException {
        UserAccount account = UserManager.getInstance().getCurrentUserAccount();
        if (account == null) {
            throw new ServerDataException(new IllegalStateException("No user is logged in."));
        }
        return account;
    }

    @Override
    public SenderInformation getSenderInformation(Ticket ticket) throws ServerDataException {
        List<TicketEmailSenderInformation> senders = TicketManager.getReader().getSenderInformationForTicket(ticket.getId());
        return new SenderInformation(senders);
    }

    @Nonnull
    private String[] convertMailsToAddressArray(String mailString) {
        if (mailString != null && mailString.length() > 0) {
            if (mailString.indexOf(59) > -1) {
                StringTokenizer emailTokens = new StringTokenizer(mailString, ";");
                Vector<String> allAdresses = new Vector<String>();
                while (emailTokens.hasMoreTokens()) {
                    allAdresses.addElement(emailTokens.nextToken().trim());
                }
                if (allAdresses.size() > 0) {
                    return allAdresses.toArray(new String[allAdresses.size()]);
                }
            } else {
                mailString = mailString.trim();
                return new String[]{mailString};
            }
        }
        return new String[0];
    }

    private EmailAccountList getMailAccounts() throws ServerDataException {
        return (EmailAccountList)EmailReader_Main.MAIL_ACCOUNTS.get();
    }

    @Override
    public ArrayList<User> getReceivers(Ticket ticket, TicketDataConnector.RECEIVERTYP receiverType, boolean answerAll) throws ServerDataException {
        String email;
        Integer resourceIDValue;
        int resourceId;
        UserGroupInfo res;
        EmailAccountList mailAccounts;
        ArrayList<User> receivers = new ArrayList<User>();
        List adders = this.spm.get(EmailReceiverAdder.class);
        for (EmailReceiverAdder adder : adders) {
            adder.addReceivers(receivers, ticket, receiverType.ordinal(), answerAll);
        }
        if (receiverType == TicketDataConnector.RECEIVERTYP.CC && !answerAll) {
            return receivers;
        }
        if (ServerOptions.isOptionSet(524288)) {
            return receivers;
        }
        HashSet<String> usedAddresses = new HashSet<String>();
        User ticketOwner = ticket.getValue(Field.TICKETDATA_OWNER, User.class);
        String[] emails = ticketOwner.getValue(Field.USERDATA_EMAIL, String[].class);
        if (emails != null && emails.length > 0) {
            boolean firstEmailAdded = false;
            for (String firstMail : emails) {
                if (firstMail.isEmpty()) continue;
                usedAddresses.add(firstMail.toLowerCase());
                if (firstEmailAdded) continue;
                firstEmailAdded = true;
                receivers.add(ticketOwner);
            }
        }
        if (!answerAll) {
            return receivers;
        }
        List<ReaStepEmailAddresses> reaStepReceivers = ticketReader.getReaStepEmailAddresses(ticket.getId());
        for (ReaStepEmailAddresses receiver : reaStepReceivers) {
            if (receiverType == TicketDataConnector.RECEIVERTYP.TO || receiverType == TicketDataConnector.RECEIVERTYP.ALL) {
                this.checkAndAddEmailAddresses(receivers, usedAddresses, receiver.getEmailIn());
                this.checkAndAddEmailAddresses(receivers, usedAddresses, receiver.getEmailAn());
                continue;
            }
            if (receiverType != TicketDataConnector.RECEIVERTYP.CC && receiverType != TicketDataConnector.RECEIVERTYP.ALL) continue;
            this.checkAndAddEmailAddresses(receivers, usedAddresses, receiver.getEmailCC());
        }
        ArrayList<String> blockedList = new ArrayList<String>();
        String blockedMails = (String)SPERRLIST.get();
        this.addMailList(blockedList, blockedMails);
        UserAccount account = this.getCurrentUserAccountOrThrow();
        User currentUser = UserModelConverter.convertUserAccount(account);
        String[] userEmails = currentUser.getValue(Field.USERDATA_EMAIL, String[].class);
        if (userEmails != null && userEmails.length > 0) {
            for (String supporterMail : userEmails) {
                if (supporterMail == null || supporterMail.trim().length() <= 0) continue;
                blockedList.add(supporterMail.trim().toLowerCase());
            }
        }
        if ((mailAccounts = this.getMailAccounts()) != null && mailAccounts.size() > 0) {
            for (EmailAccount mAccount : mailAccounts) {
                this.addMailList(blockedList, mAccount.getFrom());
            }
        }
        if ((res = HDUsersAndGroups.getResource(resourceId = (resourceIDValue = ticket.getValue(Field.TICKETDATA_RESOURCEID, Integer.class)) == null ? 0 : resourceIDValue)) != null && (email = (String)res.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_EMAIL)) != null && email.length() > 0) {
            User user = new User();
            user.addData(Field.USERDATA_USERNAME, res.getDisplayName());
            user.addData(Field.USERDATA_DISPLAYNAME, res.getDisplayName());
            String[] mails = this.convertMailsToAddressArray(email);
            if (mails != null) {
                for (String mail : mails) {
                    blockedList.add(mail.trim().toLowerCase());
                }
            }
        }
        if (blockedList.size() > 0) {
            receivers = this.filterReceivers(receivers, blockedList, ticketOwner);
        }
        return receivers;
    }

    private void checkAndAddEmailAddresses(ArrayList<User> receivers, HashSet<String> usedAddresses, String emailAddress) throws ServerDataException {
        if (emailAddress != null && emailAddress.length() > 5) {
            String[] adressen;
            for (String currentAddress : adressen = this.convertMailsToAddressArray(emailAddress)) {
                if (currentAddress == null || currentAddress.length() <= 5 || usedAddresses.contains(currentAddress.toLowerCase())) continue;
                User user = this.findUserForEmail(currentAddress);
                if (user == null) {
                    String displayname = currentAddress;
                    String email = currentAddress;
                    String uname = currentAddress;
                    int indexOf = email.indexOf(60);
                    if (indexOf >= 0) {
                        displayname = email.substring(0, indexOf).trim();
                        int lastIndex = email.lastIndexOf(62);
                        if (lastIndex > indexOf) {
                            if (usedAddresses.contains((email = email.substring(indexOf + 1, lastIndex).trim()).toLowerCase())) continue;
                            user = this.findUserForEmail(email);
                        }
                    }
                    if ((indexOf = email.indexOf(64)) > 0) {
                        uname = email.substring(0, indexOf);
                        if (email.equals(displayname)) {
                            displayname = uname;
                        }
                    }
                    if (user == null) {
                        user = new User();
                        user.addData(Field.USERDATA_USERNAME, uname);
                        user.addData(Field.USERDATA_DISPLAYNAME, displayname);
                        user.addData(Field.USERDATA_EMAIL, new String[]{email});
                        usedAddresses.add(email.toLowerCase());
                    }
                }
                receivers.add(user);
                usedAddresses.add(currentAddress.toLowerCase());
            }
        }
    }

    private User findUserForEmail(String currentAddress) {
        AndSearchExpression and = new AndSearchExpression();
        SearchCondition emailCond = new SearchCondition("email", SearchCondition.SearchTermOperator.Equals, (Object)currentAddress.toLowerCase());
        SearchCondition validCond = new SearchCondition("active", SearchCondition.SearchTermOperator.Equals, (Object)("" + SearchTagActive.valueAsInt((boolean)true)));
        and.add((SearchExpression)emailCond);
        and.add((SearchExpression)validCond);
        SearchResult results = UserManager.getInstance().search("", (List)and, new ArrayList(), 100, null);
        List resultEntries = results.getEntries();
        if (resultEntries.size() == 0) {
            return null;
        }
        SearchResultEntry userEntry = (SearchResultEntry)resultEntries.get(0);
        UserAccount userAccount = UserManager.getInstance().getUserAccount((GUID)userEntry.getId());
        return UserModelConverter.convertUserAccount(userAccount);
    }

    private ArrayList<User> filterReceivers(ArrayList<User> receivers, List<String> blockedList, User ticketOwner) {
        if (blockedList == null || blockedList.size() == 0) {
            return receivers;
        }
        ArrayList<User> filteredReceivers = new ArrayList<User>();
        for (User emailUser : receivers) {
            String[] emails = emailUser.getValue(Field.USERDATA_EMAIL, String[].class);
            ArrayList<String> filteredMailAddresses = new ArrayList<String>();
            Integer emailUserID = emailUser.getValue(Field.USERDATA_USERID, Integer.class);
            if (ticketOwner != null && emailUserID != null && emailUserID.intValue() == ticketOwner.getUserID()) {
                for (String email : emails) {
                    filteredMailAddresses.add(email);
                }
                if (filteredMailAddresses.size() <= 0) continue;
                emailUser.setData(Field.USERDATA_EMAIL, filteredMailAddresses.toArray(new String[filteredMailAddresses.size()]));
                filteredReceivers.add(emailUser);
                continue;
            }
            for (String email : emails) {
                boolean blocked = false;
                for (String blockedPart : blockedList) {
                    String quotedPattern = Pattern.quote(blockedPart.toLowerCase());
                    quotedPattern = quotedPattern.replace("*", "\\E.*\\Q");
                    if (!email.toLowerCase().matches("^" + quotedPattern + "$")) continue;
                    blocked = true;
                    break;
                }
                if (blocked) continue;
                filteredMailAddresses.add(email);
            }
            if (filteredMailAddresses.size() <= 0) continue;
            emailUser.setData(Field.USERDATA_EMAIL, filteredMailAddresses.toArray(new String[filteredMailAddresses.size()]));
            filteredReceivers.add(emailUser);
        }
        return filteredReceivers;
    }

    private void addMailList(List<String> blockedList, String blockedMails) {
        if (blockedMails != null && blockedMails.length() > 0) {
            String[] parts;
            for (String part : parts = blockedMails.split(";")) {
                if ((part = part.trim()).length() <= 0) continue;
                blockedList.add(part.trim().toLowerCase());
            }
        }
    }

    @Override
    public String getAnswerSignature(Ticket ticket, boolean convertToPlainText, Locale locale) throws ServerDataException {
        String content = null;
        UserAccount currentUser = UserManager.getInstance().getCurrentUserAccount();
        int currentUserID = HDUsersAndGroups.getUserID(currentUser);
        AutoTextManager manager = (AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class);
        List<AutoTextVO> autoTexts = manager.getAllAutoTextsForUser(currentUser.getID(), true);
        ArrayList signatures = new ArrayList();
        autoTexts.forEach(at -> {
            if (at.isEmailSignature()) {
                signatures.add(at);
            }
        });
        List ownSignatured = signatures.stream().filter(at -> at.getUserId() != null && at.getUserId() == currentUserID).collect(Collectors.toList());
        if (ownSignatured.isEmpty()) {
            ownSignatured = signatures;
        }
        if (ownSignatured.size() == 1) {
            content = ((AutoTextVO)ownSignatured.get(0)).getContentText();
            if (content != null) {
                content = this.serverValuesConnector.fillPlaceholders(content, ticket, currentUser, locale);
            }
            if (content != null && convertToPlainText) {
                content = HtmlConverter.html2text((String)content);
            }
        }
        return content;
    }

    @Override
    public ArrayList<Action> getTicketActions(Ticket ticket, boolean includeInternal) throws ServerDataException {
        ArrayList<ActionVO> ticketActionsNEW = ActionManager.getInstance().getActionsForTicket(ticket.getId(), includeInternal);
        return new ArrayList<Action>(ticketActionsNEW.stream().filter(action -> includeInternal || !Action.isOldStyleInternal(action.getId())).map(vo -> {
            int aktId = vo.getId();
            return new Action(aktId, vo.getDisplayValue(), vo.getStatusID(), Action.isSystemStep(aktId), vo.isInternal(), vo.isDeleted(), vo.getSpecial());
        }).collect(Collectors.toList()));
    }

    @Override
    public TicketDataConnector.GroupVersionID getGroupVersion(TicketDataConnector.GroupingParameter grouping, boolean onlyOwnResources, boolean inquiries, int sessionId) throws ServerDataException {
        TicketSearchFilterOptions options = TicketSearchFilterOptions.of(inquiries ? TicketSearchFilterOptions.ONLY_OPEN_INQUIRIES : TicketSearchFilterOptions.ONLY_OPEN_TICKETS).addFieldCondition(new GroupingParameterToSearchCondition(5, grouping.getFirstGroupValue())).withTicketsBundled(!inquiries).withOnlyOwnResources(onlyOwnResources).withNumOfTickets(Integer.MAX_VALUE);
        List<Integer> tickets = ticketReader.searchTicketsForUser(options);
        int maxVersion = 0;
        for (Integer ticketId : tickets) {
            int version = this.getVersionHandler().getTicketVersion(ticketId);
            maxVersion = Math.max(maxVersion, version);
        }
        return new TicketDataConnector.GroupVersionID(maxVersion, tickets.size());
    }

    @Override
    public void editTicket(int ticketId, HashMap<String, String> fields, int sessionId, ArrayList<String> htmlFields, boolean shouldDispatch) throws ServerDataException {
        TicketVO ticket = this.getReaderForSystem().getTicket(ticketId);
        if (ticket == null) {
            throw new ServerDataException(new Exception("Ticket could not be found."));
        }
        TicketManipulator ticketManipulator = TicketManager.getManipulator();
        String previewField = fields.get(Field.TICKETDATA_PREVIEW.name());
        boolean htmlContent = htmlFields != null && htmlFields.contains(Field.TICKETDATA_PREVIEW.name());
        UserAccount currentAccount = this.getCurrentUserAccountOrThrow();
        int currentUserID = HDUsersAndGroups.getUserID(currentAccount);
        MutableTicketData ticketData = this.convertDataMapForMethodEditTicket(ticketId, fields);
        try {
            if (previewField != null) {
                ticketManipulator.updateReaStepText(ticket.getInitialReaStepID(), ReaStepTextVO.of(previewField, htmlContent), ExtensionArguments.create());
            }
            if (shouldDispatch) {
                ticketData.put(Tickets.FIELD_SUBJECT, fields.get(Field.TICKETDATA_SUBJECT.name()));
                ActionVO action = (ActionVO)ActionManager.getInstance().get(5);
                String subject = TicketManipulatorInternal.createSubjectIfMissing(ticketData.get(Tickets.FIELD_SUBJECT), previewField, htmlContent);
                ticketData.put(Tickets.FIELD_SUBJECT, subject);
                MutableReaStepData reaStepData = new MutableReaStepData();
                ExtensionArguments actionExtArgs = ExtensionArguments.create();
                actionExtArgs.put(ExtensionArguments.EXTARG_AUTO_MAIL, this.getAutoMailSettingsFrom(fields));
                ReaStepTextVO text = ReaStepTextVO.empty();
                if ((action.getSpecial() & 2) > 0) {
                    text = ReaStepTextVO.of(LocalizationImpl.getStaticInstance().getTranslation("Escalate_mobile_automessage"), false);
                }
                if (ServerOptions.isOptionSet(0x800000)) {
                    reaStepData.put(ReaStepVO.FIELD_PROCESSING_TIME, ProcessingTime.ofEffort(0));
                }
                ticketManipulator.updateTicketData(ticketId, ticketData);
                ticketManipulator.applyAction(ticketId, reaStepData, text, action, actionExtArgs);
                ServerUtilities.conti.changeInRequest(ticketId, 100, currentUserID, sessionId, 0);
            } else {
                ticketManipulator.updateTicketData(ticketId, ticketData);
            }
        }
        catch (AccessDeniedException | IllegalArgumentException ex) {
            throw new ServerDataException((Exception)ex);
        }
    }

    private TicketDataConnector.MailNotification getAutoMailSettingsFrom(HashMap<String, String> fields) {
        if (fields != null && this.containsValueFor(Field.TICKETDATA_AUTOMAILING, fields)) {
            boolean value = !"0".equals(fields.get(Field.TICKETDATA_AUTOMAILING.name()));
            return value ? TicketDataConnector.MailNotification.ALWAYS : TicketDataConnector.MailNotification.NEVER;
        }
        return TicketDataConnector.MailNotification.SERVERSETTING;
    }

    private boolean containsValueFor(Field field, HashMap<String, String> fields) {
        return fields.get(field.name()) != null;
    }

    private MutableTicketData convertDataMapForMethodEditTicket(int ticketId, HashMap<String, String> fields) {
        String value;
        String value2;
        int prioID;
        MutableTicketData ticketData = new MutableTicketData();
        TicketVO ticket = this.getReaderForSystem().getTicket(ticketId);
        if (this.containsValueFor(Field.TICKETDATA_DUETIME, fields)) {
            int targetTime = Integer.parseInt(fields.get(Field.TICKETDATA_DUETIME.name()));
            if (ticket.getTargetTime() == null || ticket.getTargetTime() != targetTime) {
                ticketData.put(Tickets.FIELD_TARGET_TIME, targetTime);
            }
        }
        HashMap<Field, TicketFieldCustomField> customFieldMap = new HashMap<Field, TicketFieldCustomField>(){
            {
                this.put(Field.TICKETDATA_TICKETFIELD1, Tickets.FIELD_CUSTOM_1);
                this.put(Field.TICKETDATA_TICKETFIELD2, Tickets.FIELD_CUSTOM_2);
                this.put(Field.TICKETDATA_TICKETFIELD3, Tickets.FIELD_CUSTOM_3);
                this.put(Field.TICKETDATA_TICKETFIELD4, Tickets.FIELD_CUSTOM_4);
                this.put(Field.TICKETDATA_TICKETFIELD5, Tickets.FIELD_CUSTOM_5);
                this.put(Field.TICKETDATA_TICKETFIELD6, Tickets.FIELD_CUSTOM_6);
                this.put(Field.TICKETDATA_TICKETFIELD7, Tickets.FIELD_CUSTOM_7);
            }
        };
        for (Field customField : customFieldMap.keySet()) {
            String value3;
            if (!fields.containsKey(customField.name()) || Objects.equals(value3 = fields.get(customField.name()), ticket.getValue((TicketField)((Object)customFieldMap.get((Object)customField))))) continue;
            ticketData.putValidOrDefaultValue((TicketField)((Object)customFieldMap.get((Object)customField)), value3);
        }
        if (this.containsValueFor(Field.TICKETDATA_RESOURCEID, fields)) {
            UserGroupInfo res;
            GUID resUUID = null;
            int value4 = Integer.parseInt(fields.get(Field.TICKETDATA_RESOURCEID.name()));
            if (value4 > 0 && (res = HDUsersAndGroups.getResource(value4)) != null) {
                resUUID = res.getID();
            }
            if (!Objects.equals(resUUID, ticket.getResourceID())) {
                ticketData.put(Tickets.FIELD_RESOURCE_GUID, resUUID);
            }
        }
        if (this.containsValueFor(Field.TICKETDATA_PRIORITYID, fields) && (prioID = Integer.parseInt(fields.get(Field.TICKETDATA_PRIORITYID.name()))) != ticket.getPriorityID()) {
            ticketData.put(Tickets.FIELD_PRIORITY_ID, prioID);
        }
        if (fields.containsKey(Field.TICKETDATA_SUBJECT.name()) && !Objects.equals(value2 = fields.get(Field.TICKETDATA_SUBJECT.name()), ticket.getSubject())) {
            ticketData.putValidOrDefaultValue(Tickets.FIELD_SUBJECT, value2);
        }
        if (this.containsValueFor(Field.TICKETDATA_DEADLINE, fields)) {
            long value5 = Long.parseLong(fields.get(Field.TICKETDATA_DEADLINE.name()));
            if (ticket.getDeadline() == null || ticket.getDeadline() != value5) {
                ticketData.put(Tickets.FIELD_DEADLINE, value5);
            }
        }
        if (this.containsValueFor(Field.TICKETDATA_TERMINVEREINBARUNG, fields)) {
            long value6 = Long.parseLong(fields.get(Field.TICKETDATA_TERMINVEREINBARUNG.name()));
            Long terminVereinbarung = ticket.getValue(Tickets.FIELD_TERMINVEREINBARUNG);
            if (terminVereinbarung == null || terminVereinbarung != value6) {
                ticketData.put(Tickets.FIELD_TERMINVEREINBARUNG, value6);
            }
        }
        if (fields.containsKey(Field.TICKETDATA_SPECIALFIELD.name()) && !Objects.equals(value = fields.get(Field.TICKETDATA_SPECIALFIELD.name()), ticket.getIdentifier())) {
            ticketData.put(Tickets.FIELD_IDENTIFIER, value);
        }
        if (this.containsValueFor(Field.TICKETDATA_CLASSIFICATIONID, fields)) {
            int value7 = Integer.parseInt(fields.get(Field.TICKETDATA_CLASSIFICATIONID.name()));
            if (ticket.getClassificationID() != value7) {
                ticketData.put(Tickets.FIELD_CLASSIFICATION_ID, value7);
            }
        }
        if (this.containsValueFor(Field.TICKETDATA_CATEGORYID, fields)) {
            try {
                Integer catID = this.parseCategoryOldAndNew(fields);
                ticketData.put(Tickets.FIELD_CATEGORY_ID, catID);
            }
            catch (ServerDataException e) {
                HDLogger.error(e);
            }
        }
        return ticketData;
    }

    @Override
    public int createStepByApplyingAction(ContextType contextType, int ticketId, Action action, int effortInMinutes, Date dueDate, String bodyText, boolean isHTML, String description, BiConsumer<Ticket, Integer> consumer) throws ServerDataException {
        MutableReaStepData reaStepData = this.generateDataForNewReaStep(ticketId, action, effortInMinutes, dueDate, description);
        ReaStepTextVO text = ReaStepTextVO.of(bodyText, isHTML);
        ExtensionArguments extensionArgs = ExtensionArguments.create();
        if (dueDate != null) {
            extensionArgs.put(ExtensionArguments.EXTARG_APPOINTMENT, dueDate.getTime());
        }
        ActionVO actionVO = ActionManager.getInstance().getActionfromOldAction(ticketId, action);
        try {
            return TicketManager.getManipulator().applyAction(ticketId, reaStepData, text, actionVO, extensionArgs);
        }
        catch (AccessDeniedException | IllegalArgumentException ex) {
            throw new ServerDataException((Exception)ex);
        }
    }

    private MutableReaStepData generateDataForNewReaStep(int ticketId, Action action, int effortInMinutes, Date dueDate, String description) {
        MutableReaStepData reaStepData = new MutableReaStepData();
        ProcessingTime processingTime = ProcessingTime.ofEffort(effortInMinutes);
        reaStepData.put(ReaStepVO.FIELD_PROCESSING_TIME, processingTime);
        reaStepData.put(ReaStepVO.FIELD_DESC, ReaStepVO.FIELD_DESC.getValidOrDefaultValue(description, null));
        return reaStepData;
    }

    @Override
    public void applyAnswer(int ticketId, String receiversTo, String receiversCC, String sender, String subject, String bodyText, boolean htmlContent, int effortInMinutes, int additionalActionId, ExtensionArguments extArgs) throws ServerDataException {
        receiversTo = this.ensureCorrectnessOfEmailAddresses(receiversTo, Tickets.MSG.getMsg("invalidemail.to", new Object[0]) + " ");
        receiversCC = this.ensureCorrectnessOfEmailAddresses(receiversCC, Tickets.MSG.getMsg("invalidemail.cc", new Object[0]) + " ");
        ExtensionArguments.AdditionalEmailAction additionalAction = ExtensionArguments.AdditionalEmailAction.SEND_ONLY;
        if (additionalActionId == 2) {
            additionalAction = ExtensionArguments.AdditionalEmailAction.SEND_AND_CLOSE;
        } else if (additionalActionId != 0) {
            throw new IllegalArgumentException("Cannot execute action after sending: " + additionalActionId);
        }
        MutableReaStepData reaStepData = new MutableReaStepData();
        ProcessingTime processingTime = ProcessingTime.ofEffort(effortInMinutes);
        reaStepData.put(ReaStepVO.FIELD_PROCESSING_TIME, processingTime);
        reaStepData.put(ReaStepVO.FIELD_EMAIL_IN, EmailAddressHelper.get().extractEmailAddress(sender));
        reaStepData.put(ReaStepVO.FIELD_USER_DISPLAY_NAME, EmailAddressHelper.get().extractAlias(sender));
        reaStepData.put(ReaStepVO.FIELD_EMAIL_AN, receiversTo);
        reaStepData.put(ReaStepVO.FIELD_EMAIL_CC, receiversCC);
        reaStepData.put(ReaStepVO.FIELD_EMAIL_BCC, "");
        reaStepData.put(ReaStepVO.FIELD_DESC, subject);
        extArgs.put(ExtensionArguments.EXTARG_APPLY_ANSWER, additionalAction);
        TicketManager.getManipulator().applyAction(ticketId, reaStepData, ReaStepTextVO.of(bodyText, htmlContent), (ActionVO)ActionManager.getInstance().get(-7), extArgs);
    }

    private String ensureCorrectnessOfEmailAddresses(@Nullable String addresses, String prefixForErrorMessage) throws ServerDataException {
        if (addresses != null) {
            try {
                addresses = addresses.replace(',', ';');
                UserDataConnectorImpl.checkEmailReceivers(addresses);
            }
            catch (AddressException ae) {
                throw new ServerDataException(new IllegalArgumentException(prefixForErrorMessage + ae.getMessage()));
            }
        }
        return addresses;
    }

    @Override
    public int executeSearch(int searchID, int searchIn, String searchText, boolean searchInRequest, boolean searchInSubject, boolean searchInComment, boolean searchInEmailAddress, boolean searchInNachname, boolean searchInTicketID, UserAccount ticketOwner, int statusID, int classificationID, Date from, Date to, int[] groupIds) throws ServerDataException {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        return this.executeSearch(userAccount, searchID, searchIn, searchText, searchInRequest, searchInSubject, searchInComment, searchInEmailAddress, searchInNachname, searchInTicketID, ticketOwner, statusID, classificationID, from, to, groupIds);
    }

    private int executeSearch(@Nonnull UserAccount userAccount, int searchID, int searchIn, String searchText, boolean searchInRequest, boolean searchInSubject, boolean searchInComment, boolean searchInEmailAddress, boolean searchInNachname, boolean searchInTicketID, UserAccount ticketOwner, int statusID, int classificationID, Date from, Date to, int[] groupIds) throws ServerDataException {
        if (userAccount == null) {
            throw new ServerDataException(new IllegalArgumentException("The user does not exist."));
        }
        int searchingUserId = HDUsersAndGroups.getUserID(userAccount);
        if (searchID == -1) {
            searchID = searchingUserId;
        }
        searchText = searchText == null ? "" : searchText.trim();
        if ((searchText = searchText.replaceAll("[*%]+", "*")).equals("*")) {
            searchText = "";
        }
        TextSearchParameters params = TextSearchParameters.of(searchIn, searchText, searchInRequest, searchInSubject, searchInComment, searchInEmailAddress, searchInNachname, searchInTicketID);
        TicketSearchFilterOptions.TicketsToFind ticketsToFind = statusID == -1 ? TicketSearchFilterOptions.ONLY_TICKETS : (statusID == 0 ? TicketSearchFilterOptions.ANY : TicketSearchFilterOptions.ONLY_TICKETS_WITH_STATUS(statusID));
        TicketSearchFilterOptions options = TicketSearchFilterOptions.of(ticketsToFind);
        if (ticketOwner != null) {
            options.addFieldCondition(new GroupingParameterToSearchCondition(13, ticketOwner.getID()));
        }
        if (classificationID != -1) {
            options.addFieldCondition(new GroupingParameterToSearchCondition(3, classificationID));
        }
        options.withDateBetween(from == null ? null : Long.valueOf(from.getTime()), to == null ? null : Long.valueOf(to.getTime()));
        if (groupIds != null) {
            options.addFieldCondition(new GroupingParameterToSearchCondition(6, groupIds));
        }
        options.withOnlyOwnResources(false).withHideWiedervorlageTicketsAsConfigured(false).withTicketsBundled(false).withNumOfTickets(-1);
        List<Integer> tickets = ticketReader.searchTicketsForUser(options, params);
        OldApiAdapter.writeSearchTicketsToDB(tickets, searchID);
        return searchID;
    }

    private void removeTicketsByResourceAndStatus(List<TicketVO> tickets, UserAccount userAccount) {
        int[] requestedResources = ServerUtilities.getOpenOrderController().getResources(HDUsersAndGroups.getUserID(userAccount), true);
        Iterator<TicketVO> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            int resID;
            UserGroupInfo res;
            TicketVO ticketVO = iterator.next();
            int status = ticketVO.getStatusID();
            Integer resIdValue = null;
            GUID resUUID = ticketVO.getResourceID();
            if (resUUID != null && (res = UserGroupManager.getInstance().getGroup(resUUID)) != null) {
                resIdValue = (Integer)res.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID);
            }
            int n = resID = resIdValue == null ? -1 : resIdValue;
            if ((status == 0 || resID == -1) && HDUsersAndGroups.isDispatcher(userAccount) || OpenOrderController.orderAvailable(requestedResources, status, resID)) continue;
            iterator.remove();
        }
    }

    @Override
    public TicketDataConnector.SearchResultInfo getSearchedTicketsSync(ContextType contextType, UserAccount searchingUser, int searchID, int[] groupIds, int maxNumberOfResults, Sorting sorting, Map<Integer, Integer> knownTickets, int numberOfTickets, List<Integer> idsOfTicketsToBeIncludedInResult) throws ServerDataException {
        List<Integer> ticketsOfSearch = OldApiAdapter.getSearchedTickets(HDUsersAndGroups.getUserID(searchingUser), searchID);
        List<TicketVO> tickets = this.getReaderForSystem().getTickets(ticketsOfSearch);
        this.removeTicketsByResourceAndStatus(tickets, searchingUser);
        int size = tickets.size();
        if (idsOfTicketsToBeIncludedInResult != null) {
            tickets.removeIf(t -> !idsOfTicketsToBeIncludedInResult.contains(t.getID()));
        }
        this.sortCachedTickets(tickets, sorting);
        List<Ticket> result = this.generateTicketsFillOnlyNewOrChangedOnes(tickets, numberOfTickets, knownTickets, contextType);
        return new TicketDataConnector.SearchResultInfo(new ArrayList<Ticket>(result), size);
    }

    @Override
    public void logIntoTicket(int ticketId, int sessionId) throws ServerDataException {
        UserAccount currentAccount = this.getCurrentUserAccountOrThrow();
        UserSession userSession = OldApiAdapter.aktualisiereUserSessionInMetaController(sessionId, currentAccount);
        userSession.setHdMobile(true);
        if (ServerUtilities.getOpenOrderController().getAuftrag(ticketId) == null) {
            this.logOutFromTicket(sessionId, new int[0]);
            return;
        }
        this.ticketAccessCtrl.handleOpenedOrders(userSession, new int[]{ticketId}, null);
    }

    @Override
    public void logOutFromTicket(int sessionId, int ... ticketIDs) throws ServerDataException {
        UserAccount currentAccount = this.getCurrentUserAccountOrThrow();
        UserSession userSession = OldApiAdapter.aktualisiereUserSessionInMetaController(sessionId, currentAccount);
        this.ticketAccessCtrl.handleOpenedOrders(userSession, ticketIDs, null);
    }

    @Override
    public ArrayList<UserAccount> getUsersInTicket(int ticketId) {
        return this.ticketAccessCtrl.getUsersInTicket(ticketId);
    }

    @Override
    public void changeTicketStatus(int ticketId, int state, int mailingAction, TicketDataConnector.MailNotification mailNotification) throws ServerDataException {
        if (state == 103) {
            TicketManager.getManipulator().changeTicketStatusToRead(ticketId);
        } else if (state == 100) {
            TicketManager.getManipulator().changeTicketStatusToUnread(ticketId);
        } else {
            throw new UnsupportedOperationException("method can be used only in order to change ticket's status to read or unread. State is " + state);
        }
    }

    @Override
    public void escalateTicket(int ticketId, int newResource) throws ServerDataException {
        boolean changeTicketStatus = true;
        UserGroupInfo targetResource = HDUsersAndGroups.getResource(newResource);
        if (targetResource == null) {
            throw new IllegalStateException(String.format("Resource with ID \"%d\" does not exist.", newResource));
        }
        ReaStepTextVO text = ReaStepTextVO.empty();
        ActionVO escalate = (ActionVO)ActionManager.getInstance().get(8);
        if ((escalate.getSpecial() & 2) > 0) {
            text = ReaStepTextVO.of(LocalizationImpl.getStaticInstance().getTranslation("Escalate_mobile_automessage"), false);
        }
        try {
            TicketManager.getManipulator().escalateTicket(ticketId, targetResource.getID(), text, changeTicketStatus);
        }
        catch (AccessDeniedException | IllegalArgumentException ex) {
            throw new ServerDataException((Exception)ex);
        }
    }

    @Override
    public Ticket createNewTicket(ContextType contextType, UserAccount supporter, int targetUserId, HashMap<String, String> fields, ArrayList<String> htmlFields, boolean shouldDispatch, ExtensionArguments extensionArgs) throws ServerDataException {
        return this.createNewTicket(contextType, supporter, HDUsersAndGroups.getUserAccount(targetUserId), fields, htmlFields, shouldDispatch, extensionArgs);
    }

    @Override
    public Ticket createNewTicket(ContextType contextType, UserAccount supporter, UserAccount targetUser, HashMap<String, String> fields, ArrayList<String> htmlFields, boolean shouldDispatch, ExtensionArguments extensionArgs) throws ServerDataException {
        if (supporter == null) {
            throw new ServerDataException(new IllegalArgumentException("No valid supporter provided!"));
        }
        if (extensionArgs == null) {
            extensionArgs = ExtensionArguments.create();
        }
        targetUser = this.findOwnerAccountOrThrow(targetUser, fields);
        boolean htmlContent = htmlFields != null && htmlFields.contains(Field.TICKETDATA_PREVIEW.name());
        MutableTicketData ticketData = this.createMutableDataForNewTicket(contextType, supporter, targetUser, fields, htmlContent, shouldDispatch);
        if (shouldDispatch) {
            if (contextType != ContextType.enduser) {
                extensionArgs.put(ExtensionArguments.EXTARG_AUTO_MAIL, this.getAutoMailSettingsFrom(fields));
            }
            extensionArgs.put(ExtensionArguments.EXTARG_DISPATCH_NOW, ExtensionArguments.DispatchNow.ALWAYS);
        }
        String emailEingang = null;
        ReaStepTextVO ticketText = ReaStepTextVO.of(fields.get(Field.TICKETDATA_PREVIEW.name()), htmlContent);
        try {
            TicketVO ticketVO = TicketManager.getManipulator().createTicket(ticketText, ticketData, emailEingang, extensionArgs);
            return this.cachedTicketToTicket(ticketVO, true);
        }
        catch (AccessDeniedException | IllegalArgumentException missingFields) {
            throw new ServerDataException((Exception)missingFields);
        }
    }

    private MutableTicketData createMutableDataForNewTicket(ContextType contextType, UserAccount supporter, UserAccount targetUser, HashMap<String, String> fields, boolean htmlContent, boolean shouldDispatch) throws ServerDataException {
        String terminVereinbarungField;
        Long terminVereinbarung;
        Long deadline;
        String previewField = fields.get(Field.TICKETDATA_PREVIEW.name());
        String subjectField = TicketManipulatorInternal.createSubjectIfMissing(fields.get(Field.TICKETDATA_SUBJECT.name()), previewField, htmlContent);
        if (shouldDispatch) {
            boolean missingSubjectAndBody;
            boolean bl = missingSubjectAndBody = !(subjectField != null && !subjectField.isEmpty() || previewField != null && !previewField.isEmpty());
            if (missingSubjectAndBody) {
                throw new ServerDataException(new IllegalArgumentException("The subject or the body text has to be set when dispatching an inquiry."));
            }
        }
        Map<Integer, FieldSetting> fieldSettings = this.serverDataConnector.getFieldSettings();
        int resID = this.getIdFromField(Field.TICKETDATA_RESOURCEID, contextType, supporter, targetUser, fields, fieldSettings);
        int priID = this.getIdFromField(Field.TICKETDATA_PRIORITYID, contextType, supporter, targetUser, fields, fieldSettings);
        int klaID = this.getIdFromField(Field.TICKETDATA_CLASSIFICATIONID, contextType, supporter, targetUser, fields, fieldSettings);
        int itiID = this.getItilID(fields, targetUser, supporter, fieldSettings);
        String spezFeld = fields.get(Field.TICKETDATA_SPECIALFIELD.name());
        if (spezFeld == null) {
            Entry defaultValue = this.serverValuesConnector.getDefaultValue(Field.TICKETDATA_SPECIALFIELD, 0, targetUser, supporter, contextType, ActionType.createInquiry, fieldSettings);
            spezFeld = defaultValue != null ? defaultValue.getStringKey() : "";
        }
        MutableTicketData data = new MutableTicketData();
        data.put(Tickets.FIELD_RESOURCE_GUID, HDUsersAndGroups.getResourceGroupUUID(resID));
        data.put(Tickets.FIELD_PRIORITY_ID, priID);
        data.put(Tickets.FIELD_CLASSIFICATION_ID, klaID);
        data.put(Tickets.FIELD_ITIL_ID, itiID);
        if (this.containsValueFor(Field.TICKETDATA_DUETIME, fields)) {
            int targetTime = Integer.parseInt(fields.get(Field.TICKETDATA_DUETIME.name()));
            data.put(Tickets.FIELD_TARGET_TIME, targetTime);
        }
        data.putValidOrDefaultValue(Tickets.FIELD_SUBJECT, subjectField);
        data.putValidOrDefaultValue(Tickets.FIELD_IDENTIFIER, spezFeld);
        Integer catID = this.parseCategoryOldAndNew(fields);
        data.putValidOrDefaultValue(Tickets.FIELD_CATEGORY_ID, catID);
        data.putValidOrDefaultValue(Tickets.FIELD_CUSTOM_1, fields.get(Field.TICKETDATA_TICKETFIELD1.name()));
        data.putValidOrDefaultValue(Tickets.FIELD_CUSTOM_2, fields.get(Field.TICKETDATA_TICKETFIELD2.name()));
        data.putValidOrDefaultValue(Tickets.FIELD_CUSTOM_3, fields.get(Field.TICKETDATA_TICKETFIELD3.name()));
        data.putValidOrDefaultValue(Tickets.FIELD_CUSTOM_4, fields.get(Field.TICKETDATA_TICKETFIELD4.name()));
        data.put(Tickets.FIELD_OWNER_GUID, targetUser.getID());
        String deadlineField = fields.get(Field.TICKETDATA_DEADLINE.name());
        Long l = deadline = deadlineField != null ? Long.valueOf(Long.parseLong(deadlineField)) : null;
        if (deadline == null) {
            ResourceTimelineManager rtm = ResourceTimelineManager.getInstance();
            Date deadlineTime = rtm.calcDeadline(resID, priID);
            Long l2 = deadline = deadlineTime != null ? Long.valueOf(deadlineTime.getTime()) : null;
        }
        if (deadline != null) {
            data.put(Tickets.FIELD_DEADLINE, deadline);
        }
        Long l3 = terminVereinbarung = (terminVereinbarungField = fields.get(Field.TICKETDATA_TERMINVEREINBARUNG.name())) != null ? Long.valueOf(Long.parseLong(terminVereinbarungField)) : null;
        if (terminVereinbarung != null) {
            data.put(Tickets.FIELD_TERMINVEREINBARUNG, terminVereinbarung);
        }
        return data;
    }

    private Integer parseCategoryOldAndNew(HashMap<String, String> fields) throws ServerDataException {
        String catName;
        Integer catID = this.parseIntIfNotEmpty(fields.get(Field.TICKETDATA_CATEGORYID.name()));
        if (catID != null && catID == 0) {
            catID = null;
        }
        if (catID == null && (catName = fields.get(Field.TICKETDATA_CATEGORY.name())) != null && !catName.isEmpty()) {
            CategoryVO category = CategoryManager.getInstance().getCategoryByPath(catName);
            if (category == null) {
                throw new ServerDataException("Category does not exist: " + catName, null);
            }
            catID = category.getId();
        }
        return catID;
    }

    private int getItilID(Map<String, String> fields, UserAccount targetUser, UserAccount supporter, Map<Integer, FieldSetting> fieldSettings) throws ServerDataException {
        String itilField = fields.get(Field.TICKETDATA_ITILID.name());
        if (itilField != null) {
            return Integer.parseInt(itilField);
        }
        Entry defaultValue = this.serverValuesConnector.getDefaultValue(Field.TICKETDATA_ITILID, 0, targetUser, supporter, ContextType.supporter, ActionType.createInquiry, fieldSettings);
        if (defaultValue != null) {
            return defaultValue.getId();
        }
        return 0;
    }

    private int getIdFromField(Field field, ContextType contextType, UserAccount supporter, UserAccount targetUser, Map<String, String> fields, Map<Integer, FieldSetting> fieldSettings) throws ServerDataException {
        String fieldValue = fields.get(field.name());
        int id = 0;
        if (fieldValue == null) {
            Entry defaultValue = this.serverValuesConnector.getDefaultValue(field, 0, targetUser, supporter, contextType, ActionType.createInquiry, fieldSettings);
            if (defaultValue != null) {
                id = defaultValue.getId();
            }
        } else {
            id = Integer.parseInt(fieldValue);
        }
        return id;
    }

    private Integer parseIntIfNotEmpty(String value) {
        return StringFunctions.isEmpty((String)value) ? null : Integer.valueOf(Integer.parseInt(value));
    }

    private UserAccount findOwnerAccountOrThrow(UserAccount ticketOwner, Map<String, String> fields) throws ServerDataException {
        if (ticketOwner == null) {
            String userIdStr = fields.get(Field.USERDATA_USERID.name());
            int usrID = 0;
            try {
                usrID = Integer.parseInt(userIdStr);
            }
            catch (NumberFormatException ex) {
                throw new ServerDataException(new IllegalArgumentException("An owner for the ticket is required!"));
            }
            ticketOwner = HDUsersAndGroups.getUserAccount(usrID);
            if (ticketOwner == null) {
                throw new ServerDataException(new IllegalArgumentException("A valid owner for the ticket is required!"));
            }
        }
        return ticketOwner;
    }

    @Override
    public void updateReaStepContent(int ticketId, int stepId, String text) throws ServerDataException {
        boolean htmlContent = true;
        try {
            int createdreastep = TicketManager.getManipulator().updateReaStepText(stepId, ReaStepTextVO.of(text, htmlContent), ExtensionArguments.create());
            if (createdreastep == 0) {
                throw new ServerDataException(new IllegalArgumentException("The ticket with id " + ticketId + " could not be updated. Please ensure that the ticket exists."));
            }
        }
        catch (AccessDeniedException | IllegalArgumentException ex) {
            throw new ServerDataException((Exception)ex);
        }
    }

    public TicketEventListener getTicketEventListener() {
        return this.getVersionHandler();
    }

    private VersionHandler getVersionHandler() {
        if (this.versionHandler == null) {
            this.versionHandler = new VersionHandler();
        }
        return this.versionHandler;
    }

    private class VersionHandler
    implements TicketEventListener {
        private IntObjectHashMap<Long> checkedVersions = new IntObjectHashMap();

        private VersionHandler() {
        }

        @Override
        public void handleEvent(TicketEvent event) {
            for (ChangedTicketVO changed : event.getChangedTickets()) {
                this.checkedVersions.put(changed.getTicketID(), (Long)System.currentTimeMillis());
            }
        }

        private int getTicketVersion(int ticketId) {
            Long value = this.checkedVersions.get(ticketId);
            if (value != null) {
                return (int)(value / 1000L);
            }
            return 0;
        }
    }
}

