/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.theme;

import com.inet.lib.util.IOFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.theme.ReflectionThemeService;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import javax.servlet.http.HttpServletResponse;

public class HelpDeskThemeService
extends ReflectionThemeService {
    private static final String THEME_APP_KEY = "helpdesk";
    private static HelpDeskThemeService instance;

    private HelpDeskThemeService(String appKey) throws Throwable {
        super(appKey, true);
    }

    public static synchronized HelpDeskThemeService getInstance() throws Throwable {
        if (instance == null) {
            instance = new HelpDeskThemeService(THEME_APP_KEY);
        }
        return instance;
    }

    public static void registerResources(ServerPluginManager spm) throws Throwable {
        ClassLoader themeClassloader = ReflectionThemeService.getThemeClassloader();
        Class<?> themeResourceClass = themeClassloader.loadClass("com.inet.shared.plugins.theme.server.ThemeResource");
        Constructor<?> themeResourceConstructor = themeResourceClass.getConstructor(String.class, URL.class);
        URL resource = HelpDeskThemeService.class.getResource("css/helpdesk.less");
        spm.register(themeResourceClass, themeResourceConstructor.newInstance(THEME_APP_KEY, resource));
        URL remoteResource = HelpDeskThemeService.class.getResource("css/helpdeskremote.less");
        spm.register(themeResourceClass, themeResourceConstructor.newInstance("remotegui", remoteResource));
        URL spritesResource = HelpDeskThemeService.class.getResource("css/helpdeskremote_sprites.less");
        spm.register(themeResourceClass, themeResourceConstructor.newInstance("remotegui", spritesResource));
    }

    public boolean serveDefaultTheme(HttpServletResponse response) throws Throwable {
        URL resource = ((Object)((Object)this)).getClass().getResource("css/helpdesk.css");
        try (InputStream resourceStream = resource.openStream();){
            IOFunctions.copyData((InputStream)resourceStream, (OutputStream)response.getOutputStream());
        }
        return true;
    }

    public static boolean serveDefaultCss(HttpServletResponse response) throws Throwable {
        URL resource = HelpDeskThemeService.class.getResource("css/helpdesk.css");
        try (InputStream resourceStream = resource.openStream();){
            IOFunctions.copyData((InputStream)resourceStream, (OutputStream)response.getOutputStream());
        }
        return true;
    }
}

