/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.servlets.rpc.handler;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.UserDataConnector;
import com.inet.helpdesk.core.servlets.rpc.AbstractPacketHandler;
import com.inet.helpdesk.servlets.rpc.handler.UserResponseCreator;
import com.inet.helpdesk.shared.search.rpc.UserListRequestData;
import com.inet.helpdesk.shared.search.rpc.UserSearchResponse;
import com.inet.http.servlet.SessionStore;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.SearchID;
import com.inet.usersandgroups.user.search.SearchTagUserPermissions;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class UserSearchHandler
extends AbstractPacketHandler<UserListRequestData, UserSearchResponse> {
    private final ServerPluginManager pluginManager;
    private final UserResponseCreator responseCreator;
    private UserDataConnector dataConnector;

    public UserSearchHandler(ServerPluginManager pluginManager, UserResponseCreator responseCreator) {
        this.pluginManager = pluginManager;
        this.responseCreator = responseCreator;
    }

    @Override
    public String getCommand() {
        return "usersearch";
    }

    @Override
    public UserSearchResponse handle(HttpServletRequest request, UserListRequestData input) {
        try {
            if (this.dataConnector == null) {
                this.dataConnector = (UserDataConnector)this.pluginManager.getSingleInstance(UserDataConnector.class);
            }
            return this.responseCreator.createWithFactory((currentUserAccount, locale) -> {
                HttpSession session = SessionStore.getHttpSession();
                SearchTagUserPermissions.DO_NOT_INCLUDE_IN_TEXT_SEARCH.set((Object)true);
                return this.dataConnector.getUserSearchResult(currentUserAccount, UserDataConnector.PREFIX_THAT_MATCHES_ACTIVE_USERS + input.getRequest(), input.getMaxResults(), locale.getLanguage(), input.getBoostingConditions(), input.requestEmailAddresses(), session == null ? null : new SearchID((Object)session.getId()));
            });
        }
        catch (Exception ex) {
            HDLogger.error(ex);
            return null;
        }
    }
}

