/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.server.tickets;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.util.List;

public class SetTicketReadAfterAccess {
    public static void setTicketReadIfReadAccessedBySupporter(int ticketId, List<GUID> usersWithReadAccess) {
        GUID accessor;
        TicketVO ticket = TicketManager.getReaderForSystem().getTicket(ticketId);
        if ((ticket.getStatusID() == 100 || ticket.getStatusID() == 101) && (accessor = SetTicketReadAfterAccess.anySessionReaderHasWritePermissions(ticket, usersWithReadAccess)) != null) {
            try (UserAccountScope scope = UserAccountScope.create((GUID)accessor);){
                TicketManager.getManipulator().changeTicketStatusToRead(ticket.getID());
            }
        }
    }

    private static GUID anySessionReaderHasWritePermissions(TicketVO ticket, List<GUID> usersWithReadAccess) {
        for (GUID user : usersWithReadAccess) {
            UserAccountScope scope = UserAccountScope.create((GUID)user);
            try {
                TicketPermissionContext ticketPermissionInfo = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket.getID());
                if (ticketPermissionInfo == null || ticketPermissionInfo.getSupporterPermissions() != TicketPermissionContext.SupporterPermission.READWRITE) continue;
                GUID gUID = user;
                return gUID;
            }
            finally {
                if (scope == null) continue;
                scope.close();
            }
        }
        return null;
    }
}

