/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.search.user.tokenmatchers;

import com.inet.id.GUID;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.ConditionTokenMatcher;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.user.search.SearchTagActive;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class UserConditionTokenMatcher
implements ConditionTokenMatcher {
    @Nonnull
    public SearchExpression createSearchExpression(@Nonnull String value) {
        SearchCondition activeUsersCondition = new SearchCondition("active", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagActive.valueAsString((boolean)true));
        Set<GUID> accountIDs = this.getAccountIDs(value);
        if (accountIDs == null) {
            return activeUsersCondition;
        }
        OrSearchExpression condition = new OrSearchExpression();
        for (GUID accountID : accountIDs) {
            condition.add((Object)new SearchCondition("useraccountid", SearchCondition.SearchTermOperator.Equals, (Object)accountID.toString()));
        }
        AndSearchExpression searchExpression = new AndSearchExpression();
        searchExpression.add((SearchExpression)condition);
        searchExpression.add((SearchExpression)activeUsersCondition);
        return searchExpression;
    }

    @Nullable
    abstract Set<GUID> getAccountIDs(@Nonnull String var1);
}

