/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.reporting.server;

import com.inet.http.PluginServlet;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.fs.ResourceFile;
import com.inet.shared.servlet.ServletUtils;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class ViewerPluginServlet
implements PluginServlet {
    static final String PLUGIN_ID = "reporting";

    ViewerPluginServlet() {
    }

    @Nonnull
    public String getPathSpec() {
        return "/viewer";
    }

    public void init(ServletConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pluginContentPath = this.extractPluginContentPathFrom(request);
        if (this.isPluginContentPathValid(pluginContentPath)) {
            this.sendPluginContent(pluginContentPath, request, response);
        } else {
            ServletUtils.sendFileNotExist((HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    private String extractPluginContentPathFrom(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo != null && pathInfo.startsWith("/")) {
            pathInfo = pathInfo.substring(1);
        }
        return pathInfo;
    }

    private boolean isPluginContentPathValid(String pluginContentPath) {
        return pluginContentPath != null && !pluginContentPath.trim().isEmpty() && !pluginContentPath.startsWith("/");
    }

    private void sendPluginContent(String pluginContentPath, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServerPluginManager manager = ServerPluginManager.getInstance();
        ResourceFile file = manager.getPluginFile(PLUGIN_ID, pluginContentPath);
        if (file != null) {
            ServletUtils.sendStaticContent((ResourceFile)file, (HttpServletRequest)request, (HttpServletResponse)response);
        } else {
            ServletUtils.sendFileNotExist((HttpServletRequest)request, (HttpServletResponse)response);
        }
    }
}

