/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.reporting.server;

import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.plugins.reporting.server.valueprovider.ProviderManager;
import com.inet.report.DatabaseReportData;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.DynamicValueProvider;
import com.inet.report.Engine;
import com.inet.report.Fields;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.cache.EngineFactoryImpl;
import java.sql.SQLException;
import java.util.Properties;

public class HdEngineFactory
extends EngineFactoryImpl {
    private final ConnectionFactory connFactory;

    HdEngineFactory(ConnectionFactory connFactory) {
        this.connFactory = connFactory;
    }

    Engine createDefaultEngine(Properties props) throws ReportException {
        return super.createEngine(props);
    }

    public Engine createEngine(Properties props) throws ReportException {
        try {
            Engine eng = this.createDefaultEngine(props);
            Fields fields = eng.getFields();
            for (int i = 0; i < fields.getPromptFieldsCount(); ++i) {
                PromptField pf = fields.getPromptField(i);
                DynamicValueProvider dvp = ProviderManager.getInstance().getProviderInstanceForName(pf.getPlaceholderName());
                if (dvp == null) continue;
                pf.setDefaultValueProvider(dvp);
            }
            boolean mainHasHdConnection = this.setupDatasource(eng);
            if (!mainHasHdConnection) {
                int srCount = eng.getSubReportCount();
                for (int i = 0; i < srCount; ++i) {
                    this.setupDatasource(eng.getSubReport(i));
                }
            }
            return eng;
        }
        catch (SQLException ex) {
            throw ReportExceptionFactory.createReportExceptionWithCause((Throwable)ex);
        }
    }

    public boolean setupDatasource(Engine eng) throws ReportException, SQLException {
        DatabaseTables tables = eng.getDatabaseTables();
        int count = tables.getDatasourceCount();
        boolean hasOtherDS = false;
        boolean hasConn = false;
        String detailInfo = null;
        Configuration config = ConfigurationManager.getInstance().getCurrent();
        for (int i = 0; i < count; ++i) {
            Datasource ds = tables.getDatasource(i);
            if ("HelpDesk".equalsIgnoreCase(ds.getDataSourceConfigurationName()) || config.getName().equalsIgnoreCase(ds.getDataSourceConfigurationName())) {
                ds.setConnection(this.connFactory.getConnection());
                hasConn = true;
                continue;
            }
            if (ds.getDataFactory() instanceof DatabaseReportData) continue;
            hasOtherDS = true;
            detailInfo = ds.getDataSourceConfigurationName() + " with " + ds.getHost();
        }
        if (!hasConn && hasOtherDS) {
            throw new ReportException("Only reports which contain the datasource 'HelpDesk' (or '" + config.getName() + "') can be executed. Additional data sources are allowed. (" + detailInfo + ")", 0);
        }
        return hasConn;
    }
}

