/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.mail.reader;

import com.inet.helpdesk.config.EmailAccount;
import com.inet.notification.NotificationGenerator;
import com.inet.notification.NotificationManager;
import srv.ServerUtilities;
import srv.mail.MailConnectionErrorNotification;
import srv.mail.MailErrorHandler;

public class EmailReader_ErrorHandler {
    public void connectFailed(EmailAccount account, String errorMessage) {
        boolean wasAlreadyErrorOnce;
        boolean bl = wasAlreadyErrorOnce = account.getErrorMessage() != null && account.getErrorMessage().length() > 0;
        if (wasAlreadyErrorOnce) {
            NotificationManager.getInstance().registerGenerator((NotificationGenerator)new MailConnectionErrorNotification(account, errorMessage));
        }
    }

    public void stopHangingMail(EmailAccount emailAccount, String errorMessage) {
        new Thread(() -> new MailErrorHandler(emailAccount.getAccount(), errorMessage, ServerUtilities.conti.getCurrentConnectedSessions(), emailAccount.getResID())).start();
    }

    public void readMailFailed(EmailAccount emailAccount, String errorMessage) {
        new Thread(() -> new MailErrorHandler(emailAccount.getAccount(), errorMessage, ServerUtilities.conti.getCurrentConnectedSessions(), emailAccount.getResID())).start();
    }

    public void unexpectedReadError(EmailAccount emailAccount, String message) {
        new Thread(() -> new MailErrorHandler(emailAccount.getAccount(), message, ServerUtilities.conti.getCurrentConnectedSessions(), emailAccount.getResID())).start();
    }
}

