/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data.valueprovider;

import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.model.general.Entry;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.data.ServerDataConnectorImpl;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class OrderFieldValuesProvider
implements ServerValuesConnector.ValueProvider {
    private int myId;
    private final Field field;

    public OrderFieldValuesProvider(Field field) {
        this.field = field;
    }

    @Override
    public String getFieldKey() {
        return this.field.name();
    }

    @Override
    public void notifyRegisteredId(int yourId) {
        this.myId = yourId;
    }

    @Override
    public ArrayList<Entry> getData(UserAccount account, boolean emptyValue) throws ServerDataException {
        ArrayList<Entry> result;
        ResultSet rs;
        PreparedStatement stm;
        Connection con;
        block6: {
            ServerPluginManager spm = ServerPluginManager.getInstance();
            ConnectionFactory connectionFactory = (ConnectionFactory)spm.getSingleInstance(ConnectionFactory.class);
            con = null;
            stm = null;
            rs = null;
            result = new ArrayList<Entry>();
            if (emptyValue) {
                result.add(new Entry(this.myId, "".hashCode(), "", ""));
            }
            try {
                con = connectionFactory.getConnection();
                stm = con.prepareStatement("SELECT Beschreibung FROM tblSettings WHERE SetID=?");
                stm.setInt(1, this.field.getLanguageSetID());
                rs = stm.executeQuery();
                if (!rs.next()) break block6;
                boolean isSupporter = SystemPermissionChecker.hasAnyPermission((UserAccount)account, (Permission[])new Permission[]{HdPermissions.DISPATCHER, HdPermissions.TICKET_RESOURCES_READ, HdPermissions.TICKET_RESOURCES_READ_WRITE}) || HDUsersAndGroups.isResourceMember(account);
                result.addAll(this.getResourceFromSetting(rs.getString(1), isSupporter));
                if (this.field != Field.TICKETDATA_TICKETFIELD3) break block6;
                rs.close();
                stm.close();
                stm = con.prepareStatement("SELECT Werte FROM tblGebaeude WHERE GebID=?");
                stm.setInt(1, (Integer)account.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID));
                rs = stm.executeQuery();
                if (rs.next()) {
                    result.addAll(this.getResourceFromSetting(rs.getString(1), isSupporter));
                }
            }
            catch (SQLException e) {
                try {
                    throw new ServerDataException(e);
                }
                catch (Throwable throwable) {
                    ServerDataConnectorImpl.closeAll(con, stm, rs);
                    throw throwable;
                }
            }
        }
        ServerDataConnectorImpl.closeAll(con, stm, rs);
        return result.size() > 0 ? result : null;
    }

    private ArrayList<Entry> getResourceFromSetting(String setting, boolean isSupporter) {
        ArrayList<Entry> result = new ArrayList<Entry>();
        if (setting == null) {
            return result;
        }
        for (String part : setting.split("\\n")) {
            if ((!isSupporter || !part.startsWith("*")) && !part.startsWith("#") || (part = part.substring(1)).length() <= 0) continue;
            result.add(new Entry(this.myId, part.hashCode(), part, part));
        }
        return result;
    }

    @Override
    public boolean allowMultipleValues() {
        return false;
    }

    @Override
    public boolean allowCustomValues() {
        return false;
    }

    @Override
    public boolean hasData(UserAccount account) throws ServerDataException {
        ArrayList<Entry> data = this.getData(account, false);
        return data != null;
    }

    @Override
    public Entry getDefaultValue(UserAccount account) {
        return new Entry(this.myId, "".hashCode(), "", "");
    }
}

