/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.data.UserDataConnectorImpl;
import com.inet.helpdesk.search.user.SearchResultsBooster;
import com.inet.helpdesk.shared.search.rpc.UserListEntry;
import com.inet.helpdesk.shared.search.rpc.UserListEntry2;
import com.inet.helpdesk.shared.search.rpc.UserSearchResponse;
import com.inet.helpdesk.shared.util.UtilityFunctions;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class UserSearchResponseCreator {
    private final Function<GUID, UserAccount> userAccountProvider;

    public UserSearchResponseCreator(Function<GUID, UserAccount> userAccountProvider) {
        this.userAccountProvider = userAccountProvider;
    }

    public static void logWarningThatUserSearchIndexAndUserCacheAreOutOfSync(List outOfSyncUserIDs) {
        if (outOfSyncUserIDs == null || outOfSyncUserIDs.isEmpty()) {
            return;
        }
        String optionalEllipsis = "";
        int limitOfLoggedIDs = 10;
        if (outOfSyncUserIDs.size() > limitOfLoggedIDs) {
            outOfSyncUserIDs = outOfSyncUserIDs.subList(0, limitOfLoggedIDs);
            optionalEllipsis = ", ...";
        }
        String ids = outOfSyncUserIDs.toString().replace("[", "").replace("]", "");
        HDLogger.warn("User Search Index and User Cache are out of sync for users with IDs: " + ids + optionalEllipsis);
    }

    public UserSearchResponse prepareResultOfTheRequest(SearchResult<GUID> searchResult, SearchResultsBooster booster, boolean requestEmailAddresses, int maxResults) {
        List entries = searchResult.getEntries();
        booster.boostSearchResultEntry(entries);
        ArrayList<UserListEntry2> result = new ArrayList<UserListEntry2>();
        ArrayList<Object> outOfSyncUserIDs = new ArrayList<Object>();
        for (SearchResultEntry entry : entries) {
            try {
                if (maxResults > 0 && result.size() >= maxResults) break;
                UserListEntry2 userListEntry = this.createUserListEntryFromSearchResultEntry((SearchResultEntry<GUID>)entry, requestEmailAddresses);
                result.add(userListEntry);
            }
            catch (Throwable t) {
                outOfSyncUserIDs.add(entry.getId());
            }
        }
        UserSearchResponseCreator.logWarningThatUserSearchIndexAndUserCacheAreOutOfSync(outOfSyncUserIDs);
        boolean receivedMoreResultEntriesThanLimit = maxResults > 0 && entries.size() > maxResults;
        boolean hadResultEntriesThatAreOutOfSyncWithCache = !receivedMoreResultEntriesThanLimit && result.size() < entries.size();
        boolean partialResult = searchResult.isPartialResult() || receivedMoreResultEntriesThanLimit || hadResultEntriesThatAreOutOfSyncWithCache;
        return new UserSearchResponse(result, partialResult);
    }

    public UserSearchResponse createEmptyUserSearchResponse() {
        return new UserSearchResponse(new ArrayList<UserListEntry2>(), false);
    }

    private UserListEntry2 createUserListEntryFromSearchResultEntry(SearchResultEntry<GUID> entry, boolean requestEmailAddresses) {
        GUID accountID = (GUID)entry.getId();
        UserAccount userAccount = this.userAccountProvider.apply(accountID);
        String userId = "" + HDUsersAndGroups.getUserID(userAccount);
        String userDisplayText = requestEmailAddresses ? this.getUserEmails(userAccount) : this.getDisplayName(userAccount);
        String firstLine = entry.getFirstResultLine();
        String secondLine = entry.getSecondResultLine();
        UserListEntry2 userListEntry = new UserListEntry2(userId, userDisplayText, firstLine, secondLine, UserListEntry.UserListEntryType.User);
        userListEntry.setToolTipText(this.getToolTipText(userAccount));
        return userListEntry;
    }

    private String getDisplayName(UserAccount userAccount) {
        if (userAccount == null) {
            return "";
        }
        return userAccount.getDisplayName();
    }

    public String getToolTipText(UserAccount userAccount) {
        if (userAccount == null) {
            return "";
        }
        String userName = this.getDisplayName(userAccount);
        String lastName = (String)userAccount.getValue((UserField)UsersAndGroups.FIELD_LASTNAME);
        String firstName = (String)userAccount.getValue((UserField)UsersAndGroups.FIELD_FIRSTNAME);
        return UtilityFunctions.getDisplayNameWhichIncludesUserName(userName, lastName, firstName);
    }

    private String getUserEmails(UserAccount userAccount) {
        if (userAccount == null) {
            return "";
        }
        return this.convertEmailsToString(userAccount.getValue((UserField)UsersAndGroups.FIELD_EMAIL));
    }

    public String convertEmailsToString(Object fieldValue) {
        if (fieldValue == null) {
            return "";
        }
        String emailsConvertedToString = UserDataConnectorImpl.getFieldValueAsString(fieldValue);
        return emailsConvertedToString != null ? emailsConvertedToString : "";
    }
}

