/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.servlets.rpc.ProxyPacketHandler;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserGroupVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserGroupVOManager;
import com.inet.helpdesk.shared.communication.UserGroupDataAccess;
import com.inet.helpdesk.shared.model.UserGroupDataSet;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.stream.Collectors;
import srv.ServerUtilities;

public class UserGroupDataAccessImpl
extends ProxyPacketHandler
implements UserGroupDataAccess {
    @Override
    public UserGroupDataSet getUserGroupData(int key) throws IOException {
        UserGroupVO group = (UserGroupVO)UserGroupVOManager.getInstance().get(key);
        if (group == null) {
            return null;
        }
        UserGroupDataSet data = new UserGroupDataSet();
        data.setBgrId(group.getId());
        data.setDeleted(group.isDeleted());
        data.setName(group.getDisplayValue());
        data.setResId(group.getDefaultAuthorisationResource());
        data.setSlaPriority(group.getSLAID());
        return data;
    }

    @Override
    public Map<Integer, String> getAllDisplayNames(boolean onlyActiveEntries) throws IOException {
        return UserGroupVOManager.getInstance().getAll(onlyActiveEntries).stream().collect(Collectors.toMap(g -> g.getId(), FieldVO::getDisplayValue));
    }

    @Override
    public Class<?> getRemoteInterface() {
        return UserGroupDataAccess.class;
    }

    @Override
    public UserGroupDataSet updateUserGroupData(UserGroupDataSet data) throws IOException {
        UserGroupVO group = new UserGroupVO(data.getBgrId(), data.getName(), data.getSlaPriority(), data.getResId(), data.isDeleted());
        try {
            if (group.getId() >= 0) {
                UserGroupVOManager.getInstance().update(group);
            } else {
                data.setBgrId(UserGroupVOManager.getInstance().add(group));
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return data;
    }

    @Override
    public void updateCache() throws IOException {
        try {
            ServerUtilities.conti.setChanged(8, false);
        }
        catch (Exception ex) {
            HDLogger.error(ex);
        }
    }
}

