/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.StatisticsConnector;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.shared.model.user.User;
import com.inet.helpdesk.shared.util.TypespecificIntMap;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.UserModelConverter;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.ArrayList;
import srv.ServerUtilities;
import srv.controller.UserSession;

public class StatisticsConnectorImpl
implements StatisticsConnector {
    @Override
    public ArrayList<User> getLoggedInSupporters() throws ServerDataException {
        ArrayList<User> result = new ArrayList<User>();
        TypespecificIntMap<UserSession> connectedSessions = ServerUtilities.conti.getCurrentConnectedSessions();
        for (UserSession session : connectedSessions.getValueList()) {
            UserAccount user = session.getOwner();
            boolean supporter = SystemPermissionChecker.hasAnyPermission((UserAccount)user, (Permission[])new Permission[]{HdPermissions.DISPATCHER}) || HDUsersAndGroups.isResourceMember(user);
            if (!supporter) continue;
            result.add(UserModelConverter.convertUserAccount(user));
        }
        return result;
    }

    @Override
    public ArrayList<User> getLoggedInEnduser() throws ServerDataException {
        ArrayList<User> result = new ArrayList<User>();
        TypespecificIntMap<UserSession> connectedSessions = ServerUtilities.conti.getCurrentConnectedSessions();
        for (UserSession session : connectedSessions.getValueList()) {
            UserAccount user = session.getOwner();
            boolean enduser = !SystemPermissionChecker.hasAnyPermission((UserAccount)user, (Permission[])new Permission[]{HdPermissions.DISPATCHER}) && !HDUsersAndGroups.isResourceMember(user);
            if (!enduser) continue;
            result.add(UserModelConverter.convertUserAccount(user));
        }
        return result;
    }

    @Override
    public ArrayList<User> getLoggedInDispatcher() throws ServerDataException {
        ArrayList<User> result = new ArrayList<User>();
        TypespecificIntMap<UserSession> connectedSessions = ServerUtilities.conti.getCurrentConnectedSessions();
        for (UserSession session : connectedSessions.getValueList()) {
            UserAccount user = session.getOwner();
            boolean dispatcher = SystemPermissionChecker.hasAnyPermission((UserAccount)user, (Permission[])new Permission[]{HdPermissions.DISPATCHER});
            if (!dispatcher) continue;
            result.add(UserModelConverter.convertUserAccount(user));
        }
        return result;
    }
}

