/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.config.ConfigValue;
import com.inet.editor.HtmlConverter;
import com.inet.error.BaseErrorCode;
import com.inet.error.ErrorCode;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.AdditionalFieldSetting;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.LocalizationBundle;
import com.inet.helpdesk.core.data.ServerDataConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.ServerOptions;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.data.TranslationTextConnector;
import com.inet.helpdesk.core.data.valueprovider.KeyValueQueryValueProvider;
import com.inet.helpdesk.core.model.general.AbstractData;
import com.inet.helpdesk.core.model.general.ActionType;
import com.inet.helpdesk.core.model.general.Entry;
import com.inet.helpdesk.core.model.general.FieldSetting;
import com.inet.helpdesk.core.model.general.Localization;
import com.inet.helpdesk.core.model.general.Sorting;
import com.inet.helpdesk.core.model.resource.Resource;
import com.inet.helpdesk.core.model.ticket.FormField;
import com.inet.helpdesk.core.model.ticket.FormFieldsProvider;
import com.inet.helpdesk.core.model.ticket.Ticket;
import com.inet.helpdesk.core.model.ticket.TicketFieldRemover;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.Deletable;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationManager;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationVO;
import com.inet.helpdesk.core.ticketmanager.fields.devicetype.DeviceTypeManager;
import com.inet.helpdesk.core.ticketmanager.fields.devicetype.DeviceTypeVO;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;
import com.inet.helpdesk.core.ticketmanager.fields.resource.ResourceVO;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusVO;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.data.ServerDataConnectorImpl;
import com.inet.helpdesk.data.TableOptionsIntermediateWriter;
import com.inet.helpdesk.data.valueprovider.CombinedValueProvider;
import com.inet.helpdesk.data.valueprovider.OrderFieldValuesProvider;
import com.inet.helpdesk.data.valueprovider.QueryValueProvider;
import com.inet.helpdesk.data.valueprovider.StaticValueProvider;
import com.inet.helpdesk.shared.model.DataField;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.model.general.ContextType;
import com.inet.helpdesk.shared.model.user.User;
import com.inet.helpdesk.shared.util.TypespecificIntMap;
import com.inet.helpdesk.usersandgroups.HDFieldLocator;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.UserModelConverter;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.awt.Font;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import srv.ServerUtilities;
import srv.controller.DispatcherFetcher;
import srv.controller.Fetcher;
import srv.controller.OpenOrderController;
import srv.controller.ticket.Auftrag;
import srv.controller.ticket.attributes.UserCacheReplacement;

public class ServerValuesConnectorImpl
implements ServerValuesConnector {
    private static final String SQL_GET_AUTOTEXT = "SELECT * FROM tblTextbausteine LEFT OUTER JOIN tblTextGruppe ON tblTextbausteine.GruID=tblTextGruppe.GruID WHERE UsrID=-1 OR UsrID=?";
    private TypespecificIntMap<ServerValuesConnector.ValueProvider> providers = new TypespecificIntMap();
    private TypespecificIntMap<String> idToKey = new TypespecificIntMap();
    private Map<String, Integer> keyToId = new HashMap<String, Integer>();
    private List<AdditionalFieldSetting> additionalFieldSettings = new ArrayList<AdditionalFieldSetting>();
    public static final String TEXTBAUSTEIN_START_TAG = "<placeholder name=\"";
    public static final String TEXTBAUSTEIN_ORDERREF = "ORDERREFERENZ";
    public static final String TEXTBAUSTEIN_SUPPORTERREF = "SELFREFERENZ";
    public static final String TEXTBAUSTEIN_END_TAG = "\"/>";
    private static final ArrayList<Field> TICKET_COLUMNS_ENDUSER = new ArrayList();
    private static final ConfigValue<Integer> DEFAULT_TICKET_FONT_SIZE_VALUE = new ConfigValue<Integer>(HDConfigKeys.DEFAULT_TICKET_FONT_SIZE){

        protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
            super.setValue(strValue);
            TableOptionsIntermediateWriter.of(TableOptionsIntermediateWriter.Option.FONT_SIZE).updateField((Integer)this.get());
        }
    };
    private static final ConfigValue<String> DEFAULT_TICKET_FONT_NAME_VALUE = new ConfigValue<String>(HDConfigKeys.DEFAULT_TICKET_FONT_NAME){

        protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
            super.setValue(strValue);
            TableOptionsIntermediateWriter.of(TableOptionsIntermediateWriter.Option.FONT_NAME).updateField((String)this.get());
        }
    };
    private static final ConfigValue<Boolean> DEFAULT_TICKET_PLAINTEXT_REASTEP = new ConfigValue<Boolean>(HDConfigKeys.DEFAULT_TICKET_PLAINTEXT_REASTEP){

        protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
            super.setValue(strValue);
            int value = ((Boolean)this.get() != false ? 1 : 0) + 2;
            TableOptionsIntermediateWriter.of(TableOptionsIntermediateWriter.Option.USE_PLAINTEXT).updateField(value);
        }
    };
    private static final ConfigValue<String> DEFAULT_COMPANY_ADDRESS = new ConfigValue<String>(HDConfigKeys.DEFAULT_COMPANY_ADDRESS){

        protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
            super.setValue(strValue);
            TableOptionsIntermediateWriter.of(TableOptionsIntermediateWriter.Option.COMPANY_ADDRESS).updateField((String)this.get());
        }
    };
    private static final ConfigValue<Integer> DEFAULT_EMAIL_SEND_CLOSE_TIME = new ConfigValue<Integer>(HDConfigKeys.DEFAULT_EMAIL_SEND_CLOSE_TIME){

        protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
            super.setValue(strValue);
            TableOptionsIntermediateWriter.of(TableOptionsIntermediateWriter.Option.REACTIVATION_DAYS).updateField((Integer)this.get());
        }
    };
    private static final ConfigValue<Integer> DEFAULT_TICKET_REACTIVATION_TIME = new ConfigValue(HDConfigKeys.DEFAULT_TICKET_REACTIVATION_TIME);

    @Override
    public ArrayList<Entry> getData(ContextType context, String username, int primaryType, boolean includeDeletedEntries) throws ServerDataException {
        UserAccount account = UserCacheReplacement.getInstance().getUserByName(username);
        if (account == null) {
            throw new ServerDataException(new IllegalArgumentException("The user " + username + " does not exist."));
        }
        return this.getData(context, account, primaryType, includeDeletedEntries);
    }

    @Override
    public ArrayList<Entry> getData(ContextType context, @Nonnull UserAccount account, int primaryType, boolean includeDeletedEntries) throws ServerDataException {
        Fetcher.Row row;
        if (account == null) {
            throw new ServerDataException(new IllegalArgumentException("No current user."));
        }
        Auftrag.Field primaryField = OpenOrderController.getFieldForId(primaryType);
        if (primaryField == null) {
            ServerValuesConnector.ValueProvider provider = this.providers.get(primaryType);
            if (provider == null) {
                throw new IllegalArgumentException("No value provider registered for type " + primaryType);
            }
            return provider.getData(account, true);
        }
        Fetcher fetcher = ServerUtilities.getOpenOrderController().getAvailableAttributes(primaryField);
        AbstractData currentNode = null;
        Entry root = new Entry(-1, -1, "");
        while ((row = fetcher.getNextRow()) != null) {
            FieldVO pa = row.getPrimaryAttribute();
            if (!includeDeletedEntries && pa instanceof Deletable && ((Deletable)((Object)pa)).isDeleted() || primaryField == Auftrag.Field.ITIL && ((ItilVO)pa).isMasterType() && !SystemPermissionChecker.hasAnyPermission((UserAccount)account, (Permission[])new Permission[]{HdPermissions.ITIL_DEFINITION})) continue;
            if (primaryField == Auftrag.Field.KATEGORIE && ((CategoryVO)pa).isHidden()) {
                boolean isSupporter = ServerUtilities.getOpenOrderController().isSupporter(account);
                if (context == ContextType.enduser || !isSupporter) continue;
            }
            if (currentNode != null && currentNode.getId() == pa.getId() && (primaryField.isNumeric() || pa.getDisplayValue().toLowerCase().equals(currentNode.getStringKey()))) continue;
            int usrID = HDUsersAndGroups.getUserID(account);
            currentNode = this.addRowToEntry(row, primaryField, true, true, root, account, usrID, primaryType);
        }
        root.updateTreeData(null, account.getDisplayName());
        if (primaryField == Auftrag.Field.RESOURCE) {
            int usrID = HDUsersAndGroups.getUserID(account);
            Set<Integer> memberResources = this.toSet(ServerUtilities.getOpenOrderController().getResources(usrID, true));
            this.updateResources(root, memberResources);
        }
        ArrayList<Entry> children = root.getChildren();
        return children;
    }

    @Override
    public ArrayList<FormField> getFormFields(ActionType action, ContextType context, int targetUserId, UserAccount supporterAccount, List<DataField> currentValues) throws ServerDataException {
        return this.getFormFields(action, context, HDUsersAndGroups.getUserAccount(targetUserId), supporterAccount, currentValues);
    }

    @Override
    public ArrayList<FormField> getFormFields(ActionType action, ContextType context, UserAccount targetUser, UserAccount supporterAccount, List<DataField> currentValues) throws ServerDataException {
        List<Field> availableFields = action.getFields(context);
        if (availableFields == null || availableFields.size() == 0) {
            return null;
        }
        ServerDataConnector serverDataConnector = (ServerDataConnector)ServerPluginManager.getInstance().getSingleInstance(ServerDataConnector.class);
        Map<Integer, FieldSetting> fieldSettings = serverDataConnector.getFieldSettings();
        if (targetUser == null) {
            throw new ServerDataException(new Exception("Target user does not exists!"));
        }
        Set<Integer> actionsForCurrentUser = TicketManager.getTicketActionChecker().getEffectiveAllowedActionsForCurrentUser();
        switch (action) {
            case createInquiry: {
                if (currentValues == null || actionsForCurrentUser.contains(4)) break;
                throw new ServerDataException((Exception)((Object)new AccessDeniedException(Tickets.MSG.getMsg("actionchecker.createTicketNotAllowed", new Object[0]), (ErrorCode)BaseErrorCode.AccessDeniedOrFileNotExists)));
            }
            case editInquiry: {
                if (actionsForCurrentUser.contains(-22)) break;
                ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(-22);
                throw new ServerDataException((Exception)((Object)new AccessDeniedException(Tickets.MSG.getMsg("actionchecker.userHasNoPermissionForAction", new Object[]{actionVO.getDisplayValue()}), (ErrorCode)BaseErrorCode.AccessDeniedOrFileNotExists)));
            }
        }
        HashMap<String, String> currentValueMap = new HashMap<String, String>();
        if (currentValues != null) {
            for (DataField dataField : currentValues) {
                String obj = null;
                Field field = dataField.getField();
                if (field != null) {
                    obj = dataField.getValue(field.getClassType());
                    if (field == Field.TICKETDATA_RESOURCEID && Integer.valueOf(0).equals(obj)) {
                        continue;
                    }
                } else {
                    obj = dataField.getValue(String.class);
                }
                currentValueMap.put(dataField.getKey(), obj);
            }
        }
        ArrayList<FormField> formFields = new ArrayList<FormField>(availableFields.size());
        for (Field field : availableFields) {
            Entry notAllowedRes;
            Integer providerId;
            int options = this.getOptionForField(field, fieldSettings, action, context, supporterAccount);
            if ((options & 0x20) == 32) continue;
            int displayType = this.getDisplayTypeForField(field, supporterAccount, fieldSettings, action, context);
            int typeID = this.getIDForField(field.name());
            Entry defaultValue = null;
            defaultValue = this.getDefaultValue(field, options, targetUser, supporterAccount, context, action, fieldSettings);
            if (defaultValue == null && (providerId = this.keyToId.get(field.name())) != null) {
                ServerValuesConnector.ValueProvider provider = this.providers.get(providerId);
                defaultValue = provider.getDefaultValue(supporterAccount);
            }
            Object currentObj = currentValueMap.get(field.name());
            String displayName = null;
            if (currentObj == null) {
                if (defaultValue != null) {
                    currentObj = defaultValue.getStringKey() != null ? defaultValue.getStringKey() : Integer.valueOf(defaultValue.getId());
                    displayName = defaultValue.getDisplayName();
                }
            } else {
                displayName = this.getValueDisplayName(field, currentObj, supporterAccount);
            }
            String currentValue = Field.getStringRepresentation(currentObj);
            String notAllowedValue = null;
            if ((options & 9) == 9 && (notAllowedRes = this.getNotAllowedValue(field, supporterAccount, context)) != null) {
                notAllowedValue = notAllowedRes.getStringKey() != null ? notAllowedRes.getStringKey() : String.valueOf(notAllowedRes.getId());
            }
            String imageURL = null;
            if (currentObj != null) {
                imageURL = this.getImageUrl(field, currentObj);
            } else if (defaultValue != null) {
                imageURL = this.getNodeImageName(defaultValue);
            }
            if (displayName != null && currentValue != null && currentValue.equals(displayName)) {
                displayName = null;
            }
            formFields.add(new FormField(field.name(), currentValue, displayName, notAllowedValue, imageURL, options, displayType, typeID));
        }
        List list = ServerPluginManager.getInstance().get(FormFieldsProvider.class);
        for (FormFieldsProvider provider : list) {
            provider.customizeFormFields(formFields, action, context, targetUser, supporterAccount, currentValues);
        }
        this.sortFormFields(formFields, availableFields);
        return formFields;
    }

    private void sortFormFields(ArrayList<FormField> formFiels, final List<Field> availableFields) {
        if (formFiels != null) {
            final ArrayList<FormField> originalList = new ArrayList<FormField>(formFiels);
            Collections.sort(formFiels, new Comparator<FormField>(){

                @Override
                public int compare(FormField o1, FormField o2) {
                    boolean firstLevel2;
                    if (o1 == null) {
                        return o2 == null ? 0 : -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    String key1 = o1.getField();
                    Field f1 = null;
                    try {
                        f1 = Field.valueOf(key1);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    int options1 = o1.getOptions();
                    String key2 = o2.getField();
                    Field f2 = null;
                    try {
                        f2 = Field.valueOf(key2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    int options2 = o2.getOptions();
                    if (Field.TICKETDATA_PREVIEW == f1) {
                        return 1;
                    }
                    if (Field.TICKETDATA_PREVIEW == f2) {
                        return -1;
                    }
                    if (Field.TICKETDATA_SUBJECT == f1) {
                        return 1;
                    }
                    if (Field.TICKETDATA_SUBJECT == f2) {
                        return -1;
                    }
                    boolean firstLevel1 = (options1 & 1) == 1;
                    boolean bl = firstLevel2 = (options2 & 1) == 1;
                    if (firstLevel1 != firstLevel2) {
                        return firstLevel1 ? -1 : 1;
                    }
                    if (f1 != null && f2 == null) {
                        return -1;
                    }
                    if (f1 == null && f2 != null) {
                        return 1;
                    }
                    if (f1 == null && f2 == null) {
                        int origPosition1 = originalList.indexOf(o1);
                        int origPosition2 = originalList.indexOf(o2);
                        return origPosition1 - origPosition2;
                    }
                    int availPosition1 = availableFields.indexOf((Object)f1);
                    int availPosition2 = availableFields.indexOf((Object)f2);
                    return availPosition1 - availPosition2;
                }
            });
        }
    }

    private String getImageUrl(Field field, Object value) {
        if (field == Field.TICKETDATA_PRIORITYID) {
            int id = (Integer)value;
            PriorityVO priority = (PriorityVO)PriorityManager.getInstance().get(id);
            if (priority != null) {
                return priority.getImageName();
            }
        } else if (field == Field.TICKETDATA_ITILID) {
            int id = (Integer)value;
            ItilVO itil = (ItilVO)ItilManager.getInstance().get(id);
            if (itil != null) {
                return itil.getImageName();
            }
        } else if (field == Field.TICKETDATA_CLASSIFICATIONID) {
            int id = (Integer)value;
            ClassificationVO classification = (ClassificationVO)ClassificationManager.getInstance().get(id);
            if (classification != null) {
                return classification.getImageName();
            }
        }
        return null;
    }

    private String getValueDisplayName(Field field, Object value, UserAccount supporterAccount) {
        ServerValuesConnector.ValueProvider valueProvider;
        Integer providerID;
        ServerValuesConnector.ValueProvider valueProvider2;
        Integer providerID2;
        if (field == Field.TICKETDATA_TICKETID) {
            return String.valueOf(value);
        }
        if (field == Field.USERDATA_LANGUAGE && (providerID2 = this.keyToId.get(field.name())) != null && (valueProvider2 = this.providers.get(providerID2)) != null) {
            try {
                ArrayList<Entry> data;
                if (value != null && (data = valueProvider2.getData(supporterAccount, true)) != null) {
                    for (Entry e : data) {
                        if (!value.equals(e.getStringKey())) continue;
                        return e.getDisplayName();
                    }
                }
            }
            catch (ServerDataException data) {
                // empty catch block
            }
        }
        if (field == Field.USERDATA_LUMPSUM1 || field == Field.USERDATA_LUMPSUM2 || field == Field.USERDATA_LUMPSUM3) {
            return NumberFormat.getCurrencyInstance(ClientLocale.getThreadLocale()).format(value);
        }
        if (field.getClassType() == User.class) {
            return ((User)value).getDisplayName();
        }
        if (field.getClassType() == String.class) {
            return (String)value;
        }
        if (field.getClassType() == Date.class) {
            return String.valueOf(((Date)value).getTime());
        }
        if (field.getClassType() == String[].class) {
            StringBuilder builder = new StringBuilder();
            String[] values = (String[])value;
            for (int i = 0; i < values.length; ++i) {
                builder.append(values[i]);
                if (i == values.length - 1) continue;
                builder.append("; ");
            }
            return builder.toString();
        }
        Auftrag.Field internalField = Auftrag.Field.findField(field.getKey());
        if (field.getKey() != null && internalField != Auftrag.Field.FREI && field.getClassType() == Integer.class) {
            return ServerUtilities.getOpenOrderController().getAttributName(internalField, (Integer)value, true);
        }
        if ((field.getClassType() == Integer.class || field.getClassType() == Long.class) && (providerID = this.keyToId.get(field.name())) != null && (valueProvider = this.providers.get(providerID)) != null) {
            try {
                ArrayList<Entry> data;
                if (value != null && (data = valueProvider.getData(supporterAccount, true)) != null) {
                    long id = Long.parseLong(value.toString());
                    for (Entry e : data) {
                        if ((long)e.getId() != id) continue;
                        return e.getDisplayName();
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (ServerDataException serverDataException) {
                // empty catch block
            }
        }
        HDLogger.error("Could not convert the field '" + field + "' to Auftrag.Field");
        return null;
    }

    private int getDisplayTypeForField(Field field, UserAccount account, Map<Integer, FieldSetting> fieldSettings, ActionType action, ContextType context) throws ServerDataException {
        switch (field) {
            case TICKETDATA_PREVIEW: {
                return 1;
            }
            case TICKETDATA_OWNER: 
            case TICKETDATA_RESOURCEID: 
            case TICKETDATA_PRIORITYID: 
            case TICKETDATA_ITILID: 
            case TICKETDATA_CLASSIFICATIONID: 
            case TICKETDATA_CATEGORY: 
            case DEVICEDATA_LOCATION: 
            case USERDATA_LOCATION: 
            case USERDATA_GROUP: {
                return 2;
            }
            case TICKETDATA_DUETIME: {
                return 3;
            }
            case TICKETDATA_DEADLINE: 
            case TICKETDATA_TERMINVEREINBARUNG: {
                return 5;
            }
            case USERDATA_LUMPSUM1: 
            case USERDATA_LUMPSUM2: 
            case USERDATA_LUMPSUM3: {
                return 6;
            }
            case USERDATA_USERNAME: {
                if (action != ActionType.editUser || context != ContextType.enduser) break;
                return 0;
            }
        }
        Integer providerId = this.keyToId.get(field.name());
        ServerValuesConnector.ValueProvider provider = null;
        if (providerId != null && (provider = this.providers.get(providerId)).hasData(account)) {
            FieldSetting setting;
            if (provider.allowCustomValues()) {
                return 7;
            }
            if (provider.allowMultipleValues()) {
                return 8;
            }
            if (field == Field.TICKETDATA_SPECIALFIELD && (setting = fieldSettings.get(field.getLanguageSetID())) != null && setting.getSetting() > 0) {
                return 7;
            }
            return 2;
        }
        return 0;
    }

    private int getOptionForField(Field field, Map<Integer, FieldSetting> fieldSettings, ActionType action, ContextType context, UserAccount account) throws ServerDataException {
        FieldSetting fieldSetting;
        int languageSetID = field.getLanguageSetID();
        if (languageSetID != -1 && (fieldSetting = fieldSettings.get(languageSetID)) != null) {
            int options = 0;
            if (field.name().startsWith("USERDATA_") && context == ContextType.enduser) {
                new ServerOptions();
                if (ServerOptions.isOptionSet(64)) {
                    options |= 4;
                }
            }
            options |= fieldSetting.getOptionValue(action, context, account);
            if (field == Field.USERDATA_USERFIELD6) {
                options |= 0x100;
            }
            return options;
        }
        if (field == Field.TICKETDATA_SUBJECT) {
            return 1;
        }
        if (field == Field.TICKETDATA_PREVIEW) {
            int option = 1;
            if (this.isHtmlContent()) {
                option |= 0x40;
            }
            return option;
        }
        if (field == Field.TICKETDATA_OWNER || field == Field.TICKETDATA_TICKETID) {
            return 5;
        }
        if (field == Field.TICKETDATA_RESOURCEID) {
            return 1;
        }
        if (action == ActionType.editUser && context == ContextType.enduser && field.name().startsWith("USERDATA_")) {
            int userOption = 0;
            new ServerOptions();
            if (ServerOptions.isOptionSet(64)) {
                userOption |= 4;
            }
            if (field == Field.USERDATA_USERNAME) {
                userOption |= 4;
            }
            if (field == Field.USERDATA_COMPUTERNAME) {
                userOption |= 4;
            }
            if (field == Field.USERDATA_USERFIELD6) {
                userOption |= 0x100;
            }
            return userOption;
        }
        return 0;
    }

    @Override
    public boolean isHtmlContent() {
        return (Boolean)DEFAULT_TICKET_PLAINTEXT_REASTEP.get();
    }

    @Override
    public Entry getDefaultValue(Field field, int options, UserAccount targetUser, UserAccount supporterAccount, ContextType creationType, ActionType actionType, Map<Integer, FieldSetting> fieldSettings) throws ServerDataException {
        ResultSet rs;
        Statement st;
        Connection con;
        ConnectionFactory connectionFactory;
        FieldSetting setting;
        User targetUserOldModel = UserModelConverter.convertUserAccount(targetUser);
        if (creationType == ContextType.enduser && (Field.TICKETDATA_PREVIEW == field || Field.TICKETDATA_SUBJECT == field)) {
            Integer actionId;
            String defaultValue = "";
            AutoTextManager atm = (AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class);
            switch (actionType) {
                case editTicket: {
                    actionId = -29;
                    break;
                }
                default: {
                    actionId = null;
                }
            }
            try (UserAccountScope userScope = UserAccountScope.create((GUID)supporterAccount.getID());){
                List<AutoTextVO> autoTexts = atm.getAutoTexts(null, null, actionId);
                if (autoTexts.size() == 1) {
                    if (Field.TICKETDATA_PREVIEW == field) {
                        defaultValue = autoTexts.get(0).getContentText();
                        if ((options & 0x40) != 64) {
                            defaultValue = HtmlConverter.html2text((String)defaultValue);
                        }
                    } else if (Field.TICKETDATA_SUBJECT == field) {
                        defaultValue = autoTexts.get(0).getLabel();
                    }
                }
                Entry entry = new Entry(-1, -1, defaultValue, defaultValue);
                return entry;
            }
        }
        if (Field.TICKETDATA_CATEGORY == field) {
            return new Entry(4, 0, "", "");
        }
        if (Field.TICKETDATA_CLASSIFICATIONID == field) {
            ClassificationVO classification = (ClassificationVO)ClassificationManager.getInstance().get(0);
            return new Entry(3, 0, classification.getDisplayValue());
        }
        if (Field.TICKETDATA_OWNER == field) {
            if (targetUser == null) {
                throw new ServerDataException(new Exception("Missing User. targetUser should not be null!"));
            }
            return new Entry(-1, HDUsersAndGroups.getUserID(targetUser), null, targetUser.getDisplayName());
        }
        if (Field.TICKETDATA_SPECIALFIELD == field && (setting = fieldSettings.get(field.getLanguageSetID())) != null) {
            String defaultValue = null;
            switch (setting.getSetting()) {
                case 0: {
                    return null;
                }
                case 1: {
                    if (targetUser == null) {
                        throw new ServerDataException(new Exception("Missing User. targetUser should not be null!"));
                    }
                    defaultValue = targetUserOldModel.getValue(Field.USERDATA_COMPUTERNAME, String.class);
                    break;
                }
                case 2: {
                    if (targetUser == null) {
                        throw new ServerDataException(new Exception("Missing User. targetUser should not be null!"));
                    }
                    defaultValue = targetUserOldModel.getValue(Field.USERDATA_COSTCENTRE, String.class);
                    break;
                }
                case 3: {
                    if (targetUser == null) {
                        throw new ServerDataException(new Exception("Missing User. targetUser should not be null!"));
                    }
                    defaultValue = targetUserOldModel.getValue(Field.USERDATA_DEPARTMENT, String.class);
                    break;
                }
                case 4: {
                    if (targetUser == null) {
                        throw new ServerDataException(new Exception("Missing User. targetUser should not be null!"));
                    }
                    defaultValue = targetUserOldModel.getValue(Field.USERDATA_USERFIELD1, String.class);
                }
            }
            if (defaultValue == null) {
                defaultValue = "";
            }
            return new Entry(-1, -1, defaultValue, defaultValue);
        }
        if (Field.TICKETDATA_PRIORITYID == field || Field.TICKETDATA_ITILID == field) {
            block62: {
                Entry entry;
                int itilId;
                block61: {
                    connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
                    con = null;
                    st = null;
                    rs = null;
                    con = connectionFactory.getConnection();
                    int prioSelection = -1;
                    int prioId = -1;
                    itilId = -1;
                    st = con.createStatement();
                    rs = st.executeQuery("SELECT PriID, ItiID, PrioSelection FROM tblOptionen");
                    rs.next();
                    prioId = rs.getInt(1);
                    itilId = rs.getInt(2);
                    prioSelection = rs.getInt(3);
                    if (Field.TICKETDATA_PRIORITYID != field) break block61;
                    if (targetUser == null) {
                        throw new ServerDataException(new Exception("Missing User. targetUser should not be null!"));
                    }
                    Entry entry2 = this.getPriorityEntry(creationType, targetUser, supporterAccount, prioSelection, prioId);
                    ServerDataConnectorImpl.closeAll(con, st, rs);
                    return entry2;
                }
                try {
                    if (Field.TICKETDATA_ITILID != field) break block62;
                    entry = this.getItilInstanceForId(creationType, supporterAccount, itilId);
                }
                catch (SQLException e) {
                    try {
                        throw new ServerDataException(e);
                    }
                    catch (Throwable throwable) {
                        ServerDataConnectorImpl.closeAll(con, st, rs);
                        throw throwable;
                    }
                }
                ServerDataConnectorImpl.closeAll(con, st, rs);
                return entry;
            }
            ServerDataConnectorImpl.closeAll(con, st, rs);
        }
        if (Field.TICKETDATA_RESOURCEID == field) {
            Entry resID2;
            ResultSet rs2;
            PreparedStatement st2;
            Connection con2;
            block63: {
                UserGroupInfo resource;
                int resID2;
                if (targetUser == null) {
                    throw new ServerDataException(new Exception("Missing User. targetUser should not be null!"));
                }
                Integer groupObj = targetUserOldModel.getValue(Field.USERDATA_GROUP, Integer.class);
                if (groupObj == null) {
                    return null;
                }
                ConnectionFactory connectionFactory2 = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
                con2 = null;
                st2 = null;
                rs2 = null;
                con2 = connectionFactory2.getConnection();
                st2 = con2.prepareStatement("SELECT ResID FROM tblBenutzerGruppe WHERE BgrID = ?");
                st2.setInt(1, groupObj);
                rs2 = st2.executeQuery();
                if (!rs2.next() || (resID2 = rs2.getInt(1)) <= 0 || (resource = HDUsersAndGroups.getResource(resID2)) == null) break block63;
                Entry entry = new Entry(1, resID2, resource.getDisplayName());
                ServerDataConnectorImpl.closeAll(con2, st2, rs2);
                return entry;
            }
            try {
                resID2 = new Entry(1, 0, "", "");
            }
            catch (SQLException e) {
                try {
                    throw new ServerDataException(e);
                }
                catch (Throwable throwable) {
                    ServerDataConnectorImpl.closeAll(con2, st2, rs2);
                    throw throwable;
                }
            }
            ServerDataConnectorImpl.closeAll(con2, st2, rs2);
            return resID2;
        }
        if (Field.USERDATA_GROUP == field) {
            block64: {
                Entry e;
                connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
                con = null;
                st = null;
                rs = null;
                try {
                    String displayName;
                    con = connectionFactory.getConnection();
                    st = con.prepareStatement("SELECT GroupName FROM tblBenutzerGruppe WHERE BgrID = 0");
                    rs = st.executeQuery();
                    if (!rs.next() || (displayName = rs.getString(1)) == null) break block64;
                    e = new Entry(6, 0, displayName);
                }
                catch (SQLException e2) {
                    try {
                        throw new ServerDataException(e2);
                    }
                    catch (Throwable throwable) {
                        ServerDataConnectorImpl.closeAll(con, st, rs);
                        throw throwable;
                    }
                }
                ServerDataConnectorImpl.closeAll(con, st, rs);
                return e;
            }
            ServerDataConnectorImpl.closeAll(con, st, rs);
            return new Entry(6, 0, "");
        }
        if (Field.USERDATA_LOCATION == field) {
            connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
            con = null;
            st = null;
            rs = null;
            try {
                con = connectionFactory.getConnection();
                st = con.prepareStatement("SELECT tblGebaeude.GebID, GebBezeichnung FROM tblGebaeude INNER JOIN tblOptionen on tblGebaeude.GebID = tblOptionen.GebID");
                rs = st.executeQuery();
                if (rs.next()) {
                    int gebID = rs.getInt(1);
                    String displayName = rs.getString(2);
                    if (displayName != null) {
                        Entry entry = new Entry(5, gebID, displayName);
                        return entry;
                    }
                }
            }
            catch (SQLException e) {
                throw new ServerDataException(e);
            }
            finally {
                ServerDataConnectorImpl.closeAll(con, st, rs);
            }
            return new Entry(5, 0, "");
        }
        if (Field.USERDATA_LUMPSUM1 == field || Field.USERDATA_LUMPSUM2 == field || Field.USERDATA_LUMPSUM3 == field) {
            return new Entry(-1, 0, "0");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Entry getNotAllowedValue(Field field, UserAccount supporterAccount, ContextType creationType) throws ServerDataException {
        Entry entry;
        ResultSet rs;
        Statement st;
        Connection con;
        block8: {
            block9: {
                Entry entry2;
                if (Field.TICKETDATA_PRIORITYID != field) {
                    if (Field.TICKETDATA_ITILID != field) return null;
                }
                ConnectionFactory connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
                con = null;
                st = null;
                rs = null;
                try {
                    con = connectionFactory.getConnection();
                    int prioId = -1;
                    int itilId = -1;
                    st = con.createStatement();
                    rs = st.executeQuery("SELECT PriID, ItiID FROM tblOptionen");
                    rs.next();
                    prioId = rs.getInt("PriID");
                    itilId = rs.getInt("ItiId");
                    if (Field.TICKETDATA_PRIORITYID == field) {
                        ArrayList<Entry> allPriorities = this.getData(creationType, supporterAccount, 2, true);
                        for (Entry res : allPriorities) {
                            if (res.getId() != prioId) continue;
                            entry = res;
                            break block8;
                        }
                    }
                    if (Field.TICKETDATA_ITILID != field) break block9;
                    entry2 = this.getItilInstanceForId(creationType, supporterAccount, itilId);
                }
                catch (SQLException e) {
                    try {
                        throw new ServerDataException(e);
                    }
                    catch (Throwable throwable) {
                        ServerDataConnectorImpl.closeAll(con, st, rs);
                        throw throwable;
                    }
                }
                ServerDataConnectorImpl.closeAll(con, st, rs);
                return entry2;
            }
            ServerDataConnectorImpl.closeAll(con, st, rs);
            return null;
        }
        ServerDataConnectorImpl.closeAll(con, st, rs);
        return entry;
    }

    private Entry getItilInstanceForId(ContextType context, UserAccount account, int itilId) throws ServerDataException {
        ArrayList<Entry> allItil = this.getData(context, account, 7, true);
        for (Entry itil : allItil) {
            if (itil.getId() != itilId) continue;
            return itil;
        }
        return null;
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="parameter is internal")
    private Entry getPriorityEntry(ContextType context, UserAccount targetUser, UserAccount supporterAccount, int prioSelection, int prioId) throws ServerDataException {
        int retval;
        block10: {
            block9: {
                ResultSet result;
                PreparedStatement stm;
                Connection connection;
                block8: {
                    block7: {
                        retval = 0;
                        if (prioSelection == 0) break block9;
                        String command = null;
                        command = prioSelection == 1 ? "SlaGebPrio" : "SlaBgrPrio";
                        connection = null;
                        stm = null;
                        result = null;
                        ConnectionFactory connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
                        connection = connectionFactory.getConnection();
                        stm = connection.prepareStatement((String)connectionFactory.getCommand(command));
                        stm.setString(1, targetUser.getID().toString());
                        result = stm.executeQuery();
                        if (result != null) break block7;
                        Entry entry = null;
                        ServerDataConnectorImpl.closeAll(connection, stm, result);
                        return entry;
                    }
                    try {
                        if (result.next()) {
                            retval = result.getInt("SLA_PriID");
                        }
                        if (retval != 0) break block8;
                        retval = prioId;
                    }
                    catch (SQLException sqle) {
                        try {
                            throw new ServerDataException(sqle);
                        }
                        catch (Throwable throwable) {
                            ServerDataConnectorImpl.closeAll(connection, stm, result);
                            throw throwable;
                        }
                    }
                }
                ServerDataConnectorImpl.closeAll(connection, stm, result);
                break block10;
            }
            retval = prioId;
        }
        ArrayList<Entry> allPriorities = this.getData(context, supporterAccount, 2, true);
        for (Entry res : allPriorities) {
            if (res.getId() != retval) continue;
            return res;
        }
        return null;
    }

    private Entry addRowToEntry(Fetcher.Row row, Auftrag.Field keyType, boolean primary, boolean voidCounts, Entry root, UserAccount account, int userID, int keyTypeInt) {
        FieldVO key = primary ? row.getPrimaryAttribute() : row.getSecondaryAttribute();
        Entry res = new Entry(keyTypeInt, key.getId(), key.getDisplayValue());
        res.setImageName(this.getNodeImageName(res));
        res.setDeleted(key instanceof Deletable && ((Deletable)((Object)key)).isDeleted());
        if (keyType == Auftrag.Field.ITIL) {
            res.getDataFields().add(new DataField(Field.RESOURCE_ITILMASTERTYPE, (Object)((ItilVO)key).isMasterType()));
        }
        if (keyType == Auftrag.Field.RESOURCE) {
            res.setWriteable(this.isResourceWritable(key.getId(), userID, 0));
            UserGroupInfo parentRes = null;
            if (key instanceof ResourceVO) {
                parentRes = HDUsersAndGroups.getResource(((ResourceVO)key).getParentID());
            }
            if (parentRes != null) {
                int parentResID = (Integer)parentRes.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID);
                Entry pRes = root.getChildByID(parentResID);
                if (pRes != null) {
                    pRes.addChild(res);
                } else {
                    Entry presource = new Entry(Auftrag.Field.RESOURCE.ordinal(), parentResID, parentRes.getDisplayName());
                    presource.setWriteable(this.isResourceWritable(parentResID, userID, 0));
                    presource.setDeleted(!parentRes.isActive());
                    presource.addChild(res);
                    presource.setImageName(this.getNodeImageName(presource));
                    root.addChild(presource);
                }
            } else {
                root.addChild(res);
            }
        } else if (keyType == Auftrag.Field.KATEGORIE && key instanceof CategoryVO) {
            Entry parent;
            CategoryVO category = (CategoryVO)key;
            Integer parentID = category.getParentCategoryID();
            Entry entry = parent = parentID != null && parentID > 0 ? this.findEntry(root, parentID, 4) : root;
            if (parent == null) {
                return null;
            }
            res.setStringKey(category.getPath());
            parent.addChild(res);
        } else {
            if (!keyType.isNumeric()) {
                res.setStringKey(key.getDisplayValue().toLowerCase());
            }
            root.addChild(res);
        }
        return res;
    }

    private Entry findEntry(Entry root, int id, int typeID) {
        for (Entry child : root.getChildren()) {
            if (child.getTypeId() != typeID) {
                return null;
            }
            if (child.getId() == id) {
                return child;
            }
            Entry result = this.findEntry(child, id, typeID);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private Resource addRowToResource(Fetcher.Row row, Auftrag.Field keyType, boolean primary, boolean voidCounts, Resource root, int userID, int keyTypeInt) {
        FieldVO key = primary ? row.getPrimaryAttribute() : row.getSecondaryAttribute();
        Resource res = new Resource(keyTypeInt, key.getId(), key.getDisplayValue(), voidCounts ? 0 : row.getOrderCount(), voidCounts ? 0 : row.getUnreadCount());
        res.setVersion(row.getVersion());
        res.setImageName(this.getNodeImageName(res));
        res.setDeleted(key instanceof Deletable && ((Deletable)((Object)key)).isDeleted());
        if (keyType == Auftrag.Field.ITIL) {
            res.getDataFields().add(new DataField(Field.RESOURCE_ITILMASTERTYPE, (Object)((ItilVO)key).isMasterType()));
        }
        if (keyType != Auftrag.Field.RESOURCE || !(key instanceof ResourceVO)) {
            if (!keyType.isNumeric()) {
                res.setStringKey(key.getDisplayValue().toLowerCase());
            }
            root.addChild(res);
        } else {
            ResourceVO currentRes = (ResourceVO)key;
            res.setWriteable(this.isResourceWritable(currentRes.getId(), userID, 0));
            UserGroupInfo parentRes = HDUsersAndGroups.getResource(currentRes.getParentID());
            if (parentRes != null) {
                int parentResID = (Integer)parentRes.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID);
                Resource pRes = root.getChildByID(parentResID);
                if (pRes != null) {
                    pRes.addChild(res);
                } else {
                    Resource presource = new Resource(Auftrag.Field.RESOURCE.ordinal(), parentResID, parentRes.getDisplayName(), 0, 0);
                    presource.setWriteable(this.isResourceWritable(parentResID, userID, 0));
                    presource.setDeleted(!parentRes.isActive());
                    presource.addChild(res);
                    presource.setImageName(this.getNodeImageName(presource));
                    root.addChild(presource);
                }
            } else {
                root.addChild(res);
            }
        }
        return res;
    }

    @Override
    public String getNodeImageName(AbstractData res) {
        switch (res.getTypeId()) {
            case 1: {
                if (res.isWriteable()) {
                    return "resources_16.gif";
                }
                if (res.isReadable()) {
                    return "resources_read_16.gif";
                }
                return "resource_forign_16.gif";
            }
            case 0: {
                StatusVO status = (StatusVO)StatusManager.getInstance().get(res.getId());
                return status == null ? null : status.getImageName();
            }
            case 2: {
                PriorityVO priority = (PriorityVO)PriorityManager.getInstance().get(res.getId());
                return priority == null ? null : priority.getImageName();
            }
            case 3: {
                ClassificationVO classification = (ClassificationVO)ClassificationManager.getInstance().get(res.getId());
                return classification == null ? null : classification.getImageName();
            }
            case 5: {
                if (res.isDeleted()) {
                    return "delete_16.gif";
                }
                return "folder_closed_16.gif";
            }
            case 6: {
                if (res.isDeleted()) {
                    return "delete_16.gif";
                }
                return "benutzergr_16.gif";
            }
            case 7: {
                ItilVO itiltype = (ItilVO)ItilManager.getInstance().get(res.getId());
                return itiltype == null ? null : itiltype.getImageName();
            }
            case 8: {
                return "frei_16.gif";
            }
            case 9: {
                return "user_16.gif";
            }
            case 4: {
                return "kategorie_16.gif";
            }
            case 14: {
                DeviceTypeVO deviceTypeVO = (DeviceTypeVO)DeviceTypeManager.getInstance().get(res.getId());
                return deviceTypeVO == null ? null : deviceTypeVO.getSymbol();
            }
        }
        String fieldName = this.idToKey.get(res.getTypeId());
        if (Field.USERDATA_LANGUAGE.name().equals(fieldName)) {
            String val = res.getStringKey();
            if ("xx".equals(val)) {
                return null;
            }
            return "flags/" + val + ".png";
        }
        if (Field.TICKETDATA_CATEGORYID.name().equals(fieldName)) {
            return "kategorie_16.gif";
        }
        for (AdditionalFieldSetting additionalFieldSetting : this.additionalFieldSettings) {
            String imageName = additionalFieldSetting.getImageName(fieldName, res.getTypeId(), res.getId(), res.getStringKey());
            if (imageName == null) continue;
            return imageName;
        }
        return null;
    }

    @Override
    public boolean isResourceWritable(int resourceId, int userId, int searchDirection) {
        UserAccount account = HDUsersAndGroups.getUserAccount(userId);
        if (SystemPermissionChecker.hasAnyPermission((UserAccount)account, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ}) && SystemPermissionChecker.hasAnyPermission((UserAccount)account, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ_WRITE})) {
            return true;
        }
        UserGroupInfo resource = HDUsersAndGroups.getResource(resourceId);
        if (resource == null) {
            return false;
        }
        return HDUsersAndGroups.hasWritePermissionInResource(account.getID(), resource);
    }

    @Override
    public Resource getResources(boolean onlyOwnResources, int primaryType, int secondaryType) throws ServerDataException {
        Fetcher.Row row;
        UserAccount currentAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentAccount == null) {
            throw new ServerDataException(new IllegalArgumentException("No current user."));
        }
        if (!HDUsersAndGroups.isResourceMember(currentAccount) && !SystemPermissionChecker.hasAnyPermission((UserAccount)currentAccount, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ})) {
            return null;
        }
        int usrID = HDUsersAndGroups.getUserID(currentAccount);
        int[] visibleResources = ServerUtilities.getOpenOrderController().getResources(usrID, !onlyOwnResources);
        Auftrag.Field primaryField = OpenOrderController.getFieldForId(primaryType);
        if (primaryField == null) {
            throw new IllegalArgumentException("The primary grouping type '" + primaryType + "' is invalid, cannot build orders tree");
        }
        Auftrag.Field secondaryField = OpenOrderController.getFieldForId(secondaryType);
        if (secondaryType != -1 && secondaryField == null) {
            throw new IllegalArgumentException("The secondary grouping type '" + secondaryType + "' is invalid, cannot build orders tree");
        }
        Fetcher fetcher = ServerUtilities.getOpenOrderController().getTreeStructure(visibleResources, primaryField, secondaryField);
        AbstractData currentNode = null;
        Resource root = new Resource(-1, -1, "", 0, 0);
        int version = ServerUtilities.getOpenOrderController().getVersion(visibleResources);
        while ((row = fetcher.getNextRow()) != null) {
            FieldVO pa = row.getPrimaryAttribute();
            if (currentNode == null || currentNode.getId() != pa.getId() || !primaryField.isNumeric() && !pa.getDisplayValue().toLowerCase().equals(currentNode.getStringKey())) {
                currentNode = this.addRowToResource(row, primaryField, true, secondaryType != -1, root, usrID, primaryType);
            }
            if (secondaryType == -1 || secondaryType == primaryType) continue;
            this.addRowToResource(row, secondaryField, false, false, (Resource)currentNode, usrID, secondaryType);
        }
        root.updateTreeData(null, currentAccount.getDisplayName());
        root.setVersion(version);
        return root;
    }

    @Override
    public Resource getDispatcherResources(int sessionId) throws ServerDataException {
        UserAccount currentAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentAccount == null) {
            throw new ServerDataException(new IllegalArgumentException("No current user."));
        }
        if (!SystemPermissionChecker.hasAnyPermission((UserAccount)currentAccount, (Permission[])new Permission[]{HdPermissions.DISPATCHER})) {
            return null;
        }
        Resource root = new Resource(-1, -1, "", 0, 0);
        ResultSet inquiries = null;
        int version = ServerUtilities.conti.getVersion(7);
        try {
            Fetcher.Row row;
            inquiries = ServerUtilities.conti.getOffene(HDUsersAndGroups.getUserID(currentAccount), sessionId);
            DispatcherFetcher fetcher = new DispatcherFetcher(inquiries);
            while ((row = fetcher.getNextRow()) != null) {
                Resource res = new Resource(Auftrag.Field.ORT.ordinal(), row.getPrimaryAttribute().getId(), row.getPrimaryAttribute().getDisplayValue(), row.getOrderCount(), row.getUnreadCount());
                res.setImageName(this.getNodeImageName(res));
                res.setDeleted(false);
                root.addChild(res);
            }
        }
        catch (SQLException e) {
            throw new ServerDataException(e);
        }
        finally {
            ServerDataConnectorImpl.closeAll(null, null, inquiries);
        }
        root.setVersion(version);
        return root;
    }

    @Override
    public int getIDForField(String fieldKey) {
        Integer providerId = this.keyToId.get(fieldKey);
        if (providerId != null) {
            return providerId;
        }
        try {
            Field field = Field.valueOf(fieldKey);
            switch (field) {
                case TICKETDATA_STATUSID: {
                    return 0;
                }
                case TICKETDATA_RESOURCEID: {
                    return 1;
                }
                case TICKETDATA_PRIORITYID: {
                    return 2;
                }
                case TICKETDATA_CLASSIFICATIONID: {
                    return 3;
                }
                case TICKETDATA_CATEGORY: {
                    return 4;
                }
                case USERDATA_LOCATION: {
                    return 5;
                }
                case USERDATA_GROUP: {
                    return 6;
                }
                case TICKETDATA_ITILID: {
                    return 7;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return -1;
    }

    private void updateResources(Entry parent, Set<Integer> allowedIDs) {
        if (allowedIDs == null) {
            return;
        }
        if (parent.getTypeId() == Auftrag.Field.RESOURCE.ordinal() && !allowedIDs.contains(parent.getId())) {
            parent.setReadable(false);
        }
        if (parent.getChildren() != null) {
            for (Entry child : parent.getChildren()) {
                this.updateResources(child, allowedIDs);
            }
        }
    }

    private Set<Integer> toSet(int[] keys) {
        if (keys == null) {
            return null;
        }
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i : keys) {
            set.add(i);
        }
        return set;
    }

    public void init() {
        this.additionalFieldSettings.addAll(ServerPluginManager.getInstance().get(AdditionalFieldSetting.class));
        int id = 100;
        List registered = ServerPluginManager.getInstance().get(ServerValuesConnector.ValueProvider.class);
        if (registered != null && registered.size() > 0) {
            for (ServerValuesConnector.ValueProvider provider : registered) {
                this.registerProvider(id, provider);
                ++id;
            }
        }
        id = (id + 100) / 100 * 100;
        List<ServerValuesConnector.ValueProvider> manuell = QueryValueProvider.getQueryValueProviders();
        if (manuell != null && manuell.size() > 0) {
            for (ServerValuesConnector.ValueProvider provider : manuell) {
                this.registerProvider(id, provider);
                ++id;
            }
        }
        id = (id + 100) / 100 * 100;
        this.registerProvider(id++, new OrderFieldValuesProvider(Field.TICKETDATA_TICKETFIELD1));
        this.registerProvider(id++, new OrderFieldValuesProvider(Field.TICKETDATA_TICKETFIELD2));
        this.registerProvider(id++, new OrderFieldValuesProvider(Field.TICKETDATA_TICKETFIELD3));
        this.registerProvider(id++, new StaticValueProvider(Field.TICKETDATA_AUTOMAILING));
        this.registerProvider(id++, new KeyValueQueryValueProvider(null, Field.USERDATA_LANGUAGE));
    }

    private void registerProvider(int id, ServerValuesConnector.ValueProvider provider) {
        Integer recentID = this.keyToId.get(provider.getFieldKey());
        if (recentID != null) {
            id = recentID;
            ServerValuesConnector.ValueProvider recentProvider = this.providers.get(id);
            if (!(recentProvider instanceof CombinedValueProvider)) {
                recentProvider = new CombinedValueProvider(recentProvider);
            }
            ((CombinedValueProvider)recentProvider).addProvider(provider);
            recentProvider.notifyRegisteredId(id);
            this.providers.put(id, recentProvider);
        } else {
            provider.notifyRegisteredId(id);
            this.idToKey.put(id, provider.getFieldKey());
            this.keyToId.put(provider.getFieldKey(), id);
            this.providers.put(id, provider);
        }
    }

    @Override
    public String fillPlaceholders(String content, Ticket ticket, UserAccount supporter, Locale locale) {
        User ticketOwner = ticket == null ? null : ticket.getValue(Field.TICKETDATA_OWNER, User.class);
        UserAccount ticketOwnerAccount = ticketOwner == null ? null : HDUsersAndGroups.getUserAccount(ticketOwner.getUserID());
        int endIndex = 0;
        int startIndex = -1;
        while ((startIndex = ((String)content).indexOf(TEXTBAUSTEIN_START_TAG, startIndex + 1)) >= 0) {
            Field fieldToUse;
            String placeHolder;
            String[] parts;
            endIndex = ((String)content).indexOf(TEXTBAUSTEIN_END_TAG, startIndex + TEXTBAUSTEIN_START_TAG.length());
            if (endIndex < 0 || (parts = (placeHolder = ((String)content).substring(startIndex + TEXTBAUSTEIN_START_TAG.length(), endIndex)).split("\\.")).length != 2) continue;
            String type = parts[0];
            String fieldname = parts[1];
            String replacer = null;
            if (TEXTBAUSTEIN_ORDERREF.equals(type)) {
                fieldToUse = null;
                for (Field field : Field.values()) {
                    String key;
                    if (!field.name().startsWith("TICKETDATA_") && !field.name().startsWith("USERDATA_") || (key = field.getKey()) == null || !key.equalsIgnoreCase(fieldname)) continue;
                    fieldToUse = field;
                    break;
                }
                replacer = this.getDisplayString(ticket, ticketOwnerAccount, supporter, fieldToUse, true, locale);
            } else if (TEXTBAUSTEIN_SUPPORTERREF.equals(type)) {
                fieldToUse = null;
                for (Field field : Field.values()) {
                    if (!field.name().startsWith("USERDATA_") || field.getKey() == null || !field.getKey().equalsIgnoreCase(fieldname)) continue;
                    fieldToUse = field;
                    break;
                }
                replacer = this.getDisplayString(ticket, ticketOwnerAccount, supporter, fieldToUse, false, locale);
            }
            content = ((String)content).substring(0, startIndex) + replacer + ((String)content).substring(endIndex + TEXTBAUSTEIN_END_TAG.length());
        }
        return content;
    }

    private String getDisplayString(Ticket ticket, UserAccount ticketOwnerAccount, UserAccount supporterAccount, Field fieldToUse, boolean useTicketOwner, Locale locale) {
        Object value = null;
        if (fieldToUse != null) {
            if (fieldToUse.name().startsWith("TICKETDATA_")) {
                if (ticket != null) {
                    if (Field.TICKETDATA_ORDERID == fieldToUse) {
                        value = Tickets.getTicketIDForEmailSubject(ticket.getId());
                    } else if (Field.TICKETDATA_PRIORITYID == fieldToUse) {
                        value = "";
                        Integer prioInt = ticket.getValue(fieldToUse, Integer.class);
                        if (prioInt != null) {
                            int prioId = prioInt;
                            PriorityVO prio = (PriorityVO)PriorityManager.getInstance().get(prioId);
                            if (prio != null) {
                                value = prio.getDisplayValue();
                            }
                        }
                    } else {
                        value = ticket.getValue(fieldToUse, fieldToUse.getClassType());
                    }
                }
            } else if (fieldToUse.name().startsWith("USERDATA_")) {
                UserField userField;
                if (Field.USERDATA_GROUP.equals((Object)fieldToUse)) {
                    fieldToUse = Field.USERDATA_GROUP_DISPLAYNAME;
                }
                if (Field.USERDATA_LOCATION.equals((Object)fieldToUse)) {
                    fieldToUse = Field.USERDATA_LOCATION_DISPLAYNAME;
                }
                if (useTicketOwner) {
                    if (ticketOwnerAccount != null) {
                        userField = (UserField)HDFieldLocator.getUserFieldForDBKey(fieldToUse.getKey());
                        if (userField != null) {
                            value = ticketOwnerAccount.getValue(userField);
                        } else if (Field.USERDATA_DISPLAYNAME.getKey().equalsIgnoreCase(fieldToUse.getKey())) {
                            value = ticketOwnerAccount.getDisplayName();
                        } else if (Field.USERDATA_LOCATION_DISPLAYNAME.getKey().equalsIgnoreCase(fieldToUse.getKey())) {
                            Map locationData = HDUsersAndGroups.FIELD_LOCATION_ID.getSearchTag().getMapData();
                            Integer locationId = (Integer)ticketOwnerAccount.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
                            if (locationId != null) {
                                value = locationData.get(locationId);
                            }
                        }
                    }
                } else {
                    try {
                        userField = (UserField)HDFieldLocator.getUserFieldForDBKey(fieldToUse.getKey());
                        if (userField != null) {
                            value = supporterAccount.getValue(userField);
                        } else if (Field.USERDATA_DISPLAYNAME.getKey().equalsIgnoreCase(fieldToUse.getKey())) {
                            value = supporterAccount.getDisplayName();
                        }
                    }
                    catch (IllegalArgumentException exc) {
                        HDLogger.error(exc);
                        value = "";
                    }
                }
            }
        }
        if (value instanceof String[]) {
            String[] vals;
            StringBuilder b = new StringBuilder();
            for (String val : vals = (String[])value) {
                if (b.length() > 0) {
                    b.append("; ");
                }
                b.append(val);
            }
            value = b;
        }
        if (value instanceof Date) {
            value = DateFormat.getDateTimeInstance(2, 3, locale).format((Date)value);
        }
        return value == null ? "" : value.toString();
    }

    @Override
    public Font getDefaultFont() throws ServerDataException {
        String fontName = (String)DEFAULT_TICKET_FONT_NAME_VALUE.get();
        int fontSize = (Integer)DEFAULT_TICKET_FONT_SIZE_VALUE.get();
        if (StringFunctions.isEmpty((String)fontName)) {
            fontName = HDConfigKeys.DEFAULT_TICKET_FONT_NAME.getDefault();
        }
        if (fontSize <= 0) {
            fontSize = Integer.parseInt(HDConfigKeys.DEFAULT_TICKET_FONT_SIZE.getDefault());
        }
        return new Font(fontName, 0, fontSize);
    }

    @Override
    public Field[] getDisplayableTicketFields(ContextType contextType) throws ServerDataException {
        if (contextType == ContextType.enduser) {
            String userColumns = ServerUtilities.getOldstyleUserColumsFromConfigProperty();
            if (userColumns == null || userColumns.length() == 0) {
                userColumns = "0,1,3,2,4,5";
            }
            String[] colsStr = userColumns.split(",");
            Field[] config = new Field[colsStr.length];
            for (int i = 0; i < colsStr.length; ++i) {
                config[i] = TICKET_COLUMNS_ENDUSER.get(Integer.parseInt(colsStr[i]));
            }
            ArrayList<Field> configFields = new ArrayList<Field>(Arrays.asList(config));
            List fieldRemovers = ServerPluginManager.getInstance().get(TicketFieldRemover.class);
            for (TicketFieldRemover provider : fieldRemovers) {
                provider.removeUnwantedFields(configFields);
            }
            config = configFields.toArray(new Field[0]);
            return config;
        }
        return null;
    }

    @Override
    public boolean isSupporterNameDisplayable(ContextType contextType) throws ServerDataException {
        if (contextType == ContextType.enduser) {
            return (Boolean)ServerUtilities.CLIENT_ENDUSER_SHOWBEARBEITER.get();
        }
        return true;
    }

    @Override
    public List<Sorting.TranslatedSortField> getSortableFields(ContextType contextType, Field[] displayableTicketFields) {
        ArrayList<Sorting.TranslatedSortField> sortConfigs = new ArrayList<Sorting.TranslatedSortField>();
        LocalizationBundle localization = (LocalizationBundle)ServerPluginManager.getInstance().getSingleInstance(LocalizationBundle.class);
        TranslationTextConnector conFactory = (TranslationTextConnector)ServerPluginManager.getInstance().getSingleInstance(TranslationTextConnector.class);
        Localization instance = localization.getInstance(ClientLocale.getThreadLocale(), conFactory);
        block8: for (Field field : displayableTicketFields) {
            switch (field) {
                case TICKETDATA_LASTMODIFIED: {
                    sortConfigs.add(new Sorting.TranslatedSortField(Sorting.SortField.LASTMODIFIED, instance.getTranslation("sort.lastmodified")));
                    continue block8;
                }
                case TICKETDATA_STATUSID: {
                    sortConfigs.add(new Sorting.TranslatedSortField(Sorting.SortField.UNREAD, instance.getTranslation(contextType == ContextType.enduser ? "sort.unread.enduser" : "sort.unread")));
                    sortConfigs.add(new Sorting.TranslatedSortField(Sorting.SortField.STATUSID, instance.getTranslation("sort.state")));
                    continue block8;
                }
                case TICKETDATA_PRIORITYID: {
                    sortConfigs.add(new Sorting.TranslatedSortField(Sorting.SortField.PRIOID, instance.getTranslation("sort.prio")));
                    continue block8;
                }
                case TICKETDATA_OWNER: {
                    sortConfigs.add(new Sorting.TranslatedSortField(Sorting.SortField.TICKETOWNER, instance.getTranslation("sort.owner")));
                    continue block8;
                }
                case TICKETDATA_TICKETID: {
                    sortConfigs.add(new Sorting.TranslatedSortField(Sorting.SortField.TICKETID, instance.getTranslation("sort.ticketId")));
                    continue block8;
                }
                case TICKETDATA_SUBJECT: {
                    sortConfigs.add(new Sorting.TranslatedSortField(Sorting.SortField.SUBJECT, instance.getTranslation("sort.subject")));
                    continue block8;
                }
            }
        }
        Collections.sort(sortConfigs, new Comparator<Sorting.TranslatedSortField>(){

            @Override
            public int compare(Sorting.TranslatedSortField o1, Sorting.TranslatedSortField o2) {
                return o1.getSortField().ordinal() - o2.getSortField().ordinal();
            }
        });
        return sortConfigs;
    }

    @Override
    public int getDefaultReactivationTimeInDays() {
        return (Integer)DEFAULT_TICKET_REACTIVATION_TIME.get();
    }

    static {
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_TICKETID);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_HASATTACHMENTS);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_SUBJECT);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_STATUSID);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_RESOURCEID);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_INQUIRYDATE);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_CATEGORYID);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_PRIORITYID);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_CLASSIFICATIONID);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_ITILID);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_DEADLINE);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_TERMINVEREINBARUNG);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_SPECIALFIELD);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_LASTTEXTEDITOR);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_LASTMODIFIED);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_TICKETFIELD1);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_TICKETFIELD2);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_TICKETFIELD3);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_TICKETFIELD4);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_TICKETFIELD6);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_TICKETFIELD7);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_SUMTIMES);
        TICKET_COLUMNS_ENDUSER.add(Field.TICKETDATA_DUETIME);
    }
}

