/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.helpdesk.core.data.AdditionalFieldSetting;
import com.inet.helpdesk.core.data.LocalizationBundle;
import com.inet.helpdesk.core.data.ServerDataConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.TranslationTextConnector;
import com.inet.helpdesk.core.model.general.FieldSetting;
import com.inet.helpdesk.core.model.general.Localization;
import com.inet.helpdesk.core.model.inventory.DeviceType;
import com.inet.helpdesk.core.model.ticket.Action;
import com.inet.helpdesk.core.model.ticket.BillingInformation;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.model.FieldInformation;
import com.inet.helpdesk.shared.util.UtilityFunctions;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.jj.srv.JJServer;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.SuppressFBWarnings;
import srv.ServerUtilities;

public class ServerDataConnectorImpl
implements ServerDataConnector {
    private static final String SQL_GET_ACTION_FOR_AKTID = "SELECT * FROM tblAktionen WHERE AktID=?";
    private static final String SQL_GET_USERPROPERTIES = "SELECT Properties FROM tblUser WHERE UsrID=?";
    static final String SQL_GET_DEFAULTUSERVIEWPROPERTIES = "SELECT Config FROM tblOptionen";
    static final String SQL_UPDATE_USERVIEWPROPERTIES = "UPDATE tblOptionen Set Config=?";
    static final String PREFIX_USERVIEWCONFIG = "USERVIEWCONFIG_";
    private static HashSet<String> USERVIEWCONFIG_PROPNAMES = new HashSet<String>(){
        {
            this.add("allAttCols");
            this.add("AuthView");
            this.add("EBViewOption");
            this.add("QtView");
            this.add("btool");
            this.add("dtool");
            this.add("etool");
            this.add("EListS");
            this.add("EPView");
            this.add("ETreeSel");
            this.add("Eown");
            this.add("PanelConfig");
            this.add("SUshowTyp");
        }
    };
    private List<AdditionalFieldSetting> additionalFieldSettings = new ArrayList<AdditionalFieldSetting>();
    private final JJServer hdServerConnector;

    public ServerDataConnectorImpl(JJServer hdServerConnector) {
        this.hdServerConnector = hdServerConnector;
    }

    public static void closeAll(Connection con, Statement pst, ResultSet rs) {
        try {
            rs.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            pst.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            con.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public FieldInformation getFieldInformation(String language) throws ServerDataException {
        FieldInformation fieldInformation = new FieldInformation(language);
        try {
            LocalizationBundle localization = (LocalizationBundle)ServerPluginManager.getInstance().getSingleInstance(LocalizationBundle.class);
            TranslationTextConnector conFactory = (TranslationTextConnector)ServerPluginManager.getInstance().getSingleInstance(TranslationTextConnector.class);
            Locale locale = new Locale(language);
            Localization instance = localization.getInstance(locale, conFactory);
            for (Field field : Field.values()) {
                String labelText = instance.getTranslation(field);
                if (labelText != null) {
                    fieldInformation.addFieldDisplayName(field.name(), labelText);
                }
                fieldInformation.addFieldMaxLength(field.name(), field.getMaxLength());
            }
            for (AdditionalFieldSetting additionalFieldSetting : this.additionalFieldSettings) {
                List<AdditionalFieldSetting.FieldData> fieldData = additionalFieldSetting.getFieldData(instance);
                if (fieldData == null) continue;
                for (AdditionalFieldSetting.FieldData fd : fieldData) {
                    String fieldName = fd.getName();
                    String labelText = fd.getDisplayName();
                    if (labelText != null) {
                        fieldInformation.addFieldDisplayName(fieldName, labelText);
                    }
                    fieldInformation.addFieldMaxLength(fieldName, fd.getMaxLength());
                }
            }
        }
        catch (Exception ex) {
            throw new ServerDataException(ex);
        }
        return fieldInformation;
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="statement has no parameters")
    public Map<Integer, FieldSetting> getFieldSettings() throws ServerDataException {
        HashMap<Integer, FieldSetting> settings;
        ResultSet result;
        PreparedStatement stm;
        Connection connection;
        block8: {
            block7: {
                connection = null;
                stm = null;
                result = null;
                settings = new HashMap<Integer, FieldSetting>();
                connection = this.hdServerConnector.getConnection("HDS");
                String command = (String)this.hdServerConnector.getCommand("DialogSettings");
                stm = connection.prepareStatement(command);
                if (stm != null) break block7;
                HashMap<Integer, FieldSetting> hashMap = settings;
                ServerDataConnectorImpl.closeAll(connection, stm, result);
                return hashMap;
            }
            result = stm.executeQuery();
            if (result != null) break block8;
            HashMap<Integer, FieldSetting> hashMap = settings;
            ServerDataConnectorImpl.closeAll(connection, stm, result);
            return hashMap;
        }
        try {
            while (result.next()) {
                int id = result.getInt(1);
                settings.put(id, new FieldSetting(id, result.getString(2), result.getInt(4), result.getInt(5)));
            }
        }
        catch (SQLException e) {
            try {
                throw new ServerDataException(e);
            }
            catch (Throwable throwable) {
                ServerDataConnectorImpl.closeAll(connection, stm, result);
                throw throwable;
            }
        }
        ServerDataConnectorImpl.closeAll(connection, stm, result);
        return settings;
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="statement has no parameters")
    public ArrayList<Action> getAllActions() throws ServerDataException {
        Connection con = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        ArrayList<Action> result = new ArrayList<Action>();
        try {
            con = this.hdServerConnector.getConnection("HDS");
            pst = con.prepareStatement(this.hdServerConnector.getCommand("AktionenAll").toString());
            rs = pst.executeQuery();
            while (rs.next()) {
                int aktID = rs.getInt("AktID");
                String displayName = rs.getString("AktBezeichnung");
                int status = rs.getInt("Status");
                int intern = rs.getInt("intern");
                int deleted = rs.getInt("geloescht");
                int spezial = rs.getInt("Spezial");
                result.add(new Action(aktID, displayName, status, Action.isSystemStep(aktID), intern != 0, deleted != 0, spezial));
            }
        }
        catch (Exception ex) {
            try {
                throw new ServerDataException(ex);
            }
            catch (Throwable throwable) {
                ServerDataConnectorImpl.closeAll(con, pst, rs);
                throw throwable;
            }
        }
        ServerDataConnectorImpl.closeAll(con, pst, rs);
        return result;
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="statement has no statements")
    public ArrayList<DeviceType> getDeviceTypes() throws ServerDataException {
        Connection con = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        ArrayList<DeviceType> result = new ArrayList<DeviceType>();
        try {
            con = this.hdServerConnector.getConnection("HDS");
            pst = con.prepareStatement(this.hdServerConnector.getCommand("GerTypen").toString());
            rs = pst.executeQuery();
            while (rs.next()) {
                String displayName = rs.getString("Bezeichnung");
                String image = rs.getString("Symbol");
                int id = rs.getInt("GTyID");
                result.add(new DeviceType(id, displayName, image));
            }
        }
        catch (Exception ex) {
            try {
                throw new ServerDataException(ex);
            }
            catch (Throwable throwable) {
                ServerDataConnectorImpl.closeAll(con, pst, rs);
                throw throwable;
            }
        }
        ServerDataConnectorImpl.closeAll(con, pst, rs);
        return result;
    }

    @Override
    public Action getAction(int aktID) throws ServerDataException {
        ResultSet rs;
        PreparedStatement pst;
        Connection con;
        block4: {
            Action action;
            con = null;
            pst = null;
            rs = null;
            try {
                Action action2;
                con = this.hdServerConnector.getConnection("HDS");
                pst = con.prepareStatement(SQL_GET_ACTION_FOR_AKTID);
                pst.setInt(1, aktID);
                rs = pst.executeQuery();
                if (!rs.next()) break block4;
                String displayName = rs.getString("AktBezeichnung");
                int status = rs.getInt("Status");
                int intern = rs.getInt("intern");
                int deleted = rs.getInt("geloescht");
                int spezial = rs.getInt("Spezial");
                action = action2 = new Action(aktID, displayName, status, Action.isSystemStep(aktID), intern == 1, deleted == 1, spezial);
            }
            catch (Exception ex) {
                try {
                    throw new ServerDataException(ex);
                }
                catch (Throwable throwable) {
                    ServerDataConnectorImpl.closeAll(con, pst, rs);
                    throw throwable;
                }
            }
            ServerDataConnectorImpl.closeAll(con, pst, rs);
            return action;
        }
        ServerDataConnectorImpl.closeAll(con, pst, rs);
        return null;
    }

    public static BillingInformation getBilling(int actionId, UserAccount user) {
        BillingInformation billing = new BillingInformation();
        ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(actionId);
        if (actionVO == null) {
            return null;
        }
        int billingType = actionVO.getBillingType();
        if (billingType == 0) {
            billing.setLumpSum(null);
        } else {
            int lumpSumType = actionVO.getLumpSumType();
            double actionLumpSum = actionVO.getFixedCharge();
            if (lumpSumType == 0) {
                billing.setLumpSum(new BigDecimal(actionLumpSum));
            } else if (lumpSumType != -1) {
                Double lumpSum = null;
                switch (lumpSumType) {
                    case 1: {
                        lumpSum = (Double)user.getValue((UserField)HDUsersAndGroups.FIELD_LUMP_SUM_1);
                        break;
                    }
                    case 2: {
                        lumpSum = (Double)user.getValue((UserField)HDUsersAndGroups.FIELD_LUMP_SUM_2);
                        break;
                    }
                    case 3: {
                        lumpSum = (Double)user.getValue((UserField)HDUsersAndGroups.FIELD_LUMP_SUM_3);
                    }
                }
                if (lumpSum != null) {
                    actionLumpSum = lumpSum;
                }
                billing.setLumpSum(new BigDecimal(actionLumpSum));
            } else {
                billing.setLumpSum(null);
            }
        }
        billing.setHourlyRated(billingType != 1);
        return billing;
    }

    @Override
    public void checkForInvalidatedSessions() {
        ServerUtilities.conti.checkForInvalidatedSessions();
    }

    @Override
    public Properties getDefaultUserViewProperties() throws ServerDataException {
        Connection con = null;
        Statement pst = null;
        ResultSet rs = null;
        Properties properties = null;
        try {
            Properties configProperties;
            byte[] bytes;
            String configString;
            con = this.hdServerConnector.getConnection("HDS");
            pst = con.createStatement();
            rs = pst.executeQuery(SQL_GET_DEFAULTUSERVIEWPROPERTIES);
            if (rs.next() && (configString = rs.getString("Config")) != null && (bytes = configString.getBytes()) != null && bytes.length > 0 && (configProperties = UtilityFunctions.loadConfigProperties(bytes)) != null) {
                properties = new Properties();
                Enumeration<?> propertyNames = configProperties.propertyNames();
                while (propertyNames.hasMoreElements()) {
                    String value;
                    String key = (String)propertyNames.nextElement();
                    if (key == null || !key.startsWith(PREFIX_USERVIEWCONFIG) || (value = configProperties.getProperty(key)) == null) continue;
                    properties.setProperty(key.substring(PREFIX_USERVIEWCONFIG.length()), value);
                }
            }
        }
        catch (Exception ex) {
            try {
                throw new ServerDataException(ex);
            }
            catch (Throwable throwable) {
                ServerDataConnectorImpl.closeAll(con, pst, rs);
                throw throwable;
            }
        }
        ServerDataConnectorImpl.closeAll(con, pst, rs);
        return properties == null ? new Properties() : properties;
    }

    @Override
    public void saveDefaultUserViewProperties(Properties properties) throws ServerDataException {
        PreparedStatement stm = null;
        Statement st = null;
        ResultSet rs = null;
        Connection con = null;
        try {
            if (properties == null) {
                properties = new Properties();
            }
            Properties targetProperties = new Properties();
            con = this.hdServerConnector.getConnection("HDS");
            st = con.createStatement();
            rs = st.executeQuery(SQL_GET_DEFAULTUSERVIEWPROPERTIES);
            if (rs.next()) {
                Properties props;
                String stringValue = rs.getString("Config");
                byte[] configProperties = null;
                if (stringValue != null) {
                    configProperties = stringValue.getBytes();
                }
                if (configProperties != null && configProperties.length > 0 && (props = UtilityFunctions.loadConfigProperties(configProperties)) != null) {
                    Enumeration<?> propertyNames = props.propertyNames();
                    while (propertyNames.hasMoreElements()) {
                        String key = (String)propertyNames.nextElement();
                        if (key.startsWith(PREFIX_USERVIEWCONFIG)) continue;
                        String value = props.getProperty(key);
                        targetProperties.setProperty(key, value);
                    }
                }
            }
            ServerDataConnectorImpl.closeAll(null, st, rs);
            Enumeration<?> propertyNames = properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String value;
                String key = (String)propertyNames.nextElement();
                if (!USERVIEWCONFIG_PROPNAMES.contains(key) || (value = properties.getProperty(key)) == null) continue;
                targetProperties.setProperty(PREFIX_USERVIEWCONFIG + key, value);
            }
            stm = con.prepareStatement(SQL_UPDATE_USERVIEWPROPERTIES);
            stm.setString(1, new String(UtilityFunctions.getEncodedBytesFromProperties(targetProperties)));
            stm.execute();
        }
        catch (Exception ex) {
            try {
                throw new ServerDataException(ex);
            }
            catch (Throwable throwable) {
                ServerDataConnectorImpl.closeAll(con, stm, null);
                throw throwable;
            }
        }
        ServerDataConnectorImpl.closeAll(con, stm, null);
    }

    @Override
    public void saveUserPropertiesAsDefault(int userID) throws ServerDataException {
        Connection con = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        Properties properties = null;
        try {
            con = this.hdServerConnector.getConnection("HDS");
            pst = con.prepareStatement(SQL_GET_USERPROPERTIES);
            pst.setInt(1, userID);
            rs = pst.executeQuery();
            if (rs.next()) {
                properties = UtilityFunctions.loadConfigProperties(rs.getBytes("Properties"));
            }
        }
        catch (Exception ex) {
            try {
                throw new ServerDataException(ex);
            }
            catch (Throwable throwable) {
                ServerDataConnectorImpl.closeAll(con, pst, rs);
                throw throwable;
            }
        }
        ServerDataConnectorImpl.closeAll(con, pst, rs);
        this.saveDefaultUserViewProperties(properties);
    }

    public void init() {
        this.additionalFieldSettings.addAll(ServerPluginManager.getInstance().get(AdditionalFieldSetting.class));
    }
}

