/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ReactivationListener;
import com.inet.helpdesk.core.servlets.rpc.ProxyPacketHandler;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketManipulatorBackdoor;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.data.ProcessStartDateUpdater;
import com.inet.helpdesk.shared.communication.Processing;
import com.inet.helpdesk.shared.model.ticket.NewTicketData;
import com.inet.helpdesk.shared.model.ticket.ReaStepData;
import com.inet.helpdesk.shared.util.UtilityFunctions;
import com.inet.helpdesk.ticketmanager.trigger.StatusAndItilChangeTrigger;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.jj.srv.JJServer;
import com.inet.jj.srv.JavaCommandFactory;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import srv.ServerUtilities;
import srv.SpecialSqlCommand;
import srv.controller.OpenOrderController;
import srv.controller.TicketAccessController;
import srv.controller.UserSession;
import srv.controller.ticket.Auftrag;
import srv.controller.ticket.AuftragWithReferences;
import srv.controller.ticket.AuftragsReferenz;
import srv.controller.ticket.attributes.User;
import srv.mail.AutoMailSender;

public class ProcessingImp
extends ProxyPacketHandler
implements Processing {
    static final long ONE_MINUTE = 60000L;
    private final JJServer hdServerConnector;
    private final ServerPluginManager spm;
    private static final ConfigValue<Integer> CLIENT_START_OPTION = new ConfigValue(HDConfigKeys.CLIENT_START_OPTION);

    public ProcessingImp(JJServer hdServerConnector, ServerPluginManager spm) {
        this.hdServerConnector = hdServerConnector;
        this.spm = spm;
    }

    @Override
    public Integer insertProcessingStep(String commandName, ReaStepData step) throws IOException {
        try {
            boolean updateTicketText = !StringFunctions.isEmpty((String)step.getWas());
            return TicketManipulatorBackdoor.getBackdoor().updateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(step.getSlaveId(), updateTicketText, () -> {
                Statement stm = null;
                try {
                    Integer n;
                    block20: {
                        Connection con = this.hdServerConnector.getConnection("HDS");
                        try {
                            this.writeStep(con, step);
                            if (!"HelpDesk".equals(step.getDisplayName())) {
                                JavaCommandFactory command = (JavaCommandFactory)this.hdServerConnector.getCommand(commandName);
                                stm = command.prepareCommand(con);
                                stm.setString(1, step.getDisplayName());
                                stm.setInt(2, step.getSlaveId());
                                stm.setInt(3, HDUsersAndGroups.getUserID(UserManager.getInstance().getCurrentUserAccountID()));
                                if (step.getUserID() != null) {
                                    stm.setInt(4, step.getUserID());
                                } else {
                                    stm.setNull(4, 4);
                                }
                                stm.setInt(5, step.getBunId());
                                stm.execute();
                                if (step.getBis() - step.getVon() >= 60000L) {
                                    ServerUtilities.calculateProcessingTime(con, step.getBunId());
                                }
                            }
                            n = new Integer(step.getReaId());
                            if (con == null) break block20;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (con != null) {
                                    try {
                                        con.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                HDLogger.error(e);
                                throw new IOException(e);
                            }
                        }
                        con.close();
                    }
                    return n;
                }
                finally {
                    if (stm != null) {
                        try {
                            stm.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            });
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public ReaStepData createTicket(NewTicketData ticketData, ReaStepData initialStep) throws IOException {
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            int bunId = TicketManipulatorBackdoor.getBackdoor().getIDGenerator().generateNewTicketID();
            con = this.hdServerConnector.getConnection("HDS");
            con.setAutoCommit(false);
            st = con.createStatement(1005, 1008);
            rs = st.executeQuery("Select * From tblBuendel Where 1 = 0");
            rs.moveToInsertRow();
            rs.updateInt("BunID", bunId);
            rs.updateInt("Status", ticketData.getStatus());
            if (ticketData.getProcessor() != null) {
                rs.updateInt("LastEditorID", (int)ticketData.getProcessor());
                rs.updateString("Bearbeiter", HDUsersAndGroups.getUserAccount(ticketData.getProcessor()).getDisplayName());
            }
            this.updateIfNotNull(rs, "BunFeld1", ticketData.getCustomizationField1());
            this.updateIfNotNull(rs, "BunFeld2", ticketData.getCustomizationField2());
            this.updateIfNotNull(rs, "BunFeld3", ticketData.getCustomizationField3());
            this.updateIfNotNull(rs, "BunFeld4", ticketData.getCustomizationField4());
            this.updateIfNotNull(rs, "BunFeld5", ticketData.getCustomizationField5());
            rs.updateInt("SollZeit", ticketData.getTargetTime());
            rs.insertRow();
            rs.last();
            initialStep.setBunId(bunId);
            initialStep.setSlaveId(bunId);
            try {
                rs.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.writeStep(con, initialStep);
            rs = st.executeQuery("SELECT * FROM tblAuftraege WHERE 1 = 0");
            rs.moveToInsertRow();
            rs.updateInt("UsrID", ticketData.getUserId());
            rs.updateInt("ResID", ticketData.getResourceId());
            rs.updateInt("PriID", ticketData.getPriorityId());
            rs.updateInt("ItiID", ticketData.getItilId());
            rs.updateInt("BunID", initialStep.getBunId());
            rs.updateInt("AufID", initialStep.getBunId());
            rs.updateInt("ishtml", ticketData.isHtml() ? 1 : 0);
            rs.updateInt("KlaID", ticketData.getClassificationId());
            rs.updateInt("Master", 1);
            rs.updateInt("AnfReaID", initialStep.getReaId());
            rs.updateString("Auftrag", ticketData.getTicketText());
            if (ticketData.getCategoryId() != null) {
                rs.updateInt("BetID", (int)ticketData.getCategoryId());
            } else {
                rs.updateNull("BetID");
            }
            rs.updateString("DerBetreff", ticketData.getSubject());
            rs.updateString("spezFeld", ticketData.getIdentifier());
            if (ticketData.getWorkflowId() > 0) {
                rs.updateInt("WFID", ticketData.getWorkflowId());
            }
            if (ticketData.getDeadline() > 0L) {
                rs.updateTimestamp("DeadlineZeit", new Timestamp(ticketData.getDeadline()));
            }
            rs.updateString("EmailEingang", ticketData.getTicketType());
            rs.insertRow();
            con.commit();
            TicketManipulatorBackdoor.getBackdoor().notifyNewTicketCreatedUpdateSearchIndexAfterwardsAndSendEvent(initialStep.getBunId());
            if (ticketData.getWorkflowId() > 0) {
                SpecialSqlCommand command = new SpecialSqlCommand(con, "SetBuendelStatus", null, -1, 0, false, 6, false);
                command.setInt(1, -2);
                command.setInt(2, ticketData.getStatus());
                command.setInt(3, initialStep.getBunId());
                command.setInt(4, 9);
                int responsible = initialStep.getUserID();
                User user = new User(responsible);
                command.setInt(5, responsible);
                command.setInt(6, responsible);
                command.setString(7, user.getEmail());
                command.executeUpdate();
                command.close();
            }
        }
        catch (Exception e) {
            try {
                con.rollback();
            }
            catch (SQLException e1) {
                HDLogger.error(e1);
            }
            HDLogger.error(e);
            throw new IOException(e);
        }
        finally {
            try {
                con.setAutoCommit(true);
            }
            catch (Throwable throwable) {}
            try {
                st.close();
            }
            catch (Throwable throwable) {}
            try {
                st.close();
            }
            catch (Throwable throwable) {}
            try {
                con.close();
            }
            catch (Throwable throwable) {}
        }
        return initialStep;
    }

    @Override
    public Class<?> getRemoteInterface() {
        return Processing.class;
    }

    private void updateIfNotNull(ResultSet rs, String column, String value) throws SQLException {
        if (value != null) {
            rs.updateString(column, value);
        }
    }

    private void writeStep(Connection con, ReaStepData step) throws SQLException {
        Double lumpSum = step.getLumpSum() > 0.0 ? new Double(step.getLumpSum()) : null;
        Double hourlyRate = step.getHourlyRate() > 0.0 ? new Double(step.getHourlyRate()) : null;
        int html = step.isHtml() ? 1 : 0;
        Timestamp von = new Timestamp(step.getVon());
        Timestamp bis = new Timestamp(step.getBis());
        int reaid = ServerUtilities.addRealisierung(con, null, step.getBunId(), step.getSlaveId(), step.getActionId(), step.getBillingResource(), von, bis, hourlyRate, step.getUserID(), step.getDisplayName(), step.getSender(), step.getEmailTo(), step.getEmailCC(), step.getEmailBCC(), step.getAttachmentsId(), step.getWas(), html, step.getDescription(), lumpSum);
        step.setReaId(reaid);
        if (step.getActionId() == 5) {
            String sql = "UPDATE tblAuftraege SET AutorisierenReaID = ? WHERE AufID = ?";
            PreparedStatement pstm = con.prepareStatement(sql);
            pstm.setInt(1, reaid);
            pstm.setInt(2, step.getSlaveId());
            pstm.executeUpdate();
            new ProcessStartDateUpdater().updateProcessStartDateIfRequired(con, step.getSlaveId());
        }
    }

    @Override
    public int[] reactivateTicket(ReaStepData step, int resource, int status, boolean hasDeadline, Integer sessionOfOwnerId) throws IOException {
        try {
            ArrayList<AuftragsReferenz> subOrderRefs;
            AtomicInteger count = new AtomicInteger(0);
            AtomicInteger processorId = new AtomicInteger(-1);
            AtomicReference<Object> processorEmail = new AtomicReference<Object>(null);
            UserSession session = sessionOfOwnerId != null ? ServerUtilities.conti.getUserSession(sessionOfOwnerId) : null;
            int[] result = TicketManipulatorBackdoor.getBackdoor().updateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(step.getSlaveId(), () -> {
                Connection con = null;
                Statement pst = null;
                try {
                    if (session != null) {
                        UserAccount usr = session.getOwner();
                        processorEmail.set(((String)usr.getValue((UserField)UsersAndGroups.FIELD_EMAIL)));
                        processorId.set(HDUsersAndGroups.getUserID(usr));
                    }
                    int[] _result = new int[]{0, 0};
                    con = this.hdServerConnector.getConnection("HDS");
                    if (resource > -1) {
                        pst = con.prepareStatement("UPDATE tblAuftraege SET ResID = ? WHERE AufID = ?");
                        pst.setInt(1, resource);
                        pst.setInt(2, step.getBunId());
                        pst.execute();
                        try {
                            pst.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    pst = con.prepareStatement("UPDATE tblBuendel SET Bearbeiter = ?, BearbeitungsDatum = ?, Status = ?, LastEditorID = ? WHERE BunID = ? AND Status > 299");
                    pst.setString(1, step.getDisplayName());
                    pst.setTimestamp(2, new Timestamp(step.getVon()));
                    pst.setInt(3, status);
                    pst.setInt(4, processorId.get());
                    pst.setInt(5, step.getBunId());
                    count.set(pst.executeUpdate());
                    try {
                        pst.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    pst = con.prepareStatement("UPDATE tblAuftraege SET AutorisierenReaID = ? WHERE AufID = ? AND AutorisierenReaID is null");
                    pst.setInt(1, -1);
                    pst.setInt(2, step.getBunId());
                    pst.execute();
                    int[] nArray = _result;
                    return nArray;
                }
                finally {
                    try {
                        pst.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        con.close();
                    }
                    catch (Throwable throwable) {}
                }
            });
            int[] reszultarray = TicketManipulatorBackdoor.getBackdoor().updateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(step.getSlaveId(), () -> {
                Connection con = null;
                Statement pst = null;
                try {
                    if (count.get() > 0) {
                        con = this.hdServerConnector.getConnection("HDS");
                        if (hasDeadline && ((Integer)CLIENT_START_OPTION.get() & 0x80) != 0) {
                            ServerUtilities.resetDeadline(step.getBunId());
                        }
                        this.writeStep(con, step);
                        result[0] = step.getReaId();
                        pst = con.prepareStatement("UPDATE tblAuftraege SET AutorisierenReaID = ? WHERE AufID = ? AND AutorisierenReaID = -1");
                        pst.setInt(1, step.getReaId());
                        pst.setInt(2, step.getBunId());
                        pst.execute();
                        try {
                            pst.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        AutoMailSender.sendIfNeeded(step.getBunId(), 10, (String)processorEmail.get());
                        ServerUtilities.getOpenOrderController().notifyResourceIfNeeded(step.getBunId(), 10, processorId.get());
                        List listeners = this.spm.get(ReactivationListener.class);
                        for (ReactivationListener listener : listeners) {
                            listener.ticketReactivated(con, step.getBunId(), null);
                        }
                        if (session != null && status == 103) {
                            TicketAccessController accessController = ServerUtilities.conti.getTicketAccessController();
                            int[] openedOrders = null;
                            if (session.getCountOfOpenOrders() > 0) {
                                int[] opened = accessController.getOpenedTicketsOfSession(session);
                                if (UtilityFunctions.contains(step.getBunId(), opened)) {
                                    openedOrders = opened;
                                } else {
                                    openedOrders = new int[opened.length + 1];
                                    System.arraycopy(opened, 0, openedOrders, 0, opened.length);
                                    openedOrders[opened.length] = step.getBunId();
                                }
                            } else {
                                openedOrders = new int[]{step.getBunId()};
                            }
                            accessController.handleOpenedOrders(session, openedOrders, null);
                        }
                    }
                    int[] nArray = result;
                    return nArray;
                }
                finally {
                    try {
                        pst.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        con.close();
                    }
                    catch (Throwable throwable) {}
                }
            });
            ServerUtilities.getOpenOrderController();
            reszultarray[1] = OpenOrderController.getCurrentVersion();
            Auftrag ticket = ServerUtilities.getOpenOrderController().getAuftrag(step.getBunId());
            if (ticket instanceof AuftragWithReferences && (subOrderRefs = ((AuftragWithReferences)ticket).getSubOrderReferences()) != null) {
                try (Connection con = this.hdServerConnector.getConnection("HDS");
                     PreparedStatement pstFinal = con.prepareStatement("UPDATE tblBuendel SET Bearbeiter = ?, BearbeitungsDatum = ?, Status = ?, LastEditorID = ? WHERE BunID = ? AND Status > 299");){
                    int processorIdFinal = processorId.get();
                    for (AuftragsReferenz subOrderRef : subOrderRefs) {
                        TicketManipulatorBackdoor.getBackdoor().updateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(subOrderRef.getReferencedTicketId(), () -> {
                            pstFinal.setString(1, step.getDisplayName());
                            pstFinal.setTimestamp(2, new Timestamp(step.getVon()));
                            pstFinal.setInt(3, status);
                            pstFinal.setInt(4, processorIdFinal);
                            pstFinal.setInt(5, subOrderRef.getReferencedTicketId());
                            pstFinal.execute();
                            return null;
                        });
                    }
                }
            }
            return reszultarray;
        }
        catch (SQLException e) {
            HDLogger.error(e);
            throw new IOException(e);
        }
    }

    @Override
    public boolean updateReastepText(int reaStepID, String text, boolean ishtml) throws IOException {
        return TicketManager.getManipulator().updateReaStepText(reaStepID, ReaStepTextVO.of(text, ishtml), ExtensionArguments.create()) != 0;
    }

    @Override
    public void executeStatusTriggerIfActionDidNotChangeStatus(int ticketID, int ticketStatusBeforeChange) throws IOException {
        StatusAndItilChangeTrigger.executeStatusTriggerIfActionDidNotChangeStatus(ticketID, ticketStatusBeforeChange);
    }

    @Override
    public void executeSendAutomail(int ticketID, String producerAddress, int mailType) throws IOException {
        AutoMailSender.sendIfNeeded(ticketID, mailType, producerAddress);
    }

    @Override
    public void executeSendAutomailAndNotifyResource(int ticketID, int mailType, String producerAddress, int producerID) throws IOException {
        AutoMailSender.sendIfNeeded(ticketID, mailType, producerAddress);
        ServerUtilities.getOpenOrderController().notifyResourceIfNeeded(ticketID, mailType, producerID);
    }

    @Override
    public String fillAutoTextPlaceholders(String content, @Nullable Integer ticketId, @Nullable Integer stepId) {
        return ((AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class)).fillPlaceholders(content, ticketId, stepId);
    }
}

