/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.helpdesk.core.servlets.rpc.ProxyPacketHandler;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.shared.communication.LocationDataAccess;
import com.inet.helpdesk.shared.model.LocationDataSet;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.stream.Collectors;

public class LocationDataAccessImpl
extends ProxyPacketHandler
implements LocationDataAccess {
    @Override
    public Map<Integer, String> getAllDisplayNames(boolean onlyActiveEntries) throws IOException {
        return LocationManager.getInstance().getAll(onlyActiveEntries).stream().filter(vo -> vo.getDisplayValue() != null).collect(Collectors.toMap(c -> c.getId(), FieldVO::getDisplayValue));
    }

    @Override
    public Class<?> getRemoteInterface() {
        return LocationDataAccess.class;
    }

    @Override
    public LocationDataSet updateCustomerData(LocationDataSet data) throws IOException {
        int standardLocation = (Integer)HDUsersAndGroups.FIELD_LOCATION_ID.getDefaultValue();
        if (standardLocation == data.getGebId() && data.isDeleted()) {
            throw new IOException("Standard location");
        }
        LocationVO vo = new LocationVO(data.getGebId(), data.getName(), data.getComment(), data.getAddress(), data.getValues(), data.getSlaPriority(), data.isDeleted());
        try {
            LocationManager.getInstance().update(vo);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return data;
    }

    @Override
    public LocationDataSet insertCustomerData(LocationDataSet data) throws IOException {
        LocationVO vo = new LocationVO(data.getGebId(), data.getName(), data.getComment(), data.getAddress(), data.getValues(), data.getSlaPriority(), data.isDeleted());
        try {
            LocationManager.getInstance().add(vo);
            data.setGebId(vo.getId());
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return data;
    }
}

