/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.dbupdater.UpdaterCore;
import com.inet.dbupdater.UpdaterListener;
import com.inet.dbupdater.data.StateDescription;
import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.DatabaseInfosMsSQL;
import com.inet.dbupdater.databases.DatabaseInfosMySQL;
import com.inet.dbupdater.databases.DatabaseInfosOracle;
import com.inet.dbupdater.dbconnection.DBConnection;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.DBUpdateBackdoor;
import com.inet.lib.util.IOFunctions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.annotation.SuppressFBWarnings;
import srv.ServerUtilities;

public class DBUpdateComponent
implements DBUpdateBackdoor {
    private static final String TEST_DB_UPDATE = "TestDBUpdate";

    @Override
    public void updateDB(DatabaseConfigInfo sourceInfo, String systemUser, String systemPassword, UpdaterListener ulistener) throws SQLException {
        this.updateorMigrateDBWithDefaultStructure(sourceInfo, null, systemUser, systemPassword, ulistener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Internal API, resource is copied to temp file")
    public void updateDB(DatabaseConfigInfo sourceInfo, URL structureResource, String systemUser, String systemPassword, UpdaterListener ulistener) throws SQLException {
        File installFile = null;
        try {
            try {
                installFile = File.createTempFile("DBUpdateDatabaseStructure", "xml");
                try (InputStream input = structureResource.openStream();
                     FileOutputStream output = new FileOutputStream(installFile);){
                    IOFunctions.copyData((InputStream)input, (OutputStream)output);
                }
            }
            catch (IOException ex) {
                throw new SQLException("Cannot extract the given database structure file", ex);
            }
            this.updateorMigrateDB(sourceInfo, null, installFile, systemUser, systemPassword, ulistener);
        }
        finally {
            if (installFile != null) {
                installFile.delete();
            }
        }
    }

    @Override
    public void migrateDB(DatabaseConfigInfo sourceInfo, DatabaseConfigInfo targetInfo, String systemUser, String systemPassword, UpdaterListener ulistener) throws SQLException {
        this.updateorMigrateDBWithDefaultStructure(sourceInfo, targetInfo, systemUser, systemPassword, ulistener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateorMigrateDBWithDefaultStructure(DatabaseConfigInfo sourceInfo, DatabaseConfigInfo targetInfo, String systemUser, String systemPassword, UpdaterListener ulistener) throws SQLException {
        File installFile = null;
        boolean deleteFileAtTheEnd = false;
        try {
            try {
                installFile = new File(this.getClass().getClassLoader().getResource("cmd/installHD71.xml").toURI());
            }
            catch (IllegalArgumentException | URISyntaxException e) {
                try {
                    installFile = File.createTempFile("DBUpdateInstallHD71", "xml");
                    URL resource = this.getClass().getClassLoader().getResource("cmd/installHD71.xml");
                    try (InputStream input = resource.openStream();
                         FileOutputStream output = new FileOutputStream(installFile);){
                        IOFunctions.copyData((InputStream)input, (OutputStream)output);
                    }
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Cannot extract the installHD71.xml file", ex);
                }
                deleteFileAtTheEnd = true;
            }
            this.updateorMigrateDB(sourceInfo, targetInfo, installFile, systemUser, systemPassword, ulistener);
        }
        finally {
            if (deleteFileAtTheEnd && installFile != null) {
                installFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateorMigrateDB(DatabaseConfigInfo sourceInfo, DatabaseConfigInfo targetInfo, File structureFile, String systemUser, String systemPassword, UpdaterListener ulistener) throws SQLException {
        String url = sourceInfo.getUrl();
        String user = sourceInfo.getUser();
        String pwd = sourceInfo.getDecodedPassword();
        if (user == null) {
            user = "";
        }
        if (pwd == null) {
            pwd = "";
        }
        ServerUtilities.getJJServer().addUDS(TEST_DB_UPDATE, null, url, user, pwd);
        Connection dbCon = null;
        try {
            StateDescription currentDB;
            try {
                dbCon = ServerUtilities.getJJServer().getConnection(TEST_DB_UPDATE);
                currentDB = this.createCurrentStateDescription(sourceInfo, dbCon, null);
            }
            catch (SQLException sql) {
                String accountPassword;
                String accountUser;
                String jdbcPassword;
                String jdbcUser;
                if (systemUser == null || systemUser.isEmpty() || systemPassword == null) {
                    if (DatabaseConfigInfo.DatabaseType.inetora.equals((Object)sourceInfo.getDriver())) {
                        throw sql;
                    }
                    jdbcUser = user;
                    jdbcPassword = pwd;
                    accountUser = null;
                    accountPassword = null;
                } else {
                    jdbcUser = systemUser;
                    jdbcPassword = systemPassword;
                    accountUser = user;
                    accountPassword = pwd;
                }
                String catalog = DatabaseConfigInfo.DatabaseType.inetora.equals((Object)sourceInfo.getDriver()) ? sourceInfo.getUser() : sourceInfo.getCatalogForConnection();
                currentDB = new StateDescription(catalog, sourceInfo.getDriverClassName(), jdbcUser, jdbcPassword, sourceInfo.getUrlWithoutDB(), null, null, accountUser, accountPassword);
            }
            if (structureFile == null || !structureFile.canRead()) {
                throw new IllegalStateException("DB-Update: no structure file " + (String)(structureFile == null ? "provided" : "'" + structureFile.getAbsolutePath() + "'"));
            }
            StateDescription targetState = null;
            if (targetInfo == null) {
                targetState = new StateDescription(null, null, null, null, null, structureFile, null, null, null);
            } else {
                String accountPassword;
                String accountUser;
                String jdbcPassword;
                String jdbcUser;
                String catalog;
                String string = catalog = DatabaseConfigInfo.DatabaseType.inetora.equals((Object)targetInfo.getDriver()) ? targetInfo.getUser() : targetInfo.getCatalogForConnection();
                if (systemUser == null || systemUser.isEmpty()) {
                    jdbcUser = targetInfo.getUser();
                    jdbcPassword = targetInfo.getDecodedPassword();
                    accountUser = null;
                    accountPassword = null;
                } else {
                    jdbcUser = systemUser;
                    jdbcPassword = systemPassword == null ? "" : systemPassword;
                    accountUser = targetInfo.getUser();
                    accountPassword = targetInfo.getDecodedPassword();
                }
                targetState = new StateDescription(catalog, targetInfo.getDriverClassName(), jdbcUser, jdbcPassword, targetInfo.getUrlWithoutDB(), structureFile, null, accountUser, accountPassword);
            }
            UpdaterCore updater = new UpdaterCore(currentDB, targetState);
            if (ulistener != null) {
                updater.addUpdaterListener(ulistener);
            }
            updater.prepare();
            HDLogger.info("Db Update: executing");
            boolean success = updater.execute();
            HDLogger.info("Db Update: " + (success ? "success" : "FAILED"));
            if (!success) {
                List<Exception> ex = updater.getCatchedExceptions();
                if (ex != null && !ex.isEmpty()) {
                    throw new SQLException(ex.get(0));
                }
                throw new SQLException("Db Update failed");
            }
        }
        finally {
            ServerUtilities.getJJServer().removeUDS(TEST_DB_UPDATE);
            if (dbCon != null) {
                try {
                    dbCon.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private StateDescription createCurrentStateDescription(DatabaseConfigInfo dbInfo, Connection dbCon, File modelFile) {
        DatabaseInfos dbInfos;
        DBConnection connectionInfo = new DBConnection(dbCon);
        DatabaseConfigInfo.DatabaseType driver = dbInfo.getDriver();
        connectionInfo.setDatabaseName(DatabaseConfigInfo.DatabaseType.inetora.equals((Object)driver) ? dbInfo.getUser() : dbInfo.getCatalogForConnection());
        connectionInfo.setJdbcDriverClass(null);
        connectionInfo.setJdbcPassword(dbInfo.getDecodedPassword());
        connectionInfo.setJdbcUrl(dbInfo.getUrl());
        connectionInfo.setJdbcUser(dbInfo.getUser());
        switch (driver) {
            case mysql: {
                dbInfos = new DatabaseInfosMySQL(connectionInfo);
                break;
            }
            case inetora: {
                dbInfos = new DatabaseInfosOracle(connectionInfo);
                break;
            }
            case inetdae7: {
                dbInfos = new DatabaseInfosMsSQL(connectionInfo);
                break;
            }
            default: {
                dbInfos = new DatabaseInfos(connectionInfo);
            }
        }
        StateDescription currentDB = modelFile == null ? new StateDescription(dbInfos) : new StateDescription(dbInfos, modelFile);
        return currentDB;
    }
}

